---
title: "Operators must be declared &#39;Public&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc33011"
  - "bc33011"
helpviewer_keywords: 
  - "BC33011"
ms.assetid: 67fc0dee-4ef5-4afc-a63a-f7d20bce7954
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Operators must be declared &#39;Public&#39;
An [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md) does not include the [Public](../../visual-basic/language-reference/modifiers/public.md) keyword.  
  
 An `Operator` procedure requires both the `Public` and [Shared](../../visual-basic/language-reference/modifiers/shared.md) keywords, and a conversion operator also requires either the [Widening](../../visual-basic/language-reference/modifiers/widening.md) or the [Narrowing](../../visual-basic/language-reference/modifiers/narrowing.md) keyword.  
  
 **Error ID:** BC33011  
  
## To correct this error  
  
-   Add the `Public` keyword to the `Operator` statement.  
  
## See Also  
 [Operator Procedures](../../visual-basic/programming-guide/language-features/procedures/operator-procedures.md)   
 [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md)   
 [How to: Define an Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-an-operator.md)   
 [How to: Define a Conversion Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-a-conversion-operator.md)