---
title: "Nullable modifier &#39;?&#39; and array modifiers, &#39;(&#39; and &#39;)&#39;, cannot be specified on both a variable and its type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc33102"
  - "bc33102"
helpviewer_keywords: 
  - "BC33102"
ms.assetid: fd3f65a4-63f9-41dc-ba15-98d86f097ba8
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Nullable modifier &#39;?&#39; and array modifiers, &#39;(&#39; and &#39;)&#39;, cannot be specified on both a variable and its type
The nullable type modifier (?) is included on the variable in a variable declaration in which the array modifiers (parentheses) are included on the specified variable type. Or, the nullable type modifier is included on the specified variable type in a variable declaration in which the array modifiers are included on the variable.  
  
 **Error ID:** BC33102  
  
## To correct this error  
  
1.  Specify both the nullable type modifier (?) and the array modifiers (parentheses) on either the declared variable or the specified variable type, as shown in the following example.  
  
```vb  
' These are incorrect.  
' Dim numbers? As Integer()  
' Dim values() As Integer?  
  
'These are correct.  
Dim numbers?() As Integer  
Dim values As Integer?()  
```  
  
## See Also  
 [Nullable Value Types](../../visual-basic/programming-guide/language-features/data-types/nullable-value-types.md)