---
title: "Late binding operations cannot be converted to an expression tree | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc36604"
  - "bc36604"
helpviewer_keywords: 
  - "BC36604"
ms.assetid: 6fd66d12-8c99-46e0-9095-fe1b29fd2692
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Late binding operations cannot be converted to an expression tree
An attempt has been made to convert a late binding operation into an expression tree. This is not valid. For example, the following code causes this error.  
  
```vb  
Option Strict Off  
Module Module1  
  
    Sub Main()  
        '' Not valid.  
        ' Test(Function(someInstance) someInstance.SomeProperty)  
    End Sub  
  
    Sub Test(ByVal ex As Expressions.Expression(Of Func(Of Object, Object)))  
    End Sub  
  
End Module  
```  
  
 **Error ID:** BC36604  
  
## See Also  
 [Early and Late Binding](../../visual-basic/programming-guide/language-features/early-late-binding/index.md)   
 [NOT IN BUILD: Expression Trees in LINQ](http://msdn.microsoft.com/en-us/1a2e8e74-4bbc-45ab-9a46-2b6cfce3bcb2)