---
title: "Data type(s) of the type parameter(s) in extension method &#39;&lt;methodname&gt;&#39; defined in &#39;&lt;typename&gt;&#39; cannot be inferred from these arguments | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36649"
  - "vbc36646"
  - "bc36646"
  - "vbc36649"
helpviewer_keywords: 
  - "BC36649"
  - "BC36646"
ms.assetid: 55274b01-6d78-4950-861e-07d9273ef76e
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Data type(s) of the type parameter(s) in extension method &#39;&lt;methodname&gt;&#39; defined in &#39;&lt;typename&gt;&#39; cannot be inferred from these arguments
Data type(s) of the type parameter(s) in extension method '\<methodname>' defined in '\<typename>' cannot be inferred from these arguments. Specifying the data type(s) explicitly might correct this error.  
  
 An attempt has been made to use type inference to determine the data type (or types) of the type parameter (or parameters) when evaluating a call to a generic extension method. However, the compiler is not able to find a data type for the type parameters in this method, and it reports the error.  
  
> [!NOTE]
>  When specifying arguments is not an option (for example, for query operators in query expressions), the error message appears without the second sentence.  
  
 The following code demonstrates the error.  
  
```vb  
Module Module1  
  
    Sub Main()  
  
        Dim classInstance As ClassExample  
  
        '' Not valid.  
        'classInstance.GenericExtensionMethod("Hello", "World")  
  
    End Sub  
  
    <System.Runtime.CompilerServices.Extension()> _  
    Sub GenericExtensionMethod(Of T)(ByVal classEx As ClassExample, _  
                                     ByVal x As String, ByVal y As _  
                                     InterfaceExample(Of T))  
    End Sub  
  
End Module  
  
Interface InterfaceExample(Of T)  
End Interface  
  
Class ClassExample  
End Class  
```  
  
 **Error ID:** BC36649 and BC36646  
  
## To correct this error  
  
-   You may be able to specify a data type for the type parameter or parameters instead of relying on type inference.  
  
## See Also  
 [Relaxed Delegate Conversion](../../visual-basic/programming-guide/language-features/delegates/relaxed-delegate-conversion.md)   
 [Extension Methods](../../visual-basic/programming-guide/language-features/procedures/extension-methods.md)   
 [Generic Procedures in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-procedures.md)   
 [Type Conversions in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/type-conversions.md)