---
title: "&#39;&lt;methodname&gt;&#39; is not accessible in this context because the return type is not accessible | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc36665"
  - "vbc36666"
  - "bc36666"
  - "vbc36665"
helpviewer_keywords: 
  - "BC36666"
  - "BC36665"
ms.assetid: 8f29eb7e-351f-486c-9d1f-3556cc11b7c5
caps.latest.revision: 4
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;&lt;methodname&gt;&#39; is not accessible in this context because the return type is not accessible
You have called a function that has a return type that you cannot access from the calling statement. For example, in the following code, the call from `Main` to `PublicMethod` fails because the return type, `PrivateType`, is declared with the `Private` access modifier in class `TestClass`. Therefore, the context within which `PrivateType` can be accessed is limited to `TestClass`.  
  
```vb  
Class TestClass  
  
    Dim pT As New PrivateType  
  
    Private Class PrivateType  
    End Class  
  
    '' A corresponding error is returned in this line: 'PublicMethod   
    '' cannot expose 'PrivateType' in namespace 'ConsoleApplication1'   
    '' through class 'TestClass'.  
    'Public Function PublicMethod() As PrivateType  
    '    Return Nothing  
    'End Function  
  
End Class  
  
Module Module1  
  
    Sub Main()  
  
        Dim tc As TestClass  
        '' This error occurs here, because the data type returned by   
        '' PublicMethod()is declared Private in class TestClass and   
        '' cannot be accessed from here.  
        'Console.WriteLine(tc.PublicMethod())  
  
    End Sub  
  
End Module  
```  
  
 **Error ID:** BC36665 and BC36666  
  
## To correct this error  
  
-   If the type definition is accessible, change the access modifier from `Private` to `Public`.  
  
-   Change the return type of the function if you have access to it.  
  
-   Write a method or extension method that returns an accessible type.  
  
## See Also  
 [Access Levels in Visual Basic](../../visual-basic/programming-guide/language-features/declared-elements/access-levels.md)