---
title: "Operands of type Object used for operator &#39;&lt;operatorsymbol&gt;&#39;; runtime errors could occur | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "BC42019"
  - "vbc42019"
helpviewer_keywords: 
  - "BC42019"
ms.assetid: f61944ba-863b-4a82-aae4-249bda52ec8d
caps.latest.revision: 10
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Operands of type Object used for operator &#39;&lt;operatorsymbol&gt;&#39;; runtime errors could occur
An expression uses an operator for which one or both operands are of the [Object Data Type](../../visual-basic/language-reference/data-types/object-data-type.md).  
  
 When a variable or expression evaluates to `Object`, the compiler must perform *late binding*, which causes extra operations at run time. It also exposes your application to potential run-time errors. For example, suppose you assign a <xref:System.Windows.Forms.Form> to an `Object` variable and then try to use it with the [/ Operator (Visual Basic)](../../visual-basic/language-reference/operators/floating-point-division-operator.md). If you do this, the runtime throws an <xref:System.InvalidCastException> because Visual Basic cannot convert a <xref:System.Windows.Forms.Form> object to a numeric value.  
  
 By default, this message is a warning. For information on hiding warnings or treating warnings as errors, see [Configuring Warnings in Visual Basic](https://docs.microsoft.com/visualstudio/ide/configuring-warnings-in-visual-basic).  
  
 **Error ID:** BC42019  
  
## To correct this error  
  
-   If possible, arrange the operands to evaluate to data types for which the operator is defined.  
  
## See Also  
 [Arithmetic Operators in Visual Basic](../../visual-basic/programming-guide/language-features/operators-and-expressions/arithmetic-operators.md)