---
title: "Basic Queries (LINQ to XML) (Visual Basic) | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"
ms.tgt_pltfrm: ""
ms.topic: "article"
dev_langs: 
  - "VB"
ms.assetid: aec6ef60-f6f4-4548-b3db-cf6c94bb0008
caps.latest.revision: 3
author: "stevehoag"
ms.author: "shoag"

---
# Basic Queries (LINQ to XML) (Visual Basic)
This section provides examples of basic [!INCLUDE[sqltecxlinq](../../../../csharp/programming-guide/concepts/linq/includes/sqltecxlinq_md.md)] queries.  
  
## In This Section  
  
|Topic|Description|  
|-----------|-----------------|  
|[How to: Find an Element with a Specific Attribute (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-find-an-element-with-a-specific-attribute.md)|Shows how to find a particular element that has an attribute that has a specific value.|  
|[How to: Find an Element with a Specific Child Element (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-find-an-element-with-a-specific-child-element.md)|Shows how to find a particular element that has a child element that has a specific value.|  
|[Querying an XDocument vs. Querying an XElement (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/querying-an-xdocument-vs-querying-an-xelement.md)|Explains the differences between writing queries on an XML tree that is rooted in <xref:System.Xml.Linq.XElement> and writing queries on an XML tree that is rooted in <xref:System.Xml.Linq.XDocument>.|  
|[How to: Find Descendants with a Specific Element Name (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-find-descendants-with-a-specific-element-name.md)|Shows how to find all the descendants of an element that have a specific name. This example uses the <xref:System.Xml.Linq.XContainer.Descendants%2A> axis.|  
|[How to: Find a Single Descendant Using the Descendants Method (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-find-a-single-descendant-using-the-descendants-method.md)|Shows how to use the <xref:System.Xml.Linq.XContainer.Descendants%2A> axis method to find a single uniquely named element.|  
|[How to: Write Queries with Complex Filtering (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-write-queries-with-complex-filtering.md)|Shows how to write a query with a more complex filter.|  
|[How to: Filter on an Optional Element (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-filter-on-an-optional-element.md)|Shows how to find nodes in an irregularly shaped tree.|  
|[How to: Find All Nodes in a Namespace (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-find-all-nodes-in-a-namespace.md)|Shows how to find all nodes that are in a specific namespace.|  
|[How to: Sort Elements (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-sort-elements.md)|Shows how to write a query that sorts its results.|  
|[How to: Sort Elements on Multiple Keys (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-sort-elements-on-multiple-keys.md)|Shows how to sort on multiple keys.|  
|[How to: Calculate Intermediate Values (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-calculate-intermediate-values.md)|Shows how to use the `Let` clause to calculate intermediate values in a [!INCLUDE[sqltecxlinq](../../../../csharp/programming-guide/concepts/linq/includes/sqltecxlinq_md.md)] query.|  
|[How to: Write a Query that Finds Elements Based on Context (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-write-a-query-that-finds-elements-based-on-context.md)|Shows how to select elements based on other elements in the tree.|  
|[How to: Debug Empty Query Results Sets (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/how-to-debug-empty-query-results-sets.md)|Shows the appropriate fix when debugging queries on XML that is in a default namespace.|  
  
## See Also  
 [Querying XML Trees (Visual Basic)](../../../../visual-basic/programming-guide/concepts/linq/querying-xml-trees.md)