---
title: "Common Tasks Performed with Visual Basic Operators | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "operators [Visual Basic], logical"
  - "operators [Visual Basic], string concatenation"
  - "operators [Visual Basic], bitwise"
  - "operators [Visual Basic], bit-shift"
  - "operators [Visual Basic], arithmetic"
  - "operators [Visual Basic], string comparison"
  - "operators [Visual Basic], concatenation"
  - "Visual Basic code, operators"
  - "operators [Visual Basic], comparison"
  - "operators [Visual Basic], short-circuiting logical"
ms.assetid: d181afe5-fafa-460f-a13b-81203f6f4587
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Common Tasks Performed with Visual Basic Operators
Operators perform many common tasks involving one or more expressions called *operands*.  
  
## Arithmetic and Bit-shift Tasks  
 The following table summarizes the available arithmetic and bit-shift operations.  
  
|To|See|  
|---|---|  
|Add one numeric value to another|[+ Operator](../../../../visual-basic/language-reference/operators/addition-operator.md)|  
|Subtract one numeric value from another|[- Operator (Visual Basic)](../../../../visual-basic/language-reference/operators/subtraction-operator.md)|  
|Reverse the sign of a numeric value|[- Operator (Visual Basic)](../../../../visual-basic/language-reference/operators/subtraction-operator.md)|  
|Multiply one numeric value by another|[* Operator](../../../../visual-basic/language-reference/operators/multiplication-operator.md)|  
|Divide one numeric value into another|[/ Operator (Visual Basic)](../../../../visual-basic/language-reference/operators/floating-point-division-operator.md)|  
|Find the quotient of one numeric value divided by another (without the remainder)|[\ Operator (Visual Basic)](../../../../visual-basic/language-reference/operators/integer-division-operator.md)|  
|Find the remainder of one numeric value divided by another (without the quotient)|[Mod Operator](../../../../visual-basic/language-reference/operators/mod-operator.md)|  
|Raise one numeric value to the power of another|[^ Operator](../../../../visual-basic/language-reference/operators/exponentiation-operator.md)|  
|Shift the bit pattern of a numeric value to the left|[<\< Operator](../../../../visual-basic/language-reference/operators/left-shift-operator.md)|  
|Shift the bit pattern of a numeric value to the right|[>> Operator](../../../../visual-basic/language-reference/operators/right-shift-operator.md)|  
  
## Comparison Tasks  
 The following table summarizes the available comparison operations.  
  
|To|See|  
|---|---|  
|Determine whether two values are equal|`=` Operator ([Comparison Operators in Visual Basic](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/comparison-operators.md))|  
|Determine whether two values are unequal|`<>` Operator ([Comparison Operators in Visual Basic](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/comparison-operators.md))|  
|Determine whether one value is less than another|`<` Operator ([Comparison Operators in Visual Basic](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/comparison-operators.md))|  
|Determine whether one value is greater than another|`>` Operator ([Comparison Operators in Visual Basic](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/comparison-operators.md))|  
|Determine whether one value is less than or equal to another|`<=` Operator ([Comparison Operators in Visual Basic](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/comparison-operators.md))|  
|Determine whether one value is greater than or equal to another|`>=` Operator ([Comparison Operators in Visual Basic](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/comparison-operators.md))|  
|Determine whether two object variables refer to the same object instance|[Is Operator](../../../../visual-basic/language-reference/operators/is-operator.md)|  
|Determine whether two object variables refer to different object instances|[IsNot Operator](../../../../visual-basic/language-reference/operators/isnot-operator.md)|  
|Determine whether an object is of a specific type|[TypeOf Operator](../../../../visual-basic/language-reference/operators/typeof-operator.md)|  
  
## Concatenation Tasks  
 The following table summarizes the available concatenation operations.  
  
|To|See|  
|---|---|  
|Join multiple strings into a single string|`&` Operator ([Concatenation Operators in Visual Basic](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/concatenation-operators.md))|  
|Join numeric values with string values|`+` Operator ([Concatenation Operators in Visual Basic](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/concatenation-operators.md))|  
  
## Logical and Bitwise Tasks  
 The following table summarizes the available logical and bitwise operations.  
  
|To|See|  
|---|---|  
|Perform logical negation on a Boolean value|[Not Operator](../../../../visual-basic/language-reference/operators/not-operator.md)|  
|Perform logical conjunction on two Boolean values|[And Operator](../../../../visual-basic/language-reference/operators/and-operator.md)|  
|Perform inclusive logical disjunction on two Boolean values|[Or Operator](../../../../visual-basic/language-reference/operators/or-operator.md)|  
|Perform exclusive logical disjunction on two Boolean values|[Xor Operator](../../../../visual-basic/language-reference/operators/xor-operator.md)|  
|Perform short-circuited logical conjunction on two Boolean values|[AndAlso Operator](../../../../visual-basic/language-reference/operators/andalso-operator.md)|  
|Perform short-circuited inclusive logical disjunction on two Boolean values|[OrElse Operator](../../../../visual-basic/language-reference/operators/orelse-operator.md)|  
|Perform bit-by-bit logical conjunction on two integral values|[And Operator](../../../../visual-basic/language-reference/operators/and-operator.md)|  
|Perform bit-by-bit inclusive logical disjunction on two integral values|[Or Operator](../../../../visual-basic/language-reference/operators/or-operator.md)|  
|Perform bit-by-bit exclusive logical disjunction on two integral values|[Xor Operator](../../../../visual-basic/language-reference/operators/xor-operator.md)|  
|Perform bit-by-bit logical negation on an integral value|[Not Operator](../../../../visual-basic/language-reference/operators/not-operator.md)|  
  
## See Also  
 [Operators and Expressions](../../../../visual-basic/programming-guide/language-features/operators-and-expressions/index.md)   
 [Operators Listed by Functionality](../../../../visual-basic/language-reference/operators/operators-listed-by-functionality.md)