const {
  _getGroupParticipants,
  addParticipant,
  areAllMessagesLoaded,
  asyncLoadAllEarlierMessages,
  blockContact,
  clearChat,
  createGroup,
  deleteConversation,
  deleteMessages,
  demoteParticipant,
  downloadFileWithCredentials,
  encryptAndUploadFile,
  forwardMessages,
  getAllChatIds,
  getAllChats,
  getAllChatsWithMessages,
  getAllChatsWithNewMessages,
  getAllContacts,
  getAllGroupMetadata,
  getAllGroups,
  getAllMessagesInChat,
  getAllNewMessages,
  getAllUnreadMessages,
  getBatteryLevel,
  getChat,
  getChatById,
  getChatByName,
  getCommonGroups,
  getContact,
  getGroupAdmins,
  getGroupInviteLink,
  getGroupMetadata,
  getGroupParticipantIDs,
  getHost,
  getMe,
  getMessageById,
  getMyContacts,
  getNewId,
  getNewMessageId,
  getNumberProfile,
  getProfilePicFromServer,
  getStatus,
  getUnreadMessages,
  getUnreadMessagesInChat,
  hasUndreadMessages,
  isConnected,
  isLoggedIn,
  leaveGroup,
  loadAllEarlierMessages,
  loadAndGetAllMessagesInChat,
  loadChatEarlierMessages,
  loadEarlierMessagesTillDate,
  processFiles,
  processMessageObj,
  promoteParticipant,
  removeParticipant,
  reply,
  revokeGroupInviteLink,
  sendChatstate,
  sendContact,
  sendFile,
  sendImage,
  sendImageAsSticker,
  sendImageWithProduct,
  sendLocation,
  sendMessage,
  sendMessage2,
  sendMessageToID,
  sendMessageWithTags,
  sendMessageWithThumb,
  sendSeen,
  sendSticker,
  sendVideoAsGif,
  setMyName,
  setMyStatus,
  startTyping,
  stopTyping,
  unblockContact,
  openChat,
  openChatAt,
} = require('./functions');
const {
  base64ToFile,
  generateMediaKey,
  getFileHash,
  arrayBufferToBase64,
} = require('./helper');
const {
  addNewMessagesListener,
  addOnAddedToGroup,
  addOnLiveLocation,
  addOnNewAcks,
  addOnParticipantsChange,
  addOnStateChange,
  allNewMessagesListener,
  initNewMessagesListener,
} = require('./listeners');
const {
  _serializeChatObj,
  _serializeContactObj,
  _serializeMessageObj,
  _serializeNumberStatusObj,
  _serializeProfilePicThumb,
  _serializeRawObj,
} = require('./serializers');
const {
  getStore
} = require('./store/get-store');

module.exports = {
  setupWAPI: () => {
    if (!window.Store || !window.Store.Msg) {
      (function () {
        const parasite = `parasite${Date.now()}`;
        // webpackJsonp([], { [parasite]: (x, y, z) => getStore(z) }, [parasite]);
        if (typeof webpackJsonp === 'function')
          webpackJsonp([], {
            [parasite]: (x, y, z) => getStore(z)
          }, [parasite]);
        else
          webpackJsonp.push([
            [parasite],
            {
              [parasite]: (x, y, z) => getStore(z)
            },
            [
              [parasite]
            ],
          ]);
      })();
    }

    window.WAPI = {
      lastRead: {},
    };

    // Serializers assignations
    window.WAPI._serializeRawObj = _serializeRawObj;
    window.WAPI._serializeChatObj = _serializeChatObj;
    window.WAPI._serializeContactObj = _serializeContactObj;
    window.WAPI._serializeMessageObj = _serializeMessageObj;
    window.WAPI._serializeNumberStatusObj = _serializeNumberStatusObj;
    window.WAPI._serializeProfilePicThumb = _serializeProfilePicThumb;

    // Group Functions
    window.WAPI.createGroup = createGroup;
    window.WAPI.leaveGroup = leaveGroup;
    window.WAPI.revokeGroupInviteLink = revokeGroupInviteLink;
    window.WAPI.getGroupInviteLink = getGroupInviteLink;
    window.WAPI.getGroupAdmins = getGroupAdmins;
    window.WAPI.removeParticipant = removeParticipant;
    window.WAPI.addParticipant = addParticipant;
    window.WAPI.promoteParticipant = promoteParticipant;
    window.WAPI.demoteParticipant = demoteParticipant;

    // Chatting functions
    window.WAPI.sendChatstate = sendChatstate;
    window.WAPI.sendMessageWithThumb = sendMessageWithThumb;
    window.WAPI.processMessageObj = processMessageObj;
    window.WAPI.sendMessageWithTags = sendMessageWithTags;
    window.WAPI.sendMessage = sendMessage;
    window.WAPI.sendMessage2 = sendMessage2;
    window.WAPI.sendSeen = sendSeen;
    window.WAPI.deleteConversation = deleteConversation;
    window.WAPI.deleteMessages = deleteMessages;
    window.WAPI.clearChat = clearChat;
    window.WAPI.sendMessageToID = sendMessageToID;
    window.WAPI.sendImage = sendImage;
    window.WAPI.sendFile = sendFile;
    window.WAPI.setMyName = setMyName;
    window.WAPI.setMyStatus = setMyStatus;
    window.WAPI.sendVideoAsGif = sendVideoAsGif;
    window.WAPI.processFiles = processFiles;
    window.WAPI.sendImageWithProduct = sendImageWithProduct;
    window.WAPI.sendContact = sendContact;
    window.WAPI.forwardMessages = forwardMessages;
    window.WAPI.reply = reply;
    window.WAPI._sendSticker = sendSticker;
    window.WAPI.encryptAndUploadFile = encryptAndUploadFile;
    window.WAPI.sendImageAsSticker = sendImageAsSticker;
    window.WAPI.startTyping = startTyping;
    window.WAPI.stopTyping = stopTyping;
    window.WAPI.sendLocation = sendLocation;
    window.WAPI.blockContact = blockContact;
    window.WAPI.unblockContact = unblockContact;
    window.WAPI.openChat = openChat;
    window.WAPI.openChatAt = openChatAt;

    // Retrieving functions
    window.WAPI.getAllContacts = getAllContacts;
    window.WAPI.getMyContacts = getMyContacts;
    window.WAPI.getContact = getContact;
    window.WAPI.getAllChats = getAllChats;
    window.WAPI.haveNewMsg = hasUndreadMessages;
    window.WAPI.getAllChatsWithNewMsg = getAllChatsWithNewMessages;
    window.WAPI.getAllChatIds = getAllChatIds;
    window.WAPI.getAllNewMessages = getAllNewMessages;
    window.WAPI.getAllUnreadMessages = getAllUnreadMessages;
    window.WAPI.getAllChatsWithMessages = getAllChatsWithMessages;
    window.WAPI.getAllGroups = getAllGroups;
    window.WAPI.getChat = getChat;
    window.WAPI.getStatus = getStatus;
    window.WAPI.getChatByName = getChatByName;
    window.WAPI.getNewId = getNewId;
    window.WAPI.getChatById = getChatById;
    window.WAPI.getUnreadMessagesInChat = getUnreadMessagesInChat;
    window.WAPI.loadEarlierMessages = loadChatEarlierMessages;
    window.WAPI.loadAllEarlierMessages = loadAllEarlierMessages;
    window.WAPI.asyncLoadAllEarlierMessages = asyncLoadAllEarlierMessages;
    window.WAPI.areAllMessagesLoaded = areAllMessagesLoaded;
    window.WAPI.loadEarlierMessagesTillDate = loadEarlierMessagesTillDate;
    window.WAPI.getAllGroupMetadata = getAllGroupMetadata;
    window.WAPI.getGroupMetadata = getGroupMetadata;
    window.WAPI._getGroupParticipants = _getGroupParticipants;
    window.WAPI.getGroupParticipantIDs = getGroupParticipantIDs;
    window.WAPI.getAllMessagesInChat = getAllMessagesInChat;
    window.WAPI.loadAndGetAllMessagesInChat = loadAndGetAllMessagesInChat;
    window.WAPI.getUnreadMessages = getUnreadMessages;
    window.WAPI.getCommonGroups = getCommonGroups;
    window.WAPI.getProfilePicFromServer = getProfilePicFromServer;
    window.WAPI.downloadFileWithCredentials = downloadFileWithCredentials;
    window.WAPI.getNumberProfile = getNumberProfile;
    window.WAPI.getMessageById = getMessageById;
    window.WAPI.getNewMessageId = getNewMessageId;
    window.WAPI.getFileHash = getFileHash;
    window.WAPI.generateMediaKey = generateMediaKey;
    window.WAPI.arrayBufferToBase64 = arrayBufferToBase64;

    // Device functions
    window.WAPI.getHost = getHost;
    window.WAPI.getMe = getMe;
    window.WAPI.isLoggedIn = isLoggedIn;
    window.WAPI.isConnected = isConnected;
    window.WAPI.getBatteryLevel = getBatteryLevel;
    window.WAPI.base64ImageToFile = base64ToFile;
    window.WAPI.base64ToFile = base64ToFile;

    // Listeners initialization
    window.WAPI._newMessagesQueue = [];
    window.WAPI._newMessagesBuffer =
      sessionStorage.getItem('saved_msgs') != null ?
      JSON.parse(sessionStorage.getItem('saved_msgs')) : [];
    window.WAPI._newMessagesDebouncer = null;
    window.WAPI._newMessagesCallbacks = [];
    window.Store.Msg.off('add');
    sessionStorage.removeItem('saved_msgs');
    initNewMessagesListener();

    // Listeners
    window.addEventListener('unload', window.WAPI._unloadInform, false);
    window.addEventListener('beforeunload', window.WAPI._unloadInform, false);
    window.addEventListener('pageunload', window.WAPI._unloadInform, false);
    addNewMessagesListener();
    allNewMessagesListener();
    addOnStateChange();
    addOnNewAcks();
    addOnLiveLocation();
    addOnParticipantsChange();
    addOnAddedToGroup();

    // On-work below:

    /**
     * New version of @tag message
     */
    window.WAPI.sendMessageMentioned = async function (chatId, message, mentioned) {
      if (!Array.isArray(mentioned)) {
        mentioned = [mentioned];
      }

      const chat = WAPI.getChat(chatId);
      const users = await Store.Contact.serialize().filter((x) =>
        mentioned.includes(x.id.user)
      );

      chat.sendMessage(message, {
        linkPreview: null,
        mentionedJidList: users.map((u) => u.id),
        quotedMsg: null,
        quotedMsgAdminGroupJid: null,
      });
    };

    window.WAPI.getProfilePicSmallFromId = function (id, done) {
      window.Store.ProfilePicThumb.find(id).then(
        function (d) {
          if (d.img !== undefined) {
            window.WAPI.downloadFileWithCredentials(d.img, done);
          } else {
            done(false);
          }
        },
        function (e) {
          done(false);
        }
      );
    };

    window.WAPI.getProfilePicFromId = function (id, done) {
      window.Store.ProfilePicThumb.find(id).then(
        function (d) {
          if (d.imgFull !== undefined) {
            window.WAPI.downloadFileWithCredentials(d.imgFull, done);
          } else {
            done(false);
          }
        },
        function (e) {
          done(false);
        }
      );
    };

    window.WAPI.getWAVersion = function () {
      return window.Debug.VERSION;
    };
  }
}