/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Iterables;
import com.google.errorprone.ErrorProneJavacJavaCompiler;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.scanner.BuiltInCheckerSuppliers;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Main;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JavacMessages;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Processor;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class ErrorProneCompiler {
    private final DiagnosticListener<? super JavaFileObject> diagnosticListener;
    private final PrintWriter errOutput;
    private final String compilerName;
    private final ScannerSupplier scannerSupplier;
    private static final TaskListener EMPTY_LISTENER = new TaskListener(){

        @Override
        public void started(TaskEvent e) {
        }

        @Override
        public void finished(TaskEvent e) {
        }
    };

    public static void main(String[] args) {
        System.exit(ErrorProneCompiler.compile((String[])args).exitCode);
    }

    public static Main.Result compile(DiagnosticListener<JavaFileObject> listener, String[] args) {
        ErrorProneCompiler compiler = new Builder().listenToDiagnostics(listener).build();
        return compiler.run(args);
    }

    public static Main.Result compile(String[] args) {
        return new Builder().build().run(args);
    }

    public static Main.Result compile(String[] args, PrintWriter out) {
        ErrorProneCompiler compiler = new Builder().redirectOutputTo(out).build();
        return compiler.run(args);
    }

    private ErrorProneCompiler(String compilerName, PrintWriter errOutput, DiagnosticListener<? super JavaFileObject> diagnosticListener, ScannerSupplier scannerSupplier) {
        this.errOutput = errOutput;
        this.compilerName = compilerName;
        this.diagnosticListener = diagnosticListener;
        this.scannerSupplier = (ScannerSupplier)Preconditions.checkNotNull((Object)scannerSupplier);
    }

    public Main.Result run(String[] args) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        return this.run(args, context);
    }

    private Iterable<String> defaultToLatestSupportedLanguageLevel(Iterable<String> args) {
        String overrideLanguageLevel;
        switch (StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value()) {
            case "1.7": {
                overrideLanguageLevel = "7";
                break;
            }
            case "1.8": {
                overrideLanguageLevel = "8";
                break;
            }
            default: {
                return args;
            }
        }
        return Iterables.concat(Arrays.asList("-Xlint:-options", "-source", overrideLanguageLevel, "-target", overrideLanguageLevel), args);
    }

    private Iterable<String> setCompilePolicyToByFile(Iterable<String> args) throws InvalidCommandLineOptionException {
        for (String arg : args) {
            if (!arg.startsWith("-XDcompilePolicy")) continue;
            String value = arg.substring(arg.indexOf(61) + 1);
            if (!value.equals("byfile")) {
                throw new InvalidCommandLineOptionException("-XDcompilePolicy must be byfile for Error Prone to work properly");
            }
            return args;
        }
        return Iterables.concat(args, Arrays.asList("-XDcompilePolicy=byfile"));
    }

    private String[] prepareCompilation(String[] argv, Context context) throws InvalidCommandLineOptionException {
        Iterable<String> newArgs = this.defaultToLatestSupportedLanguageLevel(Arrays.asList(argv));
        newArgs = this.setCompilePolicyToByFile(newArgs);
        ErrorProneOptions epOptions = ErrorProneOptions.processArgs(newArgs);
        argv = epOptions.getRemainingArgs();
        if (this.diagnosticListener != null) {
            context.put(DiagnosticListener.class, this.diagnosticListener);
        }
        Scanner scanner = (Scanner)this.scannerSupplier.applyOverrides(epOptions).get();
        ErrorProneScannerTransformer transformer = ErrorProneScannerTransformer.create(scanner);
        ErrorProneCompiler.setupMessageBundle(context);
        ErrorProneCompiler.enableEndPositions(context);
        ErrorProneJavacJavaCompiler.preRegister(context, transformer, epOptions);
        return argv;
    }

    private Main.Result run(String[] argv, Context context) {
        try {
            argv = this.prepareCompilation(argv, context);
        }
        catch (InvalidCommandLineOptionException e) {
            this.errOutput.println(e.getMessage());
            this.errOutput.flush();
            return Main.Result.CMDERR;
        }
        return new Main(this.compilerName, this.errOutput).compile(argv, context);
    }

    public Main.Result run(String[] argv, List<JavaFileObject> javaFileObjects) {
        Context context = new Context();
        return this.run(argv, context, null, javaFileObjects, Collections.emptyList());
    }

    public Main.Result run(String[] argv, Context context, JavaFileManager fileManager, List<JavaFileObject> javaFileObjects, Iterable<? extends Processor> processors) {
        try {
            argv = this.prepareCompilation(argv, context);
        }
        catch (InvalidCommandLineOptionException e) {
            this.errOutput.println(e.getMessage());
            this.errOutput.flush();
            return Main.Result.CMDERR;
        }
        JavacTool tool = JavacTool.create();
        JavacTaskImpl task = (JavacTaskImpl)tool.getTask(this.errOutput, fileManager, null, Arrays.asList(argv), null, javaFileObjects, context);
        if (processors != null) {
            task.setProcessors(processors);
        }
        return task.doCall();
    }

    public static void setupMessageBundle(Context context) {
        JavacMessages.instance(context).add("com.google.errorprone.errors");
    }

    private static void enableEndPositions(Context context) {
        MultiTaskListener.instance(context).add(EMPTY_LISTENER);
    }

    public static class Builder {
        private DiagnosticListener<? super JavaFileObject> diagnosticListener = null;
        private PrintWriter errOutput = new PrintWriter(System.err, true);
        private String compilerName = "javac (with error-prone)";
        private ScannerSupplier scannerSupplier = BuiltInCheckerSuppliers.defaultChecks();

        public ErrorProneCompiler build() {
            return new ErrorProneCompiler(this.compilerName, this.errOutput, this.diagnosticListener, this.scannerSupplier);
        }

        public Builder named(String compilerName) {
            this.compilerName = compilerName;
            return this;
        }

        public Builder redirectOutputTo(PrintWriter errOutput) {
            this.errOutput = errOutput;
            return this;
        }

        public Builder listenToDiagnostics(DiagnosticListener<? super JavaFileObject> listener) {
            this.diagnosticListener = listener;
            return this;
        }

        public Builder report(ScannerSupplier scannerSupplier) {
            this.scannerSupplier = scannerSupplier;
            return this;
        }
    }
}

