/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import javax.lang.model.element.ElementKind;

@BugPattern(name="CheckReturnValue", altNames={"ResultOfMethodCallIgnored", "ReturnValueIgnored"}, summary="Ignored return value of method that is annotated with @CheckReturnValue", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class CheckReturnValue
extends AbstractReturnValueIgnored
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final Matcher<MethodInvocationTree> MATCHER = new Matcher<MethodInvocationTree>(){

        @Override
        public boolean matches(MethodInvocationTree tree, VisitorState state) {
            Symbol.MethodSymbol method = ASTHelpers.getSymbol(tree);
            if (ASTHelpers.isVoidType(method.getReturnType(), state)) {
                return false;
            }
            if (CheckReturnValue.mockitoInvocation(tree, state)) {
                return false;
            }
            Optional result = CheckReturnValue.shouldCheckReturnValue(method);
            if (result.isPresent()) {
                return (Boolean)result.get();
            }
            result = CheckReturnValue.checkEnclosingClasses(method);
            if (result.isPresent()) {
                return (Boolean)result.get();
            }
            result = CheckReturnValue.checkPackage(method);
            if (result.isPresent()) {
                return (Boolean)result.get();
            }
            return false;
        }
    };
    private static final Matcher<ExpressionTree> MOCKITO_MATCHER = Matchers.anyOf(MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("verify"), MethodMatchers.instanceMethod().onExactClass("org.mockito.stubbing.Stubber").named("when"));
    private static final String BOTH_ERROR = "@CheckReturnValue and @CanIgnoreReturnValue cannot both be applied to the same %s";

    private static Optional<Boolean> shouldCheckReturnValue(Symbol sym) {
        if (ASTHelpers.hasAnnotation(sym, CanIgnoreReturnValue.class)) {
            return Optional.of((Object)false);
        }
        if (ASTHelpers.hasAnnotation(sym, javax.annotation.CheckReturnValue.class)) {
            return Optional.of((Object)true);
        }
        return Optional.absent();
    }

    private static Optional<Boolean> checkEnclosingClasses(Symbol.MethodSymbol method) {
        Symbol enclosingClass = ASTHelpers.enclosingClass(method);
        while (enclosingClass instanceof Symbol.ClassSymbol) {
            Optional<Boolean> result = CheckReturnValue.shouldCheckReturnValue(enclosingClass);
            if (result.isPresent()) {
                return result;
            }
            enclosingClass = enclosingClass.owner;
        }
        return Optional.absent();
    }

    private static Optional<Boolean> checkPackage(Symbol.MethodSymbol method) {
        return CheckReturnValue.shouldCheckReturnValue(ASTHelpers.enclosingPackage(method));
    }

    @Override
    public Matcher<MethodInvocationTree> specializedMatcher() {
        return MATCHER;
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        String annotationToValidate;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol(tree);
        boolean checkReturn = ASTHelpers.hasAnnotation(method, javax.annotation.CheckReturnValue.class);
        boolean canIgnore = ASTHelpers.hasAnnotation(method, CanIgnoreReturnValue.class);
        if (checkReturn && canIgnore) {
            return this.buildDescription(tree).setMessage(String.format(BOTH_ERROR, "method")).build();
        }
        if (checkReturn) {
            annotationToValidate = javax.annotation.CheckReturnValue.class.getSimpleName();
        } else if (canIgnore) {
            annotationToValidate = CanIgnoreReturnValue.class.getSimpleName();
        } else {
            return Description.NO_MATCH;
        }
        if (method.getKind() != ElementKind.METHOD) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isVoidType(method.getReturnType(), state)) {
            return Description.NO_MATCH;
        }
        String message = String.format("@%s may not be applied to void-returning methods", annotationToValidate);
        return this.buildDescription(tree).setMessage(message).build();
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (ASTHelpers.hasAnnotation(tree, javax.annotation.CheckReturnValue.class) && ASTHelpers.hasAnnotation(tree, CanIgnoreReturnValue.class)) {
            return this.buildDescription(tree).setMessage(String.format(BOTH_ERROR, "class")).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean mockitoInvocation(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree receiver;
        return tree instanceof JCTree.JCMethodInvocation && ((JCTree.JCMethodInvocation)tree).getMethodSelect() instanceof JCTree.JCFieldAccess && MOCKITO_MATCHER.matches(receiver = ASTHelpers.getReceiver(tree), state);
    }
}

