/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="OverlappingQualifierAndScopeAnnotation", summary="Annotations cannot be both Qualifiers/BindingAnnotations and Scopes", explanation="Qualifiers and Scoping annotations have different semantic meanings and a single annotation should not be both a qualifier and a scoping annotation", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class InjectOverlappingQualifierAndScopeAnnotation
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final String GUICE_SCOPE_ANNOTATION = "com.google.inject.ScopeAnnotation";
    private static final String JAVAX_SCOPE_ANNOTATION = "javax.inject.Scope";
    private static final String GUICE_BINDING_ANNOTATION = "com.google.inject.BindingAnnotation";
    private static final String JAVAX_QUALIFER_ANNOTATION = "javax.inject.Qualifier";
    private static final Matcher<ClassTree> HAS_SCOPE_ANNOTATION_MATCHER = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope"));
    private static final Matcher<ClassTree> HAS_QUALIFIER_ANNOTATION_MATCHER = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.BindingAnnotation"), Matchers.hasAnnotation("javax.inject.Qualifier"));
    private static final Matcher<AnnotationTree> QUALIFIER_OR_SCOPE_MATCHER = new Matcher<AnnotationTree>(){

        @Override
        public boolean matches(AnnotationTree annotationTree, VisitorState state) {
            Symbol annotationSymbol = ASTHelpers.getSymbol(annotationTree);
            return annotationSymbol.equals(state.getSymbolFromString(InjectOverlappingQualifierAndScopeAnnotation.JAVAX_QUALIFER_ANNOTATION)) || annotationSymbol.equals(state.getSymbolFromString(InjectOverlappingQualifierAndScopeAnnotation.GUICE_BINDING_ANNOTATION)) || annotationSymbol.equals(state.getSymbolFromString(InjectOverlappingQualifierAndScopeAnnotation.JAVAX_SCOPE_ANNOTATION)) || annotationSymbol.equals(state.getSymbolFromString(InjectOverlappingQualifierAndScopeAnnotation.GUICE_SCOPE_ANNOTATION));
        }
    };

    @Override
    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        ClassTree annotationType;
        if (QUALIFIER_OR_SCOPE_MATCHER.matches(annotationTree, state) && HAS_QUALIFIER_ANNOTATION_MATCHER.matches(annotationType = InjectOverlappingQualifierAndScopeAnnotation.getAnnotationTypeFromMetaAnnotation(state), state) && HAS_SCOPE_ANNOTATION_MATCHER.matches(annotationType, state)) {
            return this.describeMatch(annotationTree, SuggestedFix.delete(annotationTree));
        }
        return Description.NO_MATCH;
    }

    private static ClassTree getAnnotationTypeFromMetaAnnotation(VisitorState state) {
        return (ClassTree)state.getPath().getParentPath().getParentPath().getLeaf();
    }
}

