/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(name="SizeGreaterThanOrEqualsZero", summary="Comparison of a size >= 0 is always true, did you intend to check for non-emptiness?", explanation="A standard means of checking non-emptiness of an array or collection is to test if the size of that collection is greater than 0. However, one may accidentally check if the size is greater than or equal to 0, which is always true.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class SizeGreaterThanOrEqualsZero
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Table<String, MethodName, Boolean> CLASSES = ImmutableTable.builder().put((Object)"com.google.common.collect.FluentIterable", (Object)MethodName.SIZE, (Object)true).put((Object)"com.google.common.collect.Multimap", (Object)MethodName.SIZE, (Object)true).put((Object)"java.io.ByteArrayOutputStream", (Object)MethodName.SIZE, (Object)false).put((Object)"java.util.Collection", (Object)MethodName.SIZE, (Object)true).put((Object)"java.util.Dictionary", (Object)MethodName.SIZE, (Object)true).put((Object)"java.util.Map", (Object)MethodName.SIZE, (Object)true).put((Object)"java.util.BitSet", (Object)MethodName.LENGTH, (Object)true).put((Object)"java.lang.CharSequence", (Object)MethodName.LENGTH, (Object)false).put((Object)"java.lang.String", (Object)MethodName.LENGTH, (Object)true).put((Object)"java.lang.StringBuilder", (Object)MethodName.LENGTH, (Object)false).put((Object)"java.lang.StringBuffer", (Object)MethodName.LENGTH, (Object)false).build();
    private static final Table<String, MethodName, Boolean> STATIC_CLASSES = ImmutableTable.builder().put((Object)"com.google.common.collect.Iterables", (Object)MethodName.SIZE, (Object)true).build();
    private static final Matcher<ExpressionTree> INSTANCE_METHOD_MATCHER = SizeGreaterThanOrEqualsZero.buildInstanceMethodMatcher();
    private static final Matcher<ExpressionTree> STATIC_METHOD_MATCHER = SizeGreaterThanOrEqualsZero.buildStaticMethodMatcher();
    private static final Matcher<MemberSelectTree> ARRAY_LENGTH_MATCHER = SizeGreaterThanOrEqualsZero.arrayLengthMatcher();
    private static final Matcher<ExpressionTree> HAS_EMPTY_METHOD = SizeGreaterThanOrEqualsZero.classHasIsEmptyFunction();

    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        ExpressionTree operand;
        ExpressionType expressionType = this.isGreaterThanEqualToZero(tree);
        if (expressionType == ExpressionType.MISMATCH) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree = operand = expressionType == ExpressionType.GREATER_THAN_EQUAL ? tree.getLeftOperand() : tree.getRightOperand();
        if (operand instanceof MethodInvocationTree) {
            MethodInvocationTree callToSize = (MethodInvocationTree)operand;
            if (INSTANCE_METHOD_MATCHER.matches(callToSize, state)) {
                return this.provideReplacementForMethodInvocation(tree, callToSize, state, expressionType);
            }
            if (STATIC_METHOD_MATCHER.matches(callToSize, state)) {
                return this.provideReplacementForStaticMethodInvocation(tree, callToSize, state, expressionType);
            }
        } else if (operand instanceof MemberSelectTree && ARRAY_LENGTH_MATCHER.matches((MemberSelectTree)operand, state)) {
            return this.removeEqualsFromComparison(tree, state, expressionType);
        }
        return Description.NO_MATCH;
    }

    private static Matcher<ExpressionTree> buildInstanceMethodMatcher() {
        TypePredicate lengthMethodClass = TypePredicates.isDescendantOfAny(CLASSES.column((Object)MethodName.LENGTH).keySet());
        TypePredicate sizeMethodClass = TypePredicates.isDescendantOfAny(CLASSES.column((Object)MethodName.SIZE).keySet());
        return Matchers.anyOf(Matchers.instanceMethod().onClass(sizeMethodClass).named("size"), Matchers.instanceMethod().onClass(lengthMethodClass).named("length"));
    }

    private static Matcher<ExpressionTree> buildStaticMethodMatcher() {
        Iterable<Matcher<ExpressionTree>> sizeStaticMethods = SizeGreaterThanOrEqualsZero.staticMethodMatcher(STATIC_CLASSES.column((Object)MethodName.SIZE).keySet(), "size");
        Iterable<Matcher<ExpressionTree>> lengthStaticMethods = SizeGreaterThanOrEqualsZero.staticMethodMatcher(STATIC_CLASSES.column((Object)MethodName.LENGTH).keySet(), "length");
        return SizeGreaterThanOrEqualsZero.anyOfIterable(Iterables.concat(sizeStaticMethods, lengthStaticMethods));
    }

    private static Iterable<Matcher<ExpressionTree>> staticMethodMatcher(Iterable<String> sizeMethodClassNames, final String methodName) {
        return Iterables.transform(sizeMethodClassNames, (Function)new Function<String, Matcher<ExpressionTree>>(){

            public Matcher<ExpressionTree> apply(String className) {
                return Matchers.staticMethod().onClass(className).named(methodName);
            }
        });
    }

    private static Matcher<ExpressionTree> isSubtypeOfAny(Iterable<String> classes) {
        return SizeGreaterThanOrEqualsZero.anyOfIterable(Iterables.transform(classes, (Function)new Function<String, Matcher<ExpressionTree>>(){

            public Matcher<ExpressionTree> apply(String clazzName) {
                return Matchers.isSubtypeOf(clazzName);
            }
        }));
    }

    private static Matcher<ExpressionTree> classHasIsEmptyFunction() {
        ImmutableList.Builder classNames = ImmutableList.builder();
        for (Table.Cell methodInformation : Iterables.concat((Iterable)CLASSES.cellSet(), (Iterable)STATIC_CLASSES.cellSet())) {
            if (!((Boolean)methodInformation.getValue()).booleanValue()) continue;
            classNames.add(methodInformation.getRowKey());
        }
        return SizeGreaterThanOrEqualsZero.isSubtypeOfAny((Iterable<String>)classNames.build());
    }

    private static Matcher<MemberSelectTree> arrayLengthMatcher() {
        return new Matcher<MemberSelectTree>(){

            @Override
            public boolean matches(MemberSelectTree tree, VisitorState state) {
                return ASTHelpers.getSymbol(tree) == state.getSymtab().lengthVar;
            }
        };
    }

    private Description provideReplacementForMethodInvocation(BinaryTree tree, MethodInvocationTree leftOperand, VisitorState state, ExpressionType expressionType) {
        ExpressionTree collection = ASTHelpers.getReceiver(leftOperand);
        if (HAS_EMPTY_METHOD.matches(collection, state)) {
            return this.describeMatch(tree, SuggestedFix.replace(tree, "!" + state.getSourceForNode((JCTree)((Object)collection)) + ".isEmpty()"));
        }
        return this.removeEqualsFromComparison(tree, state, expressionType);
    }

    private Description provideReplacementForStaticMethodInvocation(BinaryTree tree, MethodInvocationTree callToSize, final VisitorState state, ExpressionType expressionType) {
        ExpressionTree classToken = ASTHelpers.getReceiver(callToSize);
        if (HAS_EMPTY_METHOD.matches(classToken, state)) {
            List argumentSourceValues = Lists.transform(callToSize.getArguments(), (Function)new Function<ExpressionTree, CharSequence>(){

                public CharSequence apply(ExpressionTree expressionTree) {
                    return state.getSourceForNode((JCTree)((Object)expressionTree));
                }
            });
            String argumentString = Joiner.on((char)',').join((Iterable)argumentSourceValues);
            return this.describeMatch(tree, SuggestedFix.replace(tree, "!" + state.getSourceForNode((JCTree)((Object)classToken)) + ".isEmpty(" + argumentString + ")"));
        }
        return this.removeEqualsFromComparison(tree, state, expressionType);
    }

    private Description removeEqualsFromComparison(BinaryTree tree, VisitorState state, ExpressionType expressionType) {
        String replacement = expressionType == ExpressionType.GREATER_THAN_EQUAL ? state.getSourceForNode((JCTree)((Object)tree.getLeftOperand())) + " > 0" : "0 < " + state.getSourceForNode((JCTree)((Object)tree.getRightOperand()));
        return this.describeMatch(tree, SuggestedFix.replace(tree, replacement));
    }

    private ExpressionType isGreaterThanEqualToZero(BinaryTree tree) {
        ExpressionType returnType;
        ExpressionTree literalOperand;
        switch (tree.getKind()) {
            case GREATER_THAN_EQUAL: {
                literalOperand = tree.getRightOperand();
                returnType = ExpressionType.GREATER_THAN_EQUAL;
                break;
            }
            case LESS_THAN_EQUAL: {
                literalOperand = tree.getLeftOperand();
                returnType = ExpressionType.LESS_THAN_EQUAL;
                break;
            }
            default: {
                return ExpressionType.MISMATCH;
            }
        }
        if (literalOperand.getKind() != Tree.Kind.INT_LITERAL) {
            return ExpressionType.MISMATCH;
        }
        if (!((LiteralTree)literalOperand).getValue().equals(0)) {
            return ExpressionType.MISMATCH;
        }
        return returnType;
    }

    private static <T extends Tree> Matcher<T> anyOfIterable(Iterable<Matcher<T>> matchers) {
        final ImmutableList copyOfMatchers = ImmutableList.copyOf(matchers);
        return new Matcher<T>(){

            @Override
            public boolean matches(T t, VisitorState state) {
                for (Matcher matcher : copyOfMatchers) {
                    if (!matcher.matches(t, state)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static enum ExpressionType {
        LESS_THAN_EQUAL,
        GREATER_THAN_EQUAL,
        MISMATCH;

    }

    private static enum MethodName {
        LENGTH,
        SIZE;

    }
}

