/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_WildcardImport_TypeToImport;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

@BugPattern(name="WildcardImport", summary="Use of wildcard imports is forbidden", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class WildcardImport
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String ASTERISK = "*";
    private final FixStrategy fixStrategy;

    public WildcardImport() {
        this(FixStrategies.PRODUCTION);
    }

    protected WildcardImport(FixStrategy fixStrategy) {
        this.fixStrategy = fixStrategy;
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol(tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (sym.getEnclosingElement() != null && ((Symbol)sym.getEnclosingElement()).getKind() != ElementKind.PACKAGE) {
            return Description.NO_MATCH;
        }
        CompilationUnitTree unit = state.getPath().getCompilationUnit();
        ImmutableList<ImportTree> wildcardImports = WildcardImport.getWildcardImports(unit.getImports());
        if (wildcardImports.isEmpty()) {
            return Description.NO_MATCH;
        }
        if (unit.getTypeDecls().size() > 1) {
            return this.describeMatch((Tree)wildcardImports.get(0));
        }
        Set<TypeToImport> typesToImport = ImportCollector.collect((JCTree.JCClassDecl)tree);
        Multimap<ImportTree, TypeToImport> toFix = this.groupImports(wildcardImports, typesToImport);
        this.fixStrategy.apply(tree, state, wildcardImports, toFix, this);
        return Description.NO_MATCH;
    }

    private Multimap<ImportTree, TypeToImport> groupImports(ImmutableList<ImportTree> wildcardImports, Set<TypeToImport> typesToImport) {
        LinkedListMultimap toFix = LinkedListMultimap.create();
        for (TypeToImport type : typesToImport) {
            ImportTree wildcard = this.findMatchingWildcardImport(wildcardImports, type);
            if (wildcard == null) continue;
            toFix.put((Object)wildcard, (Object)type);
        }
        return toFix;
    }

    @Nullable
    private ImportTree findMatchingWildcardImport(ImmutableList<ImportTree> wildcardImports, TypeToImport type) {
        for (ImportTree importTree : wildcardImports) {
            int next;
            String importBase = ((MemberSelectTree)importTree.getQualifiedIdentifier()).getExpression().toString();
            if (!type.typeName().startsWith(importBase) || (next = type.typeName().indexOf(46, importBase.length() + 1)) != -1) continue;
            return importTree;
        }
        return null;
    }

    private static ImmutableList<ImportTree> getWildcardImports(List<? extends ImportTree> imports) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (ImportTree importTree : imports) {
            MemberSelectTree select;
            Tree ident = importTree.getQualifiedIdentifier();
            if (!(ident instanceof MemberSelectTree) || !(select = (MemberSelectTree)ident).getIdentifier().toString().equals(ASTERISK)) continue;
            result.add((Object)importTree);
        }
        return result.build();
    }

    public static enum FixStrategies implements FixStrategy
    {
        PRODUCTION{

            @Override
            public void apply(ClassTree tree, VisitorState state, ImmutableList<ImportTree> wildcardImports, Multimap<ImportTree, TypeToImport> toFix, BugChecker checker) {
                SuggestedFix.Builder fix = SuggestedFix.builder();
                for (ImportTree importToDelete : wildcardImports) {
                    String importSpecification = importToDelete.getQualifiedIdentifier().toString();
                    if (importToDelete.isStatic()) {
                        fix.removeStaticImport(importSpecification);
                        continue;
                    }
                    fix.removeImport(importSpecification);
                }
                for (TypeToImport toImport : toFix.values()) {
                    if (toImport.isStatic()) {
                        fix.addStaticImport(toImport.typeName());
                        continue;
                    }
                    fix.addImport(toImport.typeName());
                }
                if (!fix.isEmpty()) {
                    state.reportMatch(BugChecker.buildDescriptionFromChecker((Tree)wildcardImports.get(0), checker).addFix(fix.build()).build());
                }
            }
        }
        ,
        TEST{

            @Override
            public void apply(ClassTree tree, VisitorState state, ImmutableList<ImportTree> wildcardImports, Multimap<ImportTree, TypeToImport> toFix, BugChecker checker) {
                for (ImportTree toDelete : wildcardImports) {
                    Collection replacements = toFix.get((Object)toDelete);
                    Fix fix = SuggestedFix.postfixWith(toDelete, replacements.toString());
                    state.reportMatch(BugChecker.buildDescriptionFromChecker(toDelete, checker).addFix(fix).build());
                }
            }
        };

    }

    public static interface FixStrategy {
        public void apply(ClassTree var1, VisitorState var2, ImmutableList<ImportTree> var3, Multimap<ImportTree, TypeToImport> var4, BugChecker var5);
    }

    static class ImportCollector
    extends TreeScanner {
        private Set<TypeToImport> seen = new LinkedHashSet<TypeToImport>();

        ImportCollector() {
        }

        public static Set<TypeToImport> collect(JCTree.JCClassDecl tree) {
            ImportCollector collector = new ImportCollector();
            collector.scan(tree);
            return collector.seen;
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl method) {
            if (ASTHelpers.isGeneratedConstructor(method)) {
                this.scan(method.body);
            } else {
                super.visitMethodDef(method);
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            if (tree.sym != null) {
                switch (tree.sym.kind) {
                    case TYP: {
                        this.addType(tree.sym.type);
                        break;
                    }
                    case VAR: 
                    case MTH: {
                        this.addStaticMember(tree.sym);
                        break;
                    }
                }
            }
        }

        private void addStaticMember(Symbol sym) {
            if (!sym.isStatic()) {
                return;
            }
            if (sym.owner == null) {
                return;
            }
            if (sym.isPrivate()) {
                return;
            }
            String canonicalName = sym.owner.getQualifiedName() + "." + sym.getQualifiedName();
            this.seen.add(TypeToImport.create(canonicalName, true));
        }

        private void addType(Type type) {
            if (type == null) {
                return;
            }
            Symbol.TypeSymbol sym = type.tsym;
            if (sym == null) {
                return;
            }
            if (sym.isPrivate()) {
                return;
            }
            this.seen.add(TypeToImport.create(sym.getQualifiedName().toString(), false));
        }
    }

    static abstract class TypeToImport {
        TypeToImport() {
        }

        abstract String typeName();

        abstract boolean isStatic();

        String generateImportStatement() {
            return "import " + (this.isStatic() ? "static " : "") + this.typeName() + ";";
        }

        public String toString() {
            return this.generateImportStatement();
        }

        static TypeToImport create(String type, boolean stat) {
            return new AutoValue_WildcardImport_TypeToImport(type, stat);
        }
    }
}

