/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByExpression_ClassLiteral;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByExpression_LocalVariable;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByExpression_Select;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_GuardedByExpression_TypeLiteral;
import com.google.errorprone.bugpatterns.threadsafety.IllegalGuardedBy;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.ElementKind;

public abstract class GuardedByExpression {
    private static final String ENCLOSING_INSTANCE_NAME = "outer$";

    public abstract Kind kind();

    public abstract Symbol sym();

    public abstract Type type();

    public String toString() {
        return PrettyPrinter.print(this);
    }

    public String debugPrint() {
        return DebugPrinter.print(this);
    }

    private static class DebugPrinter {
        private DebugPrinter() {
        }

        public static String print(GuardedByExpression exp) {
            StringBuilder sb = new StringBuilder();
            DebugPrinter.pprint(exp, sb);
            return sb.toString();
        }

        private static void pprint(GuardedByExpression exp, StringBuilder sb) {
            switch (exp.kind()) {
                case CLASS_LITERAL: 
                case TYPE_LITERAL: 
                case LOCAL_VARIABLE: {
                    sb.append(String.format("(%s %s)", new Object[]{exp.kind(), exp.sym()}));
                    break;
                }
                case THIS: {
                    sb.append("(THIS)");
                    break;
                }
                case SELECT: {
                    DebugPrinter.pprintSelect((Select)exp, sb);
                }
            }
        }

        private static void pprintSelect(Select exp, StringBuilder sb) {
            sb.append(String.format("(%s ", new Object[]{exp.kind()}));
            DebugPrinter.pprint(exp.base(), sb);
            if (exp.sym().name.contentEquals(GuardedByExpression.ENCLOSING_INSTANCE_NAME)) {
                sb.append(String.format(" %s%s)", GuardedByExpression.ENCLOSING_INSTANCE_NAME, exp.sym().owner));
            } else {
                sb.append(String.format(" %s)", exp.sym()));
            }
        }
    }

    private static class PrettyPrinter {
        private PrettyPrinter() {
        }

        public static String print(GuardedByExpression exp) {
            StringBuilder sb = new StringBuilder();
            PrettyPrinter.pprint(exp, sb);
            return sb.toString();
        }

        private static void pprint(GuardedByExpression exp, StringBuilder sb) {
            switch (exp.kind()) {
                case CLASS_LITERAL: {
                    sb.append(String.format("%s.class", exp.sym().name));
                    break;
                }
                case THIS: {
                    sb.append("this");
                    break;
                }
                case TYPE_LITERAL: 
                case LOCAL_VARIABLE: {
                    sb.append(exp.sym().name);
                    break;
                }
                case SELECT: {
                    PrettyPrinter.pprintSelect((Select)exp, sb);
                }
            }
        }

        private static void pprintSelect(Select exp, StringBuilder sb) {
            if (exp.sym().name.contentEquals(GuardedByExpression.ENCLOSING_INSTANCE_NAME)) {
                sb.append(String.format("%s.this", exp.sym().owner.name));
            } else {
                PrettyPrinter.pprint(exp.base(), sb);
                sb.append(String.format(".%s", exp.sym().name));
                if (exp.sym().getKind() == ElementKind.METHOD) {
                    sb.append("()");
                }
            }
        }
    }

    public static enum Kind {
        THIS,
        CLASS_LITERAL,
        TYPE_LITERAL,
        LOCAL_VARIABLE,
        SELECT;

    }

    public static class Factory {
        private final Map<Symbol, Symbol.VarSymbol> syntheticOuterFields = new HashMap<Symbol, Symbol.VarSymbol>();

        ThisLiteral thisliteral() {
            return ThisLiteral.INSTANCE;
        }

        GuardedByExpression qualifiedThis(Names names, Symbol.ClassSymbol access, Symbol enclosing) {
            GuardedByExpression base = this.thisliteral();
            Symbol curr = access;
            while ((curr = curr.owner) != null) {
                Symbol.VarSymbol var = this.syntheticOuterFields.get(curr);
                if (var == null) {
                    var = new Symbol.VarSymbol(4096L, names.fromString(GuardedByExpression.ENCLOSING_INSTANCE_NAME), curr.type, curr);
                    this.syntheticOuterFields.put(curr, var);
                }
                base = this.select(base, var);
                if (!curr.equals(enclosing)) continue;
            }
            IllegalGuardedBy.checkGuardedBy(curr != null, "Expected an enclosing class.");
            return base;
        }

        ClassLiteral classLiteral(Symbol clazz) {
            return ClassLiteral.create(clazz);
        }

        TypeLiteral typeLiteral(Symbol type) {
            return TypeLiteral.create(type);
        }

        Select select(GuardedByExpression base, Symbol member) {
            if (member instanceof Symbol.VarSymbol) {
                return this.select(base, (Symbol.VarSymbol)member);
            }
            if (member instanceof Symbol.MethodSymbol) {
                return this.select(base, (Symbol.MethodSymbol)member);
            }
            throw new IllegalStateException("Bad select expression: expected symbol " + (Object)((Object)member.getKind()));
        }

        Select select(GuardedByExpression base, Symbol.VarSymbol member) {
            return Select.create(base, member, member.type);
        }

        Select select(GuardedByExpression base, Symbol.MethodSymbol member) {
            return Select.create(base, member, member.getReturnType());
        }

        GuardedByExpression select(GuardedByExpression base, Select select) {
            return Select.create(base, select.sym(), select.type());
        }

        LocalVariable localVariable(Symbol.VarSymbol varSymbol) {
            return LocalVariable.create(varSymbol);
        }
    }

    public static abstract class Select
    extends GuardedByExpression {
        public abstract GuardedByExpression base();

        public static Select create(GuardedByExpression base, Symbol sym, Type type) {
            return new AutoValue_GuardedByExpression_Select(Kind.SELECT, sym, type, base);
        }
    }

    public static class ThisLiteral
    extends GuardedByExpression {
        static final ThisLiteral INSTANCE = new ThisLiteral();

        @Override
        public Kind kind() {
            return Kind.THIS;
        }

        @Override
        public Symbol sym() {
            return null;
        }

        @Override
        public Type type() {
            return null;
        }

        private ThisLiteral() {
        }
    }

    public static abstract class LocalVariable
    extends GuardedByExpression {
        public static LocalVariable create(Symbol owner) {
            return new AutoValue_GuardedByExpression_LocalVariable(Kind.LOCAL_VARIABLE, owner, owner.type);
        }
    }

    public static abstract class TypeLiteral
    extends GuardedByExpression {
        public static TypeLiteral create(Symbol owner) {
            return new AutoValue_GuardedByExpression_TypeLiteral(Kind.TYPE_LITERAL, owner, owner.type);
        }
    }

    public static abstract class ClassLiteral
    extends GuardedByExpression {
        public static ClassLiteral create(Symbol owner) {
            return new AutoValue_GuardedByExpression_ClassLiteral(Kind.CLASS_LITERAL, owner, owner.type);
        }
    }
}

