/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.AutoValue_ImmutableChecker_Violation;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.Name;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.pcollections.ConsPStack;

@BugPattern(name="Immutable", summary="Type declaration annotated with @Immutable is not immutable", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class ImmutableChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (tree.getSimpleName().length() == 0) {
            return this.handleAnonymousClass(tree, state);
        }
        ImmutableAnnotationInfo annotation = ImmutableChecker.getImmutableAnnotation(tree);
        if (annotation == null) {
            return this.checkSubtype(tree, state);
        }
        if (WellKnownMutability.KNOWN_IMMUTABLE.containsValue((Object)annotation)) {
            return Description.NO_MATCH;
        }
        HashSet<String> typarams = new HashSet<String>();
        for (TypeParameterTree typeParameterTree : tree.getTypeParameters()) {
            typarams.add(typeParameterTree.getName().toString());
        }
        Sets.SetView difference = Sets.difference(annotation.containerOf(), typarams);
        if (!difference.isEmpty()) {
            String string = String.format("could not find type(s) referenced by containerOf: %s", Joiner.on((String)"', '").join((Iterable)difference));
            return this.buildDescription(tree).setMessage(string).build();
        }
        Violation violation = this.checkFieldsAndSupertypesForImmutability((Optional<ClassTree>)Optional.of((Object)tree), ImmutableChecker.immutableTypeParametersInScope(ASTHelpers.getSymbol(tree)), ASTHelpers.getType(tree), state);
        if (!violation.isPresent()) {
            return Description.NO_MATCH;
        }
        String message = "type annotated with @Immutable could not be proven immutable: " + violation.message();
        return this.buildDescription(tree).setMessage(message).build();
    }

    private Violation checkFieldsAndSupertypesForImmutability(Optional<ClassTree> tree, ImmutableSet<String> immutableTyParams, Type.ClassType type, VisitorState state) {
        Violation info = this.areFieldsImmutable(tree, immutableTyParams, type, state);
        if (info.isPresent()) {
            return info;
        }
        for (Type interfaceType : state.getTypes().interfaces(type)) {
            ImmutableAnnotationInfo interfaceAnnotation = ImmutableChecker.getImmutableAnnotation(interfaceType.tsym);
            if (interfaceAnnotation == null || !(info = ImmutableChecker.immutableInstantiation(immutableTyParams, interfaceAnnotation, interfaceType, state)).isPresent()) continue;
            return info.plus(String.format("'%s' extends '%s'", ImmutableChecker.getPrettyName(type.tsym, state), ImmutableChecker.getPrettyName(interfaceType.tsym, state)));
        }
        Type.ClassType superType = (Type.ClassType)state.getTypes().supertype(type);
        if (superType.getKind() == TypeKind.NONE || state.getTypes().isSameType(state.getSymtab().objectType, superType)) {
            return Violation.absent();
        }
        ImmutableAnnotationInfo superannotation = ImmutableChecker.getImmutableAnnotation(superType.tsym);
        if (superannotation != null) {
            info = ImmutableChecker.immutableInstantiation(immutableTyParams, superannotation, superType, state);
            if (!info.isPresent()) {
                return Violation.absent();
            }
            return info.plus(String.format("'%s' extends '%s'", ImmutableChecker.getPrettyName(type.tsym, state), ImmutableChecker.getPrettyName(superType.tsym, state)));
        }
        info = this.checkFieldsAndSupertypesForImmutability((Optional<ClassTree>)Optional.absent(), immutableTyParams, superType, state);
        if (!info.isPresent()) {
            return Violation.absent();
        }
        return info.plus(String.format("'%s' extends '%s'", ImmutableChecker.getPrettyName(type.tsym, state), ImmutableChecker.getPrettyName(superType.tsym, state)));
    }

    private Violation areFieldsImmutable(Optional<ClassTree> tree, ImmutableSet<String> immutableTyParams, Type.ClassType classType, VisitorState state) {
        Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)classType.tsym;
        if (classSym.members() == null) {
            return Violation.absent();
        }
        Filter<Symbol> instanceFieldFilter = new Filter<Symbol>(){

            public boolean accepts(Symbol symbol) {
                return symbol.getKind() == ElementKind.FIELD && !symbol.isStatic();
            }
        };
        HashMap<Symbol, Tree> declarations = new HashMap<Symbol, Tree>();
        if (tree.isPresent()) {
            for (Tree tree2 : ((ClassTree)tree.get()).getMembers()) {
                Symbol sym = ASTHelpers.getSymbol(tree2);
                if (sym == null) continue;
                declarations.put(sym, tree2);
            }
        }
        ImmutableList members = ImmutableList.copyOf((Iterable)classSym.members().getSymbols((Filter)instanceFieldFilter)).reverse();
        for (Symbol member : members) {
            Optional memberTree = Optional.fromNullable(declarations.get(member));
            Violation info = this.isFieldImmutable((Optional<Tree>)memberTree, immutableTyParams, classSym, classType, (Symbol.VarSymbol)member, state);
            if (!info.isPresent()) continue;
            return info;
        }
        return Violation.absent();
    }

    private Violation isFieldImmutable(Optional<Tree> tree, ImmutableSet<String> immutableTyParams, Symbol.ClassSymbol classSym, Type.ClassType classType, Symbol.VarSymbol var, VisitorState state) {
        SuppressWarnings suppression = ASTHelpers.getAnnotation(var, SuppressWarnings.class);
        if (suppression != null && !Collections.disjoint(Arrays.asList(suppression.value()), this.allNames())) {
            return Violation.absent();
        }
        if (!var.getModifiers().contains((Object)Modifier.FINAL)) {
            if (tree.isPresent()) {
                state.reportMatch(this.buildDescription((Tree)tree.get()).setMessage("@Immutable classes cannot have non-final field").addFix(SuggestedFix.addModifier((Tree)tree.get(), Modifier.FINAL, state)).build());
                return Violation.absent();
            }
            return Violation.of(String.format("'%s' has non-final field '%s'", ImmutableChecker.getPrettyName(classSym, state), var.getSimpleName()));
        }
        Type varType = state.getTypes().memberType(classType, var);
        Violation info = ImmutableTypeVisitor.isImmutableType(immutableTyParams, varType, state);
        if (info.isPresent()) {
            if (tree.isPresent()) {
                state.reportMatch(this.buildDescription((Tree)tree.get()).setMessage(info.plus("@Immutable class has mutable field").message()).build());
                return Violation.absent();
            }
            return info.plus(String.format("'%s' has field '%s' of type '%s'", ImmutableChecker.getPrettyName(classSym, state), var.getSimpleName(), varType));
        }
        return Violation.absent();
    }

    private static Violation immutableInstantiation(ImmutableSet<String> immutableTyParams, ImmutableAnnotationInfo annotation, Type type, VisitorState state) {
        if (type.tsym.getTypeParameters().size() != type.getTypeArguments().size()) {
            return Violation.of(String.format("'%s' required immutable instantiation of '%s', but was raw", ImmutableChecker.getPrettyName(type.tsym, state), Joiner.on((String)", ").join(annotation.containerOf())));
        }
        for (int i = 0; i < type.tsym.getTypeParameters().size(); ++i) {
            Type tyarg;
            Violation info;
            Symbol.TypeVariableSymbol typaram = type.tsym.getTypeParameters().get(i);
            if (!annotation.containerOf().contains((Object)((Name)typaram.getSimpleName()).toString()) || !(info = ImmutableTypeVisitor.isImmutableType(immutableTyParams, tyarg = type.getTypeArguments().get(i), state)).isPresent()) continue;
            return info.plus(String.format("'%s' was instantiated with mutable type for '%s'", ImmutableChecker.getPrettyName(type.tsym, state), typaram.getSimpleName()));
        }
        return Violation.absent();
    }

    private Description handleAnonymousClass(ClassTree tree, VisitorState state) {
        Violation info = this.checkAnonymous(tree, state);
        if (!info.isPresent()) {
            return Description.NO_MATCH;
        }
        String message = "Mutable because " + Joiner.on((String)", ").join(info.path());
        return this.buildDescription(tree).setMessage(message).build();
    }

    private Violation checkAnonymous(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol(tree);
        if (sym == null) {
            return Violation.absent();
        }
        ImmutableSet<String> typarams = ImmutableChecker.immutableTypeParametersInScope(sym);
        Type superClass = sym.getSuperclass();
        if (superClass == null) {
            return Violation.absent();
        }
        ImmutableAnnotationInfo annotation = ImmutableChecker.getImmutableAnnotation(superClass.tsym);
        if (annotation == null) {
            return Violation.absent();
        }
        return this.areFieldsImmutable((Optional<ClassTree>)Optional.of((Object)tree), typarams, ASTHelpers.getType(tree), state);
    }

    private Description checkSubtype(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol(tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Type superType = ImmutableChecker.immutableSupertype(sym, state);
        if (superType == null) {
            return Description.NO_MATCH;
        }
        String message = String.format("Class extends @Immutable type %s, but is not annotated as immutable", superType);
        Fix fix = SuggestedFix.builder().prefixWith(tree, "@Immutable ").addImport(Immutable.class.getName()).build();
        return this.buildDescription(tree).setMessage(message).addFix(fix).build();
    }

    private static Type immutableSupertype(Symbol sym, VisitorState state) {
        for (Type superType : state.getTypes().closure(sym.type)) {
            if (superType.equals(sym.type) || !ASTHelpers.hasAnnotation(superType.tsym, Immutable.class)) continue;
            return superType;
        }
        return null;
    }

    static ImmutableAnnotationInfo getImmutableAnnotation(Symbol sym) {
        String nameStr = sym.flatName().toString();
        ImmutableAnnotationInfo known = (ImmutableAnnotationInfo)WellKnownMutability.KNOWN_IMMUTABLE.get((Object)nameStr);
        if (known != null) {
            return known;
        }
        Immutable immutable = ASTHelpers.getAnnotation(sym, Immutable.class);
        if (immutable == null) {
            return null;
        }
        return ImmutableAnnotationInfo.create(sym.getQualifiedName().toString(), (Iterable<String>)ImmutableList.copyOf((Object[])immutable.containerOf()));
    }

    static ImmutableAnnotationInfo getImmutableAnnotation(Tree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym == null ? null : ImmutableChecker.getImmutableAnnotation(sym);
    }

    private static ImmutableSet<String> immutableTypeParametersInScope(Symbol sym) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        Symbol s = sym;
        block4: while (s.owner != null) {
            switch (s.getKind()) {
                case INSTANCE_INIT: {
                    break;
                }
                case PACKAGE: {
                    break block4;
                }
                default: {
                    ImmutableAnnotationInfo annotation = ImmutableChecker.getImmutableAnnotation(s);
                    if (annotation == null) break;
                    for (Symbol.TypeVariableSymbol typaram : s.getTypeParameters()) {
                        String name = ((Name)typaram.getSimpleName()).toString();
                        if (!annotation.containerOf().contains((Object)name)) continue;
                        result.add((Object)name);
                    }
                    if (s.isStatic()) break block4;
                }
            }
            s = s.owner;
        }
        return result.build();
    }

    private static String getPrettyName(Symbol sym, VisitorState state) {
        if (!sym.getSimpleName().isEmpty()) {
            return sym.getSimpleName().toString();
        }
        if (sym.getKind() == ElementKind.ENUM) {
            return sym.owner.getSimpleName().toString();
        }
        return ((Name)state.getTypes().supertype((Type)sym.type).tsym.getSimpleName()).toString();
    }

    private static class ImmutableTypeVisitor
    extends Types.SimpleVisitor<Violation, Void> {
        private final ImmutableSet<String> immutableTyParams;
        private final VisitorState state;

        static Violation isImmutableType(ImmutableSet<String> immutableTyParams, Type type, VisitorState state) {
            return type.accept(new ImmutableTypeVisitor(immutableTyParams, state), null);
        }

        private ImmutableTypeVisitor(ImmutableSet<String> immutableTyParams, VisitorState state) {
            this.immutableTyParams = immutableTyParams;
            this.state = state;
        }

        @Override
        public Violation visitWildcardType(Type.WildcardType type, Void s) {
            return this.state.getTypes().wildUpperBound(type).accept(this, null);
        }

        @Override
        public Violation visitArrayType(Type.ArrayType t, Void s) {
            return Violation.of(String.format("arrays are mutable", new Object[0]));
        }

        @Override
        public Violation visitTypeVar(Type.TypeVar type, Void s) {
            Symbol.TypeVariableSymbol tyvar = (Symbol.TypeVariableSymbol)type.tsym;
            if (this.immutableTyParams != null && this.immutableTyParams.contains((Object)((Name)tyvar.getSimpleName()).toString())) {
                return Violation.absent();
            }
            String message = this.immutableTyParams.isEmpty() ? String.format("'%s' is a mutable type variable", tyvar.getSimpleName(), this.immutableTyParams) : String.format("'%s' is a mutable type variable (not in '%s')", tyvar.getSimpleName(), Joiner.on((String)", ").join(this.immutableTyParams));
            return Violation.of(message);
        }

        @Override
        public Violation visitType(Type type, Void s) {
            switch (type.tsym.getKind()) {
                case ANNOTATION_TYPE: {
                    return Violation.absent();
                }
                case INTERFACE: 
                case ENUM: 
                case CLASS: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Unexpected type kind %s", new Object[]{type.tsym.getKind()}));
                }
            }
            ImmutableAnnotationInfo annotation = ImmutableChecker.getImmutableAnnotation(type.tsym);
            if (annotation != null) {
                return ImmutableChecker.immutableInstantiation((ImmutableSet<String>)this.immutableTyParams, annotation, type, this.state);
            }
            String nameStr = type.tsym.flatName().toString();
            if (WellKnownMutability.KNOWN_UNSAFE.contains((Object)nameStr)) {
                return Violation.of(String.format("'%s' is known to be mutable", type.tsym.getSimpleName()));
            }
            if (WellKnownMutability.isImmutableProto(this.state, type)) {
                return Violation.absent();
            }
            return Violation.of(String.format("'%s' is not annotated @Immutable", type));
        }
    }

    static abstract class Violation {
        Violation() {
        }

        private static Violation create(ConsPStack<String> path) {
            return new AutoValue_ImmutableChecker_Violation(path);
        }

        boolean isPresent() {
            return !this.path().isEmpty();
        }

        String message() {
            return Joiner.on((String)", ").join(this.path());
        }

        abstract ConsPStack<String> path();

        Violation plus(String edge) {
            return Violation.create((ConsPStack<String>)this.path().plus((Object)edge));
        }

        static Violation of(String reason) {
            return Violation.create((ConsPStack<String>)ConsPStack.singleton((Object)reason));
        }

        static Violation absent() {
            return Violation.create((ConsPStack<String>)ConsPStack.empty());
        }
    }
}

