/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

public class AnnotationSimpleName
implements Matcher<AnnotationTree> {
    private final String annotationSimpleName;

    public AnnotationSimpleName(String annotationSimpleName) {
        this.annotationSimpleName = annotationSimpleName;
    }

    @Override
    public boolean matches(AnnotationTree annotationTree, VisitorState state) {
        Tree type = annotationTree.getAnnotationType();
        if (type.getKind() == Tree.Kind.IDENTIFIER && type instanceof JCTree.JCIdent) {
            JCTree.JCIdent jcIdent = (JCTree.JCIdent)type;
            return jcIdent.sym.getSimpleName().toString().equals(this.annotationSimpleName);
        }
        if (type instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jcFieldAccess = (JCTree.JCFieldAccess)type;
            return jcFieldAccess.sym.getSimpleName().toString().equals(this.annotationSimpleName);
        }
        return false;
    }
}

