/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.scanner;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugCheckerInfo;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.InstanceReturningScannerSupplierImpl;
import com.google.errorprone.scanner.Scanner;
import com.google.errorprone.scanner.ScannerSupplierImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import org.pcollections.HashPMap;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;

public abstract class ScannerSupplier
implements Supplier<Scanner> {
    @SafeVarargs
    public static ScannerSupplier fromBugCheckerClasses(Class<? extends BugChecker> ... checkerClasses) {
        return ScannerSupplier.fromBugCheckerClasses(Arrays.asList(checkerClasses));
    }

    private static PMap<String, BugPattern.SeverityLevel> defaultSeverities(Iterable<BugCheckerInfo> checkers) {
        HashPMap severities = HashTreePMap.empty();
        for (BugCheckerInfo check : checkers) {
            severities = severities.plus((Object)check.canonicalName(), (Object)check.defaultSeverity());
        }
        return severities;
    }

    public static ScannerSupplier fromBugCheckerClasses(Iterable<Class<? extends BugChecker>> checkers) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<? extends BugChecker> checker : checkers) {
            builder.add((Object)BugCheckerInfo.create(checker));
        }
        return ScannerSupplier.fromBugCheckerInfos((Iterable<BugCheckerInfo>)builder.build());
    }

    public static ScannerSupplier fromBugCheckerInfos(Iterable<BugCheckerInfo> checkers) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (BugCheckerInfo checker : checkers) {
            builder.put((Object)checker.canonicalName(), (Object)checker);
        }
        ImmutableBiMap allChecks = builder.build();
        return new ScannerSupplierImpl((ImmutableBiMap<String, BugCheckerInfo>)allChecks, ScannerSupplier.defaultSeverities((Iterable<BugCheckerInfo>)allChecks.values()));
    }

    public static ScannerSupplier fromScanner(Scanner scanner) {
        return new InstanceReturningScannerSupplierImpl(scanner);
    }

    protected abstract ImmutableBiMap<String, BugCheckerInfo> getAllChecks();

    protected abstract ImmutableSet<BugCheckerInfo> getEnabledChecks();

    protected abstract PMap<String, BugPattern.SeverityLevel> severities();

    @CheckReturnValue
    public ScannerSupplier applyOverrides(ErrorProneOptions errorProneOptions) throws InvalidCommandLineOptionException {
        ImmutableMap<String, ErrorProneOptions.Severity> severityOverrides = errorProneOptions.getSeverityMap();
        if (severityOverrides.isEmpty()) {
            return this;
        }
        ImmutableBiMap<String, BugCheckerInfo> checks = this.getAllChecks();
        PMap severities = this.severities();
        ArrayListMultimap checksByAllNames = ArrayListMultimap.create();
        for (BugCheckerInfo bugCheckerInfo : this.getAllChecks().values()) {
            for (String name : bugCheckerInfo.allNames()) {
                checksByAllNames.put((Object)name, (Object)bugCheckerInfo);
            }
        }
        for (Map.Entry entry : severityOverrides.entrySet()) {
            Collection checksWithName = checksByAllNames.get(entry.getKey());
            if (checksWithName.isEmpty()) {
                if (errorProneOptions.ignoreUnknownChecks()) continue;
                throw new InvalidCommandLineOptionException((String)entry.getKey() + " is not a valid checker name");
            }
            block9: for (BugCheckerInfo check : checksWithName) {
                switch ((ErrorProneOptions.Severity)((Object)entry.getValue())) {
                    case OFF: {
                        if (!check.suppressibility().disableable()) {
                            throw new InvalidCommandLineOptionException(check.canonicalName() + " may not be disabled");
                        }
                        severities = severities.plus((Object)check.canonicalName(), (Object)BugPattern.SeverityLevel.NOT_A_PROBLEM);
                        continue block9;
                    }
                    case DEFAULT: {
                        severities = severities.plus((Object)check.canonicalName(), (Object)check.defaultSeverity());
                        continue block9;
                    }
                    case WARN: {
                        if (check.severity((Map<String, BugPattern.SeverityLevel>)severities).enabled() && !check.suppressibility().disableable() && check.defaultSeverity() == BugPattern.SeverityLevel.ERROR) {
                            throw new InvalidCommandLineOptionException(check.canonicalName() + " is not disableable and may not be demoted to a warning");
                        }
                        severities = severities.plus((Object)check.canonicalName(), (Object)BugPattern.SeverityLevel.WARNING);
                        continue block9;
                    }
                    case ERROR: {
                        severities = severities.plus((Object)check.canonicalName(), (Object)BugPattern.SeverityLevel.ERROR);
                        continue block9;
                    }
                }
                throw new IllegalStateException("Unexpected severity level: " + entry.getValue());
            }
        }
        return new ScannerSupplierImpl(checks, severities);
    }

    @CheckReturnValue
    public ScannerSupplier plus(ScannerSupplier other) {
        ImmutableBiMap combinedAllChecks = ImmutableBiMap.builder().putAll(this.getAllChecks()).putAll(other.getAllChecks()).build();
        PMap combinedSeverities = this.severities().plusAll(other.severities());
        return new ScannerSupplierImpl((ImmutableBiMap<String, BugCheckerInfo>)combinedAllChecks, (PMap<String, BugPattern.SeverityLevel>)combinedSeverities);
    }

    @CheckReturnValue
    public ScannerSupplier filter(Predicate<? super BugCheckerInfo> predicate) {
        PMap filteredSeverities = this.severities();
        for (Map.Entry entry : this.severities().entrySet()) {
            if (predicate.apply(this.getAllChecks().get(entry.getKey()))) continue;
            filteredSeverities = filteredSeverities.plus(entry.getKey(), (Object)BugPattern.SeverityLevel.NOT_A_PROBLEM);
        }
        return new ScannerSupplierImpl(this.getAllChecks(), filteredSeverities);
    }
}

