import { expect, it } from 'vitest'

import { isVerticalVideo, parseBilibiliUri } from '~/utils/uriParse'

const uri = 'bilibili://video/1053268502?cid=1511056422&player_height=1080&player_preload=%7B%22expire_time%22%3A1713852338%2C%22cid%22%3A1511056422%2C%22quality%22%3A16%2C%22file_info%22%3A%7B%2216%22%3A%7B%22infos%22%3A%5B%7B%22filesize%22%3A1498511%2C%22timelength%22%3A133143%7D%5D%7D%2C%2264%22%3A%7B%22infos%22%3A%5B%7B%22filesize%22%3A3624796%2C%22timelength%22%3A133074%7D%5D%7D%7D%2C%22video_codecid%22%3A7%2C%22video_project%22%3Atrue%2C%22url%22%3A%22http%3A%2F%2Fupos-sz-mirror08h.bilivideo.com%2Fupgcxcode%2F22%2F64%2F1511056422%2F1511056422-1-16.mp4%3Fe%3Dig8euxZM2rNcNbRVhwdVhwdlhWdVhwdVhoNvNC8BqJIzNbfqXBvEuENvNC8aNEVEtEvE9IMvXBvE2ENvNCImNEVEIj0Y2J_aug859r1qXg8gNEVE5XREto8z5JZC2X2gkX5L5F1eTX1jkXlsTXHeux_f2o859IB_%5Cu0026uipk%3D5%5Cu0026nbs%3D1%5Cu0026deadline%3D1713855938%5Cu0026gen%3Dplayurlv2%5Cu0026os%3D08hbv%5Cu0026oi%3D1744363898%5Cu0026trid%3D982a81d34ec344f8a79f645c8973f533U%5Cu0026mid%3D223973299%5Cu0026platform%3Dipad%5Cu0026upsig%3D679618b920edd60df22058962747c2a0%5Cu0026uparams%3De%2Cuipk%2Cnbs%2Cdeadline%2Cgen%2Cos%2Coi%2Ctrid%2Cmid%2Cplatform%5Cu0026bvc%3Dvod%5Cu0026nettype%3D0%5Cu0026orderid%3D0%2C3%5Cu0026buvid%3D%5Cu0026build%3D74800100%5Cu0026f%3DU_0_0%5Cu0026bw%3D11267%5Cu0026logo%3D80000000%22%2C%22accept_formats%22%3A%5B%7B%22quality%22%3A64%2C%22format%22%3A%22mp4720%22%2C%22description%22%3A%22%E9%AB%98%E6%B8%85%20720P%22%2C%22new_description%22%3A%22720P%20%E9%AB%98%E6%B8%85%22%2C%22display_desc%22%3A%22720P%22%2C%22need_login%22%3Atrue%7D%2C%7B%22quality%22%3A16%2C%22format%22%3A%22mp4%22%2C%22description%22%3A%22%E6%B5%81%E7%95%85%20360P%22%2C%22new_description%22%3A%22360P%20%E6%B5%81%E7%95%85%22%2C%22display_desc%22%3A%22360P%22%7D%5D%2C%22backup_url%22%3A%5B%22http%3A%2F%2Fupos-sz-mirror08c.bilivideo.com%2Fupgcxcode%2F22%2F64%2F1511056422%2F1511056422-1-16.mp4%3Fe%3Dig8euxZM2rNcNbRVhwdVhwdlhWdVhwdVhoNvNC8BqJIzNbfqXBvEuENvNC8aNEVEtEvE9IMvXBvE2ENvNCImNEVEIj0Y2J_aug859r1qXg8gNEVE5XREto8z5JZC2X2gkX5L5F1eTX1jkXlsTXHeux_f2o859IB_%5Cu0026uipk%3D5%5Cu0026nbs%3D1%5Cu0026deadline%3D1713855938%5Cu0026gen%3Dplayurlv2%5Cu0026os%3D08cbv%5Cu0026oi%3D1744363898%5Cu0026trid%3D982a81d34ec344f8a79f645c8973f533U%5Cu0026mid%3D223973299%5Cu0026platform%3Dipad%5Cu0026upsig%3D1e3cfe4756d7f7ee5875216a269acdfa%5Cu0026uparams%3De%2Cuipk%2Cnbs%2Cdeadline%2Cgen%2Cos%2Coi%2Ctrid%2Cmid%2Cplatform%5Cu0026bvc%3Dvod%5Cu0026nettype%3D0%5Cu0026orderid%3D1%2C3%5Cu0026buvid%3D%5Cu0026build%3D74800100%5Cu0026f%3DU_0_0%5Cu0026bw%3D11267%5Cu0026logo%3D40000000%22%2C%22http%3A%2F%2Fupos-sz-mirrorhwb.bilivideo.com%2Fupgcxcode%2F22%2F64%2F1511056422%2F1511056422-1-16.mp4%3Fe%3Dig8euxZM2rNcNbRVhwdVhwdlhWdVhwdVhoNvNC8BqJIzNbfqXBvEuENvNC8aNEVEtEvE9IMvXBvE2ENvNCImNEVEIj0Y2J_aug859r1qXg8gNEVE5XREto8z5JZC2X2gkX5L5F1eTX1jkXlsTXHeux_f2o859IB_%5Cu0026uipk%3D5%5Cu0026nbs%3D1%5Cu0026deadline%3D1713855938%5Cu0026gen%3Dplayurlv2%5Cu0026os%3Dhwbbv%5Cu0026oi%3D1744363898%5Cu0026trid%3D982a81d34ec344f8a79f645c8973f533U%5Cu0026mid%3D223973299%5Cu0026platform%3Dipad%5Cu0026upsig%3Db63767f2be0c0f9c3fd3fb88761ac797%5Cu0026uparams%3De%2Cuipk%2Cnbs%2Cdeadline%2Cgen%2Cos%2Coi%2Ctrid%2Cmid%2Cplatform%5Cu0026bvc%3Dvod%5Cu0026nettype%3D0%5Cu0026orderid%3D2%2C3%5Cu0026buvid%3D%5Cu0026build%3D74800100%5Cu0026f%3DU_0_0%5Cu0026bw%3D11267%5Cu0026logo%3D40000000%22%5D%2C%22union_player%22%3A%7B%22biz_type%22%3A1%2C%22dimension%22%3A%7B%22width%22%3A1920%2C%22height%22%3A1080%7D%2C%22aid%22%3A1053268502%7D%7D&player_rotate=0&player_width=1920&report_flow_data=%7B%22flow_card_type%22%3A%22av%22%2C%22flow_source%22%3A%22ann_dssm_u2i%24dssm_u2u%22%7D&trackid=all_49.router-pegasus-1475688-56f5559cb5-9vnj2.1713848738314.953'

it('should parse bilibili uri from string', () => {
  expect(parseBilibiliUri(uri))
    .toMatchInlineSnapshot(`
      {
        "cid": "1511056422",
        "player_height": 1080,
        "player_preload": "{"expire_time":1713852338,"cid":1511056422,"quality":16,"file_info":{"16":{"infos":[{"filesize":1498511,"timelength":133143}]},"64":{"infos":[{"filesize":3624796,"timelength":133074}]}},"video_codecid":7,"video_project":true,"url":"http://upos-sz-mirror08h.bilivideo.com/upgcxcode/22/64/1511056422/1511056422-1-16.mp4?e=ig8euxZM2rNcNbRVhwdVhwdlhWdVhwdVhoNvNC8BqJIzNbfqXBvEuENvNC8aNEVEtEvE9IMvXBvE2ENvNCImNEVEIj0Y2J_aug859r1qXg8gNEVE5XREto8z5JZC2X2gkX5L5F1eTX1jkXlsTXHeux_f2o859IB_\\u0026uipk=5\\u0026nbs=1\\u0026deadline=1713855938\\u0026gen=playurlv2\\u0026os=08hbv\\u0026oi=1744363898\\u0026trid=982a81d34ec344f8a79f645c8973f533U\\u0026mid=223973299\\u0026platform=ipad\\u0026upsig=679618b920edd60df22058962747c2a0\\u0026uparams=e,uipk,nbs,deadline,gen,os,oi,trid,mid,platform\\u0026bvc=vod\\u0026nettype=0\\u0026orderid=0,3\\u0026buvid=\\u0026build=74800100\\u0026f=U_0_0\\u0026bw=11267\\u0026logo=80000000","accept_formats":[{"quality":64,"format":"mp4720","description":"高清 720P","new_description":"720P 高清","display_desc":"720P","need_login":true},{"quality":16,"format":"mp4","description":"流畅 360P","new_description":"360P 流畅","display_desc":"360P"}],"backup_url":["http://upos-sz-mirror08c.bilivideo.com/upgcxcode/22/64/1511056422/1511056422-1-16.mp4?e=ig8euxZM2rNcNbRVhwdVhwdlhWdVhwdVhoNvNC8BqJIzNbfqXBvEuENvNC8aNEVEtEvE9IMvXBvE2ENvNCImNEVEIj0Y2J_aug859r1qXg8gNEVE5XREto8z5JZC2X2gkX5L5F1eTX1jkXlsTXHeux_f2o859IB_\\u0026uipk=5\\u0026nbs=1\\u0026deadline=1713855938\\u0026gen=playurlv2\\u0026os=08cbv\\u0026oi=1744363898\\u0026trid=982a81d34ec344f8a79f645c8973f533U\\u0026mid=223973299\\u0026platform=ipad\\u0026upsig=1e3cfe4756d7f7ee5875216a269acdfa\\u0026uparams=e,uipk,nbs,deadline,gen,os,oi,trid,mid,platform\\u0026bvc=vod\\u0026nettype=0\\u0026orderid=1,3\\u0026buvid=\\u0026build=74800100\\u0026f=U_0_0\\u0026bw=11267\\u0026logo=40000000","http://upos-sz-mirrorhwb.bilivideo.com/upgcxcode/22/64/1511056422/1511056422-1-16.mp4?e=ig8euxZM2rNcNbRVhwdVhwdlhWdVhwdVhoNvNC8BqJIzNbfqXBvEuENvNC8aNEVEtEvE9IMvXBvE2ENvNCImNEVEIj0Y2J_aug859r1qXg8gNEVE5XREto8z5JZC2X2gkX5L5F1eTX1jkXlsTXHeux_f2o859IB_\\u0026uipk=5\\u0026nbs=1\\u0026deadline=1713855938\\u0026gen=playurlv2\\u0026os=hwbbv\\u0026oi=1744363898\\u0026trid=982a81d34ec344f8a79f645c8973f533U\\u0026mid=223973299\\u0026platform=ipad\\u0026upsig=b63767f2be0c0f9c3fd3fb88761ac797\\u0026uparams=e,uipk,nbs,deadline,gen,os,oi,trid,mid,platform\\u0026bvc=vod\\u0026nettype=0\\u0026orderid=2,3\\u0026buvid=\\u0026build=74800100\\u0026f=U_0_0\\u0026bw=11267\\u0026logo=40000000"],"union_player":{"biz_type":1,"dimension":{"width":1920,"height":1080},"aid":1053268502}}",
        "player_rotate": 0,
        "player_width": 1920,
        "report_flow_data": "{"flow_card_type":"av","flow_source":"ann_dssm_u2i$dssm_u2u"}",
        "trackid": "all_49.router-pegasus-1475688-56f5559cb5-9vnj2.1713848738314.953",
      }
    `)
})

it('should return false if video is not vertical', () => {
  expect(isVerticalVideo(uri)).toBe(false)
})
