namespace CGAL {

/*!
\ingroup PkgStraightSkeleton2Classes

The class `Straight_skeleton_2` provides a model for the 
`StraightSkeleton_2` concept which is the class 
type used to represent a straight skeleton. 

The only purpose of this class is to protect all the modifying
operations in a `HalfedgeDS`. Normal users should not modify a
straight skeleton. If an advanced user needs to get access to the
modifying operations, it must call the required methods through the
`Base` class.

\cgalModels `StraightSkeleton_2`
\cgalModels `DefaultConstructible`
\cgalModels `CopyConstructible`
\cgalModels `Assignable`

\sa `StraightSkeletonVertex_2` 
\sa `StraightSkeletonHalfedge_2` 
\sa `StraightSkeleton_2` 


*/
template< typename Traits, typename Items, typename Alloc >
class Straight_skeleton_2 : public HalfedgeDS_vector<Traits,Items,Alloc> {
public:

/// @}

}; /* end Straight_skeleton_2 */
} /* end namespace CGAL */
