/*****************************************************************
 *           Conversion functions header v1.7                    *
 *                                                               *
 * 2006 Shengalts Aleksander aka Instructor (Shengalts@mail.ru)  *
 *                                                               *
 *                                                               *
 *Functions:                                                     *
 * xatoi, xitoa, xatoui, xuitoa, xatoi64, xi64toa                *
 * hex2dec, dec2hex, str2hex, hex2str                            *
 *                                                               *
 *****************************************************************/

#ifndef _CONVFUNC_
#define _CONVFUNC_ 
#endif

/********************************************************************
 *
 *  xatoi
 *
 *Converts string to int.
 *
 *[in]  char *str   -string number
 *
 *Returns: integer
 *
 *Examples:
 *  xatoi("45") == 45;
 *  xatoi("  -0045:value") == -45;
 ********************************************************************/
#ifdef xatoi
#define xatoi_INCLUDED
#undef xatoi
int xatoi(char *str)
{
  int nNumber=0;
  BOOL bMinus=FALSE;

  while (*str == ' ')
    ++str;
  if (*str == '+')
    ++str;
  else if (*str == '-')
  {
    bMinus=TRUE;
    ++str;
  }
  for (; *str != '\0' && *str >= '0' && *str <= '9'; ++str)
    nNumber=(nNumber * 10) + (*str - '0');
  if (bMinus == TRUE)
    nNumber=0 - nNumber;
  return nNumber;
}
#endif

/********************************************************************
 *
 *  xitoa   [API: wsprintf(szResult, "%d", 45)]
 *
 *Converts int to string.
 *
 *[in]   int number   -integer
 *[out]  char *str    -string number
 *[in]   int width    -minimum number of characters to the output
 *
 *Returns: a pointer to string
 *
 *Examples:
 *  xitoa(45, szResult, 0);   //szResult == "45"
 *  xitoa(-45, szResult, 0);  //szResult == "-45"
 *  xitoa(45, szResult, 4);   //szResult == "0045"
 ********************************************************************/
#ifdef xitoa
#define xitoa_INCLUDED
#undef xitoa
char* xitoa(int number, char *str, int width)
{
  char tmp[128]="";
  int a=0;
  int b=0;

  if (number == 0)
  {
    str[0]='0';
    --width;
    b=1;
  }
  else if (number < 0)
  {
    str[0]='-';
    number=0 - number;
    --width;
    b=1;
  }
  for (tmp[a]='\0'; number != 0; ++a)
  {
    tmp[a]=(number % 10) + '0';
    number=number / 10;
  }
  for (; width > a; ++a) tmp[a]='0';
  for (--a; a >= 0; --a, ++b) str[b]=tmp[a];

  str[b]='\0';
  return str;
}
#endif

/********************************************************************
 *
 *  xatoui
 *
 *Converts string to unsigned int.
 *
 *[in]  char *str   -string number
 *
 *Returns: unsigned integer
 *
 *Examples:
 *  xatoui("45") == 45;
 *  xatoui("  -0045:value") == 0;
 ********************************************************************/
#ifdef xatoui
#define xatoui_INCLUDED
#undef xatoui
unsigned int xatoui(char *str)
{
  unsigned int nNumber=0;

  while (*str == ' ')
    ++str;
  if (*str == '+')
    ++str;
  else (*str == '-')
    return 0;
  for (; *str != '\0' && *str >= '0' && *str <= '9'; ++str)
    nNumber=(nNumber * 10) + (*str - '0');
  return nNumber;
}
#endif

/********************************************************************
 *
 *  xuitoa
 *
 *Converts unsigned int to string.
 *
 *[in]   unsigned int number   -unsigned integer
 *[out]  char *str             -string number
 *[in]   int width             -minimum number of characters to the output
 *
 *Returns: a pointer to string
 *
 *Examples:
 *  xuitoa(45, szResult, 0);   //szResult == "45"
 *  xuitoa(45, szResult, 4);   //szResult == "0045"
 ********************************************************************/
#ifdef xuitoa
#define xuitoa_INCLUDED
#undef xuitoa
char* xuitoa(unsigned int number, char *str, int width)
{
  char tmp[128]="";
  int a=0;
  int b=0;

  if (number == 0)
  {
    str[0]='0';
    --width;
    b=1;
  }
  for (tmp[a]='\0'; number != 0; ++a)
  {
    tmp[a]=(number % 10) + '0';
    number=number / 10;
  }
  for (; width > a; ++a) tmp[a]='0';
  for (--a; a >= 0; --a, ++b) str[b]=tmp[a];

  str[b]='\0';
  return str;
}
#endif

/********************************************************************
 *
 *  xatoi64
 *
 *Converts string to int64.
 *
 *[in]  char *str   -string number
 *
 *Returns: 64-bit integer
 *
 *Examples:
 *  xatoi64("45") == 45;
 *  xatoi64("  -0045:value") == -45;
 ********************************************************************/
#ifdef xatoi64
#define xatoi64_INCLUDED
#undef xatoi64
__int64 xatoi64(char *str)
{
  __int64 nNumber=0;
  BOOL bMinus=FALSE;

  while (*str == ' ')
    ++str;
  if (*str == '+')
    ++str;
  else if (*str == '-')
  {
    bMinus=TRUE;
    ++str;
  }
  for (; *str != '\0' && *str >= '0' && *str <= '9'; ++str)
    nNumber=(nNumber * 10) + (*str - '0');
  if (bMinus == TRUE)
    nNumber=0 - nNumber;
  return nNumber;
}
#endif

/********************************************************************
 *
 *  xitoa64
 *
 *Converts int64 to string.
 *
 *[in]   __int64 number  -64-bit integer
 *[out]  char *str       -string number
 *[in]   int width       -minimum number of characters to the output
 *
 *Returns: a pointer to string
 *
 *Examples:
 *  xi64toa(45, szResult, 0);   //szResult == "45"
 *  xi64toa(-45, szResult, 0);  //szResult == "-45"
 *  xi64toa(45, szResult, 4);   //szResult == "0045"
 ********************************************************************/
#ifdef xi64toa
#define xi64toa_INCLUDED
#undef xi64toa
char* xi64toa(__int64 number, char *str, int width)
{
  char tmp[128]="";
  int a=0;
  int b=0;

  if (number == 0)
  {
    str[0]='0';
    --width;
    b=1;
  }
  else if (number < 0)
  {
    str[0]='-';
    number=0 - number;
    --width;
    b=1;
  }
  for (tmp[a]='\0'; number != 0; ++a)
  {
    tmp[a]=(char)((number % 10) + '0');
    number=number / 10;
  }
  for (; width > a; ++a) tmp[a]='0';
  for (--a; a >= 0; --a, ++b) str[b]=tmp[a];

  str[b]='\0';
  return str;
}
#endif

/********************************************************************
 *
 *  hex2dec
 *
 *Converts hex value to decimal.
 *
 *[in]  char *hex   -hex value
 *
 *Returns: integer
 *         -1 wrong hex value
 *
 *Examples:
 *  hex2dec("A1F") == 2591;
 ********************************************************************/
#if defined hex2dec || defined hex2str
#define hex2dec_INCLUDED
#undef hex2dec
int hex2dec(char *hex)
{
  int a;
  int b=0;

  while (1)
  {
    a=*hex++;
    if (a >= '0' && a <= '9') a-='0';
    else if (a >= 'a' && a <= 'f') a-='a'-10;
    else if (a >= 'A' && a <= 'F') a-='A'-10;
    else return -1;

    if (*hex) b=(b + a) * 16;
    else return (b + a);
  }
}
#endif

/********************************************************************
 *
 *  dec2hex   [API: wsprintf(szResult, "%02x", 2591)]
 *
 *Converts decimal to hex value.
 *
 *[in]   unsigned int dec   -positive integer
 *[out]  char *hex          -hex value (output)
 *[in]   BOOL lowercase     -if TRUE hexadecimal value in lowercase
 *                           if FALSE in uppercase.
 *[in]   unsigned int width -minimum number of characters to the output
 *
 *Examples:
 *  dec2hex(2591, szResult, FALSE, 2);   //szResult == "A1F"
 *  dec2hex(10, szResult, TRUE, 2);      //szResult == "0a"
 ********************************************************************/
#if defined dec2hex || defined str2hex
#define dec2hex_INCLUDED
#undef dec2hex
void dec2hex(unsigned int dec, char *hex, BOOL lowercase, unsigned int width)
{
  unsigned int a=dec;
  unsigned int b=0;
  unsigned int c=0;
  char d='1';
  if (a == 0) d='0';

  while (a)
  {
    b=a % 16;
    a=a / 16;
    if (b < 10) hex[c++]=b + '0';
    else if (lowercase == TRUE) hex[c++]=b + 'a' - 10;
    else hex[c++]=b + 'A' - 10;
  }
  while (width > c) hex[c++]='0';
  hex[c]='\0';

  if (d == '1')
    for (b=0, --c; b < c; d=hex[b], hex[b++]=hex[c], hex[c--]=d);
}
#endif

/********************************************************************
 *
 *  str2hex
 *
 *Converts string to hex values.
 *
 *[in]   unsigned char *str   -string
 *[out]  char *hex            -hex string
 *[in]   BOOL lowercase       -if TRUE hexadecimal value in lowercase
 *                             if FALSE in uppercase.
 *[in]   unsigned int bytes   -number of characters in string
 *
 *Examples:
 *  str2hex((unsigned char *)"Some Text", szResult, TRUE, lstrlen("Some Text"));   //szResult == "536f6d652054657874"
 ********************************************************************/
#if defined str2hex && defined dec2hex_INCLUDED
#define str2hex_INCLUDED
#undef str2hex
void str2hex(unsigned char *str, char *hex, BOOL lowercase, unsigned int bytes)
{
  char a[16];
  unsigned int b=0;

  for (hex[0]='\0'; b < bytes; ++b)
  {
    //wsprintf(a, "%02x", (unsigned int)str[b]);
    dec2hex((unsigned int)str[b], a, lowercase, 2);
    lstrcat(hex, a);
  }
}
#endif

/********************************************************************
 *
 *  hex2str
 *
 *Converts hex values to string.
 *
 *[in]   char *hex   -hex string
 *[out]  char *str   -string
 *
 *Examples:
 *  hex2str("536f6d652054657874", szResult);   //szResult == "Some Text"
 ********************************************************************/
#if defined hex2str && defined hex2dec_INCLUDED
#define hex2str_INCLUDED
#undef hex2str
void hex2str(char *hex, char *str)
{
  char a[4];
  int b;

  while (*hex)
  {
    a[0]=*hex;
    a[1]=*++hex;
    a[2]='\0';

    if (*hex++)
    {
      if ((b=hex2dec(a)) > 0) *str++=b;
      else break;
            }
    else break;
  }
  *str='\0';
}
#endif


/********************************************************************
 *                                                                  *
 *                           Example                                *
 *                                                                  *
 ********************************************************************

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>

//insert functions
#define xatoi
#define xitoa
#include "ConvFunc.h"

void main()
{
  char szResult[MAX_PATH]="43";
  char *pResult;
  int nError;

  nError=xatoi(szResult);
  printf("nError={%d}\n", nError);

  pResult=xitoa(45, szResult, 0);
  printf("szResult={%s}, pResult={%s}\n", szResult, pResult);
}

*/