/*****************************************************************
 *              Stack functions header v1.9                      *
 *                                                               *
 * 2006 Shengalts Aleksander aka Instructor (Shengalts@mail.ru)  *
 *                                                               *
 *                                                               *
 *Linear functions (ALLSTACKFUNCL):                              *
 * StackElementL, StackPushFrontL, StackPopFrontL,               *
 * StackPushBackL, StackSizeL, StackClearL                       *
 *                                                               *
 *Bilinear functions (ALLSTACKFUNC):                             *
 * StackElement, StackInsert, StackDelete, StackMove,            *
 * StackExchange, StackDeleteRange, StackMoveRange, StackJoin,   *
 * StackSplit, StackSize, StackClear                             *
 *                                                               *
 *Special functions (ALLSTACKFUNCS):                             *
 * StackReverseRange, StackPushSort, StackSort                   *
 *                                                               *
 *****************************************************************/

#ifndef _STACKFUNC_
#define _STACKFUNC_ 

typedef struct _HSTACK {
  int first;
  int last;
} HSTACK;

typedef struct _stackL {
  struct _stackL *prev;
} stackL;

typedef struct _stack {
  struct _stack *next;
  struct _stack *prev;
} stack;

typedef struct _stackS {
  struct _stackS *next;
  struct _stackS *prev;
  char string[MAX_PATH];
} stackS;

#endif


/********************************************************************
 ********************************************************************
 *                                                                  *
 *                   Linear chain functions (+4)                    *
 *                                                                  *
 ********************************************************************
 ********************************************************************/


/********************************************************************
 *
 *  StackElementL
 *
 *Finds the element by index and returns pointer on it.
 *
 *    [in] stackL *first    -Pointer to a pointer that specifies
 *                           the first element in the stack
 *    [in] stackL *last     -Pointer to a pointer that specifies
 *                           the top element in the stack
 *   [out] stackL **element -Pointer to a pointer to the element
 *    [in] int index        -Number of the element if positive search
 *                           from top if negative from beginning
 *
 *Returns: 0 on success
 *         1 on empty stack
 ********************************************************************/
#if defined StackElementL || defined ALLSTACKFUNCL
#define StackElementL_INCLUDED
#undef StackElementL
int StackElementL(stackL *first, stackL *last, stackL **element, int index)
{
  stackL *pTmp=last;
  int sum;
  *element=NULL;

  for (sum=1; (pTmp); ++sum)
  {
    if (sum == index)
    {
      *element=pTmp;
      return 0;
    }
    pTmp=pTmp->prev;
  }
  return 1;
}
#endif

/********************************************************************
 *
 *  StackPushFrontL
 *
 *Adds an element to the top of the stack.
 *
 *[in,out] stackL **first   -Pointer to a pointer that specifies
 *                           the first element in the stack
 *[in,out] stackL **last    -Pointer to a pointer that specifies
 *                           the top element in the stack
 *   [out] stackL **element -Pointer to a pointer to the element
 *    [in] int bytes        -Size of the structure
 ********************************************************************/
#if defined StackPushFrontL || defined ALLSTACKFUNCL
#define StackPushFrontL_INCLUDED
#undef StackPushFrontL
void StackPushFrontL(stackL **first, stackL **last, stackL **element, int bytes)
{
  *element=(stackL *)GlobalAlloc(GPTR, bytes);

  if (*last)
    (*element)->prev=*last;
  else
    *first=*element;
  *last=*element;
}
#endif

/********************************************************************
 *
 *  StackPopFrontL
 *
 *Removes the element from the top of the stack.
 *
 *[in,out] stackL **first   -Pointer to a pointer that specifies
 *                           the first element in the stack
 *[in,out] stackL **last    -Pointer to a pointer that specifies
 *                           the top element in the stack
 *
 *Returns: 0 on success
 *         1 on empty stack
 ********************************************************************/
#if defined StackPopFrontL || defined ALLSTACKFUNCL
#define StackPopFrontL_INCLUDED
#undef StackPopFrontL
int StackPopFrontL(stackL **first, stackL **last)
{
  stackL *pTmp=*last;

  if (!*last) return 1;
  *last=pTmp->prev;
  if (!*last) *first=NULL;
  GlobalFree((HGLOBAL)pTmp);
  return 0;
}
#endif

/********************************************************************
 *
 *  StackPushBackL
 *
 *Adds an element to the beginning of the stack.
 *
 *[in,out] stackL **first   -Pointer to a pointer that specifies
 *                           the first element in the stack
 *[in,out] stackL **last    -Pointer to a pointer that specifies
 *                           the top element in the stack
 *   [out] stackL **element -Pointer to a pointer to the element
 *    [in] int bytes        -Size of the structure
 ********************************************************************/
#if defined StackPushBackL || defined ALLSTACKFUNCL
#define StackPushBackL_INCLUDED
#undef StackPushBackL
void StackPushBackL(stackL **first, stackL **last, stackL **element, int bytes)
{
  *element=(stackL *)GlobalAlloc(GPTR, bytes);

  if (*first)
    (*first)->prev=*element;
  else
    *last=*element;
  *first=*element;
}
#endif

/********************************************************************
 *
 *  StackSizeL
 *
 *Gets the number of elements in the stack.                         
 *
 *[in] stackL *first   -Pointer that specifies the first
 *                      element in the stack
 *[in] stackL *last    -Pointer that specifies the top
 *                      element in the stack
 *
 *Returns: the number of elements
 ********************************************************************/
#if defined StackSizeL || defined ALLSTACKFUNCL
#define StackSizeL_INCLUDED
#undef StackSizeL
int StackSizeL(stackL *first, stackL *last)
{
  stackL *pTmp=last;
  int sum;

  for (sum=0; (pTmp); ++sum)
    pTmp=pTmp->prev;
  return sum;
}
#endif

/********************************************************************
 *
 *  StackClearL
 *
 *Clear all stack.
 *
 *[in,out] stackL **first   -Pointer to a pointer that specifies
 *                           the first element in the stack
 *[in,out] stackL **last    -Pointer to a pointer that specifies
 *                           the top element in the stack
 ********************************************************************/
#if defined StackClearL || defined ALLSTACKFUNCL
#define StackClearL_INCLUDED
#undef StackClearL
void StackClearL(stackL **first, stackL **last)
{
  stackL *pTmp=*last;
  stackL *pTmp2;

  while (pTmp)
  {
    pTmp2=pTmp->prev;
    GlobalFree((HGLOBAL)pTmp);
    pTmp=pTmp2;
  }
  *last=NULL;
  *first=NULL;
}
#endif


/********************************************************************
 ********************************************************************
 *                                                                  *
 *                   Bilinear chain functions (+8)                  *
 *                                                                  *
 ********************************************************************
 ********************************************************************/


/********************************************************************
 *
 *  StackElement
 *
 *Finds the element by index and returns pointer on it.
 *
 * [in] stack *first    -Pointer that specifies the first
 *                       element in the stack
 * [in] stack *last     -Pointer that specifies the top
 *                       element in the stack
 *[out] stack **element -Pointer to a pointer to the element
 * [in] int index       -Number of the element if positive search
 *                       from top if negative from beginning
 *
 *Returns: 0 on success
 *         1 on wrong index
 ********************************************************************/
#if defined StackElement || defined ALLSTACKFUNC
#define StackElement_INCLUDED
#undef StackElement
int StackElement(stack *first, stack *last, stack **element, int index)
{
  stack *pTmp;
  int sum;
  *element=NULL;

  if (index > 0)
  {
    pTmp=last;
    sum=1;
  }
  else if (index < 0)
  {
    pTmp=first;
    sum=-1;
  }
  else return 1;

  while (pTmp)
  {
    if (sum == index)
    {
      *element=pTmp;
      return 0;
    }
    if (index > 0)
    {
      pTmp=pTmp->prev;
      ++sum;
    }
    else
    {
      pTmp=pTmp->next;
      --sum;
    }
  }
  return 1;
}
#endif

/********************************************************************
 *
 *  StackInsert
 *
 *Finds the element by index and inserts new element in it index.
 *
 *[in,out] stack **first   -Pointer to a pointer that specifies
 *                          the first element in the stack
 *[in,out] stack **last    -Pointer to a pointer that specifies
 *                          the top element in the stack
 *   [out] stack **element -Pointer to a pointer to the element
 *    [in] int index       -Number of the element if positive search
 *                          from top if negative from beginning
 *    [in] int bytes       -Size of the structure
 *
 *Returns: 0 on success
 *         1 on wrong index
 ********************************************************************/
#if defined StackInsert || defined ALLSTACKFUNC
#define StackInsert_INCLUDED
#undef StackInsert
int StackInsert(stack **first, stack **last, stack **element, int index, int bytes)
{
  stack *pTmp;
  int sum;
  *element=NULL;

  if (index > 0)
  {
    pTmp=*last;
    sum=1;
  }
  else if (index < 0)
  {
    pTmp=*first;
    sum=-1;
  }
  else return 1;

  while ((pTmp) || (sum == index))
  {
    if (sum == index)
    {
      *element=(stack *)GlobalAlloc(GPTR, bytes);

      if (!pTmp)
      {
        if (index > 0)
        {
          if (*first)
          {
            (*first)->prev=*element;
            (*element)->next=*first;
          }
          else
            *last=*element;
          *first=*element;
        }
        else
        {
          if (*last)
          {
            (*last)->next=*element;
            (*element)->prev=*last;
          }
          else
            *first=*element;
          *last=*element;
        }
      }
      else if (index > 0)
      {
        if (pTmp == *last) *last=*element;
        else pTmp->next->prev=*element;

        (*element)->prev=pTmp;
        (*element)->next=pTmp->next;
        pTmp->next=*element;
      }
      else
      {
        if (pTmp == *first) *first=*element;
        else pTmp->prev->next=*element;

        (*element)->next=pTmp;
        (*element)->prev=pTmp->prev;
        pTmp->prev=*element;
      }
      return 0;
    }
    if (index > 0)
    {
      pTmp=pTmp->prev;
      ++sum;
    }
    else
    {
      pTmp=pTmp->next;
      --sum;
    }
  }
  return 1;
}
#endif

/********************************************************************
 *
 *  StackDelete
 *
 *Removes element.
 *
 *[in,out] stack **first   -Pointer to a pointer that specifies
 *                          the first element in the stack
 *[in,out] stack **last    -Pointer to a pointer that specifies
 *                          the top element in the stack
 *    [in] stack *element  -Pointer to the element
 *
 *Returns: 0 on success
 *         1 on empty stack
 ********************************************************************/
#if defined StackDelete || defined ALLSTACKFUNC
#define StackDelete_INCLUDED
#undef StackDelete
int StackDelete(stack **first, stack **last, stack *element)
{
  if (!element) return 1;

  if (element == *first)
  {
    *first=element->next;
    if (*first) (*first)->prev=NULL;
    else *last=NULL;
  }
  else if (element == *last)
  {
    *last=element->prev;
    if (*last) (*last)->next=NULL;
    else *first=NULL;
  }
  else
  {
    element->prev->next=element->next;
    element->next->prev=element->prev;
  }
  GlobalFree((HGLOBAL)element);
  return 0;
}
#endif

/********************************************************************
 *
 *  StackMove
 *
 *Finds the element by index and move it to the new index.
 *
 *[in,out] stack **first   -Pointer to a pointer that specifies
 *                          the first element in the stack
 *[in,out] stack **last    -Pointer to a pointer that specifies
 *                          the top element in the stack
 *    [in] int index       -Number of the element if positive search
 *                          from top if negative from beginning (source)
 *    [in] int index2      -Number of the element if positive search
 *                          from top if negative from beginning (destination)
 *
 *Returns: 0 on success
 *         1 on empty stack
 *         2 source and destination indexes pointed to the same element
 ********************************************************************/
#if defined StackMove || defined ALLSTACKFUNC
#define StackMove_INCLUDED
#undef StackMove
int StackMove(stack **first, stack **last, int index, int index2)
{
  stack *pTmp;
  stack *pTmp2=NULL;
  int sum;
  BOOL bMeet=FALSE;

  loop:

  if (index > 0)
  {
    pTmp=*last;
    sum=1;
  }
  else if (index < 0)
  {
    pTmp=*first;
    sum=-1;
  }
  else return 1;

  while (pTmp)
  {
    if (pTmp == pTmp2) bMeet=TRUE;

    if (sum == index)
    {
      if (!pTmp2)
      {
        pTmp2=pTmp;
        index=index2;
        goto loop;
      }
      if (pTmp2 == pTmp) return 2;

      if (pTmp2 == *first)
      {
        *first=pTmp2->next;
        pTmp2->next->prev=NULL;
      }
      else if (pTmp2 == *last)
      {
        *last=pTmp2->prev;
        pTmp2->prev->next=NULL;
      }
      else
      {
        pTmp2->next->prev=pTmp2->prev;
        pTmp2->prev->next=pTmp2->next;
      }

      if ((bMeet == FALSE && index < 0) || (bMeet == TRUE && index > 0))
      {
        if (pTmp == *first) *first=pTmp2;
        else pTmp->prev->next=pTmp2;

        pTmp2->next=pTmp;
        pTmp2->prev=pTmp->prev;
        pTmp->prev=pTmp2;
      }
      else
      {
        if (pTmp == *last) *last=pTmp2;
        else pTmp->next->prev=pTmp2;

        pTmp2->prev=pTmp;
        pTmp2->next=pTmp->next;
        pTmp->next=pTmp2;
      }
      return 0;
    }
    if (index > 0)
    {
      pTmp=pTmp->prev;
      ++sum;
    }
    else
    {
      pTmp=pTmp->next;
      --sum;
    }
  }
  return 1;
}
#endif

/********************************************************************
 *
 *  StackExchange
 *
 *Finds the elements by indexes and exchanges them.
 *
 *[in,out] stack **first   -Pointer to a pointer that specifies
 *                          the first element in the stack
 *[in,out] stack **last    -Pointer to a pointer that specifies
 *                          the top element in the stack
 *    [in] int index       -Number of the element if positive search
 *                          from top if negative from beginning
 *    [in] int index2      -Number of the element if positive search
 *                          from top if negative from beginning
 *
 *Returns: 0 on success
 *         1 on empty stack
 *         2 indexes pointed to the same element
 ********************************************************************/
#if defined StackExchange || defined ALLSTACKFUNC
#define StackExchange_INCLUDED
#undef StackExchange
int StackExchange(stack **first, stack **last, int index, int index2)
{
  stack *pTmp;
  stack *pTmp2=NULL;
  stack *pTmp3;
  stack *pTmp4;
  struct _stack *pTmpNext;
  struct _stack *pTmpPrev;
  int sum;
  BOOL bMeet=FALSE;

  loop:

  if (index > 0)
  {
    pTmp=*last;
    sum=1;
  }
  else if (index < 0)
  {
    pTmp=*first;
    sum=-1;
  }
  else return 1;

  while (pTmp)
  {
    if (pTmp == pTmp2) bMeet=TRUE;

    if (sum == index)
    {
      if (!pTmp2)
      {
        pTmp2=pTmp;
        index=index2;
        goto loop;
      }
      if (pTmp2 == pTmp) return 2;

      if ((bMeet == FALSE && index < 0) || (bMeet == TRUE && index > 0))
      {
        pTmp3=pTmp;
        pTmp4=pTmp2;
        pTmp=pTmp4;
        pTmp2=pTmp3;
      }
      pTmpNext=pTmp2->next;
      pTmpPrev=pTmp2->prev;

      if (pTmp2 == *first) *first=pTmp;
      else pTmp2->prev->next=pTmp;

      if (pTmp == *last) *last=pTmp2;
      else pTmp->next->prev=pTmp2;

      if (pTmp2->next == pTmp)
      {
        pTmp2->next=pTmp->next;
        pTmp2->prev=pTmp;
        pTmp->next=pTmp2;
        pTmp->prev=pTmpPrev;
      }
      else
      {
        pTmp2->next->prev=pTmp;
        pTmp->prev->next=pTmp2;

        pTmp2->next=pTmp->next;
        pTmp2->prev=pTmp->prev;
        pTmp->next=pTmpNext;
        pTmp->prev=pTmpPrev;
      }
      return 0;
    }
    if (index > 0)
    {
      pTmp=pTmp->prev;
      ++sum;
    }
    else
    {
      pTmp=pTmp->next;
      --sum;
    }
  }
  return 1;
}
#endif

/********************************************************************
 *
 *  StackDeleteRange
 *
 *Finds the elements between indexes and removes.
 *
 *[in,out] stack **first   -Pointer to a pointer that specifies
 *                          the first element in the stack
 *[in,out] stack **last    -Pointer to a pointer that specifies
 *                          the top element in the stack
 *    [in] int index       -Number of the element if positive search
 *                          from top if negative from beginning (range limit)
 *    [in] int index2      -Number of the element if positive search
 *                          from top if negative from beginning (range limit)
 *
 *Returns: 0 on success
 *         1 on empty stack
 ********************************************************************/
#if defined StackDeleteRange || defined ALLSTACKFUNC
#define StackDeleteRange_INCLUDED
#undef StackDeleteRange
int StackDeleteRange(stack **first, stack **last, int index, int index2)
{
  stack *pTmp;
  stack *pTmp2=NULL;
  stack *pTmp3;
  stack *pTmp4;
  int sum;
  BOOL bMeet=FALSE;
  BOOL bExit=FALSE;

  loop:

  if (index > 0)
  {
    pTmp=*last;
    sum=1;
  }
  else if (index < 0)
  {
    pTmp=*first;
    sum=-1;
  }
  else return 1;

  while (pTmp)
  {
    if (pTmp == pTmp2) bMeet=TRUE;

    if (sum == index)
    {
      if (!pTmp2)
      {
        pTmp2=pTmp;
        index=index2;
        goto loop;
      }
      if ((bMeet == FALSE && index < 0) || (bMeet == TRUE && index > 0))
      {
        pTmp3=pTmp;
        pTmp4=pTmp2;
        pTmp=pTmp4;
        pTmp2=pTmp3;
      }

      if ((pTmp2 == *first) && (pTmp == *last))
      {
        *first=NULL;
        *last=NULL;
      }
      else if (pTmp2 == *first)
      {
        *first=pTmp->next;
        (*first)->prev=NULL;
      }
      else if (pTmp == *last)
      {
        *last=pTmp2->prev;
        (*last)->next=NULL;
      }
      else
      {
        pTmp2->prev->next=pTmp->next;
        pTmp->next->prev=pTmp2->prev;
      }

      for (; bExit != TRUE; pTmp=pTmp3)
      {
        if (pTmp2 == pTmp) bExit=TRUE;
        else pTmp3=pTmp->prev;
        GlobalFree((HGLOBAL)pTmp);
      }
      return 0;
    }
    if (index > 0)
    {
      pTmp=pTmp->prev;
      ++sum;
    }
    else
    {
      pTmp=pTmp->next;
      --sum;
    }
  }
  return 1;
}
#endif

/********************************************************************
 *
 *  StackMoveRange
 *
 *Finds the elements by indexes and move them to the new index.
 *
 *[in,out] stack **first   -Pointer to a pointer that specifies
 *                          the first element in the stack
 *[in,out] stack **last    -Pointer to a pointer that specifies
 *                          the top element in the stack
 *    [in] int index       -Number of the element if positive search
 *                          from top if negative from beginning (range limit)
 *    [in] int index2      -Number of the element if positive search
 *                          from top if negative from beginning (range limit)
 *    [in] int index3      -Number of the element if positive search
 *                          from top if negative from beginning (destination)
 *
 *Returns: 0 on success
 *         1 on empty stack
 *         2 destination index pointed to the element in the range
 ********************************************************************/
#if defined StackMoveRange || defined ALLSTACKFUNC
#define StackMoveRange_INCLUDED
#undef StackMoveRange
int StackMoveRange(stack **first, stack **last, int index, int index2, int index3)
{
  stack *pTmp;
  stack *pTmp2=NULL;
  stack *pTmp3=NULL;
  stack *pTmp4;
  stack *pTmp5;
  int sum;
  int nMeet=0;
  BOOL bMeet=FALSE;

  loop:

  if (index > 0)
  {
    pTmp=*last;
    sum=1;
  }
  else if (index < 0)
  {
    pTmp=*first;
    sum=-1;
  }
  else return 1;

  while (pTmp)
  {
    if (pTmp3)
    {
      if (pTmp == pTmp2) ++nMeet;
      if (pTmp == pTmp3) ++nMeet;
      else if (nMeet == 2) nMeet=3;
    }
    else if (pTmp == pTmp2) bMeet=TRUE;

    if (sum == index)
    {
      if (!pTmp2)
      {
        pTmp2=pTmp;
        index=index2;
        goto loop;
      }
      if (!pTmp3)
      {
        pTmp3=pTmp;
        index=index3;
        goto loop;
      }

      if (nMeet == 1 || nMeet == 2) return 2;

      if ((bMeet == FALSE && index2 < 0) || (bMeet == TRUE && index2 > 0))
      {
        pTmp4=pTmp2;
        pTmp5=pTmp3;
        pTmp2=pTmp5;
        pTmp3=pTmp4;
      }

      if (pTmp2 == *first && pTmp3 == *last) return 2;

      if (pTmp2 == *first)
      {
        *first=pTmp3->next;
        pTmp3->next->prev=NULL;
      }
      else if (pTmp3 == *last)
      {
        *last=pTmp2->prev;
        pTmp2->prev->next=NULL;
      }
      else
      {
        pTmp3->next->prev=pTmp2->prev;
        pTmp2->prev->next=pTmp3->next;
      }

      if ((nMeet == 0 && index < 0) || (nMeet == 3 && index > 0))
      {
        if (pTmp == *first) *first=pTmp2;
        else pTmp->prev->next=pTmp2;

        pTmp3->next=pTmp;
        pTmp2->prev=pTmp->prev;
        pTmp->prev=pTmp3;
      }
      else
      {
        if (pTmp == *last) *last=pTmp3;
        else pTmp->next->prev=pTmp3;

        pTmp2->prev=pTmp;
        pTmp3->next=pTmp->next;
        pTmp->next=pTmp2;
      }
      return 0;
    }
    if (index > 0)
    {
      pTmp=pTmp->prev;
      ++sum;
    }
    else
    {
      pTmp=pTmp->next;
      --sum;
    }
  }
  return 1;
}
#endif

/********************************************************************
 *
 *  StackJoin
 *
 *Joins two stacks.
 *
 *[in,out] stack **first     -Pointer to a pointer that specifies
 *                            the first element in the stack
 *[in,out] stack **last      -Pointer to a pointer that specifies
 *                            the top element in the stack
 *    [in] stack *joinfirst  -Pointer to a pointer that specifies
 *                            the first element in the stack
 *    [in] stack *joinlast   -Pointer to a pointer that specifies
 *                            the top element in the stack
 *    [in] BOOL top          -If TRUE second stack will be joined
 *                            to the top of the first stack.
 *                            If FALSE second stack will be joined
 *                            to the beginning of the first stack.
 ********************************************************************/
#if defined StackJoin || defined ALLSTACKFUNC
#define StackJoin_INCLUDED
#undef StackJoin
void StackJoin(stack **first, stack **last, stack *joinfirst, stack *joinlast, BOOL top)
{
  if (!*first)
  {
    *first=joinfirst;
    *last=joinlast;
  }
  else if (joinfirst)
  {
    if (top)
    {
      (*last)->next=joinfirst;
      joinfirst->prev=*last;
      *last=joinlast;
    }
    else
    {
      (*first)->prev=joinlast;
      joinlast->next=*first;
      *first=joinfirst;
    }
  }
}
#endif

/********************************************************************
 *
 *  StackSplit
 *
 *Splits stack.
 *
 *[in,out] stack **first       -Pointer to a pointer that specifies
 *                              the first element in the stack
 *[in,out] stack **last        -Pointer to a pointer that specifies
 *                              the top element in the stack
 *   [out] stack **splitfirst  -Pointer to a pointer that specifies
 *                              the first element in the stack
 *   [out] stack **splitlast   -Pointer to a pointer that specifies
 *                              the top element in the stack
 *    [in] int index           -Number of the element if positive search
 *                              from top if negative from beginning.
 *                              After spliting this element will be
 *                              the last element of the first stack.
 *
 *Returns: 0 on success
 *         1 on empty stack
 ********************************************************************/
#if defined StackSplit || defined ALLSTACKFUNC
#define StackSplit_INCLUDED
#undef StackSplit
int StackSplit(stack **first, stack **last, stack **splitfirst, stack **splitlast, int index)
{
  stack *pTmp;
  int sum;

  if (index > 0)
  {
    pTmp=*last;
    sum=1;
  }
  else if (index < 0)
  {
    pTmp=*first;
    sum=-1;
  }
  else return 1;

  while (pTmp)
  {
    if (sum == index)
    {
      if (pTmp == *last)
      {
        *splitfirst=NULL;
        *splitlast=NULL;
      }
      else
      {
        *splitfirst=pTmp->next;
        *splitlast=*last;
        *last=pTmp;
        (*splitfirst)->prev=NULL;
        (*last)->next=NULL;
      }
      return 0;
    }
    if (index > 0)
    {
      pTmp=pTmp->prev;
      ++sum;
    }
    else
    {
      pTmp=pTmp->next;
      --sum;
    }
  }
  return 1;
}
#endif

/********************************************************************
 *
 *  StackSize
 *
 *Gets the number of elements in the stack.                         
 *
 *[in] stack *first   -Pointer that specifies the first
 *                     element in the stack
 *[in] stack *last    -Pointer that specifies the top
 *                     element in the stack
 *
 *Returns: the number of elements
 ********************************************************************/
#if defined StackSize || defined ALLSTACKFUNC
#define StackSize_INCLUDED
#undef StackSize
int StackSize(stack *first, stack *last)
{
  stack *pTmp=last;
  int sum;

  for (sum=0; (pTmp); ++sum)
    pTmp=pTmp->prev;
  return sum;
}
#endif

/********************************************************************
 *
 *  StackClear
 *
 *Clear all stack.
 *
 *[in,out] stack **first   -Pointer to a pointer that specifies
 *                          the first element in the stack
 *[in,out] stack **last    -Pointer to a pointer that specifies
 *                          the top element in the stack
 ********************************************************************/
#if defined StackClear || defined ALLSTACKFUNC
#define StackClear_INCLUDED
#undef StackClear
void StackClear(stack **first, stack **last)
{
  stack *pTmp=*last;
  stack *pTmp2;

  while (pTmp)
  {
    pTmp2=pTmp->prev;
    GlobalFree((HGLOBAL)pTmp);
    pTmp=pTmp2;
  }
  *last=NULL;
  *first=NULL;
}
#endif


/********************************************************************
 ********************************************************************
 *                                                                  *
 *                   Special bilinear functions                     *
 *                                                                  *
 ********************************************************************
 ********************************************************************/


/********************************************************************
 *
 *  StackReverseRange
 *
 *Reverse range of elements.
 *
 *[in,out] stack **first   -Pointer to a pointer that specifies
 *                          the first element in the stack
 *[in,out] stack **last    -Pointer to a pointer that specifies
 *                          the top element in the stack
 *    [in] int index       -Number of the element if positive search
 *                          from top if negative from beginning (range limit)
 *    [in] int index2      -Number of the element if positive search
 *                          from top if negative from beginning (range limit)
 *
 *Returns: 0 on success
 *         1 on empty stack
 *         2 indexes pointed to the same element
 *Note:
 *  StackReverseRange uses StackExchange, StackSize
 ********************************************************************/
#if (defined StackReverseRange || defined ALLSTACKFUNCS) && defined StackExchange_INCLUDED && defined StackSize_INCLUDED
#define StackReverseRange_INCLUDED
#undef StackReverseRange
int StackReverseRange(stack **first, stack **last, int index, int index2)
{
  int a,b;

  if (index < 0 && index2 > 0)
    index=StackSize(*first, *last) + index + 1;
  if (index > 0 && index2 < 0)
    index2=StackSize(*first, *last) + index2 + 1;

  if (index == index2) return 2;

  if (index > index2)
  {
    a=index;
    b=index2;
    index=b;
    index2=a;
  }
  for (a=0; index < index2 && a == 0; ++index, --index2)
    a=StackExchange(first, last, index, index2);
  return a;
}
#endif

/********************************************************************
 *
 *  StackPushSort
 *
 *Pushs element to the stack and sorts alphabetically in ascending or descending.
 *
 *[in,out] stackS **first   -Pointer to a pointer that specifies
 *                           the first element in the stack
 *[in,out] stackS **last    -Pointer to a pointer that specifies
 *                           the top element in the stack
 *   [out] stackS **element -Pointer to a pointer to the element
 *    [in] char *str        -String
 *    [in] int nUpDown      -Sorts in "1"-ascending, "-1"-descending
 *    [in] int bytes        -Size of the structure
 *
 *Note:
 *  StackPushSort uses StackInsert
 ********************************************************************/

#if (defined StackPushSort || defined ALLSTACKFUNCS) && defined StackInsert_INCLUDED
#define StackPushSort_INCLUDED
#undef StackPushSort
void StackPushSort(stackS **first, stackS **last, stackS **element, char *str, int nUpDown, int bytes)
{
  stackS *pTmp=*last;
  int a,b;

  if (nUpDown != 1 && nUpDown != -1) return;

  for (a=1; (pTmp); ++a, pTmp=pTmp->prev)
  {
    b=lstrcmpi(pTmp->string, str);
    if (b == 0 || b == nUpDown) break;
  }
  StackInsert((stack **)first, (stack **)last, (stack **)element, a, bytes);
}
#endif

/********************************************************************
 *
 *  StackSort
 *
 *Sorts the stack alphabetically in ascending or descending.
 *
 *[in,out] stackS **first   -Pointer to a pointer that specifies
 *                           the first element in the stack
 *[in,out] stackS **last    -Pointer to a pointer that specifies
 *                           the top element in the stack
 *    [in] int nUpDown      -Sorts in "1"-ascending, "-1"-descending
 *
 *Note:
 *  StackSort uses StackMove, StackElement
 ********************************************************************/

#if (defined StackSort || defined ALLSTACKFUNCS) && defined StackMove_INCLUDED && defined StackElement_INCLUDED
#define StackSort_INCLUDED
#undef StackSort
void StackSort(stackS **first, stackS **last, int nUpDown)
{
  stackS *pTmp;
  stackS *pTmp2;
  int a,b,c;

  if (nUpDown != 1 && nUpDown != -1) return;

  for (a=2; !StackElement((stack *)first, (stack *)last, (stack **)&pTmp, a); ++a)
    for (b=1; b < a && !StackElement((stack *)first, (stack *)last, (stack **)&pTmp2, b); ++b)
    {
      c=lstrcmpi(pTmp2->string, pTmp->string);
      if (c == 0 || c == nUpDown)
      {
        StackMove((stack **)first, (stack **)last, a, b);
        break;
      }
    }
}
#endif


/********************************************************************
 *                                                                  *
 *                           Example                                *
 *                                                                  *
 ********************************************************************

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>

//insert functions
#define StackInsert
#define StackElement
#define StackDelete
#include "StackFunc.h"

//structure initialization
typedef struct _mystack {
  struct _mystack *next;
  struct _mystack *prev;
  char szText[MAX_PATH];
  DWORD dwLength;
} mystack;

//stack initialization
mystack *element=NULL, *first=NULL, *last=NULL;

void main()
{
  int nError;
  
  StackInsert((stack **)&first, (stack **)&last, (stack **)&element, 1, sizeof(mystack));
  lstrcpy(element->szText, "some string");
  
  if (!(nError=StackElement((stack *)first, (stack *)last, (stack **)&element, 1)))
  {
    printf("element={%s}, error={%d}\n", element->szText, nError);
    StackDelete((stack **)&first, (stack **)&last, (stack *)element);
  }
}

*/
