/*****************************************************************
 *              String functions header v1.7                     *
 *                                                               *
 * 2006 Shengalts Aleksander aka Instructor (Shengalts@mail.ru)  *
 *                                                               *
 *                                                               *
 *Functions:                                                     *
 * WordFind, StrReplace, GetOptions, lstrcmpn, FindWordString    *
 *                                                               *
 *****************************************************************/

#ifndef _STRFUNC_
#define _STRFUNC_ 
#endif

/********************************************************************
 *
 *  WordFind
 *
 *String manipulation function.
 *
 * [in] char *pText      Text
 * [in] char *pDelim     Delimiter
 * [in] int nNumber      Number of the delimiter/word if positive
 *                        search from beginning if negative from end,
 *                        if (nNumber == 0) then returns sum of delimiters/words
 * [in] char *pOption    ">"     all text before founded delimiter
 *                       "<"     all text after founded delimiter
 *                       "<>"    deletes delimiter
 *                       "*"     text between delimiters (word)
 *                       "*>"    all text after founded word
 *                       ">*"    word and all text after founded word
 *                       "<*"    all text before founded word
 *                       "*<"    word and all text before founded word
 *                       "<*>"   deletes word and neighbouring delimiter
 * [in] BOOL bSensitive  TRUE   case sensitive
 *                       FALSE  case insensitive
 *[out] char *szResult   Output for result string, can be NULL
 *[out] int *nMaxResult  Contains the length of the result string,
 *                       not including the terminating null character,
 *                       can be NULL
 *[out] char **ppResult  Pointer to the first character of result string in pText,
 *                        can be NULL
 *
 *Returns (nRes):  sum of delimiters/words, if (nNumber == 0)
 *                 -1 syntax error or pDelim is empty
 *                 -2 no delimiters found
 *                 -3 no such delimiter/word number
 *
 *Defines:
 * #define WordFind_UNMINUS  //nNumber only positive (uses for minimize program size)
 * #define WordFind_UNPLUS   //nNumber only negative (uses for minimize program size)
 ********************************************************************/
#ifdef WordFind
#define WordFind_INCLUDED
#undef WordFind
int WordFind(char *pText, char *pDelim, int nNumber, char *pOption, BOOL bSensitive, char *szResult, int *nMaxResult, char **ppResult)
{
  char *pTextStart;
  char *pTextEnd;
  char *pTextMinus=NULL;
  char *pDelimCount;
  char *pDelimMinus=NULL;
  char *pWord;
  char *pResult;
  BOOL bFound=FALSE;
  BOOL bRow=TRUE;
  int nOption=0;
  int nCurStrNumber=0;
  int nCurWordNumber=0;
  int nDelimLen=lstrlen(pDelim);
  int nResultSize;

  if (!lstrcmp(pOption, ">")) nOption=1;
  else if (!lstrcmp(pOption, "<")) nOption=2;
  else if (!lstrcmp(pOption, "<>")) nOption=3;
  else if (!lstrcmp(pOption, "*")) nOption=4;
  else if (!lstrcmp(pOption, "*>")) nOption=5;
  else if (!lstrcmp(pOption, ">*")) nOption=6;
  else if (!lstrcmp(pOption, "<*")) nOption=7;
  else if (!lstrcmp(pOption, "*<")) nOption=8;
  else if (!lstrcmp(pOption, "<*>")) nOption=9;

  if (nDelimLen == 0 || nOption == 0)
    return -1;

  #ifndef WordFind_UNPLUS
  if (nNumber >= 0)
  {
    for (pWord=pTextStart=pTextEnd=pText; *pTextStart && *pTextEnd; ++pTextStart)
    {
      for (pTextEnd=pTextStart, pDelimCount=pDelim;
           (*pTextEnd) &&
           ((bSensitive == TRUE && *pTextEnd == *pDelimCount) ||
            (bSensitive == FALSE && (char)CharUpper((char*)(unsigned)(unsigned char)*pTextEnd) == (char)CharUpper((char*)(unsigned)(unsigned char)*pDelimCount)));
           ++pTextEnd)
      {
        if (!*++pDelimCount)
        {
          if (nOption > 3)
          {
            if (bRow == FALSE && ++nCurWordNumber == nNumber)
            {
              if (nOption == 4)
              {
                pResult=pWord;
                nResultSize=pTextEnd - pResult - nDelimLen + 1;
              }
              else if (nOption == 5)
              {
                pResult=pTextEnd - nDelimLen + 1;
                nResultSize=lstrlen(pResult);
              }
              else if (nOption == 6)
              {
                pResult=pWord;
                nResultSize=lstrlen(pResult);
              }
              else if (nOption == 7)
              {
                pResult=pText;
                nResultSize=pWord - pResult;
              }
              else if (nOption == 8)
              {
                pResult=pText;
                nResultSize=pTextEnd - pResult - nDelimLen + 1;
              }
              else if (nOption == 9)
              {
                pResult=pTextEnd + 1;
                nResultSize=(pWord - pResult) + lstrlen(pResult);
              }
              if (ppResult) *ppResult=pResult;
              if (nMaxResult) *nMaxResult=nResultSize;
              if (szResult)
              {
                if (nOption == 9)
                {
                  lstrcpyn(szResult, pText, pWord - pText + 1);
                  lstrcat(szResult, pResult);
                }
                else lstrcpyn(szResult, pResult, nResultSize + 1);
              }
              return 0;
            }
            pWord=pTextEnd + 1;
            bRow=TRUE;
          }
          else if (++nCurStrNumber == nNumber)
          {
            if (nOption == 1)
            {
              pResult=pTextEnd + 1;
              nResultSize=lstrlen(pResult);
            }
            else if (nOption == 2)
            {
              pResult=pText;
              nResultSize=pTextEnd - pResult - nDelimLen + 1;
            }
            else if (nOption == 3)
            {
              pResult=pTextEnd + 1;
              nResultSize=(pResult - pText - nDelimLen) + lstrlen(pResult);
            }
            if (ppResult) *ppResult=pResult;
            if (nMaxResult) *nMaxResult=nResultSize;
            if (szResult)
            {
              if (nOption == 3)
              {
                lstrcpyn(szResult, pText, pTextEnd - pText - nDelimLen + 2);
                lstrcat(szResult, pResult);
              }
              else lstrcpyn(szResult, pResult, nResultSize + 1);
            }
            return 0;
          }
          pTextStart=pTextEnd + 1;
          pDelimCount=pDelim;
          bFound=TRUE;
        }
      }
      if (*pTextStart && *pTextEnd) bRow=FALSE;
    }
    if (*pTextEnd) pTextEnd=pTextStart;

    if (nOption > 3 && bFound == TRUE && bRow == FALSE && ++nCurWordNumber == nNumber)
    {
      if (nOption == 4 || nOption == 6)
      {
        pResult=pWord;
        nResultSize=pTextEnd - pResult;
      }
      else if (nOption == 5)
      {
        pResult=pTextEnd;
        nResultSize=0;
      }
      else if (nOption == 7)
      {
        pResult=pText;
        nResultSize=pWord - pResult;
      }
      else if (nOption == 8)
      {
        pResult=pText;
        nResultSize=pTextEnd - pResult;
      }
      else if (nOption == 9)
      {
        pResult=pText;
        nResultSize=(pWord - nDelimLen) - pResult;
      }
      if (ppResult) *ppResult=pResult;
      if (nMaxResult) *nMaxResult=nResultSize;
      if (szResult)
      {
        lstrcpyn(szResult, pResult, nResultSize + 1);
      }
      return 0;
    }
    if (nNumber == 0)
    {
      if (nOption <= 3)
        return nCurStrNumber;
      return nCurWordNumber;
    }
  }
  #endif

  #ifndef WordFind_UNMINUS
  else if (nNumber < 0)
  {
    pTextMinus=pTextStart=pTextEnd=pText + lstrlen(pText) - 1;
    pDelimMinus=pDelim + nDelimLen - 1;
    pWord=pTextMinus + 1;

    for (; pTextEnd >= pText && pTextStart >= pText; --pTextEnd)
    {
      for (pTextStart=pTextEnd, pDelimCount=pDelimMinus;
           (pTextStart >= pText) &&
           ((bSensitive == TRUE && *pTextStart == *pDelimCount) ||
            (bSensitive == FALSE && (char)CharUpper((char*)(unsigned)(unsigned char)*pTextStart) == (char)CharUpper((char*)(unsigned)(unsigned char)*pDelimCount)));
           --pTextStart)
      {
        if (--pDelimCount < pDelim)
        {
          if (nOption > 3)
          {
            if (bRow == FALSE && --nCurWordNumber == nNumber)
            {
              if (nOption == 4)
              {
                pResult=pTextStart + nDelimLen;
                nResultSize=pWord - pResult;
              }
              else if (nOption == 5)
              {
                pResult=pWord;
                nResultSize=pTextMinus - pResult + 1;
              }
              else if (nOption == 6)
              {
                pResult=pTextStart + nDelimLen;
                nResultSize=pTextMinus - pResult + 1;
              }
              else if (nOption == 7)
              {
                pResult=pText;
                nResultSize=(pTextStart + nDelimLen) - pResult;
              }
              else if (nOption == 8)
              {
                pResult=pText;
                nResultSize=pWord - pResult;
              }
              else if (nOption == 9)
              {
                pResult=pTextStart;
                nResultSize=(pResult - pText) + (pTextMinus - pWord) + 1;
              }
              if (ppResult) *ppResult=pResult;
              if (nMaxResult) *nMaxResult=nResultSize;
              if (szResult)
              {
                if (nOption == 9)
                {
                  lstrcpyn(szResult, pText, pTextStart - pText + 1);
                  lstrcat(szResult, pWord);
                }
                else lstrcpyn(szResult, pResult, nResultSize + 1);
              }
              return 0;
            }
            pWord=pTextStart;
            bRow=TRUE;
          }
          else if (--nCurStrNumber == nNumber)
          {
            if (nOption == 1)
            {
              pResult=pTextStart + nDelimLen;
              nResultSize=pTextMinus - pResult + 1;
            }
            else if (nOption == 2)
            {
              pResult=pText;
              nResultSize=pTextStart - pResult;
            }
            else if (nOption == 3)
            {
              pResult=pTextStart;
              nResultSize=pTextMinus - pText - nDelimLen + 1;
            }
            if (ppResult) *ppResult=pResult;
            if (nMaxResult) *nMaxResult=nResultSize;
            if (szResult)
            {
              if (nOption == 3)
              {
                lstrcpyn(szResult, pText, pTextStart - pText + 1);
                lstrcat(szResult, pTextStart + nDelimLen);
              }
              else lstrcpyn(szResult, pResult, nResultSize + 1);
            }
            return 0;
          }
          pTextEnd=pTextStart;
          pDelimCount=pDelimMinus;
          bFound=TRUE;
        }
      }
      if (pTextEnd >= pText && pTextStart >= pText) bRow=FALSE;
    }
    if (nOption > 3 && bFound == TRUE && bRow == FALSE && --nCurWordNumber == nNumber)
    {
      if (nOption == 4 || nOption == 8)
      {
        pResult=pText;
        nResultSize=pWord - pResult;
      }
      else if (nOption == 5)
      {
        pResult=pWord;
        nResultSize=pTextMinus - pResult + 1;
      }
      else if (nOption == 6)
      {
        pResult=pText;
        nResultSize=pTextMinus - pResult + 1;
      }
      else if (nOption == 7)
      {
        pResult=pText;
        nResultSize=0;
      }
      else if (nOption == 9)
      {
        pResult=pWord + nDelimLen;
        nResultSize=pTextMinus - pResult + 1;
      }
      if (ppResult) *ppResult=pResult;
      if (nMaxResult) *nMaxResult=nResultSize;
      if (szResult)
      {
        lstrcpyn(szResult, pResult, nResultSize + 1);
      }
      return 0;
    }
  }
  #endif

  if (bFound == TRUE)
    return -3;
  else
    return -2;
}
#endif

/********************************************************************
 *
 *  StrReplace
 *
 *Replace substring in string.
 *
 * [in] char *pText      Text
 * [in] char *pIt        Replace it
 * [in] char *pWith      Replace with
 * [in] BOOL bSensitive  TRUE   case sensitive
 *                       FALSE  case insensitive
 *[out] char *szResult   Output, can be NULL
 *[out] int *nMaxResult  Contains the length of the result string,
 *                       including the terminating null character,
 *                       can be NULL 
 *
 *Returns:  Number of changes
 ********************************************************************/
#ifdef StrReplace
#define StrReplace_INCLUDED
#undef StrReplace
int StrReplace(char *pText, char *pIt, char *pWith, BOOL bSensitive, char *szResult, int *nMaxResult)
{
  char *pTextStart;
  char *pTextEnd;
  char *pItCount;
  char *pResult=szResult;
  int nItLen=lstrlen(pIt);
  int nWithLen=lstrlen(pWith);
  int nChanges=0;

  for (pTextStart=pTextEnd=pText; *pTextStart && *pTextEnd; ++pTextStart)
  {
    for (pTextEnd=pTextStart, pItCount=pIt;
         (*pTextEnd) &&
         ((bSensitive == TRUE && *pTextEnd == *pItCount) ||
          (bSensitive == FALSE && (char)CharUpper((char*)(unsigned)(unsigned char)*pTextEnd) == (char)CharUpper((char*)(unsigned)(unsigned char)*pItCount)));
         ++pTextEnd)
    {
      if (!*++pItCount)
      {
        if (szResult)
        {
          lstrcpyn(pResult, pText, pTextStart - pText + 1);
          lstrcat(pResult, pWith);
        }
        pResult+=pTextEnd - pText - nItLen + nWithLen + 1;
        pText=pTextStart=pTextEnd + 1;
        pItCount=pIt;
        ++nChanges;
      }
    }
  }
  if (*pTextEnd) pTextEnd=pTextStart;

  if (szResult)
  {
    if (nChanges == 0)
      lstrcpy(szResult, pText);
    else
      lstrcat(szResult, pText);
  }
  if (nMaxResult) *nMaxResult=(pResult - szResult) + (pTextEnd - pText) + 1;
  return nChanges;
}
#endif

/********************************************************************
 *
 *  GetOptions
 *
 *Gets option string from parameters line.
 *
 * [in] char *pLine      Parameters line
 * [in] char *pOption    Option
 * [in] BOOL bSensitive  TRUE   case sensitive
 *                       FALSE  case insensitive
 *[out] char *szResult   Output, can be NULL
 * [in] int nMaxResult   Output buffer size
 *
 *Returns:  length of the string copied to szResult,
 *          including the terminating null character 
 ********************************************************************/
#ifdef GetOptions
#define GetOptions_INCLUDED
#undef GetOptions
int GetOptions(char *pLine, char *pOption, BOOL bSensitive, char *szResult, int nMaxResult)
{
  char *pLineStart;
  char *pLineEnd;
  char *pOptionCount;
  char *pOptionString=NULL;
  char chQuote='\0';
  char chDelimiter=*pOption++;
  int nBytes=0;

  for (pLineStart=pLineEnd=pLine; *pLineStart && *pLineEnd; ++pLineStart)
  {
    if (chQuote == '\0' && *pLineStart != '\"' && *pLineStart != '\'' && *pLineStart != '`')
    {
      if (*pLineStart == chDelimiter)
      {
        if (pOptionString) break;

        for (pLineEnd=pLineStart + 1, pOptionCount=pOption;
             (*pLineEnd) &&
             ((bSensitive == TRUE && *pLineEnd == *pOptionCount) ||
              (bSensitive == FALSE && (char)CharUpper((char*)(unsigned)(unsigned char)*pLineEnd) == (char)CharUpper((char*)(unsigned)(unsigned char)*pOptionCount)));
             ++pLineEnd)
        {
          if (!*++pOptionCount)
          {
            pLineStart=pLineEnd;
            pOptionString=pLineEnd + 1;
            break;
          }
        }
      }
    }
    else if (chQuote == '\0')
      chQuote=*pLineStart;
    else if (*pLineStart == chQuote)
      chQuote='\0';
  }
  if (pOptionString)
  {
    while (*--pLineStart == ' ' || *pLineStart == '\t');

    if (*pOptionString == *pLineStart && (*pOptionString == '\"' || *pOptionString == '\'' || *pOptionString == '`'))
    {
      ++pOptionString, --pLineStart;
    }
    nBytes=pLineStart - pOptionString + 2;
    if (szResult)
    {
      if (nMaxResult < nBytes) nBytes=nMaxResult;
      lstrcpyn(szResult, pOptionString, nBytes);
    }
  }
  return nBytes;
}
#endif

/********************************************************************
 *
 *  lstrcmpn
 *
 *Compare characters of two strings.
 *
 *[in] char *pString    First string to compare
 *[in] char *pString2   Second string to compare
 *[in] int nMaxLength   Number of characters to compare
 *[in] BOOL bSensitive  TRUE   case sensitive
 *                      FALSE  case insensitive
 *
 *Returns:  -1 string1 less than string2
 *           0 string1 identical to string2
 *           1 string1 greater than string2
 ********************************************************************/
#ifdef lstrcmpn
#define lstrcmpn_INCLUDED
#undef lstrcmpn
int lstrcmpn(char *pString, char *pString2, int nMaxLength, BOOL bSensitive)
{
  int i;

  for (i=0;
       pString[i] && pString2[i] && i < nMaxLength &&
       ((bSensitive == TRUE && pString[i] == pString2[i]) ||
        (bSensitive == FALSE && (char)CharUpper((char*)(unsigned)(unsigned char)pString[i]) == (char)CharUpper((char*)(unsigned)(unsigned char)pString2[i])));
       ++i);

  if (i >= nMaxLength || (!pString[i] && !pString2[i])) return 0;
  if (pString[i] < pString2[i]) return -1;
  return 1;
}
#endif

/********************************************************************
 *
 *  FindWordString
 *
 *Find word substring in string.
 *
 * [in] char *pText      Text
 * [in] char *pDelim     Delimiter
 * [in] BOOL bSensitive  TRUE   case sensitive
 *                       FALSE  case insensitive
 * [in] char *pWord      Word to find
 *[out] int *nMaxWord    Contains the length of the result word,
 *                        not including the terminating null character,
 *                        can be NULL 
 *[out] char **ppWord    Pointer to the first character of result word in pText,
 *                        can be NULL
 *
 *Returns:  Number of the result word in pText
 *
 *Note:
 *  FindWordString uses WordFind, lstrcmpn
 ********************************************************************/
#ifdef FindWordString
#define FindWordString_INCLUDED
#undef FindWordString
int FindWordString(char *pText, char *pDelim, BOOL bSensitive, char *pWord, int *nMaxWord, char **ppWord)
{
  char *pStart=pText;
  int nWordLen=lstrlen(pWord);
  int nLen;
  int nNumber;

  for (nNumber=1; !WordFind(pStart, pDelim, 1, "*", bSensitive, NULL, &nLen, &pStart); ++nNumber, pStart+=nLen)
  {
    if (nWordLen == nLen && !lstrcmpn(pStart, pWord, nWordLen, bSensitive))
    {
      if (nMaxWord) *nMaxWord=nLen;
      if (ppWord) *ppWord=pStart;
      return nNumber;
    }
  }
  return 0;
}
#endif


/********************************************************************
 *                                                                  *
 *                           Example                                *
 *                                                                  *
 ********************************************************************

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>

//insert functions
#define WordFind
#define StrReplace
#define GetOptions
#define lstrcmpn
#define FindWordString
#include "StrFunc.h"

void main()
{
  char szResult[MAX_PATH];
  char *pStringBegin=NULL;
  int nStringLen;
  int nError;
  
  nError=WordFind("ABC||dfg||HJK", "||", 2, "*", TRUE, szResult, &nStringLen, &pStringBegin);
  printf("szResult={%s}, nStringLen={%d}, pStringBegin={%s}, nError={%d}\n", szResult, nStringLen, pStringBegin, nError);

  nError=StrReplace("ABC||dfg||HJK", "||", "##", TRUE, szResult, &nStringLen);
  printf("szResult={%s}, nStringLen={%d}, nError={%d}\n", szResult, nStringLen, nError);

  nError=GetOptions("/A=123 /B=\"456\" /C=`789`", "/b=", FALSE, szResult, MAX_PATH);
  printf("szResult={%s}, nError={%d}\n", szResult, nError);

  nError=lstrcmpn("ABCdfg", "abcxyz", 3, FALSE);
  printf("nError={%d}\n", nError);

  nError=FindWordString("ABC||dfg||HJK", "||", TRUE, "dfg", &nStringLen, &pStringBegin);
  printf("nStringLen={%d}, pStringBegin={%s}, nError={%d}\n", nStringLen, pStringBegin, nError);
}

*/