/*****************************************************************
 *                 Locate NSIS plugin v1.7                       *
 *                                                               *
 * 2006 Shengalts Aleksander aka Instructor (Shengalts@mail.ru)  *
 *****************************************************************/


/* Comment-out and recompile */
#define LOCATE      //Compile with Locate function
#define GETSIZE     //Compile with GetSize function
#define RMDIR_EMPTY //Compile with RMDirEmpty function



#define WIN32_LEAN_AND_MEAN
#include <windows.h>

/* Defines */
#define NSIS_MAX_STRLEN  1024
#define MAX_EXT          16
#define IDC_STATIC       1006

#define LO_TIME_WRITE         1
#define LO_TIME_CREATION      2
#define LO_TIME_ACCESS        3

#define LO_ATTR_IGNORE        0
#define LO_ATTR_INCLUDE       1
#define LO_ATTR_EXCLUDE       2

#define LO_SORT_FILES_IGNORE  0
#define LO_SORT_FILES_NAME    1
#define LO_SORT_FILES_TYPE    2
#define LO_SORT_FILES_SIZE    3
#define LO_SORT_FILES_DATE    4

#define LO_SORT_DIRS_IGNORE   0
#define LO_SORT_DIRS_NAME     1
#define LO_SORT_DIRS_DATE     2

#define LO_GOTO_END           0
#define LO_GOTO_BEGIN         1
#define LO_GOTO_FINDFIRST     2
#define LO_GOTO_NEXTDIR       3
#define LO_GOTO_NEXTFILE      4

#define LO_BANNER_IGNORE      0
#define LO_BANNER_DETAILS     1
#define LO_BANNER_CALLBACK    2

#define GETSIZE_FUNC          1
#define RMDIR_EMPTY_FUNC      2


/* Include conversion functions */
#define xatoi
#define xitoa
#define xatoi64
#define xi64toa
#include "ConvFunc.h"

/* Include string functions */
#define WordFind_UNMINUS
#define WordFind
#define GetOptions
#define lstrcmpn
#define FindWordString
#include "StrFunc.h"

/* Include private stack functions */
#define StackInsert
#define StackDelete
#define StackJoin
#define StackClear
#include "StackFunc.h"

typedef struct _files_stack {
  struct _files_stack *next;
  struct _files_stack *prev;
  DWORD dwFileAttributes;
  FILETIME ftFileTime;
  char cFileName[MAX_PATH];
  char cExt[MAX_EXT];
  __int64 nFileSize;
} files_stack;

typedef struct _dirs_stack {
  struct _dirs_stack *next;
  struct _dirs_stack *prev;
  DWORD dwFileAttributes;
  FILETIME ftFileTime;
  char cFileName[MAX_PATH];
} dirs_stack;

/* ExDll */
typedef struct _stack_t {
  struct _stack_t *next;
  char text[NSIS_MAX_STRLEN];
} stack_t;

stack_t **g_stacktop;
char *g_variables;
unsigned int g_stringsize;

#define EXDLL_INIT()        \
{                           \
  g_stacktop=stacktop;      \
  g_variables=variables;    \
  g_stringsize=string_size; \
}

/* Global variables */
typedef struct _HLOCATESTACK {
  dirs_stack *path_first;
  dirs_stack *path_last;
  dirs_stack *dirs_first;
  dirs_stack *dirs_last;
  files_stack *files_first;
  files_stack *files_last;
  char szPath[NSIS_MAX_STRLEN];
  char szWildcard[MAX_PATH];
  char szNames[NSIS_MAX_STRLEN];
  char szExt[NSIS_MAX_STRLEN];
  char szPaths[NSIS_MAX_STRLEN];
  char szExcludeFullPaths[NSIS_MAX_STRLEN];
  char szExcludePathNames[NSIS_MAX_STRLEN];
  char *pPaths;
  __int64 nSizeMoreThen;
  __int64 nSizeLessThen;
  __int64 nSize;
  FILETIME lpFileTimeAfter;
  FILETIME lpFileTimeBefore;
  int nDivisor;
  int nElement;
  HANDLE hSearch;
  __int8 nGoto;
  __int8 nTime;
  __int8 nReadOnly;
  __int8 nArchive;
  __int8 nHidden;
  __int8 nSystem;
  __int8 nSortFiles;
  __int8 nSortDirs;
  __int8 nBanner;
  BOOL bFindFiles;
  BOOL bFindDirs;
  BOOL bFindEmptyDirs;
  BOOL bGotoSubDir;
  BOOL bCompareSize;
  BOOL bCompareTime;
  BOOL bCompareAttr;
  BOOL bExtInclude;
  BOOL bExtExclude;
  BOOL bNamesInclude;
  BOOL bNamesExclude;
  BOOL bPaths;
  BOOL bFullPathsExclude;
  BOOL bPathNamesExclude;
  BOOL bOutputReverse;
  BOOL bSortFilesReverse;
  BOOL bSortDirsReverse;
} HLOCATESTACK;

char szBuf[NSIS_MAX_STRLEN];
char szBuf2[NSIS_MAX_STRLEN];
char szOptions[NSIS_MAX_STRLEN];
HANDLE hSearchDetails=0;

char *pExt;
WIN32_FIND_DATA data;
SYSTEMTIME lpSystemTime;
FILETIME lpLocalFileTime;
HLOCATESTACK *hLocateStack;

short nFunction;
__int64 nDirSizeGS;
int nFileSumGS;
int nDirSumGS;
int nBannerGS;
int nRemoveDirRM;
int nBannerRM;

/* Funtions prototypes and macros */
void PushSortName(files_stack **first, files_stack **last, files_stack **element, char *name, int nUpDown, int bytes);
void PushSortType(files_stack **first, files_stack **last, files_stack **element, char *name, char *ext, int nUpDown, int bytes);
void PushSortSize(files_stack **first, files_stack **last, files_stack **element, char *name, __int64 size, int nUpDown, int bytes);
void PushSortDate(files_stack **first, files_stack **last, files_stack **element, char *name, FILETIME date, int nUpDown, int bytes);
void SaveFilesDataToStack(files_stack **first, files_stack **last, files_stack **element, char *name);
void SaveDirsDataToStack(dirs_stack **first, dirs_stack **last, dirs_stack **element, char *name);
void ReturnDataFromStack(files_stack *last);
BOOL SearchFiles(char *path, char *wildcard, BOOL subdir);
char* GetFileExt(char *fname);

int popinteger();
void pushinteger(int integer);
int popstring(char *str);
void pushstring(const char *str);

/* NSIS functions code */
#ifdef LOCATE
void __declspec(dllexport) _Open(HWND hwndParent, int string_size,
                                      char *variables, stack_t **stacktop)
{
  EXDLL_INIT();
  {
    char *pOption;
    int nTimeDayAfterThen=1;
    int nTimeMonthAfterThen=1;
    int nTimeYearAfterThen=1601;
    int nTimeDayBeforeThen=1;
    int nTimeMonthBeforeThen=1;
    int nTimeYearBeforeThen=30827;
    int i;

    hLocateStack=(HLOCATESTACK *)GlobalAlloc(GPTR, sizeof(HLOCATESTACK));
    hLocateStack->pPaths=&hLocateStack->szPaths[0];
    hLocateStack->nSizeMoreThen=-1;
    hLocateStack->nSizeLessThen=-1;
    hLocateStack->nDivisor=1;
    hLocateStack->nElement=1;
    hLocateStack->nTime=LO_TIME_WRITE;
    hLocateStack->bFindFiles=TRUE;
    hLocateStack->bFindDirs=TRUE;
    hLocateStack->bGotoSubDir=TRUE;

    popstring(hLocateStack->szPaths);
    popstring(szOptions);

    if (GetOptions(szOptions, "/F=", FALSE, szBuf, NSIS_MAX_STRLEN) && *szBuf == '0')
      hLocateStack->bFindFiles=FALSE;
    if (GetOptions(szOptions, "/D=", FALSE, szBuf, NSIS_MAX_STRLEN) && *szBuf == '0')
      hLocateStack->bFindDirs=FALSE;
    if (GetOptions(szOptions, "/DE=", FALSE, szBuf, NSIS_MAX_STRLEN) && *szBuf == '1')
    {
      hLocateStack->bFindEmptyDirs=TRUE;
      hLocateStack->bFindDirs=FALSE;
    }
    if (GetOptions(szOptions, "/S=", FALSE, szBuf, NSIS_MAX_STRLEN))
    {
      if (!WordFind(szBuf, ",", 1, ">", TRUE, NULL, NULL, &pOption))
      {
        if (*pOption == 'K' || *pOption == 'k') hLocateStack->nDivisor=1024;
        else if (*pOption == 'M' || *pOption == 'm') hLocateStack->nDivisor=1048576;
        else if (*pOption == 'G' || *pOption == 'g') hLocateStack->nDivisor=1073741824;

        *(pOption - 1)='\0';

        if (*szBuf && !WordFind(szBuf, ":", 1, ">", TRUE, NULL, NULL, &pOption))
        {
          if (*pOption) hLocateStack->nSizeLessThen=xatoi64(pOption) * hLocateStack->nDivisor;
          *(pOption - 1)='\0';
          if (*szBuf) hLocateStack->nSizeMoreThen=xatoi64(szBuf) * hLocateStack->nDivisor;
          hLocateStack->bCompareSize=TRUE;
        }
      }
    }
    if (GetOptions(szOptions, "/T=", FALSE, szBuf, NSIS_MAX_STRLEN))
    {
      if (!WordFind(szBuf, ",", 1, ">", TRUE, NULL, NULL, &pOption))
      {
        if (*pOption == 'C' || *pOption == 'c') hLocateStack->nTime=LO_TIME_CREATION;
        else if (*pOption == 'A' || *pOption == 'c') hLocateStack->nTime=LO_TIME_ACCESS;

        *(pOption - 1)='\0';

        if (*szBuf && !WordFind(szBuf, ":", 1, ">", TRUE, NULL, NULL, &pOption))
        {
          if (*pOption)
          {
            WordFind(pOption, ".", 1, "*", TRUE, szBuf2, NULL, NULL);
            nTimeDayBeforeThen=xatoi(szBuf2);
            WordFind(pOption, ".", 2, "*", TRUE, szBuf2, NULL, NULL);
            nTimeMonthBeforeThen=xatoi(szBuf2);
            WordFind(pOption, ".", 3, "*", TRUE, szBuf2, NULL, NULL);
            nTimeYearBeforeThen=xatoi(szBuf2);
          }

          *(pOption - 1)='\0';

          if (*szBuf)
          {
            WordFind(szBuf, ".", 1, "*", TRUE, szBuf2, NULL, NULL);
            nTimeDayAfterThen=xatoi(szBuf2);
            WordFind(szBuf, ".", 2, "*", TRUE, szBuf2, NULL, NULL);
            nTimeMonthAfterThen=xatoi(szBuf2);
            WordFind(szBuf, ".", 3, "*", TRUE, szBuf2, NULL, NULL);
            nTimeYearAfterThen=xatoi(szBuf2);
          }

          lpSystemTime.wHour=0;
          lpSystemTime.wMinute=0;
          lpSystemTime.wSecond=0;
          lpSystemTime.wDay=nTimeDayAfterThen;
          lpSystemTime.wMonth=nTimeMonthAfterThen;
          lpSystemTime.wYear=nTimeYearAfterThen;
          SystemTimeToFileTime(&lpSystemTime, &hLocateStack->lpFileTimeAfter);

          lpSystemTime.wHour=23;
          lpSystemTime.wMinute=59;
          lpSystemTime.wSecond=59;
          lpSystemTime.wDay=nTimeDayBeforeThen;
          lpSystemTime.wMonth=nTimeMonthBeforeThen;
          lpSystemTime.wYear=nTimeYearBeforeThen;
          SystemTimeToFileTime(&lpSystemTime, &hLocateStack->lpFileTimeBefore);

          hLocateStack->bCompareTime=TRUE;
        }
      }
    }
    if (GetOptions(szOptions, "/A=", FALSE, szBuf, NSIS_MAX_STRLEN))
    {
      lstrcat(szBuf, "|");
      if (FindWordString(szBuf, "|", FALSE, "READONLY", NULL, NULL))
        hLocateStack->nReadOnly=LO_ATTR_INCLUDE;
      else if (FindWordString(szBuf, "|", FALSE, "-READONLY", NULL, NULL))
        hLocateStack->nReadOnly=LO_ATTR_EXCLUDE;

      if (FindWordString(szBuf, "|", FALSE, "ARCHIVE", NULL, NULL))
        hLocateStack->nArchive=LO_ATTR_INCLUDE;
      else if (FindWordString(szBuf, "|", FALSE, "-ARCHIVE", NULL, NULL))
        hLocateStack->nArchive=LO_ATTR_EXCLUDE;

      if (FindWordString(szBuf, "|", FALSE, "HIDDEN", NULL, NULL))
        hLocateStack->nHidden=LO_ATTR_INCLUDE;
      else if (FindWordString(szBuf, "|", FALSE, "-HIDDEN", NULL, NULL))
        hLocateStack->nHidden=LO_ATTR_EXCLUDE;

      if (FindWordString(szBuf, "|", FALSE, "SYSTEM", NULL, NULL))
        hLocateStack->nSystem=LO_ATTR_INCLUDE;
      else if (FindWordString(szBuf, "|", FALSE, "-SYSTEM", NULL, NULL))
        hLocateStack->nSystem=LO_ATTR_EXCLUDE;

      hLocateStack->bCompareAttr=TRUE;
    }
    if (GetOptions(szOptions, "/SF=", FALSE, szBuf, NSIS_MAX_STRLEN))
    {
      if (!lstrcmpi(szBuf, "NAME")) hLocateStack->nSortFiles=LO_SORT_FILES_NAME;
      else if (!lstrcmpi(szBuf, "TYPE")) hLocateStack->nSortFiles=LO_SORT_FILES_TYPE;
      else if (!lstrcmpi(szBuf, "SIZE")) hLocateStack->nSortFiles=LO_SORT_FILES_SIZE;
      else if (!lstrcmpi(szBuf, "DATE")) hLocateStack->nSortFiles=LO_SORT_FILES_DATE;
    }
    else if (GetOptions(szOptions, "/-SF=", FALSE, szBuf, NSIS_MAX_STRLEN))
    {
      if (!lstrcmpi(szBuf, "NAME")) hLocateStack->nSortFiles=LO_SORT_FILES_NAME;
      else if (!lstrcmpi(szBuf, "TYPE")) hLocateStack->nSortFiles=LO_SORT_FILES_TYPE;
      else if (!lstrcmpi(szBuf, "SIZE")) hLocateStack->nSortFiles=LO_SORT_FILES_SIZE;
      else if (!lstrcmpi(szBuf, "DATE")) hLocateStack->nSortFiles=LO_SORT_FILES_DATE;

      hLocateStack->bSortFilesReverse=TRUE;
    }
    if (GetOptions(szOptions, "/SD=", FALSE, szBuf, NSIS_MAX_STRLEN))
    {
      if (!lstrcmpi(szBuf, "NAME")) hLocateStack->nSortDirs=LO_SORT_DIRS_NAME;
      else if (!lstrcmpi(szBuf, "DATE")) hLocateStack->nSortDirs=LO_SORT_DIRS_DATE;
    }
    else if (GetOptions(szOptions, "/-SD=", FALSE, szBuf, NSIS_MAX_STRLEN))
    {
      if (!lstrcmpi(szBuf, "NAME")) hLocateStack->nSortDirs=LO_SORT_DIRS_NAME;
      else if (!lstrcmpi(szBuf, "DATE")) hLocateStack->nSortDirs=LO_SORT_DIRS_DATE;

      hLocateStack->bSortDirsReverse=TRUE;
    }
    if (GetOptions(szOptions, "/R=", FALSE, szBuf, NSIS_MAX_STRLEN) && *szBuf == '1')
      hLocateStack->bOutputReverse=TRUE;
    if (!GetOptions(szOptions, "/M=", FALSE, hLocateStack->szWildcard, NSIS_MAX_STRLEN))
      lstrcpy(hLocateStack->szWildcard, "*.*");
    if (GetOptions(szOptions, "/N=", FALSE, hLocateStack->szNames, NSIS_MAX_STRLEN) && *hLocateStack->szNames)
    {
      lstrcat(hLocateStack->szNames, "|");
      hLocateStack->bNamesInclude=TRUE;
    }
    else if (GetOptions(szOptions, "/-N=", FALSE, hLocateStack->szNames, NSIS_MAX_STRLEN) && *hLocateStack->szNames)
    {
      lstrcat(hLocateStack->szNames, "|");
      hLocateStack->bNamesExclude=TRUE;
    }
    if (GetOptions(szOptions, "/X=", FALSE, hLocateStack->szExt, NSIS_MAX_STRLEN))
    {
      if (*hLocateStack->szExt) lstrcat(hLocateStack->szExt, "|");
      hLocateStack->bExtInclude=TRUE;
    }
    else if (GetOptions(szOptions, "/-X=", FALSE, hLocateStack->szExt, NSIS_MAX_STRLEN))
    {
      if (*hLocateStack->szExt) lstrcat(hLocateStack->szExt, "|");
      hLocateStack->bExtExclude=TRUE;
    }
    if (GetOptions(szOptions, "/-PF=", FALSE, hLocateStack->szExcludeFullPaths, NSIS_MAX_STRLEN) && *hLocateStack->szExcludeFullPaths)
    {
      lstrcat(hLocateStack->szExcludeFullPaths, "|");
      hLocateStack->bFullPathsExclude=TRUE;
    }
    if (GetOptions(szOptions, "/-PN=", FALSE, hLocateStack->szExcludePathNames, NSIS_MAX_STRLEN) && *hLocateStack->szExcludePathNames)
    {
      lstrcat(hLocateStack->szExcludePathNames, "|");
      hLocateStack->bPathNamesExclude=TRUE;
    }
    if (GetOptions(szOptions, "/G=", FALSE, szBuf, NSIS_MAX_STRLEN) && *szBuf == '0')
      hLocateStack->bGotoSubDir=FALSE;
    if (GetOptions(szOptions, "/B=", FALSE, szBuf, NSIS_MAX_STRLEN))
    {
      if (*szBuf == '1')
      {
        if (!hSearchDetails) hSearchDetails=GetDlgItem(FindWindowEx(hwndParent, NULL, "#32770", NULL), IDC_STATIC);
        hLocateStack->nBanner=LO_BANNER_DETAILS;
      }
      else if (*szBuf == '2') hLocateStack->nBanner=LO_BANNER_CALLBACK;
    }
    if (!WordFind(hLocateStack->szPaths, "|", 1, "*", TRUE, hLocateStack->szPath, &i, &hLocateStack->pPaths))
    {
      hLocateStack->pPaths+=i;
      hLocateStack->bPaths=TRUE;
    }
    else lstrcpy(hLocateStack->szPath, hLocateStack->szPaths);

    if (!hLocateStack->bFindFiles && !hLocateStack->bFindDirs && !hLocateStack->bFindEmptyDirs)
      goto Error;

    if (!hLocateStack->bPaths)
    {
      wsprintf(szBuf, "%s\\*.*", hLocateStack->szPath);
      if ((hLocateStack->hSearch=FindFirstFile(szBuf, &data)) == INVALID_HANDLE_VALUE)
        goto Error;
      FindClose(hLocateStack->hSearch);
    }

    pushinteger((int)hLocateStack);
    hLocateStack->nGoto=LO_GOTO_BEGIN;
    return;

    Error:
    GlobalFree((HGLOBAL)hLocateStack);
    pushstring("0");
  }
}

void __declspec(dllexport) _Find(HWND hwndParent, int string_size,
                                      char *variables, stack_t **stacktop)
{
  EXDLL_INIT();
  {
    dirs_stack *first;
    dirs_stack *last;
    dirs_stack *element;
    char *pPath;
    BOOL bDirEmpty;
    int i;

    hLocateStack=(HLOCATESTACK *)popinteger();

    if (hLocateStack->nGoto == LO_GOTO_NEXTFILE) goto PopNextFile;
    else if (hLocateStack->nGoto == LO_GOTO_NEXTDIR) goto PopNextDir;
    else if (hLocateStack->nGoto == LO_GOTO_FINDFIRST) goto FindFirst;
    else if (hLocateStack->nGoto == LO_GOTO_BEGIN) goto Begin;
    else if (hLocateStack->nGoto == LO_GOTO_END) goto End;

    Begin:
    pPath=hLocateStack->szPath + lstrlen(hLocateStack->szPath);
    while (*--pPath == '\\') *pPath='\0';

    StackInsert((stack **)&hLocateStack->path_first, (stack **)&hLocateStack->path_last, (stack **)&element, 1, sizeof(dirs_stack));
    lstrcpy(element->cFileName, hLocateStack->szPath);

    while (hLocateStack->nElement != 0)
    {
      --hLocateStack->nElement;
      lstrcpy(hLocateStack->szPath, hLocateStack->path_last->cFileName);
      StackDelete((stack **)&hLocateStack->path_first, (stack **)&hLocateStack->path_last, (stack *)hLocateStack->path_last);

      if (hLocateStack->nBanner == LO_BANNER_DETAILS) SendMessage(hSearchDetails, WM_SETTEXT, 0, (LPARAM)hLocateStack->szPath);
      else if (hLocateStack->nBanner == LO_BANNER_CALLBACK)
      {
        for(i=0; i < 5; ++i) pushstring("");
        pushstring(hLocateStack->szPath);
        hLocateStack->nGoto=LO_GOTO_FINDFIRST;
        return;
      }

      FindFirst:
      wsprintf(szBuf, "%s\\%s", hLocateStack->szPath, hLocateStack->szWildcard);

      if ((hLocateStack->hSearch=FindFirstFile(szBuf, &data)) != INVALID_HANDLE_VALUE)
      {
        do
        {
          if (data.cFileName[0] == '.' && (data.cFileName[1] == '\0' || (data.cFileName[1] == '.' && data.cFileName[2] == '\0'))) continue;

          hLocateStack->nSize=(data.nFileSizeHigh * ((__int64)MAXDWORD+1)) + data.nFileSizeLow;
          if (hLocateStack->nTime == LO_TIME_WRITE) FileTimeToLocalFileTime(&data.ftLastWriteTime, &lpLocalFileTime);
          else if (hLocateStack->nTime == LO_TIME_CREATION) FileTimeToLocalFileTime(&data.ftCreationTime, &lpLocalFileTime);
          else if (hLocateStack->nTime == LO_TIME_ACCESS) FileTimeToLocalFileTime(&data.ftLastAccessTime, &lpLocalFileTime);

          if ((!hLocateStack->bCompareSize || (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) || ((hLocateStack->nSizeMoreThen == -1 || hLocateStack->nSizeMoreThen <= hLocateStack->nSize) && (hLocateStack->nSizeLessThen == -1 || hLocateStack->nSizeLessThen >= hLocateStack->nSize))) &&
              (!hLocateStack->bCompareTime || (CompareFileTime(&lpLocalFileTime, &hLocateStack->lpFileTimeAfter) != -1 && CompareFileTime(&lpLocalFileTime, &hLocateStack->lpFileTimeBefore) != 1)) &&
              (!hLocateStack->bCompareAttr || (((hLocateStack->nReadOnly == LO_ATTR_IGNORE) || (((hLocateStack->nReadOnly == LO_ATTR_INCLUDE) && (data.dwFileAttributes & FILE_ATTRIBUTE_READONLY)) || ((hLocateStack->nReadOnly == LO_ATTR_EXCLUDE) && !(data.dwFileAttributes & FILE_ATTRIBUTE_READONLY)))) &&
                                               ((hLocateStack->nArchive == LO_ATTR_IGNORE) || (((hLocateStack->nArchive == LO_ATTR_INCLUDE) && (data.dwFileAttributes & FILE_ATTRIBUTE_ARCHIVE)) || ((hLocateStack->nArchive == LO_ATTR_EXCLUDE) && !(data.dwFileAttributes & FILE_ATTRIBUTE_ARCHIVE)))) &&
                                               ((hLocateStack->nHidden == LO_ATTR_IGNORE) || (((hLocateStack->nHidden == LO_ATTR_INCLUDE) && (data.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN)) || ((hLocateStack->nHidden == LO_ATTR_EXCLUDE) && !(data.dwFileAttributes & FILE_ATTRIBUTE_HIDDEN)))) &&
                                               ((hLocateStack->nSystem == LO_ATTR_IGNORE) || (((hLocateStack->nSystem == LO_ATTR_INCLUDE) && (data.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM)) || ((hLocateStack->nSystem == LO_ATTR_EXCLUDE) && !(data.dwFileAttributes & FILE_ATTRIBUTE_SYSTEM)))))) &&
              (!hLocateStack->bNamesInclude || FindWordString(hLocateStack->szNames, "|", FALSE, data.cFileName, NULL, NULL)) &&
              (!hLocateStack->bNamesExclude || !FindWordString(hLocateStack->szNames, "|", FALSE, data.cFileName, NULL, NULL)))
          {
            if (!(data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
            {
              if (hLocateStack->bFindFiles)
              {
                pExt=GetFileExt(data.cFileName);

                if ((!hLocateStack->bExtInclude || ((*hLocateStack->szExt && *pExt && FindWordString(hLocateStack->szExt, "|", FALSE, pExt, NULL, NULL)) ||
                                                    (!*hLocateStack->szExt && !*pExt))) &&
                    (!hLocateStack->bExtExclude || ((*hLocateStack->szExt && *pExt && !FindWordString(hLocateStack->szExt, "|", FALSE, pExt, NULL, NULL)) ||
                                                    (!*hLocateStack->szExt && *pExt) ||
                                                    (*hLocateStack->szExt && !*pExt))))
                {
                  SaveFilesDataToStack(&hLocateStack->files_first, &hLocateStack->files_last, (files_stack **)&element, data.cFileName);
                }
              }
            }
            else
            {
              if (hLocateStack->bFindEmptyDirs)
              {
                WIN32_FIND_DATA dataTmp;
                HANDLE hSearchTmp;

                bDirEmpty=TRUE;
                wsprintf(szBuf, "%s\\%s\\*.*", hLocateStack->szPath, data.cFileName);

                if ((hSearchTmp=FindFirstFile(szBuf, &dataTmp)) != INVALID_HANDLE_VALUE)
                {
                  do
                  {
                    if (dataTmp.cFileName[0] == '.' && (dataTmp.cFileName[1] == '\0' || (dataTmp.cFileName[1] == '.' && dataTmp.cFileName[2] == '\0'))) continue;
                    bDirEmpty=FALSE;
                    break;
                  }
                  while (FindNextFile(hSearchTmp, &dataTmp));

                  FindClose(hSearchTmp);
                }
                else bDirEmpty=FALSE;
              }
              if (hLocateStack->bFindDirs || (hLocateStack->bFindEmptyDirs && bDirEmpty == TRUE))
              {
                SaveDirsDataToStack(&hLocateStack->dirs_first, &hLocateStack->dirs_last, &element, data.cFileName);
              }
            }
          }
        }
        while (FindNextFile(hLocateStack->hSearch, &data));

        FindClose(hLocateStack->hSearch);

        if (hLocateStack->bOutputReverse) goto PopFile;

        PopDir:
        if (hLocateStack->bFindDirs || hLocateStack->bFindEmptyDirs)
        {
          PopNextDir:

          while (hLocateStack->dirs_last)
          {
            ReturnDataFromStack((files_stack *)hLocateStack->dirs_last);
            StackDelete((stack **)&hLocateStack->dirs_first, (stack **)&hLocateStack->dirs_last, (stack *)hLocateStack->dirs_last);
            hLocateStack->nGoto=LO_GOTO_NEXTDIR;
            return;
          }
        }
        if (hLocateStack->bOutputReverse) goto PopEnd;

        PopFile:
        if (hLocateStack->bFindFiles)
        {
          PopNextFile:

          while (hLocateStack->files_last)
          {
            ReturnDataFromStack(hLocateStack->files_last);
            StackDelete((stack **)&hLocateStack->files_first, (stack **)&hLocateStack->files_last, (stack *)hLocateStack->files_last);
            hLocateStack->nGoto=LO_GOTO_NEXTFILE;
            return;
          }
        }
        if (hLocateStack->bOutputReverse) goto PopDir;

        PopEnd:;
      }

      if (hLocateStack->bGotoSubDir)
      {
        wsprintf(szBuf, "%s\\*.*", hLocateStack->szPath);

        if ((hLocateStack->hSearch=FindFirstFile(szBuf, &data)) != INVALID_HANDLE_VALUE)
        {
          first=NULL;
          last=NULL;

          do
          {
            if (data.cFileName[0] == '.' && (data.cFileName[1] == '\0' || (data.cFileName[1] == '.' && data.cFileName[2] == '\0'))) continue;

            if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
            {
              wsprintf(szBuf, "%s\\%s", hLocateStack->szPath, data.cFileName);

              if ((!hLocateStack->bFullPathsExclude || !FindWordString(hLocateStack->szExcludeFullPaths, "|", FALSE, szBuf, NULL, NULL)) &&
                  (!hLocateStack->bPathNamesExclude || !FindWordString(hLocateStack->szExcludePathNames, "|", FALSE, data.cFileName, NULL, NULL)))
              {
                if (hLocateStack->nSortDirs == LO_SORT_DIRS_DATE)
                {
                  if (hLocateStack->nTime == LO_TIME_WRITE) FileTimeToLocalFileTime(&data.ftLastWriteTime, &lpLocalFileTime);
                  else if (hLocateStack->nTime == LO_TIME_CREATION) FileTimeToLocalFileTime(&data.ftCreationTime, &lpLocalFileTime);
                  else if (hLocateStack->nTime == LO_TIME_ACCESS) FileTimeToLocalFileTime(&data.ftLastAccessTime, &lpLocalFileTime);
                }

                SaveDirsDataToStack(&first, &last, &element, szBuf);

                ++hLocateStack->nElement;
              }
            }
          }
          while (FindNextFile(hLocateStack->hSearch, &data));

          FindClose(hLocateStack->hSearch);

          StackJoin((stack **)&hLocateStack->path_first, (stack **)&hLocateStack->path_last, (stack *)first, (stack *)last, TRUE);
        }
      }
    }
    if (hLocateStack->bPaths && !WordFind(hLocateStack->pPaths, "|", 1, "*", TRUE, hLocateStack->szPath, &i, &hLocateStack->pPaths))
    {
      hLocateStack->pPaths+=i;
      hLocateStack->nElement=1;
      hLocateStack->nGoto=LO_GOTO_BEGIN;
      goto Begin;
    }
    hLocateStack->nGoto=LO_GOTO_END;

    End:
    for(i=0; i < 6; ++i) pushstring("");
  }
}

void __declspec(dllexport) _Close(HWND hwndParent, int string_size,
                                      char *variables, stack_t **stacktop)
{
  hLocateStack=(HLOCATESTACK *)popinteger();

  if (hLocateStack)
  {
    if (hLocateStack->hSearch) FindClose(hLocateStack->hSearch);
    if (hLocateStack->nBanner == LO_BANNER_DETAILS) SendMessage(hSearchDetails, WM_SETTEXT, 0, (LPARAM)"");
    StackClear((stack **)&hLocateStack->path_first, (stack **)&hLocateStack->path_last);
    hLocateStack->nGoto=LO_GOTO_END;
    GlobalFree((HGLOBAL)hLocateStack);
  }
}
#endif //LOCATE

#ifdef GETSIZE
void __declspec(dllexport) _GetSize(HWND hwndParent, int string_size,
                                      char *variables, stack_t **stacktop)
{
  EXDLL_INIT();
  {
    char *pPath;
    int i;
    int nDivisorGS=1;
    BOOL bGotoSubdirGS=TRUE;
    nDirSizeGS=0;
    nFileSumGS=0;
    nDirSumGS=0;
    nBannerGS=0;
    nFunction=GETSIZE_FUNC;

    popstring(szBuf);
    popstring(szOptions);

    pPath=szBuf + lstrlen(szBuf);
    while (*--pPath == '\\') *pPath='\0';

    if (GetOptions(szOptions, "/S=", FALSE, szBuf2, NSIS_MAX_STRLEN))
    {
      if (*szBuf2 == 'K') nDivisorGS=1024;
      else if (*szBuf2 == 'M') nDivisorGS=1048576;
      else if (*szBuf2 == 'G') nDivisorGS=1073741824;
    }
    if (GetOptions(szOptions, "/G=", FALSE, szBuf2, NSIS_MAX_STRLEN) && *szBuf2 == '0')
      bGotoSubdirGS=FALSE;
    if (GetOptions(szOptions, "/B=", FALSE, szBuf2, NSIS_MAX_STRLEN) && *szBuf2 == '1')
    {
      nBannerGS=1;
      if (!hSearchDetails) hSearchDetails=GetDlgItem(FindWindowEx(hwndParent, NULL, "#32770", NULL), IDC_STATIC);
    }
    if (!GetOptions(szOptions, "/M=", FALSE, szBuf2, NSIS_MAX_STRLEN))
      lstrcpy(szBuf2, "*.*");

    if (SearchFiles(szBuf, szBuf2, bGotoSubdirGS))
    {
      nDirSizeGS=nDirSizeGS / nDivisorGS;

      pushinteger(--nDirSumGS);
      pushinteger(nFileSumGS);
      pushstring(xi64toa(nDirSizeGS, szBuf2, 0));
    }
    else
    {
      for(i=0; i < 3; ++i) pushstring("-1");
    }
    if (nBannerGS == 1) SendMessage(hSearchDetails, WM_SETTEXT, 0, (LPARAM)"");
  }
}
#endif //GETSIZE

#ifdef RMDIR_EMPTY
void __declspec(dllexport) _RMDirEmpty(HWND hwndParent, int string_size,
                                      char *variables, stack_t **stacktop)
{
  EXDLL_INIT();
  {
    char *pPath;
    BOOL bGotoSubdirRM=TRUE;
    nRemoveDirRM=0;
    nBannerRM=0;
    nFunction=RMDIR_EMPTY_FUNC;

    popstring(szBuf);
    popstring(szOptions);

    pPath=szBuf + lstrlen(szBuf);
    while (*--pPath == '\\') *pPath='\0';

    if (GetOptions(szOptions, "/G=", FALSE, szBuf2, NSIS_MAX_STRLEN) && *szBuf2 == '0')
      bGotoSubdirRM=FALSE;
    if (GetOptions(szOptions, "/B=", FALSE, szBuf2, NSIS_MAX_STRLEN) && *szBuf2 == '1')
    {
      nBannerRM=1;
      if (!hSearchDetails) hSearchDetails=GetDlgItem(FindWindowEx(hwndParent, NULL, "#32770", NULL), IDC_STATIC);
    }
    if (!GetOptions(szOptions, "/M=", FALSE, szBuf2, NSIS_MAX_STRLEN))
      lstrcpy(szBuf2, "*.*");

    if (SearchFiles(szBuf, szBuf2, bGotoSubdirRM))
    {
      pushinteger(nRemoveDirRM);
    }
    else
    {
      pushstring("-1");
    }
    if (nBannerRM == 1) SendMessage(hSearchDetails, WM_SETTEXT, 0, (LPARAM)"");
  }
}
#endif //RMDIR_EMPTY

void __declspec(dllexport) _Unload(HWND hwndParent, int string_size,
                                      char *variables, stack_t **stacktop)
{
}

BOOL WINAPI DllMain(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{
  return TRUE;
}

void PushSortName(files_stack **first, files_stack **last, files_stack **element, char *name, int nUpDown, int bytes)
{
  files_stack *pTmp=*last;
  int a,b;

  if (nUpDown != 1 && nUpDown != -1) return;

  for (a=1; (pTmp); ++a, pTmp=pTmp->prev)
  {
    b=lstrcmpi(pTmp->cFileName, name);
    if (b == 0 || b == nUpDown) break;
  }
  StackInsert((stack **)first, (stack **)last, (stack **)element, a, bytes);
}

void PushSortType(files_stack **first, files_stack **last, files_stack **element, char *name, char *ext, int nUpDown, int bytes)
{
  files_stack *pTmp=*last;
  int a,b;

  if (nUpDown != 1 && nUpDown != -1) return;

  for (a=1; (pTmp); ++a, pTmp=pTmp->prev)
  {
    b=lstrcmpi(pTmp->cExt, ext);
    if (b == nUpDown) break;
    else if (b == 0)
    {
      b=lstrcmpi(pTmp->cFileName, name);
      if (b == 0 || b == nUpDown) break;
    }
  }
  StackInsert((stack **)first, (stack **)last, (stack **)element, a, bytes);
}

void PushSortSize(files_stack **first, files_stack **last, files_stack **element, char *name, __int64 size, int nUpDown, int bytes)
{
  files_stack *pTmp=*last;
  int a,b;

  if (nUpDown != 1 && nUpDown != -1) return;

  for (a=1; (pTmp); ++a, pTmp=pTmp->prev)
  {
    if ((nUpDown == 1 && size > pTmp->nFileSize) ||
        (nUpDown == -1 && size < pTmp->nFileSize))
    {
      break;
    }
    else if (size == pTmp->nFileSize)
    {
      b=lstrcmpi(pTmp->cFileName, name);
      if (b == 0 || b == nUpDown) break;
    }
  }
  StackInsert((stack **)first, (stack **)last, (stack **)element, a, bytes);
}

void PushSortDate(files_stack **first, files_stack **last, files_stack **element, char *name, FILETIME date, int nUpDown, int bytes)
{
  files_stack *pTmp=*last;
  int a,b;

  if (nUpDown != 1 && nUpDown != -1) return;

  for (a=1; (pTmp); ++a, pTmp=pTmp->prev)
  {
    b=CompareFileTime(&pTmp->ftFileTime, &date);
    if (b == nUpDown) break;
    else if (b == 0)
    {
      b=lstrcmpi(pTmp->cFileName, name);
      if (b == 0 || b == nUpDown) break;
    }
  }
  StackInsert((stack **)first, (stack **)last, (stack **)element, a, bytes);
}

void SaveFilesDataToStack(files_stack **first, files_stack **last, files_stack **element, char *name)
{
  int i;

  i=hLocateStack->bSortFilesReverse?-1:1;

  if (hLocateStack->nSortFiles == LO_SORT_FILES_NAME)
    PushSortName(first, last, element, name, i, sizeof(files_stack));
  else if (hLocateStack->nSortFiles == LO_SORT_FILES_TYPE)
    PushSortType(first, last, element, name, pExt, i, sizeof(files_stack));
  else if (hLocateStack->nSortFiles == LO_SORT_FILES_SIZE)
    PushSortSize(first, last, element, name, hLocateStack->nSize, i, sizeof(files_stack));
  else if (hLocateStack->nSortFiles == LO_SORT_FILES_DATE)
    PushSortDate(first, last, element, name, lpLocalFileTime, i, sizeof(files_stack));
  else
    StackInsert((stack **)first, (stack **)last, (stack **)element, 1, sizeof(files_stack));

  lstrcpy((*element)->cFileName, name);
  lstrcpyn((*element)->cExt, pExt, MAX_EXT);
  (*element)->dwFileAttributes=data.dwFileAttributes;
  (*element)->ftFileTime.dwHighDateTime=lpLocalFileTime.dwHighDateTime;
  (*element)->ftFileTime.dwLowDateTime=lpLocalFileTime.dwLowDateTime;
  (*element)->nFileSize=hLocateStack->nSize;
}

void SaveDirsDataToStack(dirs_stack **first, dirs_stack **last, dirs_stack **element, char *name)
{
  int i;

  i=hLocateStack->bSortDirsReverse?-1:1;

  if (hLocateStack->nSortDirs == LO_SORT_DIRS_NAME)
    PushSortName((files_stack **)first, (files_stack **)last, (files_stack **)element, name, i, sizeof(dirs_stack));
  else if (hLocateStack->nSortDirs == LO_SORT_DIRS_DATE)
    PushSortDate((files_stack **)first, (files_stack **)last, (files_stack **)element, name, lpLocalFileTime, i, sizeof(dirs_stack));
  else
    StackInsert((stack **)first, (stack **)last, (stack **)element, 1, sizeof(dirs_stack));

  lstrcpy((*element)->cFileName, name);
  (*element)->dwFileAttributes=data.dwFileAttributes;
  (*element)->ftFileTime.dwHighDateTime=lpLocalFileTime.dwHighDateTime;
  (*element)->ftFileTime.dwLowDateTime=lpLocalFileTime.dwLowDateTime;
}

void ReturnDataFromStack(files_stack *last)
{
  //attributes
  if (last->dwFileAttributes & FILE_ATTRIBUTE_READONLY) szBuf[0]='r';
  else szBuf[0]='-';
  if (last->dwFileAttributes & FILE_ATTRIBUTE_ARCHIVE) szBuf[1]='a';
  else szBuf[1]='-';
  if (last->dwFileAttributes & FILE_ATTRIBUTE_HIDDEN) szBuf[2]='h';
  else szBuf[2]='-';
  if (last->dwFileAttributes & FILE_ATTRIBUTE_SYSTEM) szBuf[3]='s';
  else szBuf[3]='-';
  szBuf[4]='\0';
  pushstring(szBuf);

  //date
  FileTimeToSystemTime(&last->ftFileTime, &lpSystemTime);
  wsprintf(szBuf, "%02d.%02d.%d %02d:%02d:%02d", lpSystemTime.wDay, lpSystemTime.wMonth, lpSystemTime.wYear, lpSystemTime.wHour, lpSystemTime.wMinute, lpSystemTime.wSecond);
  pushstring(szBuf);

  //size
  if (last->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) szBuf[0]='\0';
  else xi64toa(last->nFileSize / hLocateStack->nDivisor, szBuf, 0);
  pushstring(szBuf);

  //name
  pushstring(last->cFileName);

  //path
  pushstring(hLocateStack->szPath);

  //path\name
  wsprintf(szBuf, "%s\\%s", hLocateStack->szPath, last->cFileName);
  pushstring(szBuf);
}

//Function: Recursively finds files and directories
BOOL SearchFiles(char *path, char *wildcard, BOOL subdir)
{
  char nameTmp[MAX_PATH];
  WIN32_FIND_DATA data;
  HANDLE hSearch;

  if (subdir)
  {
    wsprintf(nameTmp, "%s\\*.*", path);

    if ((hSearch=FindFirstFile(nameTmp, &data)) != INVALID_HANDLE_VALUE)
    {
      do
      {
        if (data.cFileName[0] == '.' && (data.cFileName[1] == '\0' || (data.cFileName[1] == '.' && data.cFileName[2] == '\0'))) continue;

        if (data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
        {
          wsprintf(nameTmp, "%s\\%s", path, data.cFileName);

          SearchFiles(nameTmp, wildcard, TRUE);
        }
      }
      while (FindNextFile(hSearch, &data));
    }
    else
      return FALSE;

    FindClose(hSearch);
  }
  wsprintf(nameTmp, "%s\\%s", path, wildcard);

  /* Plugin */
  if (nFunction == GETSIZE_FUNC)
  {
    if (nBannerGS == 1) SendMessage(hSearchDetails, WM_SETTEXT, 0, (LPARAM)nameTmp);
    ++nDirSumGS;
  }
  else if (nBannerRM == 1) SendMessage(hSearchDetails, WM_SETTEXT, 0, (LPARAM)nameTmp);
  /**********/

  if ((hSearch=FindFirstFile(nameTmp, &data)) == INVALID_HANDLE_VALUE)
    return TRUE;
  do
  {
    if (data.cFileName[0] == '.' && (data.cFileName[1] == '\0' || (data.cFileName[1] == '.' && data.cFileName[2] == '\0'))) continue;

    wsprintf(nameTmp, "%s\\%s", path, data.cFileName);

    /* Plugin */
    if (!(data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
    {
      if (nFunction == GETSIZE_FUNC)
      {
        ++nFileSumGS;
        nDirSizeGS+=((data.nFileSizeHigh * ((__int64)MAXDWORD+1)) + data.nFileSizeLow);
      }
    }
    else if (nFunction == GETSIZE_FUNC && !subdir) ++nDirSumGS;
    else if (nFunction == RMDIR_EMPTY_FUNC && RemoveDirectory(nameTmp)) ++nRemoveDirRM;
    /**********/
  }
  while (FindNextFile(hSearch, &data));

  FindClose(hSearch);

  return TRUE;
}

char* GetFileExt(char *fname)
{
  int i;

  for (i=lstrlen(fname) - 1; i >= 0; --i)
    if (fname[i] == '.') return (fname + i + 1);
    else if (fname[i] == '\\') break;

  return "";
}

int popinteger()
{
  char szInt[16];

  popstring(szInt);
  return xatoi(szInt);
}

void pushinteger(int integer)
{
  char szInt[16];

  xitoa(integer, szInt, 0);
  pushstring(szInt);
}

//Function: Removes the element from the top of the NSIS stack and puts it in the buffer
int popstring(char *str)
{
  stack_t *th;
  if (!g_stacktop || !*g_stacktop) return 1;
  th=(*g_stacktop);
  lstrcpy(str,th->text);
  *g_stacktop = th->next;
  GlobalFree((HGLOBAL)th);
  return 0;
}

//Function: Adds an element to the top of the NSIS stack
void pushstring(const char *str)
{
  stack_t *th;
  if (!g_stacktop) return;
  th=(stack_t*)GlobalAlloc(GPTR,sizeof(stack_t)+g_stringsize);
  lstrcpyn(th->text,str,g_stringsize);
  th->next=*g_stacktop;
  *g_stacktop=th;
}
