---
title: "Compiler Warning (level 1) CS3007 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS3007"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS3007"
ms.assetid: 9c6bf776-3099-4ab5-ae89-4068ec722f79
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Warning (level 1) CS3007
Overloaded method 'method' differing only by unnamed array types is not CLS-compliant  
  
 This error occurs if you have an overloaded method that takes a jagged array and the only difference between the method signatures is the element type of the array. To avoid this error, consider using a rectangular array rather than a jagged array; use an additional parameter to disambiguate the function call; rename one or more of the overloaded methods; or, if CLS Compliance is not needed, remove the <xref:System.CLSCompliantAttribute> attribute. For more information on CLS Compliance, see [Language Independence and Language-Independent Components](https://msdn.microsoft.com/library/12a7a7h3).  
  
## Example  
 The following example generates CS3007:  
  
```  
// CS3007.cs  
[assembly: System.CLSCompliant(true)]  
public struct S  
{  
    public void F(int[][] array) { }  
    public void F(byte[][] array) { }  // CS3007  
    // Try this instead:  
    // public void F1(int[][] array) {}  
    // public void F2(byte[][] array) {}  
    // or   
    // public void F(int[,] array) {}  
    // public void F(byte[,] array) {}  
}  
```