---
title: "Compiler Error CS0263 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0263"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0263"
ms.assetid: 94fe3eb0-10e9-4602-a993-68fe125c8565
caps.latest.revision: 8
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0263
Partial declarations of 'type' must not specify different base classes  
  
 When defining a type in partial declarations, specify the same base types in each of the partial declarations. For more information, see [Partial Classes and Methods](../../csharp/programming-guide/classes-and-structs/partial-classes-and-methods.md).  
  
 The following sample generates CS0263:  
  
```  
  
// CS0263.cs  
// compile with: /target:library  
class B1  
{  
}  
  
class B2  
{  
}  
partial class C : B1  // CS0263 – is the base class B1 or B2?  
{  
}  
  
partial class C : B2  
{  
}  
```