---
title: "How to: Handle an Exception Using try-catch (C# Programming Guide) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "exception handling [C#], try/catch blocks"
  - "exceptions [C#], try/catch blocks"
  - "try/catch blocks [C#]"
ms.assetid: ca8e3773-980e-4767-8633-7408540e9818
caps.latest.revision: 14
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# How to: Handle an Exception Using try/catch (C# Programming Guide)
The purpose of a [try-catch](../../../csharp/language-reference/keywords/try-catch.md) block is to catch and handle an exception generated by working code. Some exceptions can be handled in a `catch` block and the problem solved without the exception being re-thrown; however, more often the only thing that you can do is make sure that the appropriate exception is thrown.  
  
## Example  
 In this example, <xref:System.IndexOutOfRangeException> is not the most appropriate exception: <xref:System.ArgumentOutOfRangeException> makes more sense for the method because the error is caused by the `index` argument passed in by the caller.  
  
 [!code-cs[csProgGuideExceptions#5](../../../csharp/programming-guide/exceptions/codesnippet/CSharp/how-to-handle-an-exception-using-try-catch_1.cs)]  
  
## Comments  
 The code that causes an exception is enclosed in the `try` block. A `catch` statement is added immediately after to handle `IndexOutOfRangeException`, if it occurs. The `catch` block handles the `IndexOutOfRangeException` and throws the more appropriate `ArgumentOutOfRangeException` exception instead. In order to provide the caller with as much information as possible, consider specifying the original exception as the <xref:System.Exception.InnerException%2A> of the new exception. Because the <xref:System.Exception.InnerException%2A> property is [readonly](../../../csharp/language-reference/keywords/readonly.md), you must assign it in the constructor of the new exception.  
  
## See Also  
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [Exceptions and Exception Handling](../../../csharp/programming-guide/exceptions/index.md)   
 [Exception Handling](../../../csharp/programming-guide/exceptions/exception-handling.md)