---
title: "C# Programming Guide | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "cs.langref"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "reference tables [C#]"
  - "C# language, programming guide"
  - "Visual C#, programming concepts"
  - "C# language, concepts"
ms.assetid: ac0f23a2-6bf3-4077-be99-538ae5fd3bc5
caps.latest.revision: 45
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# C# Programming Guide
This section provides detailed information on key C# language features and features accessible to C# through the .NET Framework.  
  
 Most of this section assumes that you already know something about C# and general programming concepts. If you are a complete beginner with programming or with C#, you might want to visit the [C# Developer Center](http://go.microsoft.com/fwlink/?linkid=95125), where you can find many tutorials, samples and videos to help you get started.  
  
 For information about specific keywords, operators and preprocessor directives, see [C# Reference](../../csharp/language-reference/index.md). For information about the C# Language Specification, see [C# Language Specification](../../csharp/language-reference/language-specification.md).  
  
## Language Sections  
 [Inside a C# Program](../../csharp/programming-guide/inside-a-program/index.md)  
  
 [Main() and Command-Line Arguments](../../csharp/programming-guide/main-and-command-args/index.md)  
  
 [Types](../../csharp/programming-guide/types/index.md)  
  
 [Arrays](../../csharp/programming-guide/arrays/index.md)  
  
 [Strings](../../csharp/programming-guide/strings/index.md)  
  
 [Statements, Expressions, and Operators](../../csharp/programming-guide/statements-expressions-operators/index.md)  
  
 [Classes and Structs](../../csharp/programming-guide/classes-and-structs/index.md)  
  
 [Properties](../../csharp/programming-guide/classes-and-structs/properties.md)  
  
 [Interfaces](../../csharp/programming-guide/interfaces/index.md)  
  
 [Indexers](../../csharp/programming-guide/indexers/index.md)  
  
 [Enumeration Types](../../csharp/programming-guide/enumeration-types.md)  
  
 [Delegates](../../csharp/programming-guide/delegates/index.md)  
  
 [Events](../../csharp/programming-guide/events/index.md)  
  
 [Generics](../../csharp/programming-guide/generics/index.md)  
  
 [Iterators](../../csharp/programming-guide/concepts/iterators.md)
  
 [LINQ Query Expressions](../../csharp/programming-guide/linq-query-expressions/index.md)  
  
 [Lambda Expressions](../../csharp/programming-guide/statements-expressions-operators/lambda-expressions.md)  
  
 [Namespaces](../../csharp/programming-guide/namespaces/index.md)  
  
 [Nullable Types](../../csharp/programming-guide/nullable-types/index.md)  
  
 [Unsafe Code and Pointers](../../csharp/programming-guide/unsafe-code-pointers/index.md)  
  
 [XML Documentation Comments](../../csharp/programming-guide/xmldoc/xml-documentation-comments.md)  
  
## Platform Sections  
 [Application Domains (C# and Visual Basic)](http://msdn.microsoft.com/en-us/1bc2939a-79db-4a4a-a677-4a2ce6de2b1e)  
  
 [Assemblies and the Global Assembly Cache](../../csharp/programming-guide/concepts/assemblies-gac/index.md)  
  
 [Attributes](../../csharp/programming-guide/concepts/attributes/index.md)  
  
 [Collections](../../csharp/programming-guide/concepts/collections.md)  
  
 [Exceptions and Exception Handling](../../csharp/programming-guide/exceptions/index.md)  
  
 [File System and the Registry (C# Programming Guide)](../../csharp/programming-guide/file-system/index.md)  
  
 [Interoperability](../../csharp/programming-guide/interop/index.md)  
  
 [Reflection](../../csharp/programming-guide/concepts/reflection.md)  
  
## Featured Book Chapter  
 [Advanced C#](http://go.microsoft.com/fwlink/?LinkId=195407) in [C# 3.0 in a Nutshell, Third Edition: A Desktop Quick Reference](http://go.microsoft.com/fwlink/?LinkId=195406)  
  
## See Also  
 [C# Reference](../../csharp/language-reference/index.md)   
 [C#](../../csharp/csharp.md)