---
title: "Customizing Projects and Extending My with Visual Basic | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "My namespace, customizing"
  - "My namespace"
  - "My namespace, extending"
ms.assetid: 06ca80b9-1192-4eb5-8537-8ef5edfb9be0
caps.latest.revision: 12
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Customizing Projects and Extending My with Visual Basic
You can customize project templates to provide additional `My` objects. This makes it easy for other developers to find and use your objects.  
  
## In This Section  
 [Extending the My Namespace in Visual Basic](../../../visual-basic/developing-apps/customizing-extending-my/extending-the-my-namespace.md)  
 Describes how to add custom members and values to the `My` namespace in Visual Basic.  
  
 [Packaging and Deploying Custom My Extensions](../../../visual-basic/developing-apps/customizing-extending-my/packaging-and-deploying-custom-my-extensions.md)  
 Describes how to publish custom `My` namespace extensions by using Visual Studio templates.  
  
 [Extending the Visual Basic Application Model](../../../visual-basic/developing-apps/customizing-extending-my/extending-the-visual-basic-application-model.md)  
 Describes how to specify your own extensions to the application model by overriding members of the <xref:Microsoft.VisualBasic.ApplicationServices.WindowsFormsApplicationBase> class.  
  
 [Customizing Which Objects are Available in My](../../../visual-basic/developing-apps/customizing-extending-my/customizing-which-objects-are-available-in-my.md)  
 Describes how to control which `My` objects are enabled by setting your project's _MYTYPE conditional-compilation constant.  
  
## Related Sections  
 [Development with My](../../../visual-basic/developing-apps/development-with-my/index.md)  
 Describes which `My` objects are available in different project types by default.  
  
 [Overview of the Visual Basic Application Model](../../../visual-basic/developing-apps/development-with-my/overview-of-the-visual-basic-application-model.md)  
 Describes Visual Basic's model for controlling the behavior of Windows Forms applications.  
  
 [How My Depends on Project Type](../../../visual-basic/developing-apps/development-with-my/how-my-depends-on-project-type.md)  
 Describes which `My` objects are available in different project types by default.  
  
 [Conditional Compilation](../../../visual-basic/programming-guide/program-structure/conditional-compilation.md)  
 Discusses how the compiler uses conditional-compilation to select particular sections of code to compile and exclude other sections.  
  
 <xref:Microsoft.VisualBasic.ApplicationServices.ApplicationBase>  
 Describes the `My` object that provides properties, methods, and events related to the current application.  
  
## See Also  
 [Developing Applications with Visual Basic](../../../visual-basic/developing-apps/index.md)