---
title: "Writing to Files in Visual Basic | Microsoft Docs"
ms.custom: ""
ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "I/O [Visual Basic], writing to files"
  - "files, writing to"
  - "examples [Visual Basic], writing to files"
  - "writing to files"
  - "Visual Basic, writing to files"
ms.assetid: ac6fb453-0d6c-4ce4-93b4-1bbcd06de83e
caps.latest.revision: 13
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Writing to Files in Visual Basic
This section explains how to perform tasks that involve writing to files.  
  
## In This Section  
 [How to: Write Text to Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-write-text-to-files.md)  
 Demonstrates how to write to text files.  
  
 [How to: Append to Text Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-append-to-text-files.md)  
 Demonstrates how to append text to a text file.  
  
 [How to: Write to Binary Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-write-to-binary-files.md)  
 Demonstrates how to write to a binary file.  
  
 [How to: Write Text to Files in the My Documents Directory](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-write-text-to-files-in-the-my-documents-directory.md)  
 Demonstrates how to create and write to a new text file in the **My Documents** directory.  
  
 [How to: Write Text to Files with a StreamWriter](../../../../visual-basic/developing-apps/programming/drives-directories-files/how-to-write-text-to-files-with-a-streamwriter.md)  
 Demonstrates how to write to a file with a <xref:System.IO.StreamWriter?displayProperty=fullName> object.  
  
## Reference  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem>  
 Describes the `My.Computer.FileSystem` object and its methods and properties.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.OpenTextFileWriter%2A>  
 Describes the `OpenTextFileWriter` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.WriteAllBytes%2A>  
 Describes the `WriteAllBytes` method.  
  
 <xref:Microsoft.VisualBasic.FileIO.FileSystem.WriteAllText%2A>  
 Describes the `WriteAllText` method.  
  
## Related Sections  
 [Reading from Files](../../../../visual-basic/developing-apps/programming/drives-directories-files/reading-from-files.md)  
 Explains how to perform tasks that involve reading from files.  
  
 [Creating, Deleting, and Moving Files and Directories](../../../../visual-basic/developing-apps/programming/drives-directories-files/creating-deleting-and-moving-files-and-directories.md)  
 Explains how to perform tasks that involve creating, deleting, moving, and renaming files and directories.  
  
 [Storing Data to and Reading from the Clipboard](../../../../visual-basic/developing-apps/programming/computer-resources/storing-data-to-and-reading-from-the-clipboard.md)  
 Explains how to perform tasks that are associated with `My.Computer.Clipboard`, such as reading data from or writing data to the Clipboard.  
  
 [File Encodings](../../../../visual-basic/developing-apps/programming/drives-directories-files/file-encodings.md)  
 Provides an overview of file encodings.