---
title: "Visual Basic Runtime Library Members | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "VisualBasic"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "run-time libraries, Visual Basic"
  - "libraries, Visual Basic run-time"
  - "Microsoft.VisualBasic namespace"
  - "members, Visual Basic run-time library"
ms.assetid: f5e82c6e-3500-452b-bdb8-78f0d5477604
caps.latest.revision: 16
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Visual Basic Runtime Library Members
The `Microsoft.VisualBasic` namespace contains the classes, modules, constants, and enumerations that constitute the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] runtime library. These library members provide procedures, properties, and constant values you can use in your code. Each module and class represents a particular category of functionality.  
  
## Microsoft.VisualBasic.Collection Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.Collection.Add%2A>|<xref:Microsoft.VisualBasic.Collection.Clear%2A>|<xref:Microsoft.VisualBasic.Collection.Contains%2A>|<xref:Microsoft.VisualBasic.Collection.Count%2A>|  
|<xref:Microsoft.VisualBasic.Collection.GetEnumerator%2A>|<xref:Microsoft.VisualBasic.Collection.Item%2A>|<xref:Microsoft.VisualBasic.Collection.Remove%2A>||  
  
## Microsoft.VisualBasic.ComClassAttribute Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.ComClassAttribute.ClassID%2A>|<xref:Microsoft.VisualBasic.ComClassAttribute.EventID%2A>|<xref:Microsoft.VisualBasic.ComClassAttribute.InterfaceID%2A>|<xref:Microsoft.VisualBasic.ComClassAttribute.InterfaceShadows%2A>|  
  
## Microsoft.VisualBasic.ControlChars Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.ControlChars.Back>|<xref:Microsoft.VisualBasic.ControlChars.Cr>|<xref:Microsoft.VisualBasic.ControlChars.CrLf>|<xref:Microsoft.VisualBasic.ControlChars.FormFeed>|  
|<xref:Microsoft.VisualBasic.ControlChars.Lf>|<xref:Microsoft.VisualBasic.ControlChars.NewLine>|<xref:Microsoft.VisualBasic.ControlChars.NullChar>|<xref:Microsoft.VisualBasic.ControlChars.Quote>|  
|<xref:Microsoft.VisualBasic.ControlChars.Tab>|<xref:Microsoft.VisualBasic.ControlChars.VerticalTab>|||  
  
## Microsoft.VisualBasic.Constants Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.Constants.vbAbort>|<xref:Microsoft.VisualBasic.Constants.vbAbortRetryIgnore>|<xref:Microsoft.VisualBasic.Constants.vbApplicationModal>|<xref:Microsoft.VisualBasic.Constants.vbArchive>|  
|<xref:Microsoft.VisualBasic.Constants.vbArray>|<xref:Microsoft.VisualBasic.Constants.vbBack>|<xref:Microsoft.VisualBasic.Constants.vbBinaryCompare>|<xref:Microsoft.VisualBasic.Constants.vbBoolean>|  
|<xref:Microsoft.VisualBasic.Constants.vbByte>|<xref:Microsoft.VisualBasic.Constants.vbCancel>|<xref:Microsoft.VisualBasic.Constants.vbCr>|<xref:Microsoft.VisualBasic.Constants.vbCritical>|  
|<xref:Microsoft.VisualBasic.Constants.vbCrLf>|<xref:Microsoft.VisualBasic.Constants.vbCurrency>|<xref:Microsoft.VisualBasic.Constants.vbDate>|<xref:Microsoft.VisualBasic.Constants.vbDecimal>|  
|<xref:Microsoft.VisualBasic.Constants.vbDefaultButton1>|<xref:Microsoft.VisualBasic.Constants.vbDefaultButton2>|<xref:Microsoft.VisualBasic.Constants.vbDefaultButton3>|<xref:Microsoft.VisualBasic.Constants.vbDirectory>|  
|<xref:Microsoft.VisualBasic.Constants.vbDouble>|<xref:Microsoft.VisualBasic.Constants.vbEmpty>|<xref:Microsoft.VisualBasic.Constants.vbExclamation>|<xref:Microsoft.VisualBasic.Constants.vbFalse>|  
|<xref:Microsoft.VisualBasic.Constants.vbFirstFourDays>|<xref:Microsoft.VisualBasic.Constants.vbFirstFullWeek>|<xref:Microsoft.VisualBasic.Constants.vbFirstJan1>|<xref:Microsoft.VisualBasic.Constants.vbFormFeed>|  
|<xref:Microsoft.VisualBasic.Constants.vbFriday>|<xref:Microsoft.VisualBasic.Constants.vbGeneralDate>|<xref:Microsoft.VisualBasic.Constants.vbGet>|<xref:Microsoft.VisualBasic.Constants.vbHidden>|  
|<xref:Microsoft.VisualBasic.Constants.vbHide>|<xref:Microsoft.VisualBasic.Constants.vbHiragana>|<xref:Microsoft.VisualBasic.Constants.vbIgnore>|<xref:Microsoft.VisualBasic.Constants.vbInformation>|  
|<xref:Microsoft.VisualBasic.Constants.vbInteger>|<xref:Microsoft.VisualBasic.Constants.vbKatakana>|<xref:Microsoft.VisualBasic.Constants.vbLet>|<xref:Microsoft.VisualBasic.Constants.vbLf>|  
|<xref:Microsoft.VisualBasic.Constants.vbLinguisticCasing>|<xref:Microsoft.VisualBasic.Constants.vbLong>|<xref:Microsoft.VisualBasic.Constants.vbLongDate>|<xref:Microsoft.VisualBasic.Constants.vbLongTime>|  
|<xref:Microsoft.VisualBasic.Constants.vbLowerCase>|<xref:Microsoft.VisualBasic.Constants.vbMaximizedFocus>|<xref:Microsoft.VisualBasic.Constants.vbMethod>|<xref:Microsoft.VisualBasic.Constants.vbMinimizedFocus>|  
|<xref:Microsoft.VisualBasic.Constants.vbMinimizedNoFocus>|<xref:Microsoft.VisualBasic.Constants.vbMonday>|<xref:Microsoft.VisualBasic.Constants.vbMsgBoxHelp>|<xref:Microsoft.VisualBasic.Constants.vbMsgBoxRight>|  
|<xref:Microsoft.VisualBasic.Constants.vbMsgBoxRtlReading>|<xref:Microsoft.VisualBasic.Constants.vbMsgBoxSetForeground>|<xref:Microsoft.VisualBasic.Constants.vbNarrow>|<xref:Microsoft.VisualBasic.Constants.vbNewLine>|  
|<xref:Microsoft.VisualBasic.Constants.vbNo>|<xref:Microsoft.VisualBasic.Constants.vbNormal>|<xref:Microsoft.VisualBasic.Constants.vbNormalFocus>|<xref:Microsoft.VisualBasic.Constants.vbNormalNoFocus>|  
|<xref:Microsoft.VisualBasic.Constants.vbNull>|<xref:Microsoft.VisualBasic.Constants.vbNullChar>|<xref:Microsoft.VisualBasic.Constants.vbNullString>|<xref:Microsoft.VisualBasic.Constants.vbObject>|  
|<xref:Microsoft.VisualBasic.Constants.vbObjectError>|<xref:Microsoft.VisualBasic.Constants.vbOK>|<xref:Microsoft.VisualBasic.Constants.vbOKCancel>|<xref:Microsoft.VisualBasic.Constants.vbOKOnly>|  
|<xref:Microsoft.VisualBasic.Constants.vbProperCase>|<xref:Microsoft.VisualBasic.Constants.vbQuestion>|<xref:Microsoft.VisualBasic.Constants.vbReadOnly>|<xref:Microsoft.VisualBasic.Constants.vbRetry>|  
|<xref:Microsoft.VisualBasic.Constants.vbRetryCancel>|<xref:Microsoft.VisualBasic.Constants.vbSaturday>|<xref:Microsoft.VisualBasic.Constants.vbSet>|<xref:Microsoft.VisualBasic.Constants.vbShortDate>|  
|<xref:Microsoft.VisualBasic.Constants.vbShortTime>|<xref:Microsoft.VisualBasic.Constants.vbSimplifiedChinese>|<xref:Microsoft.VisualBasic.Constants.vbSingle>|<xref:Microsoft.VisualBasic.Constants.vbString>|  
|<xref:Microsoft.VisualBasic.Constants.vbSunday>|<xref:Microsoft.VisualBasic.Constants.vbSystem>|<xref:Microsoft.VisualBasic.Constants.vbSystemModal>|<xref:Microsoft.VisualBasic.Constants.vbTab>|  
|<xref:Microsoft.VisualBasic.Constants.vbTextCompare>|<xref:Microsoft.VisualBasic.Constants.vbThursday>|<xref:Microsoft.VisualBasic.Constants.vbTraditionalChinese>|<xref:Microsoft.VisualBasic.Constants.vbTrue>|  
|<xref:Microsoft.VisualBasic.Constants.vbTuesday>|<xref:Microsoft.VisualBasic.Constants.vbUpperCase>|<xref:Microsoft.VisualBasic.Constants.vbUseDefault>|<xref:Microsoft.VisualBasic.Constants.vbUserDefinedType>|  
|<xref:Microsoft.VisualBasic.Constants.vbUseSystem>|<xref:Microsoft.VisualBasic.Constants.vbUseSystemDayOfWeek>|<xref:Microsoft.VisualBasic.Constants.vbVariant>|<xref:Microsoft.VisualBasic.Constants.vbVerticalTab>|  
|<xref:Microsoft.VisualBasic.Constants.vbVolume>|<xref:Microsoft.VisualBasic.Constants.vbWednesday>|<xref:Microsoft.VisualBasic.Constants.vbWide>|<xref:Microsoft.VisualBasic.Constants.vbYes>|  
|<xref:Microsoft.VisualBasic.Constants.vbYesNo>|<xref:Microsoft.VisualBasic.Constants.vbYesNoCancel>|||  
  
## Microsoft.VisualBasic.Conversion Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.Conversion.ErrorToString%2A>|<xref:Microsoft.VisualBasic.Conversion.Fix%2A>|<xref:Microsoft.VisualBasic.Conversion.Hex%2A>|<xref:Microsoft.VisualBasic.Conversion.Int%2A>|  
|<xref:Microsoft.VisualBasic.Conversion.Oct%2A>|<xref:Microsoft.VisualBasic.Conversion.Str%2A>|<xref:Microsoft.VisualBasic.Conversion.Val%2A>||  
  
## Microsoft.VisualBasic.DateAndTime Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.DateAndTime.DateAdd%2A>|<xref:Microsoft.VisualBasic.DateAndTime.DateDiff%2A>|<xref:Microsoft.VisualBasic.DateAndTime.DatePart%2A>|<xref:Microsoft.VisualBasic.DateAndTime.DateSerial%2A>|  
|<xref:Microsoft.VisualBasic.DateAndTime.DateString%2A>|<xref:Microsoft.VisualBasic.DateAndTime.DateValue%2A>|<xref:Microsoft.VisualBasic.DateAndTime.Day%2A>|<xref:Microsoft.VisualBasic.DateAndTime.Hour%2A>|  
|<xref:Microsoft.VisualBasic.DateAndTime.Minute%2A>|<xref:Microsoft.VisualBasic.DateAndTime.Month%2A>|<xref:Microsoft.VisualBasic.DateAndTime.MonthName%2A>|<xref:Microsoft.VisualBasic.DateAndTime.Now%2A>|  
|<xref:Microsoft.VisualBasic.DateAndTime.Second%2A>|<xref:Microsoft.VisualBasic.DateAndTime.TimeOfDay%2A>|<xref:Microsoft.VisualBasic.DateAndTime.Timer%2A>|<xref:Microsoft.VisualBasic.DateAndTime.TimeSerial%2A>|  
|<xref:Microsoft.VisualBasic.DateAndTime.TimeString%2A>|<xref:Microsoft.VisualBasic.DateAndTime.TimeValue%2A>|<xref:Microsoft.VisualBasic.DateAndTime.Today%2A>|<xref:Microsoft.VisualBasic.DateAndTime.Weekday%2A>|  
|<xref:Microsoft.VisualBasic.DateAndTime.WeekdayName%2A>|<xref:Microsoft.VisualBasic.DateAndTime.Year%2A>|||  
  
## Microsoft.VisualBasic.ErrObject Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.ErrObject.Clear%2A>|<xref:Microsoft.VisualBasic.ErrObject.Description%2A>|<xref:Microsoft.VisualBasic.ErrObject.Erl%2A>|<xref:Microsoft.VisualBasic.ErrObject.GetException%2A>|  
|<xref:Microsoft.VisualBasic.ErrObject.HelpContext%2A>|<xref:Microsoft.VisualBasic.ErrObject.HelpFile%2A>|<xref:Microsoft.VisualBasic.ErrObject.LastDllError%2A>|<xref:Microsoft.VisualBasic.ErrObject.Number%2A>|  
|<xref:Microsoft.VisualBasic.ErrObject.Raise%2A>|<xref:Microsoft.VisualBasic.ErrObject.Raise%2A>|||  
  
## Microsoft.VisualBasic.FileSystem Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.FileSystem.ChDir%2A>|<xref:Microsoft.VisualBasic.FileSystem.ChDrive%2A>|<xref:Microsoft.VisualBasic.FileSystem.CurDir%2A>|<xref:Microsoft.VisualBasic.FileSystem.Dir%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.EOF%2A>|<xref:Microsoft.VisualBasic.FileSystem.FileAttr%2A>|<xref:Microsoft.VisualBasic.FileSystem.FileClose%2A>|<xref:Microsoft.VisualBasic.FileSystem.FileCopy%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.FileDateTime%2A>|<xref:Microsoft.VisualBasic.FileSystem.FileGet%2A>|<xref:Microsoft.VisualBasic.FileSystem.FileGetObject%2A>|<xref:Microsoft.VisualBasic.FileSystem.FileLen%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.FileOpen%2A>|<xref:Microsoft.VisualBasic.FileSystem.FilePut%2A>|<xref:Microsoft.VisualBasic.FileSystem.FilePutObject%2A>|<xref:Microsoft.VisualBasic.FileSystem.FileWidth%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.FreeFile%2A>|<xref:Microsoft.VisualBasic.FileSystem.GetAttr%2A>|<xref:Microsoft.VisualBasic.FileSystem.Input%2A>|<xref:Microsoft.VisualBasic.FileSystem.InputString%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.Kill%2A>|<xref:Microsoft.VisualBasic.FileSystem.LineInput%2A>|<xref:Microsoft.VisualBasic.FileSystem.Loc%2A>|<xref:Microsoft.VisualBasic.FileSystem.Lock%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.LOF%2A>|<xref:Microsoft.VisualBasic.FileSystem.MkDir%2A>|<xref:Microsoft.VisualBasic.FileSystem.Print%2A>|<xref:Microsoft.VisualBasic.FileSystem.PrintLine%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.Rename%2A>|<xref:Microsoft.VisualBasic.FileSystem.Reset%2A>|<xref:Microsoft.VisualBasic.FileSystem.RmDir%2A>|<xref:Microsoft.VisualBasic.FileSystem.Seek%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.SetAttr%2A>|<xref:Microsoft.VisualBasic.FileSystem.SPC%2A>|<xref:Microsoft.VisualBasic.FileSystem.TAB%2A>|<xref:Microsoft.VisualBasic.FileSystem.Unlock%2A>|  
|<xref:Microsoft.VisualBasic.FileSystem.Write%2A>|<xref:Microsoft.VisualBasic.FileSystem.WriteLine%2A>|||  
  
## Microsoft.VisualBasic.Financial Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.Financial.DDB%2A>|<xref:Microsoft.VisualBasic.Financial.FV%2A>|<xref:Microsoft.VisualBasic.Financial.IPmt%2A>|<xref:Microsoft.VisualBasic.Financial.IRR%2A>|  
|<xref:Microsoft.VisualBasic.Financial.MIRR%2A>|<xref:Microsoft.VisualBasic.Financial.NPer%2A>|<xref:Microsoft.VisualBasic.Financial.NPV%2A>|<xref:Microsoft.VisualBasic.Financial.Pmt%2A>|  
|<xref:Microsoft.VisualBasic.Financial.PPmt%2A>|<xref:Microsoft.VisualBasic.Financial.PV%2A>|<xref:Microsoft.VisualBasic.Financial.Rate%2A>|<xref:Microsoft.VisualBasic.Financial.SLN%2A>|  
|<xref:Microsoft.VisualBasic.Financial.SYD%2A>||||  
  
## Microsoft.VisualBasic.Globals Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.Globals.ScriptEngine%2A>|<xref:Microsoft.VisualBasic.Globals.ScriptEngineBuildVersion%2A>|<xref:Microsoft.VisualBasic.Globals.ScriptEngineMajorVersion%2A>|<xref:Microsoft.VisualBasic.Globals.ScriptEngineMinorVersion%2A>|  
  
## Microsoft.VisualBasic.HideModuleNameAttribute Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.HideModuleNameAttribute>||||  
  
## Microsoft.VisualBasic.Information Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.Information.Erl%2A>|<xref:Microsoft.VisualBasic.Information.Err%2A>|<xref:Microsoft.VisualBasic.Information.IsArray%2A>|<xref:Microsoft.VisualBasic.Information.IsDate%2A>|  
|<xref:Microsoft.VisualBasic.Information.IsDBNull%2A>|<xref:Microsoft.VisualBasic.Information.IsError%2A>|<xref:Microsoft.VisualBasic.Information.IsNothing%2A>|<xref:Microsoft.VisualBasic.Information.IsNumeric%2A>|  
|<xref:Microsoft.VisualBasic.Information.IsReference%2A>|<xref:Microsoft.VisualBasic.Information.LBound%2A>|<xref:Microsoft.VisualBasic.Information.QBColor%2A>|<xref:Microsoft.VisualBasic.Information.RGB%2A>|  
|<xref:Microsoft.VisualBasic.Information.SystemTypeName%2A>|<xref:Microsoft.VisualBasic.Information.TypeName%2A>|<xref:Microsoft.VisualBasic.Information.UBound%2A>|<xref:Microsoft.VisualBasic.Information.VarType%2A>|  
|<xref:Microsoft.VisualBasic.Information.VbTypeName%2A>||||  
  
## Microsoft.VisualBasic.Interaction Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.Interaction.AppActivate%2A>|<xref:Microsoft.VisualBasic.Interaction.Beep%2A>|<xref:Microsoft.VisualBasic.Interaction.CallByName%2A>|<xref:Microsoft.VisualBasic.Interaction.Choose%2A>|  
|<xref:Microsoft.VisualBasic.Interaction.Command%2A>|<xref:Microsoft.VisualBasic.Interaction.CreateObject%2A>|<xref:Microsoft.VisualBasic.Interaction.DeleteSetting%2A>|<xref:Microsoft.VisualBasic.Interaction.Environ%2A>|  
|<xref:Microsoft.VisualBasic.Interaction.GetAllSettings%2A>|<xref:Microsoft.VisualBasic.Interaction.GetObject%2A>|<xref:Microsoft.VisualBasic.Interaction.GetSetting%2A>|<xref:Microsoft.VisualBasic.Interaction.IIf%2A>|  
|<xref:Microsoft.VisualBasic.Interaction.InputBox%2A>|<xref:Microsoft.VisualBasic.Interaction.MsgBox%2A>|<xref:Microsoft.VisualBasic.Interaction.Partition%2A>|<xref:Microsoft.VisualBasic.Interaction.SaveSetting%2A>|  
|<xref:Microsoft.VisualBasic.Interaction.Shell%2A>|<xref:Microsoft.VisualBasic.Interaction.Switch%2A>|||  
  
## Microsoft.VisualBasic.MyGroupCollectionAttribute Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.MyGroupCollectionAttribute.CreateMethod%2A>|<xref:Microsoft.VisualBasic.MyGroupCollectionAttribute.DefaultInstanceAlias%2A>|<xref:Microsoft.VisualBasic.MyGroupCollectionAttribute.DisposeMethod%2A>|<xref:Microsoft.VisualBasic.MyGroupCollectionAttribute.MyGroupName%2A>|  
  
## Microsoft.VisualBasic.Strings Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.Strings.Asc%2A>|<xref:Microsoft.VisualBasic.Strings.Asc%2A>|<xref:Microsoft.VisualBasic.Strings.Chr%2A>|<xref:Microsoft.VisualBasic.Strings.ChrW%2A>|  
|<xref:Microsoft.VisualBasic.Strings.Filter%2A>|<xref:Microsoft.VisualBasic.Strings.Format%2A>|<xref:Microsoft.VisualBasic.Strings.FormatCurrency%2A>|<xref:Microsoft.VisualBasic.Strings.FormatDateTime%2A>|  
|<xref:Microsoft.VisualBasic.Strings.FormatNumber%2A>|<xref:Microsoft.VisualBasic.Strings.FormatPercent%2A>|<xref:Microsoft.VisualBasic.Strings.GetChar%2A>|<xref:Microsoft.VisualBasic.Strings.InStr%2A>|  
|<xref:Microsoft.VisualBasic.Strings.InStrRev%2A>|<xref:Microsoft.VisualBasic.Strings.Join%2A>|<xref:Microsoft.VisualBasic.Strings.LCase%2A>|<xref:Microsoft.VisualBasic.Strings.Left%2A>|  
|<xref:Microsoft.VisualBasic.Strings.Len%2A>|<xref:Microsoft.VisualBasic.Strings.LSet%2A>|<xref:Microsoft.VisualBasic.Strings.LTrim%2A>|<xref:Microsoft.VisualBasic.Strings.Mid%2A>|  
|<xref:Microsoft.VisualBasic.Strings.Replace%2A>|<xref:Microsoft.VisualBasic.Strings.Right%2A>|<xref:Microsoft.VisualBasic.Strings.RSet%2A>|<xref:Microsoft.VisualBasic.Strings.RTrim%2A>|  
|<xref:Microsoft.VisualBasic.Strings.Space%2A>|<xref:Microsoft.VisualBasic.Strings.Split%2A>|<xref:Microsoft.VisualBasic.Strings.StrComp%2A>|<xref:Microsoft.VisualBasic.Strings.StrConv%2A>|  
|<xref:Microsoft.VisualBasic.Strings.StrDup%2A>|<xref:Microsoft.VisualBasic.Strings.StrReverse%2A>|<xref:Microsoft.VisualBasic.Strings.Trim%2A>|<xref:Microsoft.VisualBasic.Strings.UCase%2A>|  
  
## Microsoft.VisualBasic.VBFixedArrayAttribute Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.VBFixedArrayAttribute.Bounds%2A>|<xref:Microsoft.VisualBasic.VBFixedArrayAttribute.Length%2A>|||  
  
## Microsoft.VisualBasic.VBFixedStringAttribute Class  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.VBFixedStringAttribute.Length%2A>||||  
  
## Microsoft.VisualBasic.VbMath Module  
  
|||||  
|---|---|---|---|  
|<xref:Microsoft.VisualBasic.VBMath.Randomize%2A>|<xref:Microsoft.VisualBasic.VBMath.Rnd%2A>|||  
  
## Microsoft.VisualBasic Constants and Enumerations  
 The `Microsoft.VisualBasic` namespace provides constants and enumerations as part of the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] run-time library. You can use these constant values in your code. Each enumeration represents a particular category of functionality. For more information, see [Constants and Enumerations](../../visual-basic/language-reference/constants-and-enumerations.md).  
  
## See Also  
 [Constants and Enumerations](../../visual-basic/language-reference/constants-and-enumerations.md)   
 [Keywords](../../visual-basic/language-reference/keywords/index.md)