---
title: "Type or &#39;New&#39; expected | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc32092"
  - "bc32092"
helpviewer_keywords: 
  - "BC32092"
ms.assetid: b3041c1d-837c-4d58-bbb4-5c46f227b66d
caps.latest.revision: 7
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Type or &#39;New&#39; expected
A type parameter in the declaration of a generic type introduces a constraint list with the `As` keyword but does not specify a valid constraint.  
  
 A constraint on a type parameter must be a valid class or interface, or one of the keywords `Class`, `Structure`, or `New`. If you specify an invalid constraint or none at all, the compiler generates this error.  
  
 **Error ID:** BC32092  
  
## To correct this error  
  
1.  Determine how the type parameter should be constrained and specify the appropriate constraint in the constraint list.  
  
2.  If you intend to constrain the type parameter by a class or interface, make sure the constraint spells it correctly.  
  
3.  Remember to separate multiple constraints on a single type parameter with commas, and to enclose the constraint list in braces (`{ }`).  
  
## See Also  
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [Class (Visual Basic)](http://msdn.microsoft.com/en-us/0777c6e6-46bc-451b-ad70-57b49d4ef4f7)   
 [Structure (Visual Basic)](http://msdn.microsoft.com/en-us/263ce115-ac36-4c05-8cb7-0e0eead5c6d0)   
 [New Operator](../../visual-basic/language-reference/operators/new-operator.md)   
 [Type List](../../visual-basic/language-reference/statements/type-list.md)