---
title: "&#39;End Operator&#39; must be preceded by a matching &#39;Operator&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc33007"
  - "bc33007"
helpviewer_keywords: 
  - "BC33007"
ms.assetid: 57df3e01-0858-4cf7-9295-075a2c0c4bde
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;End Operator&#39; must be preceded by a matching &#39;Operator&#39;
An `End Operator` statement appears with no matching `Operator` declaration preceding it.  
  
 **Error ID:** BC33007  
  
## To correct this error  
  
-   Remove the `End Operator` statement if it is redundant.  
  
-   Supply the missing `Operator` procedure if one is missing.  
  
-   Move the `End Operator` statement to the appropriate place in the code.  
  
## See Also  
 [End \<keyword> Statement](../../visual-basic/language-reference/statements/end-keyword-statement.md)   
 [Operator Procedures](../../visual-basic/programming-guide/language-features/procedures/operator-procedures.md)   
 [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md)   
 [How to: Define an Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-an-operator.md)   
 [How to: Define a Conversion Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-a-conversion-operator.md)