/* This file is part of the hacked version of the ghostview package */
/* which is distributed under the terms of the gnu license. The */
/* modification referred to above is by Tanmoy Bhattacharya, */
/* <tanmoy@qcd.lanl.gov> on Nov 17, 1994. Neither the modification, */
/* nor the original program provides any warranty. */
#include <string.h>
#include <ctype.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include "pdfmark.h"
#include "pdf.h"
#ifdef NOMEMMOVE
#define memmove memcpy
#endif
union pdfmark *tagstart=NULL, *tagcurrent=NULL;
void pdf_process(char buf[])
{char *pointer=buf;
 while (*pointer&&(pointer=strstr(pointer,"\n%%[pdfinfo:\n"))) {
   char *endptr=strstr(pointer,"%%]\n");
   char *mrkptr=strstr(pointer,"\n[");
   if (mrkptr && mrkptr<endptr) {
     union pdfmark *mpointer = malloc(sizeof(union pdfmark)), *temp;
     mrkptr += 2;
     temp = getpdfmark(&mrkptr);
     if (temp) {
       *mpointer = *temp;
       mpointer -> flag.prev = tagcurrent;
       if (!tagstart) {
	 tagstart = tagcurrent = mpointer;
       } else {
	 tagcurrent -> flag.next = mpointer;
	 tagcurrent = mpointer;
       }
     }
   }
   if (endptr) {
     endptr += strlen("%%]\n");
     memmove(pointer,endptr,strlen(endptr)+1);
   }
   else pointer++;
 }
}

void pdf_clear(int pageno)
{
  static union pdfmark *tagmark = NULL;
  if (!pageno) {
    if (tagstart) {
      for (tagcurrent=tagstart; tagcurrent->flag.next;
	   tagcurrent = tagcurrent->flag.next);
      while (tagcurrent && tagcurrent != tagstart) {
	union pdfmark *pointer = tagcurrent->flag.prev;
	free(tagcurrent);
	tagcurrent = pointer;
      }
      free(tagstart);
    }
    tagmark = tagcurrent = tagstart = NULL;
  } else {
    if (tagmark) {
      for (tagcurrent=tagmark; tagcurrent->flag.next;
	   tagcurrent = tagcurrent->flag.next);
      while (tagcurrent && tagcurrent != tagmark) {
	union pdfmark *pointer = tagcurrent->flag.prev;
	free(tagcurrent);
	tagcurrent = pointer;
      }
      if (tagcurrent) tagcurrent->flag.next = NULL;
    } else if (tagstart) {
      for (tagmark=tagstart; tagmark->flag.next; tagmark = tagmark->flag.next);
      tagcurrent = tagmark;
    }
  }
}

int pdf_page(int x, int y)
{union pdfmark *pointer=tagstart;
 /* fprintf(stderr,"....Request to find: %d %d\n",x,y); */
 while(tagcurrent&&pointer){
   /* fprintf(stderr,"......Checking box: %f %f %f %f\n",
      pointer->xmin, pointer->ymin,
      pointer->xmax, pointer->ymax); */
   if (pointer->flag.type == LNK &&
       x<=pointer->pdflnk.Rect[2] && x>=pointer->pdflnk.Rect[0] &&
       y<=pointer->pdflnk.Rect[3] && y>=pointer->pdflnk.Rect[1]) {
     return pointer->pdflnk.View.FileName?-2:pointer->pdflnk.View.Page;
   }
   pointer = pointer->flag.next;
 }
 return -1;
}

extern int curpage;

struct target_entry *pdf_find(int x, int y)
{union pdfmark *pointer=tagstart;
 static struct target_entry retval;
 /* fprintf(stderr,"....Request to find: %d %d\n",x,y); */
 while(tagcurrent&&pointer){
   /* fprintf(stderr,"......Checking box: %f %f %f %f\n",
      pointer->xmin, pointer->ymin,
      pointer->xmax, pointer->ymax); */
   if (pointer->flag.type == LNK && pointer->pdflnk.SrcPage == curpage &&
       x<=pointer->pdflnk.Rect[2] && x>=pointer->pdflnk.Rect[0] &&
       y<=pointer->pdflnk.Rect[3] && y>=pointer->pdflnk.Rect[1]) {
     retval.file = pointer->pdflnk.View.FileName;
     retval.page = pointer->pdflnk.View.Page;
     retval.name = pointer->pdflnk.Dest;
     return &retval;
   }
   pointer = pointer->flag.next;
 }
 return NULL;
}

int dest_page(const char *name)
{union pdfmark *pointer=tagstart;
 while(tagcurrent&&pointer){
   if (pointer->flag.type == DEST 
       && strcmp(pointer->pdfdest.Dest?pointer->pdfdest.Dest:"", name)==0)
     return pointer->pdfdest.View.Page;
   pointer = pointer->flag.next;
 }
 return -1;
}
