#ifndef NeedFunctionPrototypes
#if defined(FUNCPROTO) || defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
#define NeedFunctionPrototypes 1
#else
#define NeedFunctionPrototypes 0
#endif /* __STDC__ */
#endif /* NeedFunctionPrototypes */

enum marktype {ANN, LNK, OUT, ARTICLE, DEST, DOCINFO, DOCVIEW, OTHER};
enum tokentype {lit, str, arr, proc, hex, dict,
	             estr, earr, eproc, ehex, edict, other};


typedef double rect[4];
typedef char   *string;
typedef string date;
typedef char   *name;
enum   bool   {false, true};
enum   op     {Open,  Print};
enum   action {GoTo, GoToR, Launch, Article};
enum pagemode {UseNone, UseOutlines, UseThumbs, FullScreen};
enum destmode {Fit, FitB, FitH, FitBH, FitR, FitV, FitBV, XYZ};

struct allmark {
   enum marktype type;
   union pdfmark *prev, *next;
};

struct annmark {
   enum marktype type;
   union pdfmark *prev, *next;
   string Title;
   int    SrcPage;
   rect   Rect;
   date   ModDate;
   string Contents;
   enum bool Open;
};

struct dest {
   int  Page;
   enum destmode View;
   double params[4];
   string FileName;
   enum op Op;
   string ID[2];  
};

struct lnkmark {
   enum marktype type;
   union pdfmark *prev, *next;
   string Title;
   int    SrcPage;
   rect   Rect;
   date   ModDate;
   enum action Action;
   name   Dest;
   struct dest View;
};

struct outmark {
   enum marktype type;
   union pdfmark *prev, *next;
   string Title;
   enum action Action;
   name   Dest;
   struct dest View;
   int    Count;
};

struct artmark {
   enum marktype type;
   union pdfmark *prev, *next;
   string Title;
   int    SrcPage;
   rect   Rect;
   string Subject, Author, Keywords;
};

struct destmark {
   enum marktype type;
   union pdfmark *prev, *next;
   name  Dest;
   struct dest View;
};

struct infomark {
   enum marktype type;
   union pdfmark *prev, *next;
   string Author, CreationDate, Creator, Producer, Title, Subject, Keywords,
          ModDate;
};

struct viewmark {
   enum marktype type;
   union pdfmark *prev, *next;
   enum action Action;
   name Dest;
   struct dest View;
   string ID[2];
   enum pagemode PageMode;
};
   
union pdfmark{
   struct allmark  flag;
   struct annmark  pdfann;
   struct lnkmark  pdflnk;
   struct outmark  pdfout;
   struct artmark  pdfart;
   struct destmark pdfdest;
   struct infomark pdfinfo;
   struct viewmark pdfview;
};

#if NeedFunctionPrototypes
union pdfmark *getpdfmark(char **infile);
#else
union pdfmark *getpdfmark();
#endif

