
# Brand Use Guidelines

## The purpose of these guidelines

Using our logo consistently is important to present a unified message to the world about who we are. That message is: 
arXiv is a place of connection, linking together people and ideas, and connecting them with the world of open science.

Unauthorized use of our logo causes confusion about who we are. And when it’s use is authorized it’s just as important that we follow consistent guidelines to preserve the legibility, memorability, and legal defensibility that we need. Our logo, approved by Cornell University, is the legal property of arXiv and Cornell University, protected against unauthorized use. Our logo is ready to help us share a consistent, intentional, and meaningful message about who we are with the world. 

### General guidelines that cover all logo use cases:

1. Use of the name arXiv and associated logos, web addresses, and colors are only allowed with explicit written permission 
from the arXiv management team, with the exception of a) arXiv authors following the guidelines for personal use below and b) current arXiv members, affiliates, and sponsors following the guidelines below.
2. If use is allowed, display of the arXiv logo should always follow the visual layout rules as stated in the [arXiv brand guide](brand). 
3. The logo should never be altered in any way, redrawn, used in an unspecified color, or reproduced on a background that will impair its visual recognition. 
4. The use of the name “arXiv” or “arXiv.org,” in non-arXiv organization names or projects that imply or tend to imply some official connection with arXiv, is prohibited.
5. Except as specifically authorized in writing, use of arXiv’s name and marks in advertising and other promotional vehicles is prohibited when such use is likely to be perceived as an endorsement, even if such an endorsement is not the intention of the person or organization seeking to use arXiv’s name or marks.
6. In order to protect its name and reputation, arXiv regulates the use of arXiv’s name and marks on memorabilia, products, and goods. Third party use of arXiv’s logo for products and other goods is prohibited.

### Further guidelines based on project type:

#### If you are an author with published works on arXiv

For arXiv authors only, non-commercial, personal, and minimal use of the arXiv logo for the purposes of linking from your website to arXiv’s website is allowed. In these instances the logo should follow these guidelines:
1. The logo is displayed at a size between a minimum of 50px and a maximum of 100px in width.
2. The logo is used with the intention of linking to arXiv (for example to your papers), and not for branding purposes.
3. The logo must link to arXiv.

Download the appropriate file for your personal use as an author: [png](https://cornell.box.com/v/arxiv-logo-small-png) or [jpg](https://cornell.box.com/v/arxiv-logo-small-jpg)


#### For products that use the arXiv API

1. Acknowledge arXiv data usage with this statement on your product: “Thank you to arXiv for use of its open access interoperability. This [service/ product] was not reviewed or approved by, nor does it necessarily express or reflect the policies or opinions of, arXiv.”
2. If your product is linking directly to arXiv PDFs or abstract pages, you may either use the full arXiv logo or the smaller logomark. (Note: your product must also comply with [arXiv’s license agreements](/help/license))
3. Typically logo usage beyond the above is not granted for API use. If you think your project is an exception you can always inquire at nextgen@arxiv.org.
4. The use of the name “arXiv” or “arXiv.org,” in non-arXiv organization names implying or tending to imply some official connection with arXiv, is prohibited.

#### For members, affiliates, and sponsors

1. We encourage current members and affiliates to acknowledge arXiv with the statement: “Proud supporter of arXiv.” 
2. arXiv’s logo may be used for the purposes of acknowledging the relationship while the membership, affiliation, or sponsorship is active.
3. Use of arXiv’s logo must follow our [visual brand guidelines](brand).

### Logo display guidelines:

If your application meets our criteria for use of arXiv's logo, find and download the right logo for your application below.

* If the allotted space in your application is **wider than 100px**, use our [full logo](https://cornell.box.com/v/arxiv-logo-svg).
* If the allotted space in your application is **between 40px and up to 100px in width**, use our [standard logomark](https://cornell.box.com/s/6uqn87ew01eeg2xokm1ltq5z5idfj0p7).
* If the allotted space in your application is **between 15px and up to 39px in width**, use our [small logomark](https://cornell.box.com/s/cleq2ex1wra4sfsj94tlqrw9z5oecg6b).
* At sizes **smaller than 15px** in width, do not use any arXiv branding element.

Have questions? Need a different color? Please reach out to nextgen@arxiv.org with your request and include a link to your application. 

All pixel width dimensions refer to device independent pixels (aka css pixels). 
