# Membership
<style>
blockquote {
  border-left:0;
  margin:0 auto;
  padding:0;
  max-width: 800px;
}
blockquote ol {
  list-style: none;
  margin: 0;
  padding: 0;
  display: flex;
  flex-direction: row;
  flex-wrap: wrap;
  justify-content: space-between;
}
blockquote ol li {
  width: 100%;
  padding:1em;
  -webkit-box-shadow: 0px 3px 8px 0px rgba(0,0,0,0.1);
  -moz-box-shadow: 0px 3px 8px 0px rgba(0,0,0,0.1);
  box-shadow: 0px 3px 8px 0px rgba(0,0,0,0.1);
  min-height:90px;
}
blockquote ol li strong {
  font-size: 20px;
  display: block;
  width: 100%;
  margin-bottom: 5px;
}
blockquote ol li {
  border: 5px solid #7c7469;
  background: #f9f7f7;
}
blockquote ol li::after {
  content: "";
  margin: 0;
}
h2, h2, h4, h5 {
  clear:both;
}
h3 {
  color: #7c7469;
  font-size: 16px !important;
  margin-bottom: 0px !important;
  font-weight: 800 !important;
}
aside {
  float:left;
  clear:both;
  width:100%;
}
table.table {
  border: 1px solid #cecece;
}
@media (min-width: 576px) {
  blockquote ol li {
    width: calc(50% - 10px);
  }
}
</style>

As the world's premier open access research sharing platform, arXiv was founded strictly for research and education, not profit. That's why we rely on members **--universities, libraries, research institutes, and labs--** to support our mission with funding and expertise. [Thank you, members](ourmembers)!

<a href="membership_confirm" class="button-fancy">Join or renew today <span> </span></a>

Membership offers your institution a high value, low-risk, budget-conscious option to serve your scholarly community. Members receive public recognition, institutional usage statistics, eligibility to serve in arXiv's governance, and more. The membership program is inclusive and flexible, and it complements arXiv's other [funding sources](funding), including affiliates and sponsors. [Questions? We're happy to help](mailto:membership@arxiv.org).

## How the standard membership program works

Is arXiv an essential resource for your researchers? If yes, then we invite you to become a member according to the structure described here.  Annual fees are based on submissions by institution, averaged over three years.

First, [find your institution's overall submission rank](reports/2021_institution_submissions). 

Then, match your rank to the fee using this table:

|Rank   |Annual Membership Fees (USD)
|-----------------------------|:--------------------|
| 1-100 | $5,000 |
| 101-500 | $2,500 |
| 501+ | $1,000 |

These fees are guaranteed until 2024. Institutions joining as part of a consortium receive a 10% discount, and country-level consortia receive a larger discount.

## Two alternatives: Champion and community memberships

**Community**

Is your institution using arXiv primarily for [downloading and reading papers](reports/2020_institution_downloads_by_year)? Or, is your institution significantly resource-limited? If yes, then community membership is the right choice. Join the arXiv community by choosing your contribution level at $1000 or less.

**Champion**

Is your institution a champion of open access and a thought leader in scholarly communications? By contributing $10,000 or more, your institution makes a strong statement in favor of fair and sustainable academic publishing.


## Confirmation and Payment Instructions

<a href="membership_confirm" class="button-fancy">Join, renew, or confirm your membership <span> </span></a>

<a href="arXiv-payment-info-2022.pdf" class="button-fancy">arXiv payment instructions <span> </span></a>

<a href="donate" class="button-fancy">Pay by credit card <span> </span></a>


## Member Benefits

- Public acknowledgement on [arXiv](ourmembers)
- Public recognition locally to the institution via an IP generated banner
- Eligibility to serve in arXiv’s governance
- Institutional submission statistics
- The opportunity to provide feedback via surveys
- Annual reports and regular newsletters
- Increase the sustainability of academic publishing and push the boundaries of open science

## Stay in Touch

- [Newsletter Sign Up](email_sign_up)
- [Blog](https://blog.arxiv.org/)
- [Twitter](https://twitter.com/arxiv)
- [Status Updates](https://status.arxiv.org/)
- [Questions? We're happy to help](mailto:membership@arxiv.org)

