# Member Advisory Board (MAB)

The Member Advisory Board (MAB) represents participating institutions’ interests and advises Cornell University on issues 
related to repository management and development, standards implementation, interoperability, development priorities, 
business planning, and outreach and advocacy. Representation on MAB is reserved for libraries, research institutions, 
laboratories, and foundations that are members of arXiv and that contribute to the financial support of the service.

The MAB has voting members in three categories: contributing organizations (at least 7), high-contributing organizations (up to 5), Simons Foundation (1). Representatives from contributing organizations are elected. High-contributing organizations represent each consortia or national organization member that contributes 5% or more of arXiv’s annual income generated through membership fees. Additionally, there are five non-voting ex-officio members.

The [MAB Bylaws](/about/mab_bylaws) detail the goals, composition, operation, and election of the Board.

## Contributing Organizations

**Los Alamos National Laboratory, USA**, _Carol Hoover, Digital Information Resources Manager (7-year term ending December 2020)_

Carol has been managing digital collections at LANL for over 10 years. She understands core science areas/R&D at LANL, actively seeks to integrate OA content into the Library collections and champions OA with LANL researchers. She has been a member of the SCOAP3 Technical Working Group, helping to develop the specifications for the market tender, and is now a US representative on the SCOAP3 Governing Council. She has served on many publisher Library Advisory Boards and has a strong and deep working knowledge of publishing business models, issues in scholarly publishing and budgeting and business practices across federal government libraries. She received a 2011 LANL Distinguished Performance Award for her work setting up a DOE complex-wide consortia licensing model for subscription-based content.

**University of Toronto, Canada**, _Mindy Thuna, Interim Associate Chief Librarian for Science and Research Information and Head, Engineering & Computer Science Library (interim term ending December 2020)_

Mindy Thuna is Interim Associate Chief Librarian for Science and Research Information and Head, Engineering & Computer Science Library at the University of Toronto in Toronto, Ontario. She worked as the AstraZeneca Science Liaison Librarian and the Research Enterprise Librarian at the University of Toronto Mississauga campus for 11 years, prior to moving campuses and changing roles in 2016. Mindy has been involved in collection development in Physics, Biology and Electrical Engineering. Current interests include research impact, open science, science communication and the use of storytelling in library instruction.

**University of Queensland, Australia**, _Amberyn Thomas, Associate Director Scholarly Communication and Repository Services (4-year term ending December 2021)_

Dr. Amberyn Thomas is Associate Director, Scholarly Communication and Repository Services at The University of Queensland Library, with direct responsibility for the provision of services around the institutional repository, open access, scholarly communication and publishing, research data management (including archiving and sharing), and research impact and evaluation services. Amberyn is an active member of the international scholarly communication sector: she is an ORCID ambassador, a member of the Research Data Services Project Board, has been a Australian Research Management Society Training Fellow (2015, 2016), and was awarded the 2016 Council of Australian University Librarians Achievement Award for Engagement and Influence, Research, and Sharing Knowledge and Data. With a PhD in Physics, and experience in the research and university sector for 30 years, Amberyn has a thorough understanding of the evolution of the arXiv repository and the innovative role it has played, and continues to play, in shaping scholarly communication in the 21st century.

**University of Sydney, Australia**, _Philip Kent, University Librarian (4-year term ending December 2021)_

Philip Kent joined Sydney in 2020 following an extensive career in Australian and UK universities and the CSIRO. This is his fourth post as University Librarian and he is the first to have held this role at both Sydney and Melbourne. His broad experience includes responsibility for cultural collections, information technology, knowledge and information management, archives and records management, risk and audit roles. His professional activities have included:  Director, CAVAL Ltd, chairing of the Council of Australian University Librarians’ resources purchasing consortium, and the Group of Eight (Go8) Librarians. He was a member of the judging panel for the SCONUL Library Design Awards (UK) in 2019. Philip serves on the Editorial Board for the Journal of the Australian Library and Information Association (JALIA), and the Standing Committee of the International Federation of Library Associations (IFLA) Library Buildings and Equipment Section. Philip previously served on arXiv Member Advisory Board from 2012- 2016. 

**Vacant Seat**

## High-Contributing Organizations

**Big Ten Academic Alliance, USA**, _Maureen P. Walsh, Associate Professor, Scholarly Sharing Strategist, The Ohio State University, University Libraries Publishing and Repository Services (4- or 6-year  institutional  term,  based on the number of High-Contributing Organizations, elected 2018)_

Maureen Walsh is an Associate Professor and Scholarly Sharing Strategist at The Ohio State University Libraries where she has worked with Ohio State's institutional repository for the past twelve years. She has been actively involved in DuraSpace governance and is currently a member of the DSpace Steering Group and the Chair of the DSpace Community Advisory Team. Maureen is a strong and collaborative leader in the well-established repository and publishing activities at Ohio State. She is well connected in the repository community and also is grounded in long-standing and deep partnerships with units on the Ohio State campus. 

**Consortium arXiv-DH and HGF: Coordinated by the German National Library of Science and Technology (TIB) and Deutsches Elektronen-Synchrotron DESY, Germany**, _Esther Tobschall, German National Library of Science and Technology (4- or 6-year institutional term, based on the number of High-Contributing Organizations, elected 2018)_

In her role as physics librarian of TIB Esther Tobschall is concerned with providing physicists with the information resources they need for their research.Thus, Esther is involved in Open Access activities of TIB . During the first years she has coordinated the arXiv-DH project (funded by the German Research Foundation), and is now representing TIB as national arXiv contact point within network arXiv-DH. Prior to entering librarianship she studied chemistry and gained her doctorate at University of Hannover with research in solid state physics.

**Jisc, UK**, _Tracey Clarke (4- or 6-year institutional term, based on the number of High-Contributing Organizations, elected 2016)_

Tracey has worked in UK research libraries since 1990 and has been active both in regional collaborations and on an international scale for a number of years. In 2018 she left the University of Sheffield in order to become a specialist library consultant and continues to focus on scholarly communications, open access developments, library technology, digital preservation and collaborative collections. In her most recent role as Associate Director (Academic and Digital Strategies), Tracey has been responsible at Executive level for research support including open access, open access publishing, research data management, library collections, faculty engagement, systems and digital services, digital preservation, licensing and copyright. She has extensive experience in strategic and operational planning and a strong interest in developing inclusive leadership throughout organizations. Additionally, Tracey has been a key member of the award winning White Rose Libraries Consortium based in the UK, leading the collaborative collections strategy and helping to establish the open access White Rose University Press. Tracey is a member of the IGeLU Steering Committee and she has also been a member of the Digital Preservation Coalition Executive Board.

**Society Members**, _represented by Scott Delman, Director of Publications for the Association for Computing Machinery (ACM), USA (1-year pilot implementation, elected 2019)_

arXiv is collaborating with a group of societies to add a new tier to the membership model. Scott Delman represents the group of societies in the MAB. He has been working in the scholarly publishing industry for over 25 years and currently serves as the Director of Publications for the Association for Computing Machinery (ACM), where he has overall responsibility for editorial, content development, publications policy, rights & permissions, production, Digital Library sales & marketing, and publications strategy, including ACM’s long-term transition to Open Access. Prior to joining ACM, Scott served in a number of senior and executive level management positions at Springer and Kluwer. In addition to his current role at ACM, Scott is actively involved in the governance of a number of initiatives including Crossref, CHORUS, and is member of the Portico Advisory Committee. The societies that participate in the pilot include American Astronomical Society, American Institute of Physics Publishing, American Mathematical Society, American Physical Society, Association for Computing Machinery, Deutsche Physikalische Gesellschaft, and Institute of Physics Publishing.  Please see: Society Tier Pilot

**University of California, USA**, _Alison M. Scott, Associate University Librarian for Collection Management and Scholarly Communication, University of California, Los Angeles  (4- or 6-year institutional term, TBD based on the number of High-Contributing Organizations, elected 2016)_

Alison M. Scott is the Associate University Librarian for Collection Management & Scholarly Communication at the University of California, Los Angeles (her prior position was at UC, Riverside). Before coming to California in 2014, she held positions in a variety of academic libraries, including Head of Collection Development for the George Washington University Libraries, Charles Warren Bibliographer for American History at Harvard University, and Head of the Popular Culture Library at Bowling Green State University. She holds master's degrees in religion and library science from the University of Chicago and a Ph.D. in American Studies from Boston University. Her research interests center on the history of the book in the United States, including women’s reading in the Early Republic, story papers of the Civil War era, and the relationships between prestige and collection development in academic libraries.

**Japan NII Consortia**, _Hideaki Takeda, Professor, National Institute of Informatics (NII), (4- or 6-year institutional term, based on the number of High-Contributing Organizations, elected 2019)_

Hideaki Takeda is a full professor in computer science at National Institute of Informatics (NII) in Tokyo, Japan. His research field is Artificial Intelligence, particularly Semantic Web and Social Media Analysis. He is an author of more than 100 papers in computer science. He has also worked for scholarly communication field by contributing design of scholarly communication services offered by NII and by serving as a representative of NII in the variety of domestic and international activities. He is currently the chair of Japan Link Center (DOI RA), the president of Research Data Utilization Forum, Japan, the chair of SPARC Japan, and was a board member of ORCID (2012-2016).

## Simons Foundation

_Yuri Tschinkel, Director of Mathematics and the Physical Sciences, Simons Foundation, US Professor of Mathematics, Courant Institute of Mathematical Sciences, New York University_

Yuri Tschinkel received his doctorate in mathematics from the Massachusetts Institute of Technology in 1992. From 1992 to 1995 he was Junior Fellow of the Harvard Society of Fellows, and 1995-96 he was a Leibniz fellow at the École Normale Supérieure in Paris. Prior to joining the Simons Foundation in 2012, Tschinkel was a faculty member at the University of Illinois at Chicago, a visiting associate professor at Princeton University, the Gauss chair of mathematics at the University of Göttingen, and professor and chair of the mathematics department at the Courant Institute, New York University. He was also a member of the Institute for Advanced Study in Princeton and held visiting fellowships at the Isaac Newton Institute for Mathematical Sciences in Cambridge, University of Tokyo, Max Planck Institute in Bonn, Institut des Hautes Études Scientifiques in Paris, Eidgenössische Technische Hochschule Zürich, and Research Institute for Mathematical Sciences at Kyoto University. He serves on the editorial boards of Experimental Mathematics, the Bulletin of the American Mathematical Society, the Central European Journal of Mathematics, and the Progress in Mathematics series from Birkhäuser. Yuri Tschinkel studies higher-dimensional algebraic varieties, their hidden symmetries and rational points. He is an author of about 100 publications (most of them available on arXiv) and editor of 15 books.

## Ex Officio Members
**Cornell University (5 non-voting seats)**, _Ramin Zabih, Faculty Director; Steinn Sigurdsson, Scientific Director; Jim Entwood, Operations Manager; Alison Fromme, Community Engagement and Development Manager._

**Scientific Advisory Board (SAB) Representative**, _Dr. Sumati Surya, Professor, Raman Research Institute, India_

**MAB Representatives to SAB**, _Carol Hoover, Digital Information Resources Manager, Los Alamos National Laboratory, USA_
