# arXiv Operating Principles

March 28, 2012

_Note: This document has not been revised since 2012 and thus, is out of date and needs be revised to reflect the current organization._

## 1. General & Editorial Principles

1.1. arXiv provides an open-access repository of scientific research to authors and researchers
worldwide.

1.2. arXiv is a scholarly communication forum informed and guided by scientists and the
scientific cultures being served.

1.3. Access to arXiv content via arXiv.org is free to individual end users.

1.4. Individual researchers can deposit their own content in arXiv for free.

1.5. Criteria and standards for depositing content in arXiv are maintained by the Scientific
Advisory Board, and deposit is governed by transparent and publicly posted policies and
procedures.

1.6. arXiv serves the needs of researchers in physics, mathematics, computer science, quantitative
biology, quantitative finance, and statistics. Any expansion into other subjects or disciplines
must include scholarly community support, satisfy arXiv’s quality standards, and take into
consideration its operational capacity and financial requirements.

1.7. Whenever possible, arXiv adopts open-source software and relevant standards and best
practices.

## 2. Governance Principles

### 2. Role of Cornell University

2.1. CUL holds the overall responsibility for arXiv’s operation and development, with strategic
and operational guidance from its Member Advisory Board (MAB) and its Scientific
Advisory Board (SAB).

2.2. Cornell University:

2.2.a. Manages the moderation of submissions and user support, including the development
and implementation of policies and procedures;

2.2.b. Operates arXiv’s technical infrastructure, including system maintenance, standards
implementation, and development initiatives for incorporating new features and
services.

2.2.c. Coordinates and facilitates the meetings and deliberations of Member and Scientific
Advisory boards.

2.2.d. Provides interfaces and data access to support open reuse of arXiv data.

2.2.e. Assumes responsibility for archiving to ensure long-term access and maintains arXiv
mirror sites.

2.2.f. Establishes and maintains collaborations with related initiatives to improve services
for the scientific community through interoperability and through sharing tools and
software.

2.2.g. Administers the arXiv membership program and assumes ultimate financial
responsibility for running arXiv.

2.2.h. Maintains a transparent and open communication strategy to engage and inform
arXiv’s key stakeholders.

2.2.i. Bears responsibility for developing a succession plan in the event it can no longer host
the service.

### 3. Role of the Member Advisory Board

3.1. A Member Advisory Board is elected from arXiv’s membership and serves as a consultative
body.

3.2. The board represents participating institutions’ interests and advises CUL on issues related to
repository management and development, standards implementation, interoperability,
development priorities, business planning, and outreach and advocacy.

3.3. Membership in arXiv and representation on the MAB is reserved for libraries, research
institutions, laboratories, and foundations that contribute to the financial support of the
service.

3.4. Voting for representatives to the MAB is open to all eligible member institutions, each of
which shall have one vote. Member institutions may delegate their representation to a
consortium or other proxy<sup1</supwith the voting representation of such proxies being equal to the
number of members represented.

3.5. The MAB is chaired by the arXiv Program Director from CUL and includes two members of
the Scientific Advisory Board as non-voting ex officio members. The CUL IT and usersupport leads attend meetings as non-voting members to participate in discussions and
provide background information.

3.6. The MAB reviews and comments on arXiv budgets proposed by CUL.

### 4. Role of the Scientific Advisory Board

4.1. The Scientific Advisory Board is composed of scientists and researchers in areas covered by
arXiv. Chairs of subject Advisory Committees serve as _ex officio_ members of the board. The
selection process for the remaining members will be delineated in arXiv board bylaws.

4.2. The SAB selects a Chair from among its members. The Chair works with the arXiv director
of user support to coordinate SAB activities. The roles of the Chair and the arXiv director of
user support, with respect to the SAB, will be specified in arXiv board bylaws.

4.3. The SAB:

4.3.a. Provides advice and guidance pertaining to the intellectual oversight of arXiv, with
particular focus on the policies and operation of arXiv's moderation system.

4.3.b. Reviews the criteria and standards for deposit in arXiv and proposes revisions to
those criteria and standards as it deems warranted.

4.3.c. Proposes new subject or discipline domains to be covered by arXiv and/or reviews
proposals for such domains.

4.3.d. Provides scientist feedback on arXiv development projects proposed by the MAB.

4.3.e. Makes recommendations regarding development projects — in particular, suggestions
about improvements to the systems that support submission and moderation
processing.

4.4. Two members of the MAB serve as non-voting ex officio members of the SAB.

4.5. The CU IT and user support leads attend SAB meetings as non-voting members to
participate in discussions and provide background information.

## 5. General Governance Principles

5.1. To ensure transparency and accountability, arXiv provides annual operational and financial
reports to member institutions.

5.2. The SAB and the MAB operate in parallel, complementing each other and providing
essential input for CU<sup2</sup. To this end, the SAB appoints two members to serve as non-voting
_ex officio_ members of the MAB; the MAB appoints two members to serve as non-voting _ex
officio_ members of the SAB.

5.3. Members acknowledge that the host institution’s legal obligations and fiduciary
responsibilities place practical constraints on the formal governance structure and terms. Within these constraints, arXiv is committed to adhering to the stated governance principles,
and to review periodically these principles.

## 6. Economic Principles

6.1. arXiv is supported financially by Cornell University Library and a global collective of
institutional members, potentially supplemented by foundation grants.

6.2. CU has committed to contribute a cash subsidy of $75,000 per year in support of arXiv’s
operational costs and an in-kind contribution of all indirect costs, which currently represents
37% of total arXiv operating costs<sup3</sup.

6.3. Each member institution pledges a five-year initial funding commitment to support arXiv<sup4</sup. Membership fees may be adjusted annually to ensure that arXiv is sustained at an acceptable level of service, as determined by Cornell University in consultation with the MAB and the SAB.

6.4. Membership fees are equitable and based on an explicit fee structure.

6.5. Board proposals to CUL for service upgrades or development projects that require
supplemental funding (that is, costs additional to the costs incurred for operating and
maintaining the service) must identify the source of such funding prior to the upgrade being
implemented.

6.6. Any fees for value-added services will be set at a level sufficient to recover the cost of
providing the service and to contribute to arXiv operating costs. Supplemental services need
to be provided on transparent and non-discriminatory terms, avoiding exclusive partnerships.

6.7. After a successful initial membership offering, if members’ financial support falls below the
level Cornell deems adequate to maintain arXiv at an acceptable level of quality, reserve
funds will be used for two years to allow time for Cornell to secure sufficient funding
support. Failure to do so may result in the development of an exit strategy, including the
transition of arXiv to another institution.

***
<sup1</supFunders may make their payment of membership fees for individual institutions conditional on those institutions designating the funder their proxy. However, monitoring such requirements would be beyond arXiv’s purview.

<sup2</supSpecifics of the composition, terms, selection, and goals of the Scientific Advisory Board and the Member
Advisory Board will be articulated in the groups’ bylaws (to be developed).

<sup3</supCUL’s indirect costs include library and departmental administration; staff support (finance/budget, human resources, facility staff, and staff IT); and maintenance, custodial, utility, and other facility related costs for the building.

<sup4</supSee the arXiv Membership Program section about the specifics of the five-year commitment.

***
_Revisions:_

minor reformatting on July 10, 2012, OYR

deleted a footnote on October 1, 2012, OYR
