2010 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2010 for the 200 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads (this is a
change from the 2009 statistics, which counted one download per host per
month, and increases the number of downloads counted); 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (we have significantly increased the number
institutions recognized which means that some institutions appear in the
top 200 list that were erroneously omitted from the 2009 statistics. A
large fraction of downloads come from commercial ISPs which are not
included. Clients with host names that don't resolve or off-campus
accesses will lead to undercounting, failure to recognize institutional
domain names will exclude those institutions and undercount the total
institutional downloads). We have identified 11.9 million downloads from
institutional domain names out of a total of 40 million downloads in
2010.

<table>
<thead>
<tr class="header">
<th>Rank</th>
<th>Institutional domain</th>
<th>Percentage of total<br />
institutional downloads</th>
<th>Number of article downloads</th>
</tr>
</thead>
<tbody>
<tr class="odd">
<td>1</td>
<td>mpg.de(*)</td>
<td>2.42%</td>
<td>287056</td>
</tr>
<tr class="even">
<td>2</td>
<td>cern.ch</td>
<td>1.80%</td>
<td>213822</td>
</tr>
<tr class="odd">
<td>3</td>
<td>u-tokyo.ac.jp</td>
<td>1.49%</td>
<td>177027</td>
</tr>
<tr class="even">
<td>4</td>
<td>cam.ac.uk</td>
<td>1.31%</td>
<td>156091</td>
</tr>
<tr class="odd">
<td>5</td>
<td>kyoto-u.ac.jp</td>
<td>1.06%</td>
<td>125810</td>
</tr>
<tr class="even">
<td>6</td>
<td>harvard.edu</td>
<td>1.06%</td>
<td>125482</td>
</tr>
<tr class="odd">
<td>7</td>
<td>ox.ac.uk</td>
<td>0.98%</td>
<td>116877</td>
</tr>
<tr class="even">
<td>8</td>
<td>mit.edu</td>
<td>0.95%</td>
<td>112319</td>
</tr>
<tr class="odd">
<td>9</td>
<td>princeton.edu</td>
<td>0.82%</td>
<td>97458</td>
</tr>
<tr class="even">
<td>10</td>
<td>caltech.edu</td>
<td>0.81%</td>
<td>95874</td>
</tr>
<tr class="odd">
<td>11</td>
<td>berkeley.edu</td>
<td>0.79%</td>
<td>94226</td>
</tr>
<tr class="even">
<td>12</td>
<td>in2p3.fr</td>
<td>0.77%</td>
<td>91451</td>
</tr>
<tr class="odd">
<td>13</td>
<td>ethz.ch</td>
<td>0.70%</td>
<td>82627</td>
</tr>
<tr class="even">
<td>14</td>
<td>desy.de</td>
<td>0.65%</td>
<td>77444</td>
</tr>
<tr class="odd">
<td>15</td>
<td>inaf.it(*)</td>
<td>0.62%</td>
<td>73875</td>
</tr>
<tr class="even">
<td>16</td>
<td>uni-bonn.de</td>
<td>0.61%</td>
<td>71863</td>
</tr>
<tr class="odd">
<td>17</td>
<td>ucsb.edu</td>
<td>0.60%</td>
<td>70996</td>
</tr>
<tr class="even">
<td>18</td>
<td>ic.ac.uk</td>
<td>0.59%</td>
<td>70635</td>
</tr>
<tr class="odd">
<td>19</td>
<td>stanford.edu</td>
<td>0.59%</td>
<td>70025</td>
</tr>
<tr class="even">
<td>20</td>
<td>cea.fr</td>
<td>0.58%</td>
<td>68693</td>
</tr>
<tr class="odd">
<td>21</td>
<td>umich.edu</td>
<td>0.58%</td>
<td>68515</td>
</tr>
<tr class="even">
<td>22</td>
<td>dur.ac.uk</td>
<td>0.55%</td>
<td>64962</td>
</tr>
<tr class="odd">
<td>23</td>
<td>columbia.edu</td>
<td>0.55%</td>
<td>64773</td>
</tr>
<tr class="even">
<td>24</td>
<td>uni-heidelberg.de</td>
<td>0.53%</td>
<td>62759</td>
</tr>
<tr class="odd">
<td>25</td>
<td>fnal.gov</td>
<td>0.50%</td>
<td>58811</td>
</tr>
<tr class="even">
<td>26</td>
<td>utexas.edu</td>
<td>0.48%</td>
<td>57574</td>
</tr>
<tr class="odd">
<td>27</td>
<td>sissa.it</td>
<td>0.48%</td>
<td>57142</td>
</tr>
<tr class="even">
<td>28</td>
<td>cornell.edu</td>
<td>0.47%</td>
<td>55807</td>
</tr>
<tr class="odd">
<td>29</td>
<td>ohio-state.edu</td>
<td>0.47%</td>
<td>55638</td>
</tr>
<tr class="even">
<td>30</td>
<td>perimeterinstitute.ca</td>
<td>0.46%</td>
<td>54694</td>
</tr>
<tr class="odd">
<td>31</td>
<td>kek.jp</td>
<td>0.45%</td>
<td>53751</td>
</tr>
<tr class="even">
<td>32</td>
<td>stonybrook.edu(*)</td>
<td>0.45%</td>
<td>53040</td>
</tr>
<tr class="odd">
<td>33</td>
<td>tohoku.ac.jp</td>
<td>0.43%</td>
<td>51052</td>
</tr>
<tr class="even">
<td>34</td>
<td>ictp.it(*)</td>
<td>0.43%</td>
<td>50499</td>
</tr>
<tr class="odd">
<td>35</td>
<td>uchicago.edu</td>
<td>0.42%</td>
<td>50219</td>
</tr>
<tr class="even">
<td>36</td>
<td>tsinghua.edu.cn</td>
<td>0.42%</td>
<td>49814</td>
</tr>
<tr class="odd">
<td>37</td>
<td>ihep.ac.cn</td>
<td>0.42%</td>
<td>49664</td>
</tr>
<tr class="even">
<td>38</td>
<td>yale.edu</td>
<td>0.41%</td>
<td>48727</td>
</tr>
<tr class="odd">
<td>39</td>
<td>jussieu.fr</td>
<td>0.41%</td>
<td>48572</td>
</tr>
<tr class="even">
<td>40</td>
<td>bnl.gov</td>
<td>0.40%</td>
<td>48079</td>
</tr>
<tr class="odd">
<td>41</td>
<td>colorado.edu</td>
<td>0.40%</td>
<td>48013</td>
</tr>
<tr class="even">
<td>42</td>
<td>wisc.edu</td>
<td>0.40%</td>
<td>47346</td>
</tr>
<tr class="odd">
<td>43</td>
<td>uni-bielefeld.de</td>
<td>0.40%</td>
<td>46898</td>
</tr>
<tr class="even">
<td>44</td>
<td>uwaterloo.ca</td>
<td>0.39%</td>
<td>45796</td>
</tr>
<tr class="odd">
<td>45</td>
<td>utoronto.ca</td>
<td>0.38%</td>
<td>45245</td>
</tr>
<tr class="even">
<td>46</td>
<td>osaka-u.ac.jp</td>
<td>0.38%</td>
<td>45234</td>
</tr>
<tr class="odd">
<td>47</td>
<td>weizmann.ac.il</td>
<td>0.38%</td>
<td>45112</td>
</tr>
<tr class="even">
<td>48</td>
<td>washington.edu</td>
<td>0.38%</td>
<td>44771</td>
</tr>
<tr class="odd">
<td>49</td>
<td>uiuc.edu</td>
<td>0.38%</td>
<td>44730</td>
</tr>
<tr class="even">
<td>50</td>
<td>umd.edu</td>
<td>0.38%</td>
<td>44624</td>
</tr>
<tr class="odd">
<td>51</td>
<td>nagoya-u.ac.jp</td>
<td>0.38%</td>
<td>44602</td>
</tr>
<tr class="even">
<td>52</td>
<td>uv.es</td>
<td>0.37%</td>
<td>44189</td>
</tr>
<tr class="odd">
<td>53</td>
<td>univie.ac.at</td>
<td>0.37%</td>
<td>43912</td>
</tr>
<tr class="even">
<td>54</td>
<td>tamu.edu</td>
<td>0.37%</td>
<td>43749</td>
</tr>
<tr class="odd">
<td>55</td>
<td>usp.br</td>
<td>0.37%</td>
<td>43550</td>
</tr>
<tr class="even">
<td>56</td>
<td>nasa.gov</td>
<td>0.37%</td>
<td>43362</td>
</tr>
<tr class="odd">
<td>57</td>
<td>nus.edu.sg</td>
<td>0.36%</td>
<td>42581</td>
</tr>
<tr class="even">
<td>58</td>
<td>jinr.ru</td>
<td>0.35%</td>
<td>41517</td>
</tr>
<tr class="odd">
<td>59</td>
<td>riken.jp(*)</td>
<td>0.35%</td>
<td>41352</td>
</tr>
<tr class="even">
<td>60</td>
<td>uni-frankfurt.de</td>
<td>0.34%</td>
<td>40879</td>
</tr>
<tr class="odd">
<td>61</td>
<td>epfl.ch</td>
<td>0.34%</td>
<td>40811</td>
</tr>
<tr class="even">
<td>62</td>
<td>ens.fr</td>
<td>0.34%</td>
<td>40801</td>
</tr>
<tr class="odd">
<td>63</td>
<td>mcgill.ca</td>
<td>0.34%</td>
<td>39988</td>
</tr>
<tr class="even">
<td>64</td>
<td>psu.edu</td>
<td>0.33%</td>
<td>39556</td>
</tr>
<tr class="odd">
<td>65</td>
<td>unige.ch</td>
<td>0.33%</td>
<td>39288</td>
</tr>
<tr class="even">
<td>66</td>
<td>slac.stanford.edu</td>
<td>0.33%</td>
<td>39114</td>
</tr>
<tr class="odd">
<td>67</td>
<td>uni-mainz.de</td>
<td>0.32%</td>
<td>38370</td>
</tr>
<tr class="even">
<td>68</td>
<td>rutgers.edu</td>
<td>0.32%</td>
<td>37440</td>
</tr>
<tr class="odd">
<td>69</td>
<td>umn.edu</td>
<td>0.31%</td>
<td>37260</td>
</tr>
<tr class="even">
<td>70</td>
<td>ntu.edu.tw</td>
<td>0.31%</td>
<td>37145</td>
</tr>
<tr class="odd">
<td>71</td>
<td>uva.nl</td>
<td>0.31%</td>
<td>36903</td>
</tr>
<tr class="even">
<td>72</td>
<td>uni-karlsruhe.de</td>
<td>0.31%</td>
<td>36488</td>
</tr>
<tr class="odd">
<td>73</td>
<td>ucla.edu</td>
<td>0.31%</td>
<td>36399</td>
</tr>
<tr class="even">
<td>74</td>
<td>u-psud.fr</td>
<td>0.30%</td>
<td>35878</td>
</tr>
<tr class="odd">
<td>75</td>
<td>helsinki.fi</td>
<td>0.30%</td>
<td>35868</td>
</tr>
<tr class="even">
<td>76</td>
<td>uci.edu</td>
<td>0.30%</td>
<td>35653</td>
</tr>
<tr class="odd">
<td>77</td>
<td>navy.mil</td>
<td>0.29%</td>
<td>34232</td>
</tr>
<tr class="even">
<td>78</td>
<td>tau.ac.il</td>
<td>0.28%</td>
<td>33825</td>
</tr>
<tr class="odd">
<td>79</td>
<td>uam.es</td>
<td>0.28%</td>
<td>33584</td>
</tr>
<tr class="even">
<td>80</td>
<td>uni-regensburg.de</td>
<td>0.28%</td>
<td>33549</td>
</tr>
<tr class="odd">
<td>81</td>
<td>ucsd.edu</td>
<td>0.28%</td>
<td>33044</td>
</tr>
<tr class="even">
<td>82</td>
<td>nyu.edu</td>
<td>0.28%</td>
<td>33012</td>
</tr>
<tr class="odd">
<td>83</td>
<td>uni-wuerzburg.de</td>
<td>0.28%</td>
<td>32808</td>
</tr>
<tr class="even">
<td>84</td>
<td>rwth-aachen.de</td>
<td>0.27%</td>
<td>32534</td>
</tr>
<tr class="odd">
<td>85</td>
<td>ed.ac.uk</td>
<td>0.27%</td>
<td>31777</td>
</tr>
<tr class="even">
<td>86</td>
<td>lanl.gov</td>
<td>0.27%</td>
<td>31721</td>
</tr>
<tr class="odd">
<td>87</td>
<td>ubc.ca</td>
<td>0.27%</td>
<td>31657</td>
</tr>
<tr class="even">
<td>88</td>
<td>pd.infn.it</td>
<td>0.26%</td>
<td>31418</td>
</tr>
<tr class="odd">
<td>89</td>
<td>arizona.edu</td>
<td>0.26%</td>
<td>31156</td>
</tr>
<tr class="even">
<td>90</td>
<td>uni-hamburg.de</td>
<td>0.26%</td>
<td>30713</td>
</tr>
<tr class="odd">
<td>91</td>
<td>purdue.edu</td>
<td>0.26%</td>
<td>30625</td>
</tr>
<tr class="even">
<td>92</td>
<td>ucl.ac.uk</td>
<td>0.26%</td>
<td>30553</td>
</tr>
<tr class="odd">
<td>93</td>
<td>huji.ac.il</td>
<td>0.26%</td>
<td>30442</td>
</tr>
<tr class="even">
<td>94</td>
<td>uu.nl</td>
<td>0.26%</td>
<td>30332</td>
</tr>
<tr class="odd">
<td>95</td>
<td>csic.es</td>
<td>0.26%</td>
<td>30298</td>
</tr>
<tr class="even">
<td>96</td>
<td>hu-berlin.de</td>
<td>0.25%</td>
<td>30007</td>
</tr>
<tr class="odd">
<td>97</td>
<td>upenn.edu</td>
<td>0.25%</td>
<td>29390</td>
</tr>
<tr class="even">
<td>98</td>
<td>ub.es</td>
<td>0.25%</td>
<td>29385</td>
</tr>
<tr class="odd">
<td>99</td>
<td>nottingham.ac.uk</td>
<td>0.25%</td>
<td>29336</td>
</tr>
<tr class="even">
<td>100</td>
<td>ucm.es</td>
<td>0.25%</td>
<td>29108</td>
</tr>
<tr class="odd">
<td>101</td>
<td>ufl.edu</td>
<td>0.24%</td>
<td>29071</td>
</tr>
<tr class="even">
<td>102</td>
<td>uni-muenchen.de(*)</td>
<td>0.24%</td>
<td>28874</td>
</tr>
<tr class="odd">
<td>103</td>
<td>kuleuven.be</td>
<td>0.24%</td>
<td>28523</td>
</tr>
<tr class="even">
<td>104</td>
<td>soton.ac.uk</td>
<td>0.24%</td>
<td>28213</td>
</tr>
<tr class="odd">
<td>105</td>
<td>gatech.edu</td>
<td>0.24%</td>
<td>28120</td>
</tr>
<tr class="even">
<td>106</td>
<td>utl.pt</td>
<td>0.24%</td>
<td>27983</td>
</tr>
<tr class="odd">
<td>107</td>
<td>chalmers.se</td>
<td>0.23%</td>
<td>27695</td>
</tr>
<tr class="even">
<td>108</td>
<td>leidenuniv.nl</td>
<td>0.23%</td>
<td>27494</td>
</tr>
<tr class="odd">
<td>109</td>
<td>lbl.gov</td>
<td>0.23%</td>
<td>27339</td>
</tr>
<tr class="even">
<td>110</td>
<td>imsc.res.in</td>
<td>0.23%</td>
<td>27282</td>
</tr>
<tr class="odd">
<td>111</td>
<td>unimelb.edu.au</td>
<td>0.23%</td>
<td>26871</td>
</tr>
<tr class="even">
<td>112</td>
<td>ulb.ac.be</td>
<td>0.22%</td>
<td>26711</td>
</tr>
<tr class="odd">
<td>113</td>
<td>tuwien.ac.at</td>
<td>0.22%</td>
<td>26423</td>
</tr>
<tr class="even">
<td>114</td>
<td>uibk.ac.at</td>
<td>0.22%</td>
<td>26416</td>
</tr>
<tr class="odd">
<td>115</td>
<td>rug.nl</td>
<td>0.22%</td>
<td>26407</td>
</tr>
<tr class="even">
<td>116</td>
<td>uu.se</td>
<td>0.22%</td>
<td>26363</td>
</tr>
<tr class="odd">
<td>117</td>
<td>cnrs.fr(*)</td>
<td>0.22%</td>
<td>26242</td>
</tr>
<tr class="even">
<td>118</td>
<td>uni-tuebingen.de</td>
<td>0.22%</td>
<td>26138</td>
</tr>
<tr class="odd">
<td>119</td>
<td>obspm.fr</td>
<td>0.22%</td>
<td>25848</td>
</tr>
<tr class="even">
<td>120</td>
<td>uni-hannover.de</td>
<td>0.21%</td>
<td>25523</td>
</tr>
<tr class="odd">
<td>121</td>
<td>bris.ac.uk</td>
<td>0.21%</td>
<td>25239</td>
</tr>
<tr class="even">
<td>122</td>
<td>polytechnique.fr</td>
<td>0.21%</td>
<td>25083</td>
</tr>
<tr class="odd">
<td>123</td>
<td>uni-freiburg.de</td>
<td>0.21%</td>
<td>25073</td>
</tr>
<tr class="even">
<td>124</td>
<td>titech.ac.jp</td>
<td>0.21%</td>
<td>24998</td>
</tr>
<tr class="odd">
<td>125</td>
<td>ias.edu</td>
<td>0.21%</td>
<td>24794</td>
</tr>
<tr class="even">
<td>126</td>
<td>nbi.dk</td>
<td>0.21%</td>
<td>24372</td>
</tr>
<tr class="odd">
<td>127</td>
<td>cuhk.edu.hk</td>
<td>0.20%</td>
<td>24270</td>
</tr>
<tr class="even">
<td>128</td>
<td>northwestern.edu</td>
<td>0.20%</td>
<td>24180</td>
</tr>
<tr class="odd">
<td>129</td>
<td>uni-koeln.de</td>
<td>0.20%</td>
<td>24145</td>
</tr>
<tr class="even">
<td>130</td>
<td>jhu.edu</td>
<td>0.20%</td>
<td>24098</td>
</tr>
<tr class="odd">
<td>131</td>
<td>cmu.edu</td>
<td>0.20%</td>
<td>23752</td>
</tr>
<tr class="even">
<td>132</td>
<td>uzh.ch</td>
<td>0.20%</td>
<td>23729</td>
</tr>
<tr class="odd">
<td>133</td>
<td>waseda.ac.jp</td>
<td>0.20%</td>
<td>23698</td>
</tr>
<tr class="even">
<td>134</td>
<td>ukzn.ac.za</td>
<td>0.20%</td>
<td>23394</td>
</tr>
<tr class="odd">
<td>135</td>
<td>tifr.res.in</td>
<td>0.20%</td>
<td>23198</td>
</tr>
<tr class="even">
<td>136</td>
<td>nao.ac.jp</td>
<td>0.19%</td>
<td>23073</td>
</tr>
<tr class="odd">
<td>137</td>
<td>qmul.ac.uk</td>
<td>0.19%</td>
<td>23031</td>
</tr>
<tr class="even">
<td>138</td>
<td>usyd.edu.au</td>
<td>0.19%</td>
<td>22954</td>
</tr>
<tr class="odd">
<td>139</td>
<td>uni-augsburg.de</td>
<td>0.19%</td>
<td>22940</td>
</tr>
<tr class="even">
<td>140</td>
<td>unam.mx</td>
<td>0.19%</td>
<td>22912</td>
</tr>
<tr class="odd">
<td>141</td>
<td>uni-jena.de</td>
<td>0.19%</td>
<td>22809</td>
</tr>
<tr class="even">
<td>142</td>
<td>bu.edu</td>
<td>0.19%</td>
<td>22684</td>
</tr>
<tr class="odd">
<td>143</td>
<td>tkk.fi(*)</td>
<td>0.19%</td>
<td>22541</td>
</tr>
<tr class="even">
<td>144</td>
<td>fi.infn.it</td>
<td>0.19%</td>
<td>22341</td>
</tr>
<tr class="odd">
<td>145</td>
<td>eso.org</td>
<td>0.19%</td>
<td>22317</td>
</tr>
<tr class="even">
<td>146</td>
<td>roma1.infn.it</td>
<td>0.19%</td>
<td>22303</td>
</tr>
<tr class="odd">
<td>147</td>
<td>postech.ac.kr</td>
<td>0.19%</td>
<td>22216</td>
</tr>
<tr class="even">
<td>148</td>
<td>tu-darmstadt.de</td>
<td>0.19%</td>
<td>22063</td>
</tr>
<tr class="odd">
<td>149</td>
<td>nist.gov</td>
<td>0.19%</td>
<td>22034</td>
</tr>
<tr class="even">
<td>150</td>
<td>ujf-grenoble.fr</td>
<td>0.19%</td>
<td>22033</td>
</tr>
<tr class="odd">
<td>151</td>
<td>kaist.ac.kr</td>
<td>0.19%</td>
<td>22017</td>
</tr>
<tr class="even">
<td>152</td>
<td>hiroshima-u.ac.jp</td>
<td>0.18%</td>
<td>21903</td>
</tr>
<tr class="odd">
<td>153</td>
<td>utah.edu</td>
<td>0.18%</td>
<td>21823</td>
</tr>
<tr class="even">
<td>154</td>
<td>indiana.edu</td>
<td>0.18%</td>
<td>21223</td>
</tr>
<tr class="odd">
<td>155</td>
<td>prl.res.in</td>
<td>0.18%</td>
<td>21192</td>
</tr>
<tr class="even">
<td>156</td>
<td>uniroma1.it</td>
<td>0.18%</td>
<td>20829</td>
</tr>
<tr class="odd">
<td>157</td>
<td>uj.edu.pl</td>
<td>0.17%</td>
<td>20654</td>
</tr>
<tr class="even">
<td>158</td>
<td>anu.edu.au</td>
<td>0.17%</td>
<td>20393</td>
</tr>
<tr class="odd">
<td>159</td>
<td>uct.ac.za</td>
<td>0.17%</td>
<td>20243</td>
</tr>
<tr class="even">
<td>160</td>
<td>iap.fr</td>
<td>0.17%</td>
<td>20146</td>
</tr>
<tr class="odd">
<td>161</td>
<td>uq.edu.au</td>
<td>0.17%</td>
<td>20125</td>
</tr>
<tr class="even">
<td>162</td>
<td>ualberta.ca</td>
<td>0.17%</td>
<td>19823</td>
</tr>
<tr class="odd">
<td>163</td>
<td>unibe.ch</td>
<td>0.17%</td>
<td>19794</td>
</tr>
<tr class="even">
<td>164</td>
<td>uio.no</td>
<td>0.17%</td>
<td>19754</td>
</tr>
<tr class="odd">
<td>165</td>
<td>uni-erlangen.de</td>
<td>0.16%</td>
<td>19314</td>
</tr>
<tr class="even">
<td>166</td>
<td>gla.ac.uk</td>
<td>0.16%</td>
<td>19242</td>
</tr>
<tr class="odd">
<td>167</td>
<td>unipi.it</td>
<td>0.16%</td>
<td>19079</td>
</tr>
<tr class="even">
<td>168</td>
<td>ucdavis.edu</td>
<td>0.16%</td>
<td>19079</td>
</tr>
<tr class="odd">
<td>169</td>
<td>ornl.gov</td>
<td>0.16%</td>
<td>19002</td>
</tr>
<tr class="even">
<td>170</td>
<td>sinica.edu.tw</td>
<td>0.16%</td>
<td>18990</td>
</tr>
<tr class="odd">
<td>171</td>
<td>kth.se</td>
<td>0.16%</td>
<td>18932</td>
</tr>
<tr class="even">
<td>172</td>
<td>duke.edu</td>
<td>0.16%</td>
<td>18826</td>
</tr>
<tr class="odd">
<td>173</td>
<td>upc.es</td>
<td>0.16%</td>
<td>18617</td>
</tr>
<tr class="even">
<td>174</td>
<td>hokudai.ac.jp</td>
<td>0.15%</td>
<td>18393</td>
</tr>
<tr class="odd">
<td>175</td>
<td>ucl.ac.be</td>
<td>0.15%</td>
<td>18369</td>
</tr>
<tr class="even">
<td>176</td>
<td>msu.edu</td>
<td>0.15%</td>
<td>18332</td>
</tr>
<tr class="odd">
<td>177</td>
<td>kyushu-u.ac.jp</td>
<td>0.15%</td>
<td>18208</td>
</tr>
<tr class="even">
<td>178</td>
<td>kfa-juelich.de</td>
<td>0.15%</td>
<td>18164</td>
</tr>
<tr class="odd">
<td>179</td>
<td>uni-bochum.de</td>
<td>0.15%</td>
<td>18045</td>
</tr>
<tr class="even">
<td>180</td>
<td>hawaii.edu</td>
<td>0.15%</td>
<td>18022</td>
</tr>
<tr class="odd">
<td>181</td>
<td>tudelft.nl(*)</td>
<td>0.15%</td>
<td>17885</td>
</tr>
<tr class="even">
<td>182</td>
<td>anl.gov</td>
<td>0.15%</td>
<td>17712</td>
</tr>
<tr class="odd">
<td>183</td>
<td>ntnu.no</td>
<td>0.15%</td>
<td>17590</td>
</tr>
<tr class="even">
<td>184</td>
<td>unicamp.br</td>
<td>0.15%</td>
<td>17582</td>
</tr>
<tr class="odd">
<td>185</td>
<td>iastate.edu</td>
<td>0.15%</td>
<td>17560</td>
</tr>
<tr class="even">
<td>186</td>
<td>fuw.edu.pl</td>
<td>0.15%</td>
<td>17542</td>
</tr>
<tr class="odd">
<td>187</td>
<td>to.infn.it</td>
<td>0.15%</td>
<td>17493</td>
</tr>
<tr class="even">
<td>188</td>
<td>tus.ac.jp</td>
<td>0.15%</td>
<td>17477</td>
</tr>
<tr class="odd">
<td>189</td>
<td>usc.es</td>
<td>0.15%</td>
<td>17464</td>
</tr>
<tr class="even">
<td>190</td>
<td>ifh.de</td>
<td>0.15%</td>
<td>17339</td>
</tr>
<tr class="odd">
<td>191</td>
<td>nthu.edu.tw</td>
<td>0.15%</td>
<td>17257</td>
</tr>
<tr class="even">
<td>192</td>
<td>snu.ac.kr</td>
<td>0.14%</td>
<td>17172</td>
</tr>
<tr class="odd">
<td>193</td>
<td>sns.it</td>
<td>0.14%</td>
<td>17085</td>
</tr>
<tr class="even">
<td>194</td>
<td>ku.dk</td>
<td>0.14%</td>
<td>17061</td>
</tr>
<tr class="odd">
<td>195</td>
<td>tu-muenchen.de</td>
<td>0.14%</td>
<td>17048</td>
</tr>
<tr class="even">
<td>196</td>
<td>ugr.es</td>
<td>0.14%</td>
<td>16989</td>
</tr>
<tr class="odd">
<td>197</td>
<td>bose.res.in</td>
<td>0.14%</td>
<td>16699</td>
</tr>
<tr class="even">
<td>198</td>
<td>msu.ru</td>
<td>0.14%</td>
<td>16614</td>
</tr>
<tr class="odd">
<td>199</td>
<td>tu-berlin.de</td>
<td>0.14%</td>
<td>16604</td>
</tr>
<tr class="even">
<td>200</td>
<td>tsukuba.ac.jp</td>
<td>0.14%</td>
<td>16592</td>
</tr>
</tbody>
</table>

(\*) Some institutions' downloads come from multiple domains which have
been combined to report an aggregate number:

-   cnrs.fr includes downloads from cnrs-orleans.fr.
-   ictp.it includes downloads from trieste.it.
-   inaf.it includes downloads from astro.it.
-   mpg.de includes downloads from aei.mpg.de, age.mpg.de,
    bgc-jena.mpg.de, biochem.mpg.de, biophys.mpg.de, cbs.mpg.de,
    coll.mpg.de, cpfs.mpg.de, demogr.mpg.de, ds.mpg.de, econ.mpg.de,
    enzyme-halle.mpg.de, eva.mpg.de, fkf.mpg.de,
    harnackhaus-berlin.mpg.de, hll.mpg.de, ice.mpg.de, immunbio.mpg.de,
    ip.mpg.de, ipp-hgw.mpg.de, ipp.mpg.de, iuscrim.mpg.de, mis.mpg.de,
    mmg.mpg.de, molgen.mpg.de, mpa-garching.mpg.de, mpch-mainz.mpg.de,
    mpdl.mpg.de, mpe-garching.mpg.de, mpe.mpg.de, mpi-dortmund.mpg.de,
    mpi-fg-koeln.mpg.de, mpi-halle.mpg.de, mpi-hd.mpg.de,
    mpi-inf.mpg.de, mpi-magdeburg.mpg.de, mpi-muelheim.mpg.de,
    mpi-sb.mpg.de, mpi-stuttgart.mpg.de, mpi-sws.mpg.de, mpia-hd.mpg.de,
    mpib-berlin.mpg.de, mpibp-frankfurt.mpg.de, mpibpc.mpg.de,
    mpie-duesseldorf.mpg.de, mpifr-bonn.mpg.de, mpih-frankfurt.mpg.de,
    mpiib-berlin.mpg.de, mpikg.mpg.de, mpim-bonn.mpg.de,
    mpimf-heidelberg.mpg.de, mpimp-golm.mpg.de, mpip-mainz.mpg.de,
    mpipks-dresden.mpg.de, mpipsykl.mpg.de, mpipz.mpg.de, mpisoc.mpg.de,
    mpiwg-berlin.mpg.de, mpiz-koeln.mpg.de, mpl.mpg.de, mppmu.mpg.de,
    mpq.mpg.de, mps.mpg.de, neuro.mpg.de, orn.mpg.de, rz-berlin.mpg.de,
    rzg.mpg.de, tuebingen.mpg.de, vw-extern.mpg.de, vw.mpg.de.
-   riken.jp includes downloads from riken.go.jp.
-   stonybrook.edu includes downloads from sunysb.edu.
-   tkk.fi includes downloads from hut.fi.
-   tudelft.nl includes downloads from tudelft.net.
-   uni-muenchen.de includes downloads from lmu.de.

Update history:  
2011-03-11 - Revised to remove erroneously included robot downloads from
[INSPIRE](http://inspirebeta.net/) partner in cern.ch total, additional
institutional domains identified.  
2011-01-28 - Usage data for 2010 first posted.
