2018 Institutional arXiv Usage Data
===================================

The following table is a compilation of arXiv downloads for calendar
year 2018 for the 250 heaviest user institutions. See also [arXiv
Support](../support).

**Caveats:** While we have taken considerable effort to extract reliable
download data representing unique full-text downloads by real users,
there are many factors which affect accuracy. These factors include: 1)
the data is from the main arXiv site and the arXiv mirrors, though some
mirror data is incomplete; 2) we have counted downloads according to the
COUNTER algorithm which excludes rapid repeat downloads; 3) we have
attempted to identify and remove robot or automated downloads from the
count (false positives lead to undercounting, failing to identify robots
leads to overcounting); and 4) we include here only downloads that
appear to be from an institution based on the DNS name of the client for
patterns that we recognize (A large fraction of downloads come from
commercial ISPs which are not included. Clients with host names that
don't resolve or off-campus accesses will lead to undercounting, failure
to recognize institutional domain names will exclude those institutions
and undercount the total institutional downloads.) We have identified
27 million downloads from institutional domain names out of a total of
over 228 million downloads in 2018

|	Rank	|	Institutional Domain	|	Percentage of Total	|	Number of Article Downloads	|
|	:----:	|	--------------	|	----:	|	----:	|
|	1	|	cam.ac.uk	|	1.70%	|	464575	|
|	2	|	mit.edu	|	1.68%	|	459752	|
|	3	|	berkeley.edu	|	1.66%	|	454036	|
|	4	|	(\*)mpg.de	|	1.57%	|	428290	|
|	5	|	stanford.edu	|	1.41%	|	386310	|
|	6	|	ethz.ch	|	1.30%	|	354636	|
|	7	|	ox.ac.uk	|	1.20%	|	328173	|
|	8	|	in2p3.fr	|	1.19%	|	325756	|
|	(9)	|	cern.ch	|	na	|	315032	|
|	10	|	princeton.edu	|	1.12%	|	305632	|
|	11	|	ic.ac.uk	|	1.03%	|	282060	|
|	12	|	columbia.edu	|	1.01%	|	276197	|
|	13	|	(\*)illinois.edu	|	0.95%	|	260051	|
|	(14)	|	jhu.edu	|	na	|	250224	|
|	15	|	kyoto-u.ac.jp	|	0.90%	|	245725	|
|	16	|	epfl.ch	|	0.84%	|	229977	|
|	17	|	u-tokyo.ac.jp	|	0.84%	|	229004	|
|	18	|	cornell.edu	|	0.82%	|	223908	|
|	19	|	caltech.edu	|	0.81%	|	222356	|
|	20	|	umd.edu	|	0.78%	|	213664	|
|	21	|	ucl.ac.uk	|	0.78%	|	213641	|
|	22	|	hku.hk	|	0.77%	|	211541	|
|	23	|	gatech.edu	|	0.76%	|	208509	|
|	(24)	|	uchicago.edu	|	na	|	207211	|
|	25	|	nyu.edu	|	0.75%	|	205567	|
|	26	|	utexas.edu	|	0.71%	|	193789	|
|	27	|	ed.ac.uk	|	0.70%	|	192425	|
|	28	|	cuhk.edu.hk	|	0.70%	|	190498	|
|	29	|	uva.nl	|	0.70%	|	190424	|
|	30	|	uwaterloo.ca	|	0.70%	|	190366	|
|	31	|	ucsb.edu	|	0.68%	|	186441	|
|	32	|	utoronto.ca	|	0.66%	|	181534	|
|	(33)	|	washington.edu	|	na	|	176737	|
|	34	|	umn.edu	|	0.64%	|	174422	|
|	35	|	ucla.edu	|	0.63%	|	173072	|
|	36	|	upenn.edu	|	0.61%	|	167661	|
|	37	|	harvard.edu	|	0.61%	|	165866	|
|	38	|	ust.hk	|	0.60%	|	164279	|
|	39	|	(\*)desy.de	|	0.55%	|	151599	|
|	40	|	(\*)stonybrook.edu	|	0.55%	|	151512	|
|	41	|	uni-heidelberg.de	|	0.54%	|	148463	|
|	42	|	cmu.edu	|	0.54%	|	147836	|
|	43	|	(\*)uni-karlsruhe.de	|	0.52%	|	142841	|
|	44	|	rutgers.edu	|	0.52%	|	141123	|
|	45	|	yale.edu	|	0.51%	|	138451	|
|	46	|	ntu.edu.tw	|	0.50%	|	137695	|
|	47	|	wisc.edu	|	0.50%	|	137221	|
|	48	|	uni-bonn.de	|	0.50%	|	136752	|
|	49	|	purdue.edu	|	0.50%	|	136477	|
|	50	|	ubc.ca	|	0.48%	|	130127	|
|	51	|	(\*)tudelft.nl	|	0.47%	|	127375	|
|	52	|	(\*)sydney.edu.au	|	0.42%	|	114884	|
|	53	|	colorado.edu	|	0.42%	|	114226	|
|	54	|	(\*)tum.de	|	0.41%	|	111392	|
|	55	|	nthu.edu.tw	|	0.41%	|	111375	|
|	56	|	rwth-aachen.de	|	0.41%	|	110973	|
|	57	|	tohoku.ac.jp	|	0.40%	|	109852	|
|	58	|	usc.edu	|	0.40%	|	109375	|
|	59	|	uci.edu	|	0.39%	|	107288	|
|	60	|	dur.ac.uk	|	0.39%	|	105246	|
|	61	|	northwestern.edu	|	0.38%	|	104900	|
|	62	|	uni-freiburg.de	|	0.38%	|	104487	|
|	63	|	bu.edu	|	0.37%	|	101267	|
|	64	|	(\*)ucsd.edu	|	0.36%	|	98226	|
|	65	|	uni-mainz.de	|	0.35%	|	96034	|
|	66	|	univie.ac.at	|	0.34%	|	94249	|
|	67	|	ufl.edu	|	0.34%	|	93197	|
|	68	|	ias.edu	|	0.34%	|	92567	|
|	69	|	nctu.edu.tw	|	0.33%	|	90517	|
|	70	|	osaka-u.ac.jp	|	0.32%	|	88728	|
|	71	|	bris.ac.uk	|	0.32%	|	88170	|
|	72	|	umass.edu	|	0.32%	|	87377	|
|	73	|	tu-dresden.de	|	0.32%	|	86346	|
|	74	|	sissa.it	|	0.31%	|	86017	|
|	75	|	nagoya-u.ac.jp	|	0.31%	|	85888	|
|	76	|	uzh.ch	|	0.31%	|	84925	|
|	77	|	tu-darmstadt.de	|	0.31%	|	84858	|
|	78	|	(\*)riken.jp	|	0.31%	|	84857	|
|	79	|	vt.edu	|	0.30%	|	82587	|
|	80	|	tu-berlin.de	|	0.30%	|	81911	|
|	81	|	warwick.ac.uk	|	0.30%	|	81838	|
|	82	|	monash.edu.au	|	0.29%	|	80261	|
|	83	|	cea.fr	|	0.29%	|	80211	|
|	84	|	ucdavis.edu	|	0.29%	|	79782	|
|	85	|	kuleuven.be	|	0.29%	|	79767	|
|	86	|	kth.se	|	0.28%	|	77514	|
|	87	|	ictp.it	|	0.28%	|	77170	|
|	88	|	indiana.edu	|	0.27%	|	75152	|
|	89	|	usp.br	|	0.27%	|	75151	|
|	90	|	umich.edu	|	0.27%	|	74693	|
|	91	|	ualberta.ca	|	0.27%	|	73428	|
|	92	|	uni-hamburg.de	|	0.27%	|	73311	|
|	93	|	chalmers.se	|	0.27%	|	72764	|
|	94	|	umontreal.ca	|	0.27%	|	72653	|
|	95	|	postech.ac.kr	|	0.25%	|	69347	|
|	96	|	su.se	|	0.25%	|	68828	|
|	97	|	(\*)manchester.ac.uk	|	0.25%	|	68419	|
|	98	|	uu.se	|	0.25%	|	68391	|
|	99	|	rug.nl	|	0.25%	|	67064	|
|	100	|	uni-hannover.de	|	0.24%	|	66702	|
|	101	|	unimelb.edu.au	|	0.24%	|	66328	|
|	102	|	fraunhofer.de	|	0.24%	|	65569	|
|	103	|	tamu.edu	|	0.24%	|	65313	|
|	104	|	(\*)inaf.it	|	0.24%	|	65127	|
|	105	|	(\*)upmc.fr	|	0.24%	|	65054	|
|	106	|	qmul.ac.uk	|	0.23%	|	62697	|
|	107	|	helsinki.fi	|	0.23%	|	62361	|
|	108	|	unibe.ch	|	0.23%	|	61846	|
|	109	|	lanl.gov	|	0.22%	|	61426	|
|	110	|	tuwien.ac.at	|	0.22%	|	61083	|
|	111	|	uv.es	|	0.22%	|	60810	|
|	112	|	kek.jp	|	0.22%	|	60341	|
|	113	|	soton.ac.uk	|	0.22%	|	59812	|
|	114	|	sinica.edu.tw	|	0.22%	|	59635	|
|	115	|	huji.ac.il	|	0.22%	|	59345	|
|	116	|	inria.fr	|	0.22%	|	59040	|
|	117	|	uni-stuttgart.de	|	0.21%	|	58243	|
|	118	|	sfu.ca	|	0.21%	|	57680	|
|	119	|	tau.ac.il	|	0.21%	|	57399	|
|	120	|	uni-frankfurt.de	|	0.21%	|	57038	|
|	121	|	nbi.dk	|	0.21%	|	56545	|
|	122	|	u-psud.fr	|	0.21%	|	56507	|
|	123	|	unc.edu	|	0.21%	|	56435	|
|	124	|	uni-koeln.de	|	0.21%	|	56355	|
|	125	|	ntnu.no	|	0.21%	|	56296	|
|	126	|	ucsc.edu	|	0.21%	|	56258	|
|	127	|	lu.se	|	0.20%	|	56000	|
|	128	|	buffalo.edu	|	0.20%	|	55940	|
|	129	|	ens.fr	|	0.20%	|	55237	|
|	130	|	prl.res.in	|	0.20%	|	54016	|
|	131	|	unsw.edu.au	|	0.20%	|	53852	|
|	132	|	iastate.edu	|	0.20%	|	53419	|
|	133	|	uni-erlangen.de	|	0.19%	|	53301	|
|	134	|	ru.nl	|	0.19%	|	52768	|
|	135	|	uibk.ac.at	|	0.19%	|	52067	|
|	136	|	shef.ac.uk	|	0.19%	|	51790	|
|	137	|	uni-kl.de	|	0.19%	|	51720	|
|	138	|	uni-regensburg.de	|	0.19%	|	51309	|
|	139	|	unibas.ch	|	0.19%	|	51143	|
|	140	|	fu-berlin.de	|	0.19%	|	51097	|
|	141	|	csic.es	|	0.19%	|	51047	|
|	142	|	susx.ac.uk	|	0.18%	|	50532	|
|	143	|	utdallas.edu	|	0.18%	|	50185	|
|	144	|	washington.edu	|	0.18%	|	49998	|
|	145	|	uio.no	|	0.18%	|	49852	|
|	146	|	ugent.be	|	0.18%	|	48581	|
|	147	|	hu-berlin.de	|	0.18%	|	48456	|
|	148	|	titech.ac.jp	|	0.18%	|	48425	|
|	149	|	kcl.ac.uk	|	0.17%	|	47571	|
|	150	|	ulb.ac.be	|	0.17%	|	47488	|
|	151	|	anu.edu.au	|	0.17%	|	47335	|
|	152	|	asu.edu	|	0.17%	|	47302	|
|	153	|	keio.ac.jp	|	0.17%	|	47145	|
|	154	|	jinr.ru	|	0.17%	|	46964	|
|	155	|	jhmi.edu	|	0.17%	|	46462	|
|	156	|	wustl.edu	|	0.17%	|	46135	|
|	157	|	uni-tuebingen.de	|	0.17%	|	45853	|
|	158	|	leeds.ac.uk	|	0.17%	|	45827	|
|	159	|	dtu.dk	|	0.17%	|	45807	|
|	160	|	leidenuniv.nl	|	0.17%	|	45645	|
|	161	|	(*)uni-saarland.de	|	0.17%	|	45560	|
|	162	|	cuni.cz	|	0.17%	|	45130	|
|	163	|	uni-wuerzburg.de	|	0.16%	|	45083	|
|	164	|	uni-ulm.de	|	0.16%	|	44514	|
|	165	|	slac.stanford.edu	|	0.16%	|	43748	|
|	166	|	rochester.edu	|	0.16%	|	42878	|
|	167	|	(\*)tkk.fi	|	0.16%	|	42494	|
|	168	|	psu.edu	|	0.15%	|	41991	|
|	169	|	anl.gov	|	0.15%	|	41715	|
|	170	|	lancs.ac.uk	|	0.15%	|	41635	|
|	171	|	tue.nl	|	0.15%	|	41303	|
|	172	|	uni-muenster.de	|	0.15%	|	41183	|
|	173	|	uni-bielefeld.de	|	0.15%	|	40816	|
|	174	|	adelaide.edu.au	|	0.15%	|	40234	|
|	175	|	unicamp.br	|	0.15%	|	40205	|
|	176	|	ens-lyon.fr	|	0.15%	|	40003	|
|	177	|	ucm.es	|	0.15%	|	39764	|
|	178	|	uni-bochum.de	|	0.14%	|	39556	|
|	179	|	navy.mil	|	0.14%	|	39367	|
|	180	|	uic.edu	|	0.14%	|	39298	|
|	181	|	bnl.gov	|	0.14%	|	39053	|
|	182	|	(*)tu-graz.ac.at	|	0.14%	|	38953	|
|	183	|	uni-jena.de	|	0.14%	|	37682	|
|	184	|	pd.infn.it	|	0.14%	|	37552	|
|	185	|	cf.ac.uk	|	0.14%	|	37504	|
|	186	|	gla.ac.uk	|	0.14%	|	37451	|
|	(187)	|	uq.edu.au	|	na	|	37368	|
|	188	|	(\*)snl.gov	|	0.14%	|	37014	|
|	189	|	nao.ac.jp	|	0.14%	|	36978	|
|	190	|	fsu.edu	|	0.13%	|	36667	|
|	191	|	mcgill.ca	|	0.13%	|	36417	|
|	192	|	toronto.edu	|	0.13%	|	36368	|
|	193	|	u-strasbg.fr	|	0.13%	|	36056	|
|	194	|	kyushu-u.ac.jp	|	0.13%	|	36031	|
|	195	|	kfa-juelich.de	|	0.13%	|	35867	|
|	196	|	cvut.cz	|	0.13%	|	35753	|
|	197	|	tus.ac.jp	|	0.13%	|	35225	|
|	198	|	waseda.ac.jp	|	0.13%	|	34640	|
|	199	|	hawaii.edu	|	0.13%	|	34540	|
|	200	|	hokudai.ac.jp	|	0.13%	|	34477	|
|	201	|	ub.es	|	0.13%	|	34466	|
|	202	|	bath.ac.uk	|	0.13%	|	34443	|
|	203	|	ucf.edu	|	0.12%	|	33838	|
|	204	|	metu.edu.tr	|	0.12%	|	33791	|
|	205	|	utah.edu	|	0.12%	|	33538	|
|	206	|	bham.ac.uk	|	0.12%	|	33482	|
|	207	|	utl.pt	|	0.12%	|	33286	|
|	208	|	jyu.fi	|	0.12%	|	33271	|
|	209	|	univ-lyon1.fr	|	0.12%	|	33117	|
|	210	|	uam.es	|	0.12%	|	32936	|
|	211	|	hiroshima-u.ac.jp	|	0.12%	|	32887	|
|	212	|	llnl.gov	|	0.12%	|	32297	|
|	213	|	tsukuba.ac.jp	|	0.12%	|	32226	|
|	214	|	unitn.it	|	0.12%	|	32131	|
|	215	|	york.ac.uk	|	0.12%	|	32020	|
|	216	|	oregonstate.edu	|	0.12%	|	31900	|
|	217	|	cwru.edu	|	0.12%	|	31714	|
|	218	|	utwente.nl	|	0.12%	|	31548	|
|	219	|	unifi.it	|	0.12%	|	31516	|
|	220	|	(\*)ku.dk	|	0.12%	|	31484	|
|	221	|	roma1.infn.it	|	0.11%	|	31250	|
|	222	|	(\*)cnrs.fr	|	0.11%	|	31166	|
|	223	|	obspm.fr	|	0.11%	|	30542	|
|	224	|	qut.edu.au	|	0.11%	|	30326	|
|	225	|	tcd.ie	|	0.11%	|	30133	|
|	226	|	iap.fr	|	0.11%	|	29658	|
|	227	|	uchicago.edu	|	0.11%	|	29160	|
|	228	|	pitt.edu	|	0.11%	|	29025	|
|	229	|	mcmaster.ca	|	0.11%	|	28829	|
|	230	|	unam.mx	|	0.11%	|	28775	|
|	231	|	(\*)tu-dortmund.de	|	0.11%	|	28763	|
|	232	|	ehu.es	|	0.10%	|	28627	|
|	233	|	to.infn.it	|	0.10%	|	28392	|
|	234	|	polytechnique.fr	|	0.10%	|	28358	|
|	235	|	nikhef.nl	|	0.10%	|	28103	|
|	236	|	unipd.it	|	0.10%	|	28040	|
|	237	|	rpi.edu	|	0.10%	|	28029	|
|	238	|	tifr.res.in	|	0.10%	|	27549	|
|	239	|	yorku.ca	|	0.10%	|	26916	|
|	240	|	ucl.ac.be	|	0.10%	|	26888	|
|	241	|	st-andrews.ac.uk	|	0.10%	|	26629	|
|	242	|	kobe-u.ac.jp	|	0.10%	|	26592	|
|	243	|	duke.edu	|	0.10%	|	26390	|
|	244	|	bose.res.in	|	0.10%	|	26302	|
|	245	|	dlr.de	|	0.10%	|	26213	|
|	246	|	uoregon.edu	|	0.10%	|	26173	|
|	247	|	msu.edu	|	0.10%	|	26158	|
|	248	|	univ-paris-diderot.fr	|	0.10%	|	26052	|
|	249	|	upc.es	|	0.09%	|	25961	|
|	250	|	au.dk	|	0.09%	|	25957	|


(\*) Some institutions' downloads come from multiple domains which have been combined to report an aggregate number:

- desy.de includes downloads from ifh.de.
- illinois.edu includes downloads from uiuc.edu.
- inaf.it includes downloads from astro.it.
- manchester.ac.uk includes downloads from man.ac.uk.
- mpg.de includes downloads from aei.mpg.de, age.mpg.de, bgc-jena.mpg.de, biochem.mpg.de, biophys.mpg.de, brain.mpg.de, cbs.mpg.de, cec.mpg.de, coll.mpg.de, cpfs.mpg.de, demogr.mpg.de, ds.mpg.de, em.mpg.de, enzyme-halle.mpg.de, eva.mpg.de, fhi-berlin.mpg.de, fkf.mpg.de, gwdg.de, hll.mpg.de, ice.mpg.de, ie-freiburg.mpg.de, ip.mpg.de, ipp.mpg.de, is.mpg.de, mis.mpg.de, mmg.mpg.de, molgen.mpg.de, mpa-garching.mpg.de, mpcdf.mpg.de, mpdl.mpg.de, mpe-garching.mpg.de, mpe.mpg.de, mpi-dortmund.mpg.de, mpi-fg-koeln.mpg.de, mpi-halle.mpg.de, mpi-hd.mpg.de, mpi-inf.mpg.de, mpi-klsb.mpg.de, mpi-magdeburg.mpg.de, mpi-muelheim.mpg.de, mpi-sb.mpg.de, mpi-stuttgart.mpg.de, mpia-hd.mpg.de, mpib-berlin.mpg.de, mpibpc.mpg.de, mpie-duesseldorf.mpg.de, mpifr-bonn.mpg.de, mpih-frankfurt.mpg.de, mpiib-berlin.mpg.de, mpikg.mpg.de, mpim-bonn.mpg.de, mpimet.mpg.de, mpimp-golm.mpg.de, mpip-mainz.mpg.de, mpipks-dresden.mpg.de, mpipriv-hh.mpg.de, mpipz.mpg.de, mpiwg-berlin.mpg.de, mppmu.mpg.de, mpq.mpg.de, mps.mpg.de, neuro.mpg.de, nf.mpg.de, orn.mpg.de, psych.mpg.de, rz-berlin.mpg.de, rzg.mpg.de, sf.mpg.de, shh.mpg.de, tuebingen.mpg.de, vw.mpg.de.
- riken.jp includes downloads from riken.go.jp.
- stonybrook.edu includes downloads from sunysb.edu.
- sydney.edu.au includes downloads from usyd.edu.au.
- tkk.fi includes downloads from aalto.fi, hut.fi.
- tu-dortmund.de includes downloads from uni-dortmund.de.
- tu-graz.ac.at includes downloads from tugraz.at.
- tudelft.nl includes downloads from tudelft.net.
- tum.de includes downloads from tu-muenchen.de.
- ucsd.edu includes downloads from sdsc.edu.
- uni-karlsruhe.de includes downloads from fzk.de, kit.edu.
- uni-saarland.de includes downloads from uni-sb.de.
- upmc.fr includes downloads from jussieu.fr.

(\**) Some institutions' downloads were created via an alternative method due to anomalies. They have been placed at their approximate rank and are noted by the parentheses around the rank number. Downloads for these institutions have been left out of the calculation for precentage of total.
