# 2020 arXiv Roadmap

The arXiv roadmap is a living document for the arXiv team to communicate our annual priorities and aspirations to the community. Items are listed in approximate priority order, and are subject to change based upon consideration of input from the arXiv advisory boards and other stakeholders, assessment of new opportunities and initiatives as they arise, and progress on next generation arXiv development.

Our overall goal of 2020 is to continue with the [Next Gen arXiv](https://blogs.cornell.edu/arxiv/2019/10/31/arxiv-ng-project-explanation/) (arXiv- NG) development plan to migrate from the existing arXiv system (&quot;Classic Renewal&quot;). We aim to progressively evolve arXiv into a modern and architecturally sound software system while maintaining the level of consistency and availability of the system as a whole.

Related documents: [arXiv software releases](https://confluence.cornell.edu/x/Wzs2FQ)||[arXiv development blog posts](https://blogs.cornell.edu/arxiv/category/arxiv-development/)

## Technical

**NG Submission Interface:** In 2018, we began work on a new user interface and API for submitting e-prints that will improve the user experience and make it easier to provide new features. In 2020, we will begin alpha testing, then moving on to public beta evaluation. Eventually it will replace the classic submission interface.

**New Registration and Account Management Interfaces:** We are rebuilding the user registration and account management interfaces to provide a more user-friendly experience, and to integrate with the NG submission system, API gateway, and other new components.

**Accessibility Improvements:** Reach the halfway point on our roadmap to better support accessibility.

**Service Status Communication:** We will be adopting a service to centralize communication around the status of arXiv services, including planned maintenance and outages.

**Legacy Service Migrations to the Cloud:** In 2019, our local service provider suffered several major outages that directly affected arXiv. We will begin migrating some of the legacy services to the cloud, starting with export.arxiv.org, to mitigate risk and improve service reliability.

**Compilation Service Updates:** arXiv&#39;s TeX compilation service has not received major updates since it was last refreshed with TeX Live 2016. We will plan to include TeX Live 2020 for the next major update and to improve the overall process. We will also repackage the service as a container to remove dependencies on our legacy environment.

**NG Bulk/Programmatic Access:** This includes a refreshed search API, reimplementation of the legacy arXiv API, RSS feed support, and better tools for accessing e-print content (e.g., for text and data mining), via an API gateway.

**Core Announcement Record Modernization:** We have begun to outgrow the way that we store and access the canonical record of e-print submissions. We plan on migrating the canonical record to a system that can scale with arXiv over the next decade, and make it easier to handle higher volumes of traffic.

**Search Improvements:** We will continue to make improvements to our search interfaces throughout the year, strongly informed by user feedback.

**Dark Archive for arXiv:** We will work with service providers to establish a dark archive and ensure perpetual long-term access to content in the event of a sustained outage.

**Maintenance and Operational Support:** A significant amount of developer effort is devoted to a range of activities that ensure that the service continues to run smoothly. Activities include (but are not limited to) to server maintenance and troubleshooting, service monitoring, analytics, internal support requests, bug fixes, and ad hoc meetings and conferences

## Moderation and User Support

**Help and About Page Updates:** The [about](/about/) section of arXiv was started in fall 2019 and those pages will continue to be developed and organized. Technical help and policy pages will be updated on an ongoing basis and as components of arXiv Next Generation are rolled out.

**Planning Improvements for NG:** There is ongoing work for additional updates to submission and moderation systems ahead of future NG software development in those areas. Some topics we are considering: support for various content types (proceedings, etc.), improved support for bulk and proxy submissions, explore alternatives for handling and displaying withdrawn submissions, improved workflows and communication for moderators, and update internal documentation on user account policies and identify ways to automate actions.

**User research process:** Complete our formalized process, begun in 2019, for conducting and storing user research. Remaining work includes broadening our user feedback groups and establishing continuous research patterns.

## Business &amp; Governance

**arXiv Planning:** We will bring onboard a new Executive Director. This will initiate an assessment of arXiv goals, needs, mission, vision, and values. Based on this scope, we will start creating a plan to identify priorities, new development areas, and set strategic directions to create a framework for our fundraising, collaboration, and communication processes.

  > In progress. Welcome [Eleonora Presani](https://blogs.cornell.edu/arxiv/2020/03/16/arxiv-announces-its-first-executive-director/) as Executive Director

**Fundraising:** We will strengthen and further diversify our fundraising strategies to support arXiv NG plan, including grants and inviting additional arXiv users (libraries, research organizations, and corporations) to become members and increase individual and corporation giving. We will also be exploring funding opportunities from several different government agencies, and possible grant funding from private foundations.

**Priority Setting &amp; Communication:** We will review our current processes for priority setting, feedback seeking, and communication to improve the transparency of how decisions are made and implemented.

  > In progress.
