arXiv Business Planning Update
------------------------------

July 2011

It has been 19 months since we announced the planning effort for a new
collaborative arXiv business model. The Cornell team has been busy
working on several fronts—here are the highlights (some mentioned in
previous updates):

-   Implement a three-year interim plan (2010-2012) for seeking
    contributions from the top 200 institutions with heavy use:
    -   By the end of 2010, we received support from 123 institutions
        representing 11 countries, totaling $360,000 in contributions.
    -   So far in 2011 we have support from 114 institutions, totaling
        $324,000 in pledges from 12 countries. We anticipate the number
        of contributing institutions to grow.
    -   We gratefully acknowledge the contributions of supporting
        institutions: [arXiv 2010
        Supporters](/help/support/2010_supporters) and [arXiv 2011
        Supporters](/help/support/2011_supporters).
    -   Budget information for arXiv is available here: [CY2010 expenses
        and revenues](https://confluence.cornell.edu/x/BKpRF) and
        [CY2011 budget projection](/help/support/2011_budget).
-   Review and stabilize arXiv staffing and organization by defining
    roles for management, IT development, and user support with clear
    lines of reporting and responsibility.
-   Evaluate arXiv's IT infrastructure and develop and assess a plan for
    migrating the 20-year old search and display architecture to
    [Invenio](http://invenio-software.org/) as the basis of a new
    discovery and access system. Develop an agreement with CERN to
    collaborate on further development and maintenance of
    [Invenio](http://invenio-software.org/) (open sources digital
    library platform).
-   Structure the arXiv budget within CUL accounting as a grant-funded
    account in order to adhere to Cornell's financial policies and to
    provide audit track.
-   Hold discussions with a group of publishers and societies to discuss
    how to include them in the business planning process (interest in
    creating a funding pool in support of arXiv R&D such as data support
    and better linking among versions).
-   Analyze and enhance arXiv usage metrics and statistics. We continue
    to improve our log analysis tools used to associate downloads with
    institutions. We have also conducted an indepth analysis of one
    month of submissions. Although only a sample, it indicates that
    submission and download-based usage data exhibit similar patterns.
-   Explore potential legal status options to establish a
    community-based support and governance structure and appropriate
    procedures for strategic, operational, and fiscal oversight.

During May 2011, we held 3 open informational conference calls and had
an opportunity to talk with 27 colleagues on various issues related to
arXiv. Here are some of the common questions we received during the
calls:

**Will arXiv be expanded to other subjects?**

> We frequently receive requests to extend arXiv to include other
> subject areas. We have adopted a measured approach to expansion, as
> there is significant organizational and administrative effort required
> both to create and to maintain new subject areas. Adding a new subject
> area involves exploring the user-base and use characteristics
> pertaining to the subject area, establishing the necessary advisory
> committees, and recruiting moderators. Also, although arXiv.org is the
> central portal for scientific communication in some disciplines, it is
> neither feasible nor necessarily desirable to play that role in all
> disciplines. While we anticipate that arXiv will become increasingly
> broad in its subject area coverage, we believe this development must
> occur in a planned and strategic manner.

**Do you keep track of the source of funding from the contributing
institutions? Where are the funds coming from (library vs. other
academic departments or administrative units)?**

> We typically work directly with the acquisition units of contributing
> libraries and research centers and are usually unaware of the ultimate
> source of funding. We know of only a few cases in which the library
> acted as the liaison and funding came from an academic department
> within the institution.

**What is the relationship between arXiv and SCOAP3? Wouldn't SCOAP3
potentially cover the expenses associated with running arXiv?**

> arXiv and [SCOAP3 (Sponsoring Consortium for Open Access Publishing in
> Particle Physics)](http://scoap3.org) complement each other. arXiv is
> critical for providing unrestricted and immediate circulation of
> initial research in several fields, not limited to HEP (see [arXiv
> subject
> distribution](https://confluence.cornell.edu/download/attachments/340896308/arXiv%20statistics.pdf)),
> whereas SCOAP3 tackles the issue of sustainable open access to
> peer-reviewed HEP publications by re-directing subscription funds.
> arXiv would potentially be a beneficiary of redirected funding
> administered by the SCOAP3 consortium. The conclusion of the SCOAP3
> Global Partnership Meeting in April 2011 was to move towards an
> operational phase. It is not clear, however, when this initiative will
> be in full operation. It is important to note that the SCOAP3
> initiative is restricted to HEP and particle physics content only,
> which represents between 18% and 40% of submissions to arXiv
> (depending how broadly the subject area is construed). If SCOAP3 is
> successful it could potentially subvent a similar fraction of arXiv's
> operating costs. We will continue to monitor the development of SCOAP3
> and its impact on our long-term plans.

**Will you change the rates next year?**

> We expect to keep the contribution support levels steady for the
> interim business planning period (2010-2012), and thus the rates will
> not change for CY2012. We are in the process of outlining a
> longer-term business model for 2013 and beyond. We anticipate that
> this model will continue to include contributions from institutions,
> and we are examining the feasibility and consequences of different
> support levels.

**What are the goals of the data conservancy pilot?**

> We announced in the [April 2011
> update](/help/support/arxiv_busplan_Apr2011) that in collaboration
> with the [NSF Data Conservancy project](http://dataconservancy.org/),
> we have launched a pilot interface that allows arXiv submitters to
> upload data associated with their articles directly to the Data
> Conservancy repository. Links to the data are added in the arXiv
> record automatically. We currently have 23 such papers (see [an
> example](http://arxiv.org/abs/1106.4185)). This is a research project
> and arXiv and the Data Conservancy make no guarantee about continued
> availability of data sets uploaded via this mechanism past the end of
> 2011. However, it is expected that the current Data Conservancy pilot
> projects will evolve toward much-needed long-term scientific data
> curation infrastructure that works seamlessly with article
> repositories such as arXiv.

**How can we keep up with the developments related to your business
planning initiative?**

> The arXiv sustainability initiative's website is
> [http://arxiv.org/help/support](/help/support), and we will continue
> to post quarterly updates there. You are also welcome to send your
> questions and input to <support@arxiv.org>. We have recently created
> an announcement email list for updates about arXiv support efforts,
> and we have transferred all of our current contacts to that list. If
> you received this update directly, you are already subscribed. Others
> wishing to receive quarterly updates via email are encouraged to join
> the list. Instructions are included below this update. Also, in order
> to respond to your questions and get your input, we will hold three
> open conference calls in August (to accommodate different time zones)
> and invite you to join one:
>
> -   August 15, Monday, noon, EDT
> -   August 16, Tuesday, 6am EDT
> -   August 25, Thursday, 4pm EDT
>
> We are very interested in understanding different perspectives on our
> business model efforts and welcome suggestions, criticisms, and
> encouragement! Please register for these conference calls at:
> <https://cornell.qualtrics.com/SE/?SID=SV_3E2cIaYbB2Mf6YI>.

We thank all our supporters and welcome questions and suggestions.

arXiv Business Planning Team  
Fiona Patrick, Oya Y. Rieger, David Ruddy, Simeon Warner  
Cornell University Library

**arXiv support announcement email list**  
This is an announcement-only list. We anticipate 4-6 posting per year.
To join:

> Send an email message to:
> <arxiv-support-updates-L-request@cornell.edu>  
> Leave the subject line blank. The body of the message should be a
> single word: **join**

To ask questions about arXiv support issues or to send comments, please
address email to <support@arxiv.org>
