# arXiv Scientific Advisory Board Bylaws

_Revisions adopted on 20 August 2019_

## Article 1. Definitions

1.1	The name of the organization is the arXiv Scientific Advisory Board, hereinafter referred to as SAB and the Board. SAB is a consultative body advising Cornell University, hereinafter referred to as CU.

1.2	CU holds overall responsibility for arXiv’s operation and development, with strategic and operational guidance from the SAB and the Member Advisory Board, hereinafter referred to as MAB. The arXiv Operating Principles delineate the respective roles of CU, SAB, and MAB.

1.3	The SAB is composed of scientists and researchers in areas covered by arXiv. Among other duties, the SAB provides advice and guidance pertaining to the intellectual oversight of arXiv, with particular focus on the policies and operation of arXiv’s moderation system. The complete role of the SAB is described in the arXiv Operating Principles.

## Article 2. Scientific Advisory Board Membership

2.1	_Classes of Members_
	The SAB shall have two classes of members: 1) Voting Members, and 2) Non-Voting Members.
	
2.1.1	_Voting Board Members_

a)	_Number._ There shall be between 10 and 14 Voting Board Members on the SAB. The number of SAB Voting Members may be changed by an amendment to these Bylaws, as described in 7.1. No decrease in the number of Voting Members shall have the effect of shortening the term of any incumbent SAB member.

b)	_Qualifications._ At least two-thirds of Voting Board Members shall be drawn from the arXiv membership of Contributing Organizations (“Contributing Organizations”), as defined in the arXiv Operating Principles.

c)	_Ex officio Subject Advisory Committee Chairs._ The Chairs of the Subject Advisory Committees in Physics, Mathematics, Computer Science shall be ex officio members of the Board. In addition, there will be two ex officio members in representation of the other arXiv sections. Chairs of any other Subject Committee which the Board deems appropriate can also be included. Such ex officio members shall have all the rights and duties of other Voting Board Members.

d)	_Reserved Funder Board Seats._ Foundations and other funders identified by CU as contributing 25% or more of arXiv’s annual operating funding shall have the right to a seat on the SAB. These seats must be filled by scientists, and nominees for the seat must be approved by a majority vote of Voting Board Members then in office. Board members holding reserved Board seats shall have all the rights and duties of other Voting Board Members.

e)	_Election._ All Voting SAB Members, except for ex officio Subject Advisory Committee Chairs (c) and any member filling a Reserved Funder Board seat (d), shall be elected at the Scientific Advisory Board’s Annual Meeting by a majority vote of the Voting Board Members then in office excluding any conflicted Members. Members shall be elected from the candidates proposed to the Board by the Nominating Committee or made known to Board members by other means. Any Member whose term is ending shall be considered as conflicted for the discussion and vote unless this Member explicitly declares that he/she is not available for an additional term.

f)	_Term of Office._ All Voting Members of the SAB shall serve staggered, three-year renewable terms.

2.1.2	_Non-Voting Members_

a)	_Reserved CU Seats._ Up to five SAB seats are reserved for CU. These will be filled by the arXiv Scientific Director, arXiv Program Director, and the arXiv IT and User Support managers, or other CU staff as appointed by the University Librarian of CU. The role of these members is to provide information, participate in Board discussions, and document SAB discussions by keeping the minutes of all SAB meetings. 

b)	_Reserved MAB Seats._ Two SAB seats are reserved for members of the Member Advisory Board, who shall be appointed to the SAB as specified by the MAB Bylaws. 

2.2	_Participation._ Only Voting Members of the Board shall participate in decisions of the Board, as described in 4.1.

2.3	_Resignation, Removal, Replacement of a Board Member_

a)	_Resignation._ Any SAB member may resign at any time by giving written notice to the Chair of the Board.

b)	_Removal._  Any Voting SAB Member may be removed from the Board, with or without cause, by a majority vote of the Voting Board Members then in office.

c)	_Vacancies._ A vacancy on the SAB shall be filled by a majority vote of the Voting Board Members then in office. The term of office of a Board member elected to fill a vacancy shall be the remaining term of the member being replaced.

## Article 3. Officers

3.1	_Board Officers_

a)	_Chair._ The presiding officer of the SAB is the Chair. The SAB shall elect the Chair from among the current Voting Board Members.

b)	_Vice Chair._ The SAB may elect one or more Vice Chairs. The SAB Chair may also appoint a Vice Chair for a temporary term not to exceed one month.

c)	_Subject Advisory Committee Chairs._ For all arXiv Subject Advisory Committees, the SAB shall vote upon recommendations for Subject Advisory Committee Chairs made by the Subject Advisory Committees themselves.  In the event that no recommendation is received or that a recommended Subject Advisory Committee Chair is not confirmed by the SAB, the SAB shall select a Subject Advisory Committee Chair from the candidates proposed to the Board by the Nominating Committee or made known to Board members by other means. A Chair whose term is ending shall be considered as conflicted for the discussion and vote unless this Chair explicitly declares that he/she is not available for an additional term.

d)	_Other Officers._ The Board may elect other officers as it deems necessary.

3.2	_Election, Term of Office, Resignation and Removal, Vacancies_

a)	_Election of Officers._ Elected officers of the SAB shall be elected by a majority vote of the Voting Board Members then in office excluding any Members that are conflicted (by being candidates for the vote or otherwise as described in 2.1.1e and 3.1c).

b)	_Term of Office._ Elected officers of the SAB shall serve for a one-year renewable term and, except in the case of resignation or removal, shall hold office until their respective successors have been duly elected. Subject Advisory Committee Chairs shall serve for three-year terms, which may be renewed upon a decision of the Board.

c)	_Resignation._ Any officer may resign at any time by giving notice to the Board.

d)	_Removal._ Any elected officer may be removed, with or without cause, by a majority vote of the Voting Board Members then in office.

e)	_Vacancies._ A vacancy in any elected office shall be filled for the unexpired term by a majority vote of the Voting Board Members then in office.

3.3	_Powers and Duties_

a)	_Chair._ The Chair shall preside at all meetings of the Board and shall exercise general charge and supervision of the affairs of the SAB. The Chair shall see that all notices are duly given in accordance with the provisions of these Bylaws. The Chair shall facilitate open and inclusive discussion and decision-making and shall attempt to state clearly the “sense of the Board” when he or she determines that all Voting Board Members are generally united in their judgment (in mutual concordance). The Chair shall perform such other duties as may be assigned by the Board.

b)	_Vice Chair._ The Vice Chair(s) shall assist the Chair and preside at meetings in the absence of the Chair. The Vice Chair(s) shall perform such other duties as may be assigned by the Board.

c)	_Subject Advisory Committee Chairs._ The Subject Advisory Committee Chairs shall be responsible for overseeing their respective Subject Advisory Committees and reporting on those committees’ activities and recommendations to the Board. 

d)	_Other Officers._ Other officers elected by the Board shall have the authority prescribed to them by the Board.

## Article 4. SAB Operation

4.1	_Decisions of the Board._ All meetings of the SAB shall be conducted in a manner that seeks consensual agreement. When the Board considers any matter that requires a decision, the opinion of any Board member who wishes to express an opinion shall be considered by the Board. When the Chair determines that all Voting Board Members present are generally united in their judgment, he or she shall attempt to state clearly the “sense of the Board.” If all Voting Board Members present give approval to this statement, or if some Voting Board Members present are not in agreement but are willing to stand aside and accept and uphold the judgment of the majority, consensual agreement shall be reached and shall be considered a decision of the Board.

If consensual agreement cannot be reached, a vote shall be taken by the Voting Board Members present. Both majority and minority opinions shall be recorded and made available to CU and the MAB.
	
In the case of the election of Board members, Board Chair, or Board officers, a majority vote of the Voting Board Members then in office, excluding any conflicted Members, shall be considered a decision of the Board.
	
4.2	_Board Policies and Procedures._ The SAB shall have authority to adopt policies and procedures governing SAB activities. The SAB may delegate to committees such powers as it deems fit, as long as those powers do not impinge on the rights reserved to CU.

4.3	_SAB and MAB Communication._ The Board meeting agendas and minutes will be shared with the MAB for their review and comments. The MAB representatives on the SAB will act as liaisons and may seek input from their colleagues as needed prior to or after the Board deliberations.

## Article 5. Meetings

5.1	_Annual Meeting._ The Annual Meeting of the SAB shall be held at a date, time, and place designated by the Board’s Chair. Notice of the date, time, and place of the Annual Meeting shall be given to all Board members in such form as the Board may determine.

5.2	_Regular Meetings._  Regular meetings of the SAB shall be held upon such notice and such date, time, and place as designated by the Board.

5.3	_Special Meetings._ Special meetings of the SAB may be called at any time by the Chair or by a majority of the Voting Board Members then in office. Notice of the date, time, and place of special meetings shall be given to all SAB members in such form as the Board may determine.

5.4	_Participation by Remote Communication._ Any SAB member may participate in a meeting of the Board by means of a conference telephone or similar device which allows all persons participating in the meeting to hear each other. The SAB may also determine that any annual, regular, or special meeting will be held solely by means of remote communication, in which case the meeting notice shall describe the means for such remote communication.

5.5	_Written Consent in Lieu of a Meeting._ The SAB may make a decision of the Board without a meeting if written consent (which may be conveyed electronically) to the decision is given by a majority of the Voting Board Members then in office.

5.6	_Attendance._ A Voting Board Member who fails to attend three consecutive regularly scheduled SAB meetings may be deemed by the consensual agreement of the Board to have resigned, and the Board vacancy created will be filled in accordance with the provisions of 2.3(c).

5.7	_Quorum._ A majority of the Voting Board Members then in office shall constitute a quorum for the transaction of business at any meeting of the Board.

5.8	_Voting._ As described in 4.1, decisions of the Board are determined by Voting Board Members, by means of consensual agreement or vote, at any meeting at which a quorum is present, except as otherwise specified in these Bylaws.

5.9	_Minutes._ CU will be responsible for preparing minutes of each SAB meeting. SAB members will review and approve the minutes. The Board meeting agendas and minutes will be shared with the MAB for their review and comments. A summary of meeting outcomes may be shared with arXiv supporters.

5.10	_Travel Support._ For Board members who need assistance with their travel expenses to attend in-person meetings, CU will reimburse applicable travel expenses up to a cap communicated to Board members prior to every meeting.

## Article 6. Committees

6.1	_Standing Board Committees._ The SAB may, by a resolution adopted by a decision of the Board, designate and appoint one or more committees, each consisting of two or more Board members, which committees shall have and exercise the authority of the Board. However, no committee shall have the authority to amend or repeal these Bylaws, elect or remove any officer or SAB member, or authorize the dissolution of the Board.

6.2	_Nominating Committee._ Each year, the Chair or the Chair’s designee shall submit for the approval of the SAB a list of not less than three nor more than five individuals, comprised of SAB members (who shall constitute a majority of the committee) and representatives from Contributing Organizations that do not currently have a representative serving on the Board, to serve on the Nominating Committee.  The Nominating Committee shall propose a slate of candidates for election to the SAB, or as a Chair of a Subject Advisory Committee, in advance of any Annual Meeting of the SAB that includes Board member election. Nominating Committee members shall serve for one-year terms or until their successors have been appointed.

6.3	_MAB Committee._ Each year, the Chair will appoint two SAB members to serve as the Board’s ex officio representatives on the MAB. MAB Committee members shall serve for one-year terms or until their successors have been appointed.

6.4	_Subject Advisory Committees._ The SAB may appoint members to the Subject Advisory Committees in such manner as the Board deems appropriate. The Subject Advisory Committees shall have the powers and duties designated by the SAB, and shall give advice and make non-binding recommendations to the Board. As described in 3.1(c), the SAB shall elect the Chair of each Subject Advisory Committee.

6.5	_Other Committees and Task Forces._ The SAB may create and appoint members to such other committees and task forces as the Board shall deem appropriate. Such committees and task forces shall have the powers and duties designated by the SAB, and shall give advice and make non-binding recommendations to the Board. Each committee shall consist of at least one Board member and shall operate for the term designated by the Board.

6.6	_Vacancies and Rules._ Vacancies in the membership of committees may be filled by the SAB Chair. Each committee and task force may adopt rules for its meetings not inconsistent with these Bylaws or with any rules adopted by the SAB. Unless otherwise specified herein, all committee members shall serve at the pleasure of the Board.

## Article 7. Amendments

7.1	Within the confinement of arXiv principles, these Bylaws may be amended, or new articles adopted, by the consent of two-thirds of the Voting Members of the Board then in office. Depending on the assessment of the Board Chair, the changes may need to be reviewed by the MAB or Cornell’s General Counsel.



### Document Revision History

2013-09-16	Initial adoption of bylaws.

2014-10-06	Revisions approved and adopted.

2019-08-20	Replaced Cornell University Library (CUL) with Cornell University (CU); revised 2.1.1 c) as approved by SAB.

