---
title: arXiv API Access
---

# arXiv API Access

arXiv offers public API access in order to maximize its openness and interoperability. Many projects utilize this option without becoming official [arXivLabs collaborations](https://labs.arxiv.org). 

**Commercial projects** that utilize arXiv’s [public APIs](basics) or other [bulk data pipelines](../bulk_data) are requested to contact arXiv at [nextgen@arxiv.org](mailto:nextgen@arxiv.org), review [arXiv's brand guidelines](/about/brand), sign a memorandum of understanding, and consider becoming an [arXiv affiliate](/about/funding) before embarking on the project. This includes any project created as a product for sale.


**Independent, noncommercial, and open access projects** that…

1. utilize arXiv’s public APIs 
2. do not require assistance from arXiv, and 
3. do not use the names “arXiv”, “arXiv.org”, “arXiv Labs”, “arXivLabs” or associated logos, web addresses and colors
4. are free, open access, and/or intended for research or educational purposes

...are considered entirely independent from arXiv. However, we do request that you acknowledge arXiv data usage with this statement: “Thank you to arXiv for use of its open access interoperability.”

**For all API users**, 

- Familiarize yourself with arXiv’s [API Terms of Use](tou).
- Review the [API Basics](basics) and the [API User Manual](user-manual). 
- Acknowledge arXiv data usage with this statement on your product: “Thank you to arXiv for use of its open access interoperability.”
- Do not brand your project with arXiv’s names (“arXiv”, “arXiv.org”, “arXiv Labs”, “arXivLabs”) or use associated logos, web addresses, and colors in a manner that implies arXiv’s endorsement of the project.
- Check out the arXiv [API user community](basics#community) to learn, ask questions, and share information about your project. 
- Review these additional resources about arXiv’s interoperability: [arXiv’s identifier scheme](../arxiv_identifier_for_services), [bulk data access information](../bulk_data), and the [Open Archives Initiative](../oa). 

Does your project positively benefit the arXiv community and require significant assistance from arXiv staff? If so, learn more about how to apply to become an [arXivLabs collaborator](https://labs.arxiv.org).
