Data set support in collaboration with the Data Conservancy
===========================================================

From 2010 through 2013-03, arXiv collaborated on a pilot project with
the [Data Conservancy](http://dataconservancy.org/) to support remote
data deposit for arXiv submissions. The Data Conservancy project was
initially funded by the US National Science Foundation
([NSF](http://nsf.gov/)), and aimed to *"research, design, implement,
deploy and sustain data curation infrastructure for cross-disciplinary
discovery with an emphasis on observational data"*.

*2015-03 Data Conservancy pilot repository discontinued, data has been
merged into arXiv.* Although the pilot ended in 2013 and the pilot data
repository was discontinued in 2015, data uploaded to the Data
Conservancy as part of the arXiv submission process remains available as
detailed below.

Datasets associated with the following 634 arXiv article versions were
merged into arXiv as [ancillary files](/help/ancillary_files):

[arXiv:0801.0830v6](/abs/0801.0830v6),
[arXiv:0802.1945v3](/abs/0802.1945v3),
[arXiv:0804.1645v2](/abs/0804.1645v2),
[arXiv:0805.1856v5](/abs/0805.1856v5),
[arXiv:0809.1276v5](/abs/0809.1276v5),
[arXiv:0810.2103v11](/abs/0810.2103v11),
[arXiv:0810.2103v13](/abs/0810.2103v13),
[arXiv:0810.5336v2](/abs/0810.5336v2),
[arXiv:0810.5336v3](/abs/0810.5336v3),
[arXiv:0905.3953v4](/abs/0905.3953v4),
[arXiv:0907.1810v2](/abs/0907.1810v2),
[arXiv:0909.4464v6](/abs/0909.4464v6),
[arXiv:0911.4697v4](/abs/0911.4697v4),
[arXiv:1002.0102v4](/abs/1002.0102v4),
[arXiv:1002.1439v3](/abs/1002.1439v3),
[arXiv:1003.2090v3](/abs/1003.2090v3),
[arXiv:1006.4419v2](/abs/1006.4419v2),
[arXiv:1006.5846v2](/abs/1006.5846v2),
[arXiv:1006.5846v3](/abs/1006.5846v3),
[arXiv:1008.5267v2](/abs/1008.5267v2),
[arXiv:1009.0625v3](/abs/1009.0625v3),
[arXiv:1009.3036v3](/abs/1009.3036v3),
[arXiv:1009.4188v3](/abs/1009.4188v3),
[arXiv:1009.5247v2](/abs/1009.5247v2),
[arXiv:1010.0300v3](/abs/1010.0300v3),
[arXiv:1011.0362v2](/abs/1011.0362v2),
[arXiv:1012.3095v2](/abs/1012.3095v2),
[arXiv:1012.3948v3](/abs/1012.3948v3),
[arXiv:1101.5120v5](/abs/1101.5120v5),
[arXiv:1102.4094v2](/abs/1102.4094v2),
[arXiv:1103.3827v2](/abs/1103.3827v2),
[arXiv:1103.5927v2](/abs/1103.5927v2),
[arXiv:1104.0429v2](/abs/1104.0429v2),
[arXiv:1104.0778v2](/abs/1104.0778v2),
[arXiv:1104.2038v2](/abs/1104.2038v2),
[arXiv:1104.5348v2](/abs/1104.5348v2),
[arXiv:1104.5494v1](/abs/1104.5494v1),
[arXiv:1105.0092v1](/abs/1105.0092v1),
[arXiv:1105.0092v3](/abs/1105.0092v3),
[arXiv:1105.1400v1](/abs/1105.1400v1),
[arXiv:1105.2314v1](/abs/1105.2314v1),
[arXiv:1105.2580v1](/abs/1105.2580v1),
[arXiv:1105.2892v1](/abs/1105.2892v1),
[arXiv:1105.3003v1](/abs/1105.3003v1),
[arXiv:1105.3244v1](/abs/1105.3244v1),
[arXiv:1105.3307v1](/abs/1105.3307v1),
[arXiv:1105.3897v1](/abs/1105.3897v1),
[arXiv:1105.3909v2](/abs/1105.3909v2),
[arXiv:1105.5061v1](/abs/1105.5061v1),
[arXiv:1105.5868v1](/abs/1105.5868v1),
[arXiv:1105.6107v1](/abs/1105.6107v1),
[arXiv:1106.0441v1](/abs/1106.0441v1),
[arXiv:1106.0800v1](/abs/1106.0800v1),
[arXiv:1106.1380v1](/abs/1106.1380v1),
[arXiv:1106.1694v1](/abs/1106.1694v1),
[arXiv:1106.1771v2](/abs/1106.1771v2),
[arXiv:1106.1953v3](/abs/1106.1953v3),
[arXiv:1106.1953v4](/abs/1106.1953v4),
[arXiv:1106.1953v6](/abs/1106.1953v6),
[arXiv:1106.2044v1](/abs/1106.2044v1),
[arXiv:1106.2440v2](/abs/1106.2440v2),
[arXiv:1106.2441v1](/abs/1106.2441v1),
[arXiv:1106.2625v1](/abs/1106.2625v1),
[arXiv:1106.2794v1](/abs/1106.2794v1),
[arXiv:1106.4058v1](/abs/1106.4058v1),
[arXiv:1106.4185v1](/abs/1106.4185v1),
[arXiv:1106.5566v2](/abs/1106.5566v2),
[arXiv:1106.5960v1](/abs/1106.5960v1),
[arXiv:1106.6290v1](/abs/1106.6290v1),
[arXiv:1107.0062v1](/abs/1107.0062v1),
[arXiv:1107.0347v2](/abs/1107.0347v2),
[arXiv:1107.0396v2](/abs/1107.0396v2),
[arXiv:1107.0603v1](/abs/1107.0603v1),
[arXiv:1107.0662v1](/abs/1107.0662v1),
[arXiv:1107.1342v1](/abs/1107.1342v1),
[arXiv:1107.1753v1](/abs/1107.1753v1),
[arXiv:1107.1823v1](/abs/1107.1823v1),
[arXiv:1107.1926v3](/abs/1107.1926v3),
[arXiv:1107.2013v1](/abs/1107.2013v1),
[arXiv:1107.2271v2](/abs/1107.2271v2),
[arXiv:1107.2348v1](/abs/1107.2348v1),
[arXiv:1107.2348v2](/abs/1107.2348v2),
[arXiv:1107.2725v3](/abs/1107.2725v3),
[arXiv:1107.3506v2](/abs/1107.3506v2),
[arXiv:1107.4072v1](/abs/1107.4072v1),
[arXiv:1107.4941v1](/abs/1107.4941v1),
[arXiv:1107.5027v1](/abs/1107.5027v1),
[arXiv:1107.5943v2](/abs/1107.5943v2),
[arXiv:1108.0502v1](/abs/1108.0502v1),
[arXiv:1108.0538v1](/abs/1108.0538v1),
[arXiv:1108.0659v1](/abs/1108.0659v1),
[arXiv:1108.0673v1](/abs/1108.0673v1),
[arXiv:1108.0869v1](/abs/1108.0869v1),
[arXiv:1108.1430v1](/abs/1108.1430v1),
[arXiv:1108.1845v1](/abs/1108.1845v1),
[arXiv:1108.2304v1](/abs/1108.2304v1),
[arXiv:1108.2326v1](/abs/1108.2326v1),
[arXiv:1108.2950v1](/abs/1108.2950v1),
[arXiv:1108.3479v1](/abs/1108.3479v1),
[arXiv:1108.3981v1](/abs/1108.3981v1),
[arXiv:1108.4836v1](/abs/1108.4836v1),
[arXiv:1108.5048v1](/abs/1108.5048v1),
[arXiv:1108.5382v1](/abs/1108.5382v1),
[arXiv:1108.5405v1](/abs/1108.5405v1),
[arXiv:1108.5901v2](/abs/1108.5901v2),
[arXiv:1109.0065v1](/abs/1109.0065v1),
[arXiv:1109.0240v1](/abs/1109.0240v1),
[arXiv:1109.0348v1](/abs/1109.0348v1),
[arXiv:1109.0348v2](/abs/1109.0348v2),
[arXiv:1109.0459v1](/abs/1109.0459v1),
[arXiv:1109.1067v1](/abs/1109.1067v1),
[arXiv:1109.1322v1](/abs/1109.1322v1),
[arXiv:1109.1380v1](/abs/1109.1380v1),
[arXiv:1109.1632v1](/abs/1109.1632v1),
[arXiv:1109.1632v3](/abs/1109.1632v3),
[arXiv:1109.2650v1](/abs/1109.2650v1),
[arXiv:1109.2650v2](/abs/1109.2650v2),
[arXiv:1109.2925v1](/abs/1109.2925v1),
[arXiv:1109.3119v1](/abs/1109.3119v1),
[arXiv:1109.3182v1](/abs/1109.3182v1),
[arXiv:1109.3491v1](/abs/1109.3491v1),
[arXiv:1109.4018v1](/abs/1109.4018v1),
[arXiv:1109.5621v1](/abs/1109.5621v1),
[arXiv:1109.5678v1](/abs/1109.5678v1),
[arXiv:1109.5724v2](/abs/1109.5724v2),
[arXiv:1109.5823v1](/abs/1109.5823v1),
[arXiv:1109.5977v1](/abs/1109.5977v1),
[arXiv:1109.6065v1](/abs/1109.6065v1),
[arXiv:1109.6120v1](/abs/1109.6120v1),
[arXiv:1109.6353v1](/abs/1109.6353v1),
[arXiv:1109.6358v1](/abs/1109.6358v1),
[arXiv:1109.6529v1](/abs/1109.6529v1),
[arXiv:1109.6573v1](/abs/1109.6573v1),
[arXiv:1109.6573v2](/abs/1109.6573v2),
[arXiv:1109.6591v1](/abs/1109.6591v1),
[arXiv:1109.6595v2](/abs/1109.6595v2),
[arXiv:1109.6595v3](/abs/1109.6595v3),
[arXiv:1109.6932v1](/abs/1109.6932v1),
[arXiv:1110.0079v1](/abs/1110.0079v1),
[arXiv:1110.0243v3](/abs/1110.0243v3),
[arXiv:1110.0644v3](/abs/1110.0644v3),
[arXiv:1110.0785v3](/abs/1110.0785v3),
[arXiv:1110.1018v1](/abs/1110.1018v1),
[arXiv:1110.1119v1](/abs/1110.1119v1),
[arXiv:1110.1515v1](/abs/1110.1515v1),
[arXiv:1110.1623v1](/abs/1110.1623v1),
[arXiv:1110.1804v1](/abs/1110.1804v1),
[arXiv:1110.1963v5](/abs/1110.1963v5),
[arXiv:1110.1987v1](/abs/1110.1987v1),
[arXiv:1110.2366v1](/abs/1110.2366v1),
[arXiv:1110.2380v1](/abs/1110.2380v1),
[arXiv:1110.2479v1](/abs/1110.2479v1),
[arXiv:1110.2479v2](/abs/1110.2479v2),
[arXiv:1110.2756v1](/abs/1110.2756v1),
[arXiv:1110.3262v1](/abs/1110.3262v1),
[arXiv:1110.3281v3](/abs/1110.3281v3),
[arXiv:1110.3574v1](/abs/1110.3574v1),
[arXiv:1110.3649v1](/abs/1110.3649v1),
[arXiv:1110.3649v2](/abs/1110.3649v2),
[arXiv:1110.3655v1](/abs/1110.3655v1),
[arXiv:1110.3877v1](/abs/1110.3877v1),
[arXiv:1110.4328v1](/abs/1110.4328v1),
[arXiv:1110.4551v1](/abs/1110.4551v1),
[arXiv:1110.4866v1](/abs/1110.4866v1),
[arXiv:1110.4921v1](/abs/1110.4921v1),
[arXiv:1110.5091v1](/abs/1110.5091v1),
[arXiv:1110.5091v2](/abs/1110.5091v2),
[arXiv:1110.5243v1](/abs/1110.5243v1),
[arXiv:1110.5436v1](/abs/1110.5436v1),
[arXiv:1110.6253v1](/abs/1110.6253v1),
[arXiv:1110.6304v1](/abs/1110.6304v1),
[arXiv:1110.6579v1](/abs/1110.6579v1),
[arXiv:1110.6722v1](/abs/1110.6722v1),
[arXiv:1111.0111v1](/abs/1111.0111v1),
[arXiv:1111.0129v1](/abs/1111.0129v1),
[arXiv:1111.0394v1](/abs/1111.0394v1),
[arXiv:1111.0397v1](/abs/1111.0397v1),
[arXiv:1111.0397v2](/abs/1111.0397v2),
[arXiv:1111.0401v1](/abs/1111.0401v1),
[arXiv:1111.0736v1](/abs/1111.0736v1),
[arXiv:1111.1266v1](/abs/1111.1266v1),
[arXiv:1111.1586v1](/abs/1111.1586v1),
[arXiv:1111.1679v1](/abs/1111.1679v1),
[arXiv:1111.1868v1](/abs/1111.1868v1),
[arXiv:1111.2138v1](/abs/1111.2138v1),
[arXiv:1111.3466v1](/abs/1111.3466v1),
[arXiv:1111.3762v1](/abs/1111.3762v1),
[arXiv:1111.3931v1](/abs/1111.3931v1),
[arXiv:1111.4538v1](/abs/1111.4538v1),
[arXiv:1111.4599v3](/abs/1111.4599v3),
[arXiv:1111.4930v2](/abs/1111.4930v2),
[arXiv:1111.5289v1](/abs/1111.5289v1),
[arXiv:1111.6208v1](/abs/1111.6208v1),
[arXiv:1111.6226v2](/abs/1111.6226v2),
[arXiv:1111.6378v1](/abs/1111.6378v1),
[arXiv:1111.6697v1](/abs/1111.6697v1),
[arXiv:1111.6733v1](/abs/1111.6733v1),
[arXiv:1111.6733v2](/abs/1111.6733v2),
[arXiv:1111.6781v1](/abs/1111.6781v1),
[arXiv:1111.6781v2](/abs/1111.6781v2),
[arXiv:1111.6824v1](/abs/1111.6824v1),
[arXiv:1112.0236v1](/abs/1112.0236v1),
[arXiv:1112.0780v1](/abs/1112.0780v1),
[arXiv:1112.1209v1](/abs/1112.1209v1),
[arXiv:1112.1790v3](/abs/1112.1790v3),
[arXiv:1112.1903v1](/abs/1112.1903v1),
[arXiv:1112.2070v1](/abs/1112.2070v1),
[arXiv:1112.2070v2](/abs/1112.2070v2),
[arXiv:1112.2287v1](/abs/1112.2287v1),
[arXiv:1112.2994v1](/abs/1112.2994v1),
[arXiv:1112.3082v1](/abs/1112.3082v1),
[arXiv:1112.3174v1](/abs/1112.3174v1),
[arXiv:1112.3306v2](/abs/1112.3306v2),
[arXiv:1112.3361v1](/abs/1112.3361v1),
[arXiv:1112.3457v2](/abs/1112.3457v2),
[arXiv:1112.3576v1](/abs/1112.3576v1),
[arXiv:1112.3635v1](/abs/1112.3635v1),
[arXiv:1112.4160v1](/abs/1112.4160v1),
[arXiv:1112.4285v2](/abs/1112.4285v2),
[arXiv:1112.4475v1](/abs/1112.4475v1),
[arXiv:1112.5693v2](/abs/1112.5693v2),
[arXiv:1112.6016v1](/abs/1112.6016v1),
[arXiv:1201.0096v3](/abs/1201.0096v3),
[arXiv:1201.0099v2](/abs/1201.0099v2),
[arXiv:1201.0551v1](/abs/1201.0551v1),
[arXiv:1201.0811v1](/abs/1201.0811v1),
[arXiv:1201.0923v1](/abs/1201.0923v1),
[arXiv:1201.1015v1](/abs/1201.1015v1),
[arXiv:1201.1740v1](/abs/1201.1740v1),
[arXiv:1201.1885v2](/abs/1201.1885v2),
[arXiv:1201.1896v1](/abs/1201.1896v1),
[arXiv:1201.1896v2](/abs/1201.1896v2),
[arXiv:1201.2090v1](/abs/1201.2090v1),
[arXiv:1201.2297v2](/abs/1201.2297v2),
[arXiv:1201.2722v1](/abs/1201.2722v1),
[arXiv:1201.3584v1](/abs/1201.3584v1),
[arXiv:1201.3622v1](/abs/1201.3622v1),
[arXiv:1201.4163v2](/abs/1201.4163v2),
[arXiv:1201.4314v1](/abs/1201.4314v1),
[arXiv:1201.4526v2](/abs/1201.4526v2),
[arXiv:1201.4624v1](/abs/1201.4624v1),
[arXiv:1201.5762v1](/abs/1201.5762v1),
[arXiv:1201.5949v1](/abs/1201.5949v1),
[arXiv:1201.5960v1](/abs/1201.5960v1),
[arXiv:1201.6021v1](/abs/1201.6021v1),
[arXiv:1201.6155v1](/abs/1201.6155v1),
[arXiv:1201.6305v1](/abs/1201.6305v1),
[arXiv:1201.6632v2](/abs/1201.6632v2),
[arXiv:1202.1307v1](/abs/1202.1307v1),
[arXiv:1202.1307v2](/abs/1202.1307v2),
[arXiv:1202.1538v1](/abs/1202.1538v1),
[arXiv:1202.1613v1](/abs/1202.1613v1),
[arXiv:1202.1991v1](/abs/1202.1991v1),
[arXiv:1202.2093v1](/abs/1202.2093v1),
[arXiv:1202.2272v1](/abs/1202.2272v1),
[arXiv:1202.2518v1](/abs/1202.2518v1),
[arXiv:1202.2541v1](/abs/1202.2541v1),
[arXiv:1202.3824v1](/abs/1202.3824v1),
[arXiv:1202.3884v1](/abs/1202.3884v1),
[arXiv:1202.4192v1](/abs/1202.4192v1),
[arXiv:1202.4321v1](/abs/1202.4321v1),
[arXiv:1202.4980v1](/abs/1202.4980v1),
[arXiv:1202.4987v1](/abs/1202.4987v1),
[arXiv:1202.5152v1](/abs/1202.5152v1),
[arXiv:1202.5609v1](/abs/1202.5609v1),
[arXiv:1202.6129v1](/abs/1202.6129v1),
[arXiv:1202.6447v2](/abs/1202.6447v2),
[arXiv:1202.6447v3](/abs/1202.6447v3),
[arXiv:1202.6582v1](/abs/1202.6582v1),
[arXiv:1203.0534v1](/abs/1203.0534v1),
[arXiv:1203.0650v2](/abs/1203.0650v2),
[arXiv:1203.0680v1](/abs/1203.0680v1),
[arXiv:1203.0813v1](/abs/1203.0813v1),
[arXiv:1203.0837v1](/abs/1203.0837v1),
[arXiv:1203.0955v1](/abs/1203.0955v1),
[arXiv:1203.1314v1](/abs/1203.1314v1),
[arXiv:1203.1328v1](/abs/1203.1328v1),
[arXiv:1203.1532v1](/abs/1203.1532v1),
[arXiv:1203.1654v3](/abs/1203.1654v3),
[arXiv:1203.2083v1](/abs/1203.2083v1),
[arXiv:1203.2248v1](/abs/1203.2248v1),
[arXiv:1203.2372v1](/abs/1203.2372v1),
[arXiv:1203.2409v1](/abs/1203.2409v1),
[arXiv:1203.2439v1](/abs/1203.2439v1),
[arXiv:1203.2620v1](/abs/1203.2620v1),
[arXiv:1203.2629v2](/abs/1203.2629v2),
[arXiv:1203.2965v1](/abs/1203.2965v1),
[arXiv:1203.3071v1](/abs/1203.3071v1),
[arXiv:1203.3675v1](/abs/1203.3675v1),
[arXiv:1203.3675v4](/abs/1203.3675v4),
[arXiv:1203.3690v1](/abs/1203.3690v1),
[arXiv:1203.4334v1](/abs/1203.4334v1),
[arXiv:1203.4393v1](/abs/1203.4393v1),
[arXiv:1203.5011v1](/abs/1203.5011v1),
[arXiv:1203.5216v1](/abs/1203.5216v1),
[arXiv:1203.6061v3](/abs/1203.6061v3),
[arXiv:1203.6061v4](/abs/1203.6061v4),
[arXiv:1203.6428v1](/abs/1203.6428v1),
[arXiv:1204.0546v1](/abs/1204.0546v1),
[arXiv:1204.0856v2](/abs/1204.0856v2),
[arXiv:1204.0916v1](/abs/1204.0916v1),
[arXiv:1204.1378v1](/abs/1204.1378v1),
[arXiv:1204.1416v1](/abs/1204.1416v1),
[arXiv:1204.1416v2](/abs/1204.1416v2),
[arXiv:1204.1416v3](/abs/1204.1416v3),
[arXiv:1204.2078v1](/abs/1204.2078v1),
[arXiv:1204.2078v2](/abs/1204.2078v2),
[arXiv:1204.2172v1](/abs/1204.2172v1),
[arXiv:1204.2183v1](/abs/1204.2183v1),
[arXiv:1204.2183v2](/abs/1204.2183v2),
[arXiv:1204.2198v1](/abs/1204.2198v1),
[arXiv:1204.2292v1](/abs/1204.2292v1),
[arXiv:1204.2396v1](/abs/1204.2396v1),
[arXiv:1204.3019v2](/abs/1204.3019v2),
[arXiv:1204.3077v1](/abs/1204.3077v1),
[arXiv:1204.3170v1](/abs/1204.3170v1),
[arXiv:1204.3389v1](/abs/1204.3389v1),
[arXiv:1204.3415v1](/abs/1204.3415v1),
[arXiv:1204.3415v2](/abs/1204.3415v2),
[arXiv:1204.3415v4](/abs/1204.3415v4),
[arXiv:1204.3775v1](/abs/1204.3775v1),
[arXiv:1204.3800v1](/abs/1204.3800v1),
[arXiv:1204.4317v1](/abs/1204.4317v1),
[arXiv:1204.4937v1](/abs/1204.4937v1),
[arXiv:1204.4964v1](/abs/1204.4964v1),
[arXiv:1204.5680v2](/abs/1204.5680v2),
[arXiv:1204.5743v1](/abs/1204.5743v1),
[arXiv:1205.0685v2](/abs/1205.0685v2),
[arXiv:1205.4617v1](/abs/1205.4617v1),
[arXiv:1205.4743v1](/abs/1205.4743v1),
[arXiv:1205.5051v1](/abs/1205.5051v1),
[arXiv:1205.5243v2](/abs/1205.5243v2),
[arXiv:1205.5243v3](/abs/1205.5243v3),
[arXiv:1205.5535v1](/abs/1205.5535v1),
[arXiv:1205.5559v2](/abs/1205.5559v2),
[arXiv:1205.5610v1](/abs/1205.5610v1),
[arXiv:1205.6141v1](/abs/1205.6141v1),
[arXiv:1205.6328v1](/abs/1205.6328v1),
[arXiv:1205.6429v1](/abs/1205.6429v1),
[arXiv:1205.6650v1](/abs/1205.6650v1),
[arXiv:1205.6896v1](/abs/1205.6896v1),
[arXiv:1206.0001v1](/abs/1206.0001v1),
[arXiv:1206.0284v2](/abs/1206.0284v2),
[arXiv:1206.0748v1](/abs/1206.0748v1),
[arXiv:1206.1434v1](/abs/1206.1434v1),
[arXiv:1206.1906v1](/abs/1206.1906v1),
[arXiv:1206.2487v1](/abs/1206.2487v1),
[arXiv:1206.3111v1](/abs/1206.3111v1),
[arXiv:1206.3342v1](/abs/1206.3342v1),
[arXiv:1206.3524v2](/abs/1206.3524v2),
[arXiv:1206.3697v3](/abs/1206.3697v3),
[arXiv:1206.3729v1](/abs/1206.3729v1),
[arXiv:1206.4045v1](/abs/1206.4045v1),
[arXiv:1206.4101v1](/abs/1206.4101v1),
[arXiv:1206.4429v2](/abs/1206.4429v2),
[arXiv:1206.5616v1](/abs/1206.5616v1),
[arXiv:1206.5840v1](/abs/1206.5840v1),
[arXiv:1206.5867v2](/abs/1206.5867v2),
[arXiv:1206.6518v2](/abs/1206.6518v2),
[arXiv:1206.7027v1](/abs/1206.7027v1),
[arXiv:1207.0217v1](/abs/1207.0217v1),
[arXiv:1207.0274v1](/abs/1207.0274v1),
[arXiv:1207.0717v1](/abs/1207.0717v1),
[arXiv:1207.1258v1](/abs/1207.1258v1),
[arXiv:1207.1274v1](/abs/1207.1274v1),
[arXiv:1207.1664v1](/abs/1207.1664v1),
[arXiv:1207.1737v2](/abs/1207.1737v2),
[arXiv:1207.1943v1](/abs/1207.1943v1),
[arXiv:1207.2232v1](/abs/1207.2232v1),
[arXiv:1207.2319v1](/abs/1207.2319v1),
[arXiv:1207.2415v2](/abs/1207.2415v2),
[arXiv:1207.2415v3](/abs/1207.2415v3),
[arXiv:1207.2415v4](/abs/1207.2415v4),
[arXiv:1207.2641v2](/abs/1207.2641v2),
[arXiv:1207.2697v1](/abs/1207.2697v1),
[arXiv:1207.2743v1](/abs/1207.2743v1),
[arXiv:1207.3178v1](/abs/1207.3178v1),
[arXiv:1207.3182v1](/abs/1207.3182v1),
[arXiv:1207.3344v1](/abs/1207.3344v1),
[arXiv:1207.3362v1](/abs/1207.3362v1),
[arXiv:1207.3795v2](/abs/1207.3795v2),
[arXiv:1207.3860v1](/abs/1207.3860v1),
[arXiv:1207.4291v1](/abs/1207.4291v1),
[arXiv:1207.4435v1](/abs/1207.4435v1),
[arXiv:1207.4570v1](/abs/1207.4570v1),
[arXiv:1207.4862v1](/abs/1207.4862v1),
[arXiv:1207.4938v1](/abs/1207.4938v1),
[arXiv:1207.6282v1](/abs/1207.6282v1),
[arXiv:1207.6726v1](/abs/1207.6726v1),
[arXiv:1207.6740v1](/abs/1207.6740v1),
[arXiv:1207.7088v1](/abs/1207.7088v1),
[arXiv:1207.7218v1](/abs/1207.7218v1),
[arXiv:1208.0264v1](/abs/1208.0264v1),
[arXiv:1208.1022v1](/abs/1208.1022v1),
[arXiv:1208.1260v1](/abs/1208.1260v1),
[arXiv:1208.1496v1](/abs/1208.1496v1),
[arXiv:1208.1524v1](/abs/1208.1524v1),
[arXiv:1208.1956v1](/abs/1208.1956v1),
[arXiv:1208.2057v1](/abs/1208.2057v1),
[arXiv:1208.2275v1](/abs/1208.2275v1),
[arXiv:1208.2534v1](/abs/1208.2534v1),
[arXiv:1208.2640v1](/abs/1208.2640v1),
[arXiv:1208.2728v2](/abs/1208.2728v2),
[arXiv:1208.2954v1](/abs/1208.2954v1),
[arXiv:1208.3432v1](/abs/1208.3432v1),
[arXiv:1208.3449v1](/abs/1208.3449v1),
[arXiv:1208.3570v1](/abs/1208.3570v1),
[arXiv:1208.3691v1](/abs/1208.3691v1),
[arXiv:1208.3800v1](/abs/1208.3800v1),
[arXiv:1208.3804v1](/abs/1208.3804v1),
[arXiv:1208.3912v1](/abs/1208.3912v1),
[arXiv:1208.4151v1](/abs/1208.4151v1),
[arXiv:1208.4380v1](/abs/1208.4380v1),
[arXiv:1208.4551v1](/abs/1208.4551v1),
[arXiv:1208.4611v2](/abs/1208.4611v2),
[arXiv:1208.4644v2](/abs/1208.4644v2),
[arXiv:1208.4729v1](/abs/1208.4729v1),
[arXiv:1208.4809v1](/abs/1208.4809v1),
[arXiv:1208.4856v1](/abs/1208.4856v1),
[arXiv:1208.5024v1](/abs/1208.5024v1),
[arXiv:1208.5343v2](/abs/1208.5343v2),
[arXiv:1208.5392v1](/abs/1208.5392v1),
[arXiv:1208.5642v3](/abs/1208.5642v3),
[arXiv:1208.5642v4](/abs/1208.5642v4),
[arXiv:1208.5899v2](/abs/1208.5899v2),
[arXiv:1208.6133v1](/abs/1208.6133v1),
[arXiv:1209.0337v1](/abs/1209.0337v1),
[arXiv:1209.0360v1](/abs/1209.0360v1),
[arXiv:1209.0465v2](/abs/1209.0465v2),
[arXiv:1209.0662v2](/abs/1209.0662v2),
[arXiv:1209.0662v3](/abs/1209.0662v3),
[arXiv:1209.0773v2](/abs/1209.0773v2),
[arXiv:1209.0981v1](/abs/1209.0981v1),
[arXiv:1209.0981v2](/abs/1209.0981v2),
[arXiv:1209.1079v1](/abs/1209.1079v1),
[arXiv:1209.1329v1](/abs/1209.1329v1),
[arXiv:1209.1388v1](/abs/1209.1388v1),
[arXiv:1209.1444v1](/abs/1209.1444v1),
[arXiv:1209.1513v1](/abs/1209.1513v1),
[arXiv:1209.1983v1](/abs/1209.1983v1),
[arXiv:1209.2058v1](/abs/1209.2058v1),
[arXiv:1209.2177v1](/abs/1209.2177v1),
[arXiv:1209.2557v1](/abs/1209.2557v1),
[arXiv:1209.2841v2](/abs/1209.2841v2),
[arXiv:1209.2856v2](/abs/1209.2856v2),
[arXiv:1209.3090v1](/abs/1209.3090v1),
[arXiv:1209.3101v1](/abs/1209.3101v1),
[arXiv:1209.3330v2](/abs/1209.3330v2),
[arXiv:1209.3723v1](/abs/1209.3723v1),
[arXiv:1209.4066v1](/abs/1209.4066v1),
[arXiv:1209.5039v1](/abs/1209.5039v1),
[arXiv:1209.5040v1](/abs/1209.5040v1),
[arXiv:1209.5041v1](/abs/1209.5041v1),
[arXiv:1209.5249v1](/abs/1209.5249v1),
[arXiv:1209.5249v2](/abs/1209.5249v2),
[arXiv:1209.5249v3](/abs/1209.5249v3),
[arXiv:1209.5588v1](/abs/1209.5588v1),
[arXiv:1209.5735v1](/abs/1209.5735v1),
[arXiv:1209.5767v1](/abs/1209.5767v1),
[arXiv:1209.6037v1](/abs/1209.6037v1),
[arXiv:1209.6094v1](/abs/1209.6094v1),
[arXiv:1209.6355v1](/abs/1209.6355v1),
[arXiv:1209.6439v2](/abs/1209.6439v2),
[arXiv:1210.0203v1](/abs/1210.0203v1),
[arXiv:1210.0557v2](/abs/1210.0557v2),
[arXiv:1210.0576v1](/abs/1210.0576v1),
[arXiv:1210.0967v1](/abs/1210.0967v1),
[arXiv:1210.1516v1](/abs/1210.1516v1),
[arXiv:1210.1516v2](/abs/1210.1516v2),
[arXiv:1210.3902v1](/abs/1210.3902v1),
[arXiv:1210.4259v1](/abs/1210.4259v1),
[arXiv:1210.4259v3](/abs/1210.4259v3),
[arXiv:1210.4566v1](/abs/1210.4566v1),
[arXiv:1210.4597v1](/abs/1210.4597v1),
[arXiv:1210.4773v1](/abs/1210.4773v1),
[arXiv:1210.5417v2](/abs/1210.5417v2),
[arXiv:1210.5706v2](/abs/1210.5706v2),
[arXiv:1210.5706v3](/abs/1210.5706v3),
[arXiv:1210.5732v1](/abs/1210.5732v1),
[arXiv:1210.5924v1](/abs/1210.5924v1),
[arXiv:1210.6051v1](/abs/1210.6051v1),
[arXiv:1210.6181v1](/abs/1210.6181v1),
[arXiv:1210.6243v1](/abs/1210.6243v1),
[arXiv:1210.6649v1](/abs/1210.6649v1),
[arXiv:1210.7001v2](/abs/1210.7001v2),
[arXiv:1210.7164v1](/abs/1210.7164v1),
[arXiv:1210.7205v1](/abs/1210.7205v1),
[arXiv:1210.7234v1](/abs/1210.7234v1),
[arXiv:1210.7259v2](/abs/1210.7259v2),
[arXiv:1210.7624v1](/abs/1210.7624v1),
[arXiv:1210.7701v1](/abs/1210.7701v1),
[arXiv:1210.7935v1](/abs/1210.7935v1),
[arXiv:1210.8008v1](/abs/1210.8008v1),
[arXiv:1210.8154v1](/abs/1210.8154v1),
[arXiv:1210.8154v2](/abs/1210.8154v2),
[arXiv:1211.0027v2](/abs/1211.0027v2),
[arXiv:1211.0027v3](/abs/1211.0027v3),
[arXiv:1211.0097v1](/abs/1211.0097v1),
[arXiv:1211.0119v1](/abs/1211.0119v1),
[arXiv:1211.0131v1](/abs/1211.0131v1),
[arXiv:1211.0131v3](/abs/1211.0131v3),
[arXiv:1211.0220v1](/abs/1211.0220v1),
[arXiv:1211.0611v2](/abs/1211.0611v2),
[arXiv:1211.1302v1](/abs/1211.1302v1),
[arXiv:1211.1491v1](/abs/1211.1491v1),
[arXiv:1211.1650v1](/abs/1211.1650v1),
[arXiv:1211.1869v1](/abs/1211.1869v1),
[arXiv:1211.2103v1](/abs/1211.2103v1),
[arXiv:1211.2304v1](/abs/1211.2304v1),
[arXiv:1211.2905v1](/abs/1211.2905v1),
[arXiv:1211.3421v1](/abs/1211.3421v1),
[arXiv:1211.4178v1](/abs/1211.4178v1),
[arXiv:1211.4269v1](/abs/1211.4269v1),
[arXiv:1211.4820v1](/abs/1211.4820v1),
[arXiv:1211.4911v1](/abs/1211.4911v1),
[arXiv:1211.5408v1](/abs/1211.5408v1),
[arXiv:1211.5572v1](/abs/1211.5572v1),
[arXiv:1211.5748v1](/abs/1211.5748v1),
[arXiv:1211.5864v1](/abs/1211.5864v1),
[arXiv:1211.5889v1](/abs/1211.5889v1),
[arXiv:1211.5962v1](/abs/1211.5962v1),
[arXiv:1211.6055v1](/abs/1211.6055v1),
[arXiv:1211.6425v1](/abs/1211.6425v1),
[arXiv:1211.6496v1](/abs/1211.6496v1),
[arXiv:1211.6574v1](/abs/1211.6574v1),
[arXiv:1211.6967v1](/abs/1211.6967v1),
[arXiv:1211.7016v1](/abs/1211.7016v1),
[arXiv:1212.0177v1](/abs/1212.0177v1),
[arXiv:1212.0587v1](/abs/1212.0587v1),
[arXiv:1212.0587v3](/abs/1212.0587v3),
[arXiv:1212.0587v4](/abs/1212.0587v4),
[arXiv:1212.0940v1](/abs/1212.0940v1),
[arXiv:1212.1390v1](/abs/1212.1390v1),
[arXiv:1212.1390v2](/abs/1212.1390v2),
[arXiv:1212.1390v3](/abs/1212.1390v3),
[arXiv:1212.1449v1](/abs/1212.1449v1),
[arXiv:1212.2111v2](/abs/1212.2111v2),
[arXiv:1212.2248v1](/abs/1212.2248v1),
[arXiv:1212.2531v1](/abs/1212.2531v1),
[arXiv:1212.2618v1](/abs/1212.2618v1),
[arXiv:1212.2969v1](/abs/1212.2969v1),
[arXiv:1212.3730v1](/abs/1212.3730v1),
[arXiv:1212.3810v2](/abs/1212.3810v2),
[arXiv:1212.4245v2](/abs/1212.4245v2),
[arXiv:1212.4383v1](/abs/1212.4383v1),
[arXiv:1212.4979v1](/abs/1212.4979v1),
[arXiv:1212.5058v1](/abs/1212.5058v1),
[arXiv:1212.5161v1](/abs/1212.5161v1),
[arXiv:1212.5588v1](/abs/1212.5588v1),
[arXiv:1212.5651v1](/abs/1212.5651v1),
[arXiv:1212.5655v1](/abs/1212.5655v1),
[arXiv:1212.5843v2](/abs/1212.5843v2),
[arXiv:1212.5892v1](/abs/1212.5892v1),
[arXiv:1212.6253v1](/abs/1212.6253v1),
[arXiv:1212.6875v3](/abs/1212.6875v3),
[arXiv:1212.6964v1](/abs/1212.6964v1),
[arXiv:1301.0244v1](/abs/1301.0244v1),
[arXiv:1301.0257v1](/abs/1301.0257v1),
[arXiv:1301.0323v1](/abs/1301.0323v1),
[arXiv:1301.0679v1](/abs/1301.0679v1),
[arXiv:1301.0894v1](/abs/1301.0894v1),
[arXiv:1301.0894v2](/abs/1301.0894v2),
[arXiv:1301.1129v1](/abs/1301.1129v1),
[arXiv:1301.1290v1](/abs/1301.1290v1),
[arXiv:1301.1825v1](/abs/1301.1825v1),
[arXiv:1301.2023v1](/abs/1301.2023v1),
[arXiv:1301.2403v1](/abs/1301.2403v1),
[arXiv:1301.2681v1](/abs/1301.2681v1),
[arXiv:1301.3246v1](/abs/1301.3246v1),
[arXiv:1301.3383v1](/abs/1301.3383v1),
[arXiv:1301.3825v1](/abs/1301.3825v1),
[arXiv:1301.4233v1](/abs/1301.4233v1),
[arXiv:1301.4494v1](/abs/1301.4494v1),
[arXiv:1301.4516v1](/abs/1301.4516v1),
[arXiv:1301.4668v1](/abs/1301.4668v1),
[arXiv:1301.4833v1](/abs/1301.4833v1),
[arXiv:1301.5408v1](/abs/1301.5408v1),
[arXiv:1301.5472v1](/abs/1301.5472v1),
[arXiv:1301.5771v1](/abs/1301.5771v1),
[arXiv:1301.5867v1](/abs/1301.5867v1),
[arXiv:1301.5897v1](/abs/1301.5897v1),
[arXiv:1301.5939v1](/abs/1301.5939v1),
[arXiv:1301.6148v1](/abs/1301.6148v1),
[arXiv:1301.6577v1](/abs/1301.6577v1),
[arXiv:1301.6594v1](/abs/1301.6594v1),
[arXiv:1301.7182v1](/abs/1301.7182v1),
[arXiv:1301.7182v2](/abs/1301.7182v2),
[arXiv:1302.0222v1](/abs/1302.0222v1),
[arXiv:1302.0319v1](/abs/1302.0319v1),
[arXiv:1302.0382v1](/abs/1302.0382v1),
[arXiv:1302.0382v2](/abs/1302.0382v2),
[arXiv:1302.2806v1](/abs/1302.2806v1),
[arXiv:1302.3382v1](/abs/1302.3382v1),
[arXiv:1302.4889v1](/abs/1302.4889v1),
[arXiv:1302.5271v1](/abs/1302.5271v1),
[arXiv:1302.5283v2](/abs/1302.5283v2),
[arXiv:1302.6051v1](/abs/1302.6051v1),
[arXiv:1302.6428v1](/abs/1302.6428v1),
[arXiv:1302.6577v1](/abs/1302.6577v1),
[arXiv:1302.6643v1](/abs/1302.6643v1),
[arXiv:1302.7020v1](/abs/1302.7020v1),
[arXiv:1302.7255v1](/abs/1302.7255v1),
[arXiv:1303.0033v1](/abs/1303.0033v1),
[arXiv:1303.0432v1](/abs/1303.0432v1),
[arXiv:1303.0432v2](/abs/1303.0432v2),
[arXiv:1303.0599v1](/abs/1303.0599v1),
[arXiv:1303.1065v1](/abs/1303.1065v1),
[arXiv:1303.1211v1](/abs/1303.1211v1),
[arXiv:1303.1410v1](/abs/1303.1410v1),
[arXiv:1303.1673v1](/abs/1303.1673v1),
[arXiv:1303.1799v1](/abs/1303.1799v1),
[arXiv:1303.1800v2](/abs/1303.1800v2),
[arXiv:1303.2080v1](/abs/1303.2080v1),
[arXiv:1303.2096v1](/abs/1303.2096v1),
[arXiv:1303.2338v1](/abs/1303.2338v1),
[arXiv:1303.2840v1](/abs/1303.2840v1),
[arXiv:1303.3201v1](/abs/1303.3201v1),
[arXiv:1303.3319v1](/abs/1303.3319v1),
[arXiv:1303.3692v1](/abs/1303.3692v1),
[arXiv:1303.3894v1](/abs/1303.3894v1),
[arXiv:1303.4048v1](/abs/1303.4048v1),
[arXiv:1303.4048v2](/abs/1303.4048v2),
[arXiv:1303.4048v3](/abs/1303.4048v3),
[arXiv:1303.4488v1](/abs/1303.4488v1),
[arXiv:1303.4488v2](/abs/1303.4488v2),
[arXiv:1303.4835v1](/abs/1303.4835v1),
[arXiv:1303.4864v1](/abs/1303.4864v1),
[arXiv:1303.5269v1](/abs/1303.5269v1),
[arXiv:1303.5461v1](/abs/1303.5461v1),
[arXiv:1303.5562v1](/abs/1303.5562v1),
[arXiv:1303.5986v1](/abs/1303.5986v1),
[arXiv:1303.6163v1](/abs/1303.6163v1),
[arXiv:1303.6455v1](/abs/1303.6455v1),
[arXiv:cs/0512073v10](/abs/cs/0512073v10).

Data associated with the following 66 arXiv article versions was
identical to the existing arXiv article files and/or existing ancillary
files and was thus not merged:

[arXiv:0801.0830v7](/abs/0801.0830v7),
[arXiv:0801.0830v8](/abs/0801.0830v8),
[arXiv:0901.2792v2](/abs/0901.2792v2),
[arXiv:0908.4548v3](/abs/0908.4548v3),
[arXiv:1004.2988v3](/abs/1004.2988v3),
[arXiv:1004.4046v3](/abs/1004.4046v3),
[arXiv:1005.1280v3](/abs/1005.1280v3),
[arXiv:1005.3979v3](/abs/1005.3979v3),
[arXiv:1005.3979v4](/abs/1005.3979v4),
[arXiv:1009.1283v2](/abs/1009.1283v2),
[arXiv:1104.4443v3](/abs/1104.4443v3),
[arXiv:1106.3615v3](/abs/1106.3615v3),
[arXiv:1107.1932v1](/abs/1107.1932v1),
[arXiv:1107.5397v1](/abs/1107.5397v1),
[arXiv:1108.1461v1](/abs/1108.1461v1),
[arXiv:1108.1461v4](/abs/1108.1461v4),
[arXiv:1109.0614v1](/abs/1109.0614v1),
[arXiv:1110.1928v1](/abs/1110.1928v1),
[arXiv:1111.2750v1](/abs/1111.2750v1),
[arXiv:1112.2058v1](/abs/1112.2058v1),
[arXiv:1112.6090v1](/abs/1112.6090v1),
[arXiv:1201.2261v1](/abs/1201.2261v1),
[arXiv:1202.2037v1](/abs/1202.2037v1),
[arXiv:1203.0233v1](/abs/1203.0233v1),
[arXiv:1203.3103v1](/abs/1203.3103v1),
[arXiv:1203.3611v1](/abs/1203.3611v1),
[arXiv:1204.0056v1](/abs/1204.0056v1),
[arXiv:1204.1385v1](/abs/1204.1385v1),
[arXiv:1204.1598v1](/abs/1204.1598v1),
[arXiv:1206.1552v1](/abs/1206.1552v1),
[arXiv:1206.1748v1](/abs/1206.1748v1),
[arXiv:1206.6281v1](/abs/1206.6281v1),
[arXiv:1206.6281v2](/abs/1206.6281v2),
[arXiv:1206.6281v4](/abs/1206.6281v4),
[arXiv:1207.0665v1](/abs/1207.0665v1),
[arXiv:1207.0665v2](/abs/1207.0665v2),
[arXiv:1207.0805v1](/abs/1207.0805v1),
[arXiv:1207.0911v1](/abs/1207.0911v1),
[arXiv:1207.1591v1](/abs/1207.1591v1),
[arXiv:1207.2222v1](/abs/1207.2222v1),
[arXiv:1207.2867v1](/abs/1207.2867v1),
[arXiv:1207.3541v1](/abs/1207.3541v1),
[arXiv:1208.1893v1](/abs/1208.1893v1),
[arXiv:1208.3769v1](/abs/1208.3769v1),
[arXiv:1208.3840v1](/abs/1208.3840v1),
[arXiv:1210.2882v1](/abs/1210.2882v1),
[arXiv:1210.3939v1](/abs/1210.3939v1),
[arXiv:1210.4091v1](/abs/1210.4091v1),
[arXiv:1211.2575v1](/abs/1211.2575v1),
[arXiv:1211.5282v1](/abs/1211.5282v1),
[arXiv:1212.0059v1](/abs/1212.0059v1),
[arXiv:1212.6080v1](/abs/1212.6080v1),
[arXiv:1212.6472v1](/abs/1212.6472v1),
[arXiv:1301.0963v1](/abs/1301.0963v1),
[arXiv:1301.1134v1](/abs/1301.1134v1),
[arXiv:1301.2400v1](/abs/1301.2400v1),
[arXiv:1302.0222v2](/abs/1302.0222v2),
[arXiv:1302.1185v1](/abs/1302.1185v1),
[arXiv:1302.1185v2](/abs/1302.1185v2),
[arXiv:1302.1638v1](/abs/1302.1638v1),
[arXiv:1302.1667v2](/abs/1302.1667v2),
[arXiv:1302.1752v1](/abs/1302.1752v1),
[arXiv:1302.4233v1](/abs/1302.4233v1),
[arXiv:1302.6018v1](/abs/1302.6018v1),
[arXiv:1303.1913v1](/abs/1303.1913v1),
[arXiv:hep-th/0201115v17](/abs/hep-th/0201115v17).
