Protecting your Privacy
=======================

Privacy Policy
---------------------------------------

Please see our [privacy policy](policies/privacy_policy). The information below is specific to display of submitter and author email.

Submitter Email
---------------------------------------

Over the years, arXiv has occasionally received complaints from
submitters regarding unsolicited physics-related e-mails apparently
prompted by their submissions. Recently, spammers targeting more general
audiences have been using increasingly aggressive techniques to harvest
e-mail addresses from the web. E-mail addresses may also be harvested by
e-mail viruses from browser caches and mail spools, and then diffused
further in falsified `From:` lines.

Measures are now in place at arXiv to protect the e-mail addresses of
submitters from abuse. For example, submitter addresses are no longer
visible on the abstract page of a paper; the submitter's address is
instead available on a link that says **\[view email\]**. Access to this
link requires one to logon, or first to
[register](/user/register). For this function, users of
mirror sites will be redirected to the main site, since only the main
site currently supports authentication. The intent of this and other
technical measures now in place is to make it difficult or impossible to
harvest large numbers of e-mail addresses with minimal inconvenience to
users who need a single address for legitimate communication purposes.

Why does arXiv make e-mail addresses available?
-----------------------------------------------

arXiv allows registered users to view the email address that was used to
upload each submission to arXiv. There are two intended purposes:

-   to give users the ability to send feedback on papers to the
    submitter
-   to help users [contact eligible arXiv
    endorsers](endorsement#request) in order to make their own
    submissions

arXiv monitors each user's requests to view email addresses. If a large
number of email addresses are viewed by a single user in a short amount
of time, an *irrevocable* block will be placed on the users account that
will prevent them from viewing any additional email address. Users that
view a large number of email addresses in a short period of time are
typically collecting email addresses for the promotion of an event,
service or concept, and this is an inappropriate use of the contact
information for other users.

*arXiv is committed to protecting its users from spam and other misuses
of personal information that is collected in the course of operating
arXiv.org. Email addresses or other personal information collected from
arXiv data must not be abused for unsolicited emailing or other forms of
spam.*

If you have any questions about what constitutes appropriate use of
submitter email addresses, please [contact](contact.md) the arXiv
administrators.
