The arXiv endorsement system
============================

arXiv requires that users be *endorsed*
before submitting their first paper to a category.

Why does arXiv require endorsement?
-----------------------------------

arXiv is distinct from the web as a whole, because arXiv contains
exclusively scientific content. The endorsement system verifies that
arXiv contributors belong to the scientific community in a fair and
sustainable way that can scale with arXiv's future growth.

*arXiv is an openly accessible, moderated repository for scholarly
papers in specific scientific disciplines. Material submitted to arXiv
is expected to be of interest, relevance, and value to those
disciplines. Endorsement is a necessary but not sufficient condition to
have papers accepted in arXiv; arXiv reserves the right to reject or
reclassify any submission.*

The endorsement system ensures that arXiv content is relevant to current
research at much lower cost than conventional peer-reviewed journals, so
we can continue to offer free access to the scientific community and the
general public. Although our system may be imperfect, people who fail to
get endorsement are still free to post articles on their web site or to
submit their publications to peer-reviewed journals.

How can I get endorsed?
-----------------------

arXiv may give some people automatic endorsements based on subject area,
topic, previous submissions, and academic affiliation. In most cases,
automatic endorsement is given to authors from known academic
institutions and research facilities. arXiv submitters are therefore
encouraged to associate an institutional email address, if they have
one, with their arXiv account (see [author registration
help](registerhelp)). This will expedite the endorsement process.

During the submission process, however, we may require authors who are
submitting papers to a subject category for the first time to get an
*endorsement* from an established arXiv author. Detailed instructions on
how to proceed with the endorsement request are provided at that time.

<span id="request"></span> If you need to be endorsed by someone, it is
best for you to find an endorser who

1.  you know personally and
2.  is knowledgeable in the subject area of your paper.

A good choice for graduate students would be your thesis advisor or
another professor in your department/institution working in your field.

Alternatively this is the recommended way to proceed.

1.  Start by finding related articles in your field. Your preprint
    surely has cited works that are already posted in the arXiv, some of
    these works will be particularly relevant.
2.  Bring up these abstracts from the arXiv page.
3.  You can find somebody qualified to endorse by clicking on the link
    titled "Which of these authors are endorsers?" at the bottom of
    every abstract page.
4.  Using that information, you can then find the email address of the
    submitter on the abstract page just under the "Submission history"
    heading.

It is a good idea to send eligible endorsers a copy of your proposed
submission along with the endorsement request. Please note, however,
that it is inappropriate to email large numbers of potential endorsers
at once, or to repeatedly email the same endorser with a request for
endorsement.

At least one positive endorsement is required per *endorsement domain*
to be considered endorsed for that domain.

arXiv reserves the right to revoke any submitter's endorsement if that
submitter has violated arXiv policies.

Who can endorse?
----------------

Endorsers must have authored a certain number of papers within the
*endorsement domain* of a subject area. The number of papers depends on
the particular subject area, but has been set so that any active
scientist who has been working in their field for a few years should be
able to endorse if their work has been submitted to arXiv and if they are
registered as an author of their papers. **Endorsement domains** have been
chosen to reflect related subject areas and ensure that it will be easy
for people to find endorsements: most high-level subject areas (e.g.,
hep-th, cond-mat, q-bio) are currently endorsement domains, with the
notable exception of physics, in which individual subject classes (e.g.,
phys.acc-phys, phys.med-ph) are endorsement domains. To ensure that
endorsers are active members of the community, we only count papers that
have been submitted between three months and five years ago.\*

If you would like to be able to endorse, the most important thing that
you can do is make sure that you are registered as an author of your
papers. If you can get the *paper password* for a paper you can [claim
ownership](/auth/need-paper-password) of a paper immediately. If you
don't have the paper password, you can [request
ownership](/auth/request-ownership) of a paper. Note that you must also
have an active positive endorsement to that area yourself before you may
endorse for that subject classification.

\* We reserve the right to suspend a person's ability to endorse.

What are my responsibilities as an endorser?
--------------------------------------------

**The endorsement process is not peer review.** You should know the
person that you endorse **or** you should see the paper that the person
intends to submit. We don't expect you to read the paper in detail, or
verify that the work is correct, but you should check that the paper is
appropriate for the subject area. You should not endorse the author if
the author is unfamiliar with the basic facts of the field, or if the
work is entirely disconnected with current work in the area. If you are
sent a paper to read, you should treat that content as privileged
information and respect its confidentiality as you would if you were
asked to review it for a journal.

If an author asks you for endorsement, they will send you a
six-character alphanumeric *endorsement code*. After you enter this code
on the [endorsement form](/auth/endorse), you can tell us that you
**do** or **do not** wish to endorse a person. If you wish to abstain
from the endorsement process altogether, do not submit anything on the
endorsement form. If you choose not to endorse a author, you **should**
use the endorsement form to explicitly tell us that you do not wish to
endorse this person, and this will be recorded as a negative vote of
endorsement.

The fact that you have personally endorsed or not endorsed a person (as
well as any optional comments) is private between you and the arXiv
administrators – this information will not be shared with arXiv users or
the person requesting endorsement, although under certain circumstances
an author might be able to infer your action.

If you feel uncomfortable about endorsing an author for any reason, do
not do it – ask the person to find another endorser. Only provide
endorsement to authors seeking to submit their own work, not to
third-parties or proxies.
