# LaTeX2e class for Astronomy & Astrophysics

arXiv uses **aa.cls version 9.0**. This version requires a flag for
backward compatibility between earlier versions (7.x, and below) of the
aa.cls file. This looks like:

``` 
\documentclass[bibyear]{aa}
  
```

For additional information please consult the [A\&A
website](http://www.aanda.org/author-information/latex-issues/texnical-background-information).

arXiv used **aa.cls version 6.1** `[2006/06/01 v6.1 LaTeX document class
for Astronomy and Astrophysics journal]` for new submissions and
replacements received since early 2007, until TexLive 2011 (which used
**aa.cls version 7.0**).

arXiv has used **aa.cls version 5.2** for new submissions and
replacements received after the end of September 2002.

You must use the **letterpaper** class option to ensure proper printout
on standard US letter paper.

The `sidecaption` layout conflicts with our automatic use of HyperTeX.
If you use the `sidecaption` layout you must [disable HyperTeX for your
submission](http://arxiv.org/help/faq/mistakes#nohypertex).

## Don't Forget to Check the PDF\!

As always, carefully check the diagnostic messages on screen and
<span class="note">verify the PDF generated by arXiv *before* the paper
is announced</span>.

-----

## Historical note

When EDP became publisher of [Astronomy &
Astrophysics](http://www.edpsciences.org/aa/) they modified the existing
LaTeX2e class files in a backwards incompatible way without changing the
name of the class file or at least appending a version qualifier to the
filename. Obviously this causes conflicts for large TeX installations
like arXiv's with a large number of papers requiring the previous
version of aa.cls for proper processing.

Since we need to ensure that previously archived papers are not
adversely affected by these updates, we could not simply install the
latest version. The solution we adopted was to version arXiv's TeX tree.
By default, papers submitted before October 2002 are processed with
version 4.05 (Dec 1995) and those from October 2002 onward are processed
with version 5.20 (June
2002).

### Explicitly selecting a version of the Astronomy & Astrophysics class file

You may either:

1.  Bundle your version of aa.cls and possibly other class and style
    files with your paper. These will be used instead of any system
    files with the same name.
2.  Use a version qualifier for the class file name. To use aa.cls
    version 5.2 (June 2002) your latex document should contain  
    `\documentclass[...]{aa520}`  
    To use aa.cls version 5.01 (June 2000) your latex document should
    contain  
    `\documentclass[...]{aa501}`  
    (Note that we substituted `letterpaper` for `a4paper` in our copy of
    aa501.cls to ensure proper printing on the shorter US lettersize
    paper.)
