# HyperTeX FAQ

This historical FAQ maintained by [Kasper Peeters](http://maths.dur.ac.uk/users/kasper.peeters/index.html) <kasper.peeters@durham.ac.uk>, with contributions from Tanmoy Bhattacharya, David Carlisle, Mark Doyle, Paul Ginsparg, Alan Jeffrey, Hiroshi Kubo, Sebastian Rahtz and Arthur Smith.

###### For detailed information on the current `hypertex`, please refer to the [CTAN website](https://ctan.org/pkg/hyperref).

April 13th, 2008.

> HyperTeX is a defacto standard for inclusion of hyperlink information in TeX and LaTeX documents, which can then be used to generated PDF or DVI files with embedded links. These links enable easy navigation inside documents as well as between documents, just as in HTML, using standard PDF, Postscript and DVI viewers. Various TeX, LaTeX and BibTeX style sheets and macro packages exist which facilitate the construction of hyperlinked documents.

Adding hyperlinks to a LaTeX document
-------------------------------------

The simplest way to add hyperlinks to a LaTeX document is to make use of the [hyperref](ftp://ftp.tex.ac.uk/tex-archive/macros/latex2e/contrib/hyperref/) package written by Sebastian Rahtz. It provides macros for constructing hyperlinks by hand, and it can also automatically construct hyperlinks for all the '\\cite' and '\\ref' commands. Hyperref is part of most modern TeX distributions. To use it, simply add
```TeX
\usepackage{hyperref}
```
to the top of your LaTeX file. See below for a [more detailed example](#example). You will also want to read the section below in order to find out how to make the PDF, Postscript or DVI file.

Plain TeX users are referred to the [hyperbasics.tex](ftp://ftp.tex.ac.uk/tex-archive/support/hypertex/tanmoy/hyperbasics.tex) file written by Tanmoy Bhattacharya.

Generating PDF/Postscript/DVI files with hyperlinks
---------------------------------------------------

If you use hyperref, the DVI file which comes out of latex will contain hyperlink information which is recognised by programs such as xdvi.

In order to create a Postscript or PDF file, you need to use the a hyperlink-aware converter such as [dvips](http://www.radicaleye.com/dvips.html), [dvipdfm](http://gaspra.kettering.edu/dvipdfm/), or generate the PDF file directly from the TeX or LaTeX source using [pdftex](http://www.tug.org/applications/pdftex/).

Viewing TeX/LaTeX generated output with hyperlinks
--------------------------------------------------

Most DVI previewers, such as [xdvi](http://math.berkeley.edu/~vojta/xdvi.html), [dviout](http://akagi.ms.u-tokyo.ac.jp/ftp.html#TeX) and [idvi](http://www.geom.umn.edu/java/idvi/) will display hypertex links without any further modifications.

The same is true for most PDF previewers, such as [Adobe Reader](http://www.adobe.com/products/acrobat/readstep2.html), recent versions of [Evince](http://www.gnome.org/projects/evince/) and [Xpdf](http://www.foolabs.com/xpdf/).

Using BibTeX with hyperlinks
----------------------------

There are various BibTeX style files which automatically create hyperlinks to eprints available through [arXiv.org](http://arxiv.org). BibTeX entries which are compatible with these styles are generated by SPIRES, and look like
```LaTeX
 @Article{Maldacena:1997re,
     author        = "Maldacena, Juan Martin",
     title         = "{The large N limit of superconformal field theories and
                      supergravity}",
     journal       = "Adv. Theor. Math. Phys.",
     volume        = "2",
     year          = "1998",
     pages         = "231-252",
     eprint        = "hep-th/9711200",
     archivePrefix = "arXiv",
     SLACcitation  = "%%CITATION = HEP-TH/9711200;%%"
}
```
 Style files which handle both the old-style and new-style preprint numbers include [utphys.bst](http://golem.ph.utexas.edu/~distler/TeXstuff/utphys.bst) and [kp.bst](bibstyles/kp.bst). For more information see [the BibTeX page on arXiv.org](bibstyles/).

Example
-------

(For full details you are referred to the [manual of hyperref](http://www.tug.org/applications/hyperref/ftp/doc/manual.html).) Here is a sample LaTeX file which includes links:
```LaTeX
\documentclass[11pt]{article}
\usepackage{hyperref}

\begin{document}
This is the first page, with a
\hyperlink{page2}{link to a word on the second page}.

\newpage

This is the \hypertarget{page2}{second} page, with a link to an
\href{https://arxiv.org}{external document}.

\end{document}
```
If you now run
```
latex link.tex
dvips -z link.dvi -o link.ps
ps2pdf link.ps link.pdf
```
you will end up with [link.dvi](link.dvi), [link.ps](link.ps) and [link.pdf](link.pdf) files which all contain hyperlinks. Alternatively, you can use pdflatex, `pdflatex link.tex` to obtain the hyperlinked PDF file directly. There is a wide variety of options to influence the link style

How it is all done internally
-----------------------------

TeX and LaTeX output is in the form of a ".dvi" file, the letters being short for "device-independent". ".dvi" files are not completely self-contained because they depend on external font files, but aside from that they describe the formatting of a document in a fashion independent of the display or printing device. The ".dvi" format is also arbitrarily extendible, due to the "\\special" command of TeX, which allows new display commands to be embedded in the ".dvi" file. The "\\special" command has previously been used to extend TeX by allowing inclusion of line drawings, PostScript figures, and colored text.

HyperTeX adds five new "\\special" commands to the menagerie. These are:
```LaTeX
\special{html:<a href="hrefstring">}
\special{html:<a name="namestring">}
\special{html:</a>}
\special{html:<img src="hrefstring">}
\special{html:<base href="hrefstring">}
```
These are identified as HyperTeX specials by the first 4 characters, "html". The first three commands establish links between sections of documents in a manner exactly analogous to the HTML of the Web. The "img" command is intended to place an image of arbitrary graphical format on the page, although this is not very widely supported by current viewers. The "hrefstring" values are arbitrary URLs. If you want to use a fragment indicator in the URL (the \`#' hash mark), make sure to change its catcode to \`letter' first:
```LaTeX
{\catcode`\#=11
 \special{html:<a href="http://www.foo.org/bar#foobar"}}
```
See chapter 7 of the TeXbook for more information about catcodes.

Rather than just applying these "\\special" commands directly, use of one of the macro packages (at least as a first step to "hyper-izing" a document) is highly recommended.

The various subsections of a document can be referenced as part of a URL description through the "#" extension to the URL name. We have been using the following standard names for ease of linking into HyperTeX documents based on the macro packages currently available:
```
Page 5 is at             doc.dvi#page.5
Section 2 is at          doc.dvi#section.2
Equation 3 is at         doc.dvi#equation.3
Reference 11 is at       doc.dvi#reference.11
```
(but see the note about \`#' catcodes in the previous section). Similar definitions thus far exist for subsection, figure and table entities. New macro packages or style files should try to conform to this naming scheme (see the currently available packages for details on how this is done).

If all else fails
-----------------

Contact the maintainer of this FAQ; see the email address at the top of this page.
